/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.physics;

import org.jagatoo.datatypes.Enableable;
import org.xith3d.loop.Updatable;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.physics.PhysicsGFXManager;
import org.xith3d.physics.collision.CollisionEngine;
import org.xith3d.physics.collision.CollisionResolveListener;
import org.xith3d.physics.collision.CollisionResolver;
import org.xith3d.physics.collision.CollisionResolversManager;
import org.xith3d.physics.simulation.SimulationEngine;
import org.xith3d.physics.simulation.SurfaceParameters;

public abstract class PhysicsEngine
implements Updatable,
Enableable {
    private final CollisionResolversManager collisionResolversManager;
    private final CollisionEngine collEngine;
    private final SimulationEngine simEngine;
    private PhysicsGFXManager gfxManager = null;
    private boolean enabled = true;

    public final CollisionResolversManager getCollisionResolversManager() {
        return this.collisionResolversManager;
    }

    public final void setDefaultSurfaceParameters(SurfaceParameters parameters) {
        this.getCollisionResolversManager().setDefaultSurfaceParameters(parameters);
    }

    public final SurfaceParameters getDefaultSurfaceParameters() {
        return this.getCollisionResolversManager().getDefaultSurfaceParameters();
    }

    public final void addCollisionResolver(CollisionResolver cr) {
        this.getCollisionResolversManager().addCollisionResolver(cr);
    }

    public final void removeCollisionResolver(CollisionResolver cr) {
        this.getCollisionResolversManager().removeCollisionResolver(cr);
    }

    public final void addCollisionResolverListener(CollisionResolveListener l) {
        this.getCollisionResolversManager().addCollisionResolveListener(l);
    }

    public final void removeCollisionResolverListener(CollisionResolveListener l) {
        this.getCollisionResolversManager().removeCollisionResolveListener(l);
    }

    public final CollisionEngine getCollisionEngine() {
        return this.collEngine;
    }

    public final SimulationEngine getSimulationEngine() {
        return this.simEngine;
    }

    public final void setGFXManager(PhysicsGFXManager gfxManager) {
        this.gfxManager = gfxManager;
    }

    public final PhysicsGFXManager getGFXManager() {
        return this.gfxManager;
    }

    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.collEngine != null) {
            this.collEngine.setEnabled(enabled);
        }
        if (this.simEngine != null) {
            this.simEngine.setEnabled(enabled);
        }
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        if (this.simEngine != null) {
            this.simEngine.update(gameTime, frameTime, timingMode);
        }
        if (this.collEngine != null) {
            this.collEngine.update(gameTime, frameTime, timingMode);
        }
        if (this.gfxManager != null) {
            this.gfxManager.update(gameTime, frameTime, timingMode);
        }
    }

    protected PhysicsEngine(CollisionEngine collEngine, SimulationEngine simEngine) {
        this.collEngine = collEngine;
        this.simEngine = simEngine;
        this.gfxManager = new PhysicsGFXManager();
        if (simEngine != null) {
            this.collisionResolversManager = new CollisionResolversManager(collEngine, simEngine.newSurfaceParameters());
            simEngine.setCollisionResolversManager(this.collisionResolversManager);
        } else {
            this.collisionResolversManager = null;
        }
    }
}

