/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.physics.collision;

import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.util.MatrixUtils;
import org.xith3d.physics.collision.Collideable;
import org.xith3d.physics.collision.CollideableGroup;
import org.xith3d.physics.collision.CollisionEngine;
import org.xith3d.physics.simulation.Body;

public abstract class CollideableBase
implements Collideable {
    private final CollisionEngine engine;
    private String name = null;
    private Object userObject = null;
    private Body body = null;
    private CollideableGroup parent;
    private final Point3f position;
    private final Point3f worldPos;
    private final Matrix3f rotation;
    private final Matrix3f worldRot;
    private Point3f posPoint3f = null;
    private Tuple3f rotTuple3f = null;
    private Matrix3f rotMatrix3f = null;

    public CollisionEngine getEngine() {
        return this.engine;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public final void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public final Object getUserObject() {
        return this.userObject;
    }

    protected void setParent(CollideableGroup parent) {
        this.parent = parent;
    }

    public final CollideableGroup getParent() {
        return this.parent;
    }

    public void setBody(Body body) {
        this.body = body;
    }

    public final Body getBody() {
        if (this.body != null) {
            return this.body;
        }
        if (this.getParent() != null) {
            return this.getParent().getBody();
        }
        return null;
    }

    public void setRotation(float x, float y, float z, boolean recomputeWorldCoords) {
        MatrixUtils.eulerToMatrix3f((float)x, (float)y, (float)z, (Matrix3f)this.rotation);
        if (recomputeWorldCoords) {
            this.recomputeWorldCoords(true, true);
        }
    }

    public final void setRotation(float x, float y, float z) {
        this.setRotation(x, y, z, true);
    }

    public final void setRotation(Tuple3f rot) {
        this.setRotation(rot.getX(), rot.getY(), rot.getZ());
    }

    public final void setRotationX(float x) {
        Tuple3f rotation = this.getRotation();
        rotation.setX(x);
        this.setRotation(rotation);
    }

    public final void setRotationY(float y) {
        Tuple3f rotation = this.getRotation();
        rotation.setY(y);
        this.setRotation(rotation);
    }

    public final void setRotationZ(float z) {
        Tuple3f rotation = this.getRotation();
        rotation.setZ(z);
        this.setRotation(rotation);
    }

    public final Tuple3f getRotation() {
        if (this.rotTuple3f == null) {
            this.rotTuple3f = new Tuple3f();
        }
        MatrixUtils.matrixToEuler((Matrix3f)this.rotation, (Tuple3f)this.rotTuple3f);
        return this.rotTuple3f;
    }

    public final void getRotation(Tuple3f rot) {
        MatrixUtils.matrixToEuler((Matrix3f)this.rotation, (Tuple3f)rot);
    }

    public void setRotationMatrix(Matrix3f rot, boolean recomputeWorldCoords) {
        this.rotation.set(rot);
        if (recomputeWorldCoords) {
            this.recomputeWorldCoords(true, true);
        }
    }

    public final void setRotationMatrix(Matrix3f rot) {
        this.setRotationMatrix(rot, true);
    }

    public final Matrix3f getRotationMatrix() {
        return this.rotation.getReadOnly();
    }

    public final void getRotationMatrix(Matrix3f mat) {
        mat.set(this.rotation);
    }

    public void setPosition(float x, float y, float z, boolean recomputeWorldCoords) {
        this.position.set(x, y, z);
        if (recomputeWorldCoords) {
            this.recomputeWorldCoords(true, true);
        }
    }

    public final void setPosition(float x, float y, float z) {
        this.setPosition(x, y, z, true);
    }

    public final void setPosition(Tuple3f pos) {
        this.setPosition(pos.getX(), pos.getY(), pos.getZ());
    }

    public final void setPositionX(float x) {
        Point3f position = this.getPosition();
        this.setPosition(x, position.getY(), position.getZ());
    }

    public final void setPositionY(float y) {
        Point3f position = this.getPosition();
        this.setPosition(position.getX(), y, position.getZ());
    }

    public final void setPositionZ(float z) {
        Point3f position = this.getPosition();
        this.setPosition(position.getX(), position.getY(), z);
    }

    public final Point3f getPosition() {
        return this.position.getReadOnly();
    }

    public final void getPosition(Tuple3f pos) {
        pos.set((TupleNf)this.position);
    }

    public final Point3f getWorldPos() {
        if (this.posPoint3f == null) {
            this.posPoint3f = new Point3f();
        }
        this.getWorldPos((Tuple3f)this.posPoint3f);
        return this.posPoint3f;
    }

    public final void getWorldPos(Tuple3f pos) {
        pos.set((TupleNf)this.worldPos);
    }

    public final Tuple3f getWorldRot() {
        if (this.rotTuple3f == null) {
            this.rotTuple3f = new Tuple3f();
        }
        this.getWorldRot(this.rotTuple3f);
        return this.rotTuple3f;
    }

    public final void getWorldRot(Tuple3f rot) {
        MatrixUtils.matrixToEuler((Matrix3f)this.getWorldRotMat(), (Tuple3f)rot);
    }

    public final Matrix3f getWorldRotMat() {
        if (this.rotMatrix3f == null) {
            this.rotMatrix3f = new Matrix3f();
        }
        this.getWorldRotMat(this.rotMatrix3f);
        return this.rotMatrix3f;
    }

    public final void getWorldRotMat(Matrix3f rot) {
        rot.set(this.worldRot);
    }

    protected abstract void applyWorldRotation(Matrix3f var1);

    protected abstract void applyWorldPosition(Tuple3f var1);

    protected void recomputeWorldRotMat(Matrix3f worldRot, boolean applyToImplementation) {
        if (this.getParent() == null) {
            worldRot.setIdentity();
        } else {
            this.getParent().getWorldRotMat(worldRot);
        }
        worldRot.mul(this.getRotationMatrix());
        if (applyToImplementation) {
            this.applyWorldRotation(worldRot);
        }
    }

    protected void recomputeWorldPos(Point3f worldPos, boolean applyToImplementation) {
        if (this.getParent() == null) {
            worldPos.set((TupleNf)this.getPosition());
        } else {
            if (this.posPoint3f == null) {
                this.posPoint3f = new Point3f();
            }
            if (this.rotMatrix3f == null) {
                this.rotMatrix3f = new Matrix3f();
            }
            this.getParent().getWorldPos((Tuple3f)this.posPoint3f);
            this.getParent().getWorldRotMat(this.rotMatrix3f);
            worldPos.set((TupleNf)this.getPosition());
            this.rotMatrix3f.transform((Tuple3f)worldPos);
            worldPos.add((TupleNf)this.posPoint3f, (TupleNf)worldPos);
        }
        if (applyToImplementation) {
            this.applyWorldPosition((Tuple3f)worldPos);
        }
    }

    public void recomputeChildrenWorldCoords(boolean applyToImplementation) {
        if (this instanceof CollideableGroup) {
            int n = ((CollideableGroup)((Object)this)).getChildrenCount();
            for (int i = 0; i < n; ++i) {
                ((CollideableGroup)((Object)this)).getChild(i).recomputeWorldCoords(true, applyToImplementation);
            }
        }
    }

    public void recomputeWorldCoords(boolean childrenToo, boolean applyToImplementation) {
        this.recomputeWorldPos(this.worldPos, applyToImplementation);
        this.recomputeWorldRotMat(this.worldRot, applyToImplementation);
        if (childrenToo) {
            this.recomputeChildrenWorldCoords(applyToImplementation);
        }
    }

    public String toString() {
        if (this.getName() == null) {
            return super.toString();
        }
        return super.toString() + " \"" + this.getName() + "\"";
    }

    public CollideableBase(CollisionEngine engine) {
        this.engine = engine;
        this.position = new Point3f();
        this.worldPos = new Point3f();
        this.rotation = new Matrix3f();
        this.rotation.setIdentity();
        this.worldRot = new Matrix3f();
        this.worldRot.setIdentity();
    }
}

