/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.physics.collision;

import java.util.ArrayList;
import java.util.List;
import org.xith3d.physics.collision.Collideable;
import org.xith3d.physics.collision.CollideableGroup;
import org.xith3d.physics.collision.Collision;
import org.xith3d.physics.collision.CollisionEngine;
import org.xith3d.physics.collision.CollisionListener;
import org.xith3d.physics.collision.CollisionResolveListener;
import org.xith3d.physics.collision.CollisionResolversManager;
import org.xith3d.physics.simulation.Body;
import org.xith3d.physics.simulation.SimulationWorld;
import org.xith3d.physics.simulation.SurfaceParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollisionResolver
implements CollisionListener {
    private final ArrayList<Collideable> list1;
    private final ArrayList<Collideable> list2;
    private boolean ignoreStatic = true;
    private CollisionResolversManager manager = null;

    public final void setIgnoreStaticCollisions(boolean ignoreStatic) {
        this.ignoreStatic = ignoreStatic;
    }

    public final boolean getIgnoreStatic() {
        return this.ignoreStatic;
    }

    @Override
    public void onCollision(Collision collision) {
        boolean consumed = false;
        Body body1 = collision.getCollideable1().getBody();
        Body body2 = collision.getCollideable2().getBody();
        SimulationWorld simWorld = body1 != null ? body1.getWorld() : (body2 != null ? body2.getWorld() : null);
        ArrayList<CollisionResolveListener> listeners = this.manager.getCollisionResolveListeners();
        SurfaceParameters defaultSurfaceParameters = this.manager.getDefaultSurfaceParameters();
        for (int l = 0; l < listeners.size(); ++l) {
            CollisionResolveListener listener = listeners.get(l);
            if (!listener.onCollisionToResolve(collision, defaultSurfaceParameters, simWorld, consumed)) continue;
            consumed = true;
        }
        if (!consumed && simWorld != null) {
            simWorld.resolveCollision(collision, body1, body2, defaultSurfaceParameters);
        }
    }

    public void update() {
        CollisionEngine collisionEngine = this.manager.getCollisionEngine();
        for (int i = 0; i < this.list1.size(); ++i) {
            Collideable collideable1 = this.list1.get(i);
            if (this.list2 == null) {
                collisionEngine.checkCollisions((CollideableGroup)collideable1, this.ignoreStatic, this);
                continue;
            }
            for (int j = 0; j < this.list2.size(); ++j) {
                Collideable collideable2 = this.list2.get(j);
                collisionEngine.checkCollisions(collideable1, collideable2, this.ignoreStatic, this);
            }
        }
    }

    protected void setManager(CollisionResolversManager manager) {
        this.manager = manager;
    }

    private static final void list2List(Body source, List<Collideable> target) {
        int n = source.getCollideablesCount();
        for (int j = 0; j < n; ++j) {
            target.add(source.getCollideable(j));
        }
    }

    private static final void list2List(Body[] source, List<Collideable> target) {
        for (int i = 0; i < source.length; ++i) {
            int n = source[i].getCollideablesCount();
            for (int j = 0; j < n; ++j) {
                target.add(source[i].getCollideable(j));
            }
        }
    }

    private static final void list2List(List<Body> source, List<Collideable> target) {
        for (int i = 0; i < source.size(); ++i) {
            int n = source.get(i).getCollideablesCount();
            for (int j = 0; j < n; ++j) {
                target.add(source.get(i).getCollideable(j));
            }
        }
    }

    public CollisionResolver(Body body1, Body body2) {
        if (body1 == null || body2 == null) {
            throw new IllegalArgumentException("None of the parameters must be null");
        }
        if (body1.getCollideablesCount() == 0 || body2.getCollideablesCount() == 0) {
            throw new IllegalArgumentException("No Collideables attached to one of the Bodies.");
        }
        this.list1 = new ArrayList(body1.getCollideablesCount());
        this.list2 = new ArrayList(body2.getCollideablesCount());
        CollisionResolver.list2List(body1, this.list1);
        CollisionResolver.list2List(body2, this.list2);
    }

    public CollisionResolver(Body body1, List<Body> bodies2) {
        if (body1 == null || bodies2 == null) {
            throw new IllegalArgumentException("None of the parameters must be null");
        }
        if (body1.getCollideablesCount() == 0 || bodies2.size() == 0) {
            throw new IllegalArgumentException("No Collideables attached to one of the Bodies.");
        }
        this.list1 = new ArrayList(body1.getCollideablesCount());
        int count = 0;
        for (int i = 0; i < bodies2.size(); ++i) {
            count += bodies2.get(i).getCollideablesCount();
        }
        this.list2 = new ArrayList(count);
        CollisionResolver.list2List(body1, this.list1);
        CollisionResolver.list2List(bodies2, this.list2);
    }

    public CollisionResolver(Body body1, Body[] bodies2) {
        if (body1 == null || bodies2 == null) {
            throw new IllegalArgumentException("None of the parameters must be null");
        }
        if (body1.getCollideablesCount() == 0 || bodies2.length == 0) {
            throw new IllegalArgumentException("No Collideables attached to one of the Bodies.");
        }
        this.list1 = new ArrayList(body1.getCollideablesCount());
        int count = 0;
        for (int i = 0; i < bodies2.length; ++i) {
            count += bodies2[i].getCollideablesCount();
        }
        this.list2 = new ArrayList(count);
        CollisionResolver.list2List(body1, this.list1);
        CollisionResolver.list2List(bodies2, this.list2);
    }

    public CollisionResolver(List<Body> bodies1, List<Body> bodies2) {
        int i;
        if (bodies1 == null || bodies2 == null) {
            throw new IllegalArgumentException("None of the parameters must be null");
        }
        if (bodies1.size() == 0 || bodies2.size() == 0) {
            throw new IllegalArgumentException("No Collideables attached to one of the Bodies.");
        }
        int count = 0;
        for (i = 0; i < bodies1.size(); ++i) {
            count += bodies1.get(i).getCollideablesCount();
        }
        this.list1 = new ArrayList(count);
        count = 0;
        for (i = 0; i < bodies2.size(); ++i) {
            count += bodies2.get(i).getCollideablesCount();
        }
        this.list2 = new ArrayList(count);
        CollisionResolver.list2List(bodies1, this.list1);
        CollisionResolver.list2List(bodies2, this.list2);
    }

    public CollisionResolver(Body[] bodies1, Body[] bodies2) {
        int i;
        if (bodies1 == null || bodies2 == null) {
            throw new IllegalArgumentException("None of the parameters must be null");
        }
        if (bodies1.length == 0 || bodies2.length == 0) {
            throw new IllegalArgumentException("No Collideables attached to one of the Bodies.");
        }
        int count = 0;
        for (i = 0; i < bodies1.length; ++i) {
            count += bodies1[i].getCollideablesCount();
        }
        this.list1 = new ArrayList(count);
        count = 0;
        for (i = 0; i < bodies2.length; ++i) {
            count += bodies2[i].getCollideablesCount();
        }
        this.list2 = new ArrayList(count);
        CollisionResolver.list2List(bodies1, this.list1);
        CollisionResolver.list2List(bodies2, this.list2);
    }

    public CollisionResolver(Body body1, Collideable collideable2) {
        if (body1 == null || collideable2 == null) {
            throw new IllegalArgumentException("None of the parameters must be null");
        }
        if (body1.getCollideablesCount() == 0) {
            throw new IllegalArgumentException("No Collideables attached to the Body.");
        }
        this.list1 = new ArrayList(body1.getCollideablesCount());
        this.list2 = new ArrayList(1);
        CollisionResolver.list2List(body1, this.list1);
        this.list2.add(collideable2);
    }

    public CollisionResolver(Collideable collideable1, Collideable collideable2) {
        if (collideable1 == null || collideable2 == null) {
            throw new IllegalArgumentException("None of the parameters must be null");
        }
        this.list1 = new ArrayList(1);
        this.list2 = new ArrayList(1);
        this.list1.add(collideable1);
        this.list2.add(collideable2);
    }

    public CollisionResolver(CollideableGroup collideableGroup) {
        if (collideableGroup == null) {
            throw new IllegalArgumentException("None of the parameters must be null");
        }
        this.list1 = new ArrayList(1);
        this.list2 = null;
        this.list1.add(collideableGroup);
    }
}

