/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.physics.collision.collideable;

import org.jagatoo.opengl.enums.DrawMode;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.physics.collision.CollideableBase;
import org.xith3d.physics.collision.CollisionEngine;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.primitives.Line;

public abstract class RayCollideable
extends CollideableBase {
    private static Appearance defaultAppearance = null;
    private Line gfxObject = null;
    private final Point3f origin;
    private final Vector3f direction;
    private final Point3f end;
    private float length;

    public static void setDefaultAppearance(Appearance app) {
        defaultAppearance = app;
    }

    public static void setDefaultAppearance(Colorf color) {
        if (defaultAppearance == null) {
            defaultAppearance = new Appearance();
        }
        defaultAppearance.setColor(color);
    }

    public static Appearance getDefaultAppearance() {
        return defaultAppearance;
    }

    public final String getInfo() {
        return "A ray collideable. One can adjust its origin and direction";
    }

    public final String getType() {
        return "Ray";
    }

    public Line getBaseGFX() {
        if (this.gfxObject == null) {
            Point3f end = Point3f.fromPool((float)0.0f, (float)0.0f, (float)1.0f);
            end.scale(this.getLength());
            this.gfxObject = defaultAppearance == null ? new Line((Tuple3f)end, Colorf.RED) : new Line((Tuple3f)end, defaultAppearance.getColoringAttributes(true).getColor());
            Point3f.toPool((Point3f)end);
        }
        if (this.gfxObject.getAppearance(true).getPolygonAttributes() != null) {
            this.gfxObject.getAppearance().getPolygonAttributes().setDrawMode(DrawMode.FILL);
        }
        return this.gfxObject;
    }

    public Line getDebugGFX() {
        Line shape = this.getBaseGFX();
        shape.getAppearance().getPolygonAttributes().setDrawMode(DrawMode.LINE);
        return shape;
    }

    public void setOrigin(float x, float y, float z) {
        if (this.gfxObject != null) {
            this.gfxObject.setCoordinates(x, y, z, this.end.getX(), this.end.getY(), this.end.getZ());
        }
        this.origin.set(x, y, z);
    }

    public final void setOrigin(Tuple3f origin) {
        this.setOrigin(origin.getX(), origin.getY(), origin.getZ());
    }

    public final Point3f getOrigin() {
        return this.origin.getReadOnly();
    }

    public void setDirection(float x, float y, float z) {
        if (this.gfxObject != null) {
            this.gfxObject.setCoordinates(this.origin.getX(), this.origin.getY(), this.origin.getZ(), x, y, z);
        }
        this.direction.set(x, y, z);
        this.length = this.direction.length();
        this.end.add((TupleNf)this.origin, (TupleNf)this.direction);
    }

    public final void setDirection(Tuple3f direction) {
        this.setDirection(direction.getX(), direction.getY(), direction.getZ());
    }

    public final Vector3f getDirection() {
        return this.direction.getReadOnly();
    }

    public final Point3f getEnd() {
        return this.end.getReadOnly();
    }

    public void setLength(float length) {
        this.direction.normalize();
        this.direction.scale(length);
        this.setDirection((Tuple3f)this.direction);
    }

    public final float getLength() {
        return this.length;
    }

    public RayCollideable(CollisionEngine eng, float originX, float originY, float originZ, float directionX, float directionY, float directionZ) {
        super(eng);
        this.origin = new Point3f(originX, originY, originZ);
        this.direction = new Vector3f(directionX, directionY, directionZ);
        this.end = new Point3f((Tuple3f)this.origin);
        this.end.add((TupleNf)this.direction);
        this.length = this.direction.length();
    }

    public RayCollideable(CollisionEngine eng, Tuple3f origin, Tuple3f direction) {
        this(eng, origin.getX(), origin.getY(), origin.getZ(), direction.getX(), direction.getY(), direction.getZ());
    }
}

