/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.physics.collision.collideable;

import org.jagatoo.opengl.enums.DrawMode;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.physics.collision.CollideableBase;
import org.xith3d.physics.collision.CollisionEngine;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.primitives.Sphere;

public abstract class SphereCollideable
extends CollideableBase {
    private static Appearance defaultAppearance = null;
    private Sphere gfxObject = null;
    private float radius;

    public static void setDefaultAppearance(Appearance app) {
        defaultAppearance = app;
    }

    public static void setDefaultAppearance(Texture texture) {
        if (defaultAppearance == null) {
            defaultAppearance = new Appearance();
        }
        defaultAppearance.setTexture(texture);
    }

    public static void setDefaultAppearance(String texture) {
        SphereCollideable.setDefaultAppearance(TextureLoader.getInstance().getTexture(texture));
    }

    public static Appearance getDefaultAppearance() {
        return defaultAppearance;
    }

    public final String getInfo() {
        return "A sphere collideable. One can adjust its radius";
    }

    public final String getType() {
        return "Sphere";
    }

    public Sphere getBaseGFX() {
        if (this.gfxObject == null) {
            this.gfxObject = defaultAppearance == null ? new Sphere(this.getRadius(), 8, 16, 11, false, 2) : new Sphere(this.getRadius(), 8, 16, defaultAppearance.cloneNodeComponent(false));
        }
        if (this.gfxObject.getAppearance(true).getPolygonAttributes() != null) {
            this.gfxObject.getAppearance().getPolygonAttributes().setDrawMode(DrawMode.FILL);
        }
        return this.gfxObject;
    }

    public Sphere getDebugGFX() {
        Sphere shape = this.getBaseGFX();
        shape.getAppearance().getPolygonAttributes().setDrawMode(DrawMode.LINE);
        return shape;
    }

    public void setRadius(float radius) {
        if (this.gfxObject != null) {
            float q = radius / this.radius;
            StaticTransform.scale(this.gfxObject, q);
        }
        this.radius = radius;
    }

    public final float getRadius() {
        return this.radius;
    }

    public SphereCollideable(CollisionEngine eng, float radius) {
        super(eng);
        this.radius = radius;
    }
}

