/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.physics.util;

import java.util.ArrayList;
import org.jagatoo.datatypes.RepositionListener3f;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.util.MatrixUtils;
import org.xith3d.physics.util.ListeningPlaceable;

public abstract class PlaceableImpl
implements ListeningPlaceable {
    protected boolean valueCheckedBeforeChanged = false;
    protected final Point3f position;
    protected final Matrix3f rotation;
    private Tuple3f rotEuler = null;
    private final ArrayList<RepositionListener3f> repositionListeners = new ArrayList();

    public void addRepositionListener(RepositionListener3f l) {
        this.repositionListeners.add(l);
    }

    public void removeRepositionListener(RepositionListener3f l) {
        this.repositionListeners.remove(l);
    }

    protected void onPositionChanged() {
        for (int i = 0; i < this.repositionListeners.size(); ++i) {
            this.repositionListeners.get(i).onPositionChanged(this.position.getX(), this.position.getY(), this.position.getZ());
        }
    }

    public void setPosition(float posX, float posY, float posZ) {
        if (this.valueCheckedBeforeChanged && this.position.getX() == posX && this.position.getY() == posY && this.position.getZ() == posZ) {
            return;
        }
        this.position.set(posX, posY, posZ);
        this.onPositionChanged();
    }

    public final void setPosition(Tuple3f pos) {
        this.setPosition(pos.getX(), pos.getY(), pos.getZ());
    }

    public final Point3f getPosition() {
        return this.position.getReadOnly();
    }

    public final void getPosition(Tuple3f pos) {
        pos.set((TupleNf)this.position);
    }

    protected void onRotationChanged() {
    }

    public void setRotation(float rotX, float rotY, float rotZ) {
        MatrixUtils.eulerToMatrix3f((float)rotX, (float)rotY, (float)rotZ, (Matrix3f)this.rotation);
        this.onRotationChanged();
    }

    public final void setRotation(Tuple3f rot) {
        this.setRotation(rot.getX(), rot.getY(), rot.getZ());
    }

    public final Tuple3f getRotation() {
        if (this.rotEuler == null) {
            this.rotEuler = new Tuple3f();
        }
        MatrixUtils.matrixToEuler((Matrix3f)this.rotation, (Tuple3f)this.rotEuler);
        return this.rotEuler.getReadOnly();
    }

    public final void getRotation(Tuple3f rot) {
        this.setRotation(rot.getX(), rot.getY(), rot.getZ());
    }

    public void setRotationMatrix(Matrix3f rot) {
        this.rotation.set(rot);
        this.onRotationChanged();
    }

    public final Matrix3f getRotationMatrix() {
        return this.rotation.getReadOnly();
    }

    public final void getRotationMatrix(Matrix3f rot) {
        rot.set(this.rotation);
    }

    public final void setPositionX(float v) {
        this.position.setX(v);
        this.onPositionChanged();
    }

    public final void setPositionY(float v) {
        this.position.setY(v);
        this.onPositionChanged();
    }

    public final void setPositionZ(float v) {
        this.position.setZ(v);
        this.onPositionChanged();
    }

    public final float getPositionX() {
        return this.position.getX();
    }

    public final float getPositionY() {
        return this.position.getY();
    }

    public final float getPositionZ() {
        return this.position.getZ();
    }

    public final void setRotationX(float v) {
        Tuple3f rot = this.getRotation();
        MatrixUtils.eulerToMatrix3f((float)v, (float)rot.getY(), (float)rot.getZ(), (Matrix3f)this.rotation);
        this.onRotationChanged();
    }

    public final void setRotationY(float v) {
        Tuple3f rot = this.getRotation();
        MatrixUtils.eulerToMatrix3f((float)rot.getX(), (float)v, (float)rot.getZ(), (Matrix3f)this.rotation);
        this.onRotationChanged();
    }

    public final void setRotationZ(float v) {
        Tuple3f rot = this.getRotation();
        MatrixUtils.eulerToMatrix3f((float)rot.getX(), (float)rot.getY(), (float)v, (Matrix3f)this.rotation);
        this.onRotationChanged();
    }

    public final float getRotationX() {
        return this.getRotation().getX();
    }

    public final float getRotationY() {
        return this.getRotation().getY();
    }

    public final float getRotationZ() {
        return this.getRotation().getZ();
    }

    public PlaceableImpl() {
        this.position = new Point3f(0.0f, 0.0f, 0.0f);
        this.rotation = new Matrix3f();
        this.rotation.setIdentity();
    }
}

