/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.picking;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.xith3d.picking.PickListener;
import org.xith3d.picking.PickResult;
import org.xith3d.utility.logging.X3DLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PickDispatcher
implements PickListener {
    private final LinkedList<PickListener> listeners = new LinkedList();
    private final ArrayList<PickListener> copy = new ArrayList(8);

    public void addPickListener(PickListener listener) {
        this.listeners.add(listener);
    }

    public void removePickListener(PickListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void onObjectPicked(PickResult nearest, Object userObject, long pickTime) {
        this.copy.addAll(this.listeners);
        for (int i = 0; i < this.copy.size(); ++i) {
            PickListener pickListener = this.copy.get(i);
            try {
                pickListener.onObjectPicked(nearest, userObject, pickTime);
                continue;
            }
            catch (Throwable exception) {
                X3DLog.println(exception);
            }
        }
        this.copy.clear();
    }

    @Override
    public void onObjectsPicked(List<PickResult> pickResults, Object userObject, long pickTime) {
        this.copy.addAll(this.listeners);
        for (int i = 0; i < this.copy.size(); ++i) {
            PickListener pickListener = this.copy.get(i);
            try {
                pickListener.onObjectsPicked(pickResults, userObject, pickTime);
                continue;
            }
            catch (Throwable exception) {
                X3DLog.println(exception);
            }
        }
        this.copy.clear();
    }

    @Override
    public void onPickingMissed(Object userObject, long pickTime) {
        this.copy.addAll(this.listeners);
        for (int i = 0; i < this.copy.size(); ++i) {
            PickListener pickListener = this.copy.get(i);
            try {
                pickListener.onPickingMissed(userObject, pickTime);
                continue;
            }
            catch (Throwable exception) {
                X3DLog.println(exception);
            }
        }
        this.copy.clear();
    }
}

