/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render;

import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Tuple2f;
import org.xith3d.render.BaseRenderPassConfig;
import org.xith3d.render.RenderPass;
import org.xith3d.render.RenderPassConfig;
import org.xith3d.render.Renderer;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.View;

public class BackgroundRenderPass
extends RenderPass {
    public void setFrustumCullingEnabled(boolean enabled) {
        throw new Error("You cannot set this on a BackgroundRenderPass.");
    }

    public final boolean isFrustumCullingEnabled() {
        return false;
    }

    public BackgroundRenderPass(BranchGroup branchGroup, RenderPassConfig config) {
        super(branchGroup, config);
        if (config.getCameraMode() == null) {
            config.setCameraMode(View.CameraMode.VIEW_FIXED_POSITION);
        }
    }

    public BackgroundRenderPass(RenderPassConfig config) {
        this(new BranchGroup(), config);
    }

    public static BackgroundRenderPass createPerspective(BranchGroup branchGroup, View.CameraMode cameraMode, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy, float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView) {
        BaseRenderPassConfig config = new BaseRenderPassConfig(View.ProjectionPolicy.PERSPECTIVE_PROJECTION, cameraMode, opaqueSortingPolicy, transparentSortingPolicy, frontClipDistance, backClipDistance, screenScale, fieldOfView);
        return new BackgroundRenderPass(branchGroup, config);
    }

    public static BackgroundRenderPass createPerspective(BranchGroup branchGroup, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy, float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView) {
        BaseRenderPassConfig config = new BaseRenderPassConfig(View.ProjectionPolicy.PERSPECTIVE_PROJECTION, opaqueSortingPolicy, transparentSortingPolicy, frontClipDistance, backClipDistance, screenScale, fieldOfView);
        return new BackgroundRenderPass(branchGroup, config);
    }

    public static BackgroundRenderPass createPerspective(View.CameraMode cameraMode, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy, float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView) {
        BaseRenderPassConfig config = new BaseRenderPassConfig(View.ProjectionPolicy.PERSPECTIVE_PROJECTION, cameraMode, opaqueSortingPolicy, transparentSortingPolicy, frontClipDistance, backClipDistance, screenScale, fieldOfView);
        return new BackgroundRenderPass(new BranchGroup(), config);
    }

    public static BackgroundRenderPass createPerspective(Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy, float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView) {
        BaseRenderPassConfig config = new BaseRenderPassConfig(View.ProjectionPolicy.PERSPECTIVE_PROJECTION, opaqueSortingPolicy, transparentSortingPolicy, frontClipDistance, backClipDistance, screenScale, fieldOfView);
        return new BackgroundRenderPass(new BranchGroup(), config);
    }

    public static BackgroundRenderPass createPerspective(BranchGroup branchGroup, View.CameraMode cameraMode, float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView) {
        return BackgroundRenderPass.createPerspective(branchGroup, cameraMode, null, null, frontClipDistance, backClipDistance, screenScale, fieldOfView);
    }

    public static BackgroundRenderPass createPerspective(BranchGroup branchGroup, float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView) {
        return BackgroundRenderPass.createPerspective(branchGroup, (Renderer.OpaqueSortingPolicy)null, (Renderer.TransparentSortingPolicy)null, frontClipDistance, backClipDistance, screenScale, fieldOfView);
    }

    public static BackgroundRenderPass createPerspective(View.CameraMode cameraMode, float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView) {
        return BackgroundRenderPass.createPerspective(new BranchGroup(), cameraMode, null, null, frontClipDistance, backClipDistance, screenScale, fieldOfView);
    }

    public static BackgroundRenderPass createPerspective(float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView) {
        return BackgroundRenderPass.createPerspective(new BranchGroup(), (Renderer.OpaqueSortingPolicy)null, (Renderer.TransparentSortingPolicy)null, frontClipDistance, backClipDistance, screenScale, fieldOfView);
    }

    public static BackgroundRenderPass createPerspective(BranchGroup branchGroup, View.CameraMode cameraMode, float frontClipDistance, float backClipDistance, float screenScale) {
        return BackgroundRenderPass.createPerspective(branchGroup, cameraMode, frontClipDistance, backClipDistance, screenScale, -9999.0f);
    }

    public static BackgroundRenderPass createPerspective(BranchGroup branchGroup, float frontClipDistance, float backClipDistance, float screenScale) {
        return BackgroundRenderPass.createPerspective(branchGroup, frontClipDistance, backClipDistance, screenScale, -9999.0f);
    }

    public static BackgroundRenderPass createPerspective(View.CameraMode cameraMode, float frontClipDistance, float backClipDistance, float screenScale) {
        return BackgroundRenderPass.createPerspective(new BranchGroup(), cameraMode, frontClipDistance, backClipDistance, screenScale, -9999.0f);
    }

    public static BackgroundRenderPass createPerspective(float frontClipDistance, float backClipDistance, float screenScale) {
        return BackgroundRenderPass.createPerspective(new BranchGroup(), frontClipDistance, backClipDistance, screenScale, -9999.0f);
    }

    public static BackgroundRenderPass createPerspective(BranchGroup branchGroup, View.CameraMode cameraMode, float frontClipDistance, float backClipDistance) {
        return BackgroundRenderPass.createPerspective(branchGroup, cameraMode, frontClipDistance, backClipDistance, -9999.0f, -9999.0f);
    }

    public static BackgroundRenderPass createPerspective(BranchGroup branchGroup, float frontClipDistance, float backClipDistance) {
        return BackgroundRenderPass.createPerspective(branchGroup, frontClipDistance, backClipDistance, -9999.0f, -9999.0f);
    }

    public static BackgroundRenderPass createPerspective(View.CameraMode cameraMode, float frontClipDistance, float backClipDistance) {
        return BackgroundRenderPass.createPerspective(new BranchGroup(), cameraMode, frontClipDistance, backClipDistance, -9999.0f, -9999.0f);
    }

    public static BackgroundRenderPass createPerspective(float frontClipDistance, float backClipDistance) {
        return BackgroundRenderPass.createPerspective(new BranchGroup(), frontClipDistance, backClipDistance, -9999.0f, -9999.0f);
    }

    public static BackgroundRenderPass createPerspective(BranchGroup branchGroup, View.CameraMode cameraMode, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy) {
        return BackgroundRenderPass.createPerspective(branchGroup, cameraMode, opaqueSortingPolicy, transparentSortingPolicy, -9999.0f, -9999.0f, -9999.0f, -9999.0f);
    }

    public static BackgroundRenderPass createPerspective(BranchGroup branchGroup, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy) {
        return BackgroundRenderPass.createPerspective(branchGroup, opaqueSortingPolicy, transparentSortingPolicy, -9999.0f, -9999.0f, -9999.0f, -9999.0f);
    }

    public static BackgroundRenderPass createPerspective(View.CameraMode cameraMode, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy) {
        return BackgroundRenderPass.createPerspective(new BranchGroup(), cameraMode, opaqueSortingPolicy, transparentSortingPolicy, -9999.0f, -9999.0f, -9999.0f, -9999.0f);
    }

    public static BackgroundRenderPass createPerspective(Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy) {
        return BackgroundRenderPass.createPerspective(new BranchGroup(), opaqueSortingPolicy, transparentSortingPolicy, -9999.0f, -9999.0f, -9999.0f, -9999.0f);
    }

    public static BackgroundRenderPass createPerspective(BranchGroup branchGroup, View.CameraMode cameraMode) {
        return BackgroundRenderPass.createPerspective(branchGroup, cameraMode, -9999.0f, -9999.0f, -9999.0f, -9999.0f);
    }

    public static BackgroundRenderPass createPerspective(BranchGroup branchGroup) {
        return BackgroundRenderPass.createPerspective(branchGroup, -9999.0f, -9999.0f, -9999.0f, -9999.0f);
    }

    public static BackgroundRenderPass createPerspective(View.CameraMode cameraMode) {
        return BackgroundRenderPass.createPerspective(new BranchGroup(), cameraMode, -9999.0f, -9999.0f, -9999.0f, -9999.0f);
    }

    public static BackgroundRenderPass createPerspective() {
        return BackgroundRenderPass.createPerspective(new BranchGroup(), -9999.0f, -9999.0f, -9999.0f, -9999.0f);
    }

    public static BackgroundRenderPass createParallel(BranchGroup branchGroup, View.CameraMode cameraMode, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy, float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView) {
        BaseRenderPassConfig config = new BaseRenderPassConfig(View.ProjectionPolicy.PARALLEL_PROJECTION, cameraMode, opaqueSortingPolicy, transparentSortingPolicy, frontClipDistance, backClipDistance, screenScale, fieldOfView);
        return new BackgroundRenderPass(branchGroup, config);
    }

    public static BackgroundRenderPass createParallel(BranchGroup branchGroup, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy, float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView) {
        BaseRenderPassConfig config = new BaseRenderPassConfig(View.ProjectionPolicy.PARALLEL_PROJECTION, opaqueSortingPolicy, transparentSortingPolicy, frontClipDistance, backClipDistance, screenScale, fieldOfView);
        return new BackgroundRenderPass(branchGroup, config);
    }

    public static BackgroundRenderPass createParallel(View.CameraMode cameraMode, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy, float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView) {
        BaseRenderPassConfig config = new BaseRenderPassConfig(View.ProjectionPolicy.PARALLEL_PROJECTION, cameraMode, opaqueSortingPolicy, transparentSortingPolicy, frontClipDistance, backClipDistance, screenScale, fieldOfView);
        return new BackgroundRenderPass(new BranchGroup(), config);
    }

    public static BackgroundRenderPass createParallel(Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy, float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView) {
        BaseRenderPassConfig config = new BaseRenderPassConfig(View.ProjectionPolicy.PARALLEL_PROJECTION, opaqueSortingPolicy, transparentSortingPolicy, frontClipDistance, backClipDistance, screenScale, fieldOfView);
        return new BackgroundRenderPass(new BranchGroup(), config);
    }

    public static BackgroundRenderPass createParallel(BranchGroup branchGroup, View.CameraMode cameraMode, float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView) {
        return BackgroundRenderPass.createParallel(branchGroup, cameraMode, null, null, frontClipDistance, backClipDistance, screenScale, fieldOfView);
    }

    public static BackgroundRenderPass createParallel(BranchGroup branchGroup, float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView) {
        return BackgroundRenderPass.createParallel(branchGroup, (Renderer.OpaqueSortingPolicy)null, (Renderer.TransparentSortingPolicy)null, frontClipDistance, backClipDistance, screenScale, fieldOfView);
    }

    public static BackgroundRenderPass createParallel(View.CameraMode cameraMode, float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView) {
        return BackgroundRenderPass.createParallel(new BranchGroup(), cameraMode, null, null, frontClipDistance, backClipDistance, screenScale, fieldOfView);
    }

    public static BackgroundRenderPass createParallel(float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView) {
        return BackgroundRenderPass.createParallel(new BranchGroup(), (Renderer.OpaqueSortingPolicy)null, (Renderer.TransparentSortingPolicy)null, frontClipDistance, backClipDistance, screenScale, fieldOfView);
    }

    public static BackgroundRenderPass createParallel(BranchGroup branchGroup, View.CameraMode cameraMode, float frontClipDistance, float backClipDistance, float screenScale) {
        return BackgroundRenderPass.createParallel(branchGroup, cameraMode, frontClipDistance, backClipDistance, screenScale, -9999.0f);
    }

    public static BackgroundRenderPass createParallel(BranchGroup branchGroup, float frontClipDistance, float backClipDistance, float screenScale) {
        return BackgroundRenderPass.createParallel(branchGroup, frontClipDistance, backClipDistance, screenScale, -9999.0f);
    }

    public static BackgroundRenderPass createParallel(View.CameraMode cameraMode, float frontClipDistance, float backClipDistance, float screenScale) {
        return BackgroundRenderPass.createParallel(new BranchGroup(), cameraMode, frontClipDistance, backClipDistance, screenScale, -9999.0f);
    }

    public static BackgroundRenderPass createParallel(float frontClipDistance, float backClipDistance, float screenScale) {
        return BackgroundRenderPass.createParallel(new BranchGroup(), frontClipDistance, backClipDistance, screenScale, -9999.0f);
    }

    public static BackgroundRenderPass createParallel(BranchGroup branchGroup, View.CameraMode cameraMode, float frontClipDistance, float backClipDistance) {
        return BackgroundRenderPass.createParallel(branchGroup, cameraMode, frontClipDistance, backClipDistance, -9999.0f, -9999.0f);
    }

    public static BackgroundRenderPass createParallel(BranchGroup branchGroup, float frontClipDistance, float backClipDistance) {
        return BackgroundRenderPass.createParallel(branchGroup, frontClipDistance, backClipDistance, -9999.0f, -9999.0f);
    }

    public static BackgroundRenderPass createParallel(View.CameraMode cameraMode, float frontClipDistance, float backClipDistance) {
        return BackgroundRenderPass.createParallel(new BranchGroup(), cameraMode, frontClipDistance, backClipDistance, -9999.0f, -9999.0f);
    }

    public static BackgroundRenderPass createParallel(float frontClipDistance, float backClipDistance) {
        return BackgroundRenderPass.createParallel(new BranchGroup(), frontClipDistance, backClipDistance, -9999.0f, -9999.0f);
    }

    public static BackgroundRenderPass createParallel(BranchGroup branchGroup, View.CameraMode cameraMode, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy) {
        return BackgroundRenderPass.createParallel(branchGroup, cameraMode, opaqueSortingPolicy, transparentSortingPolicy, -9999.0f, -9999.0f, -9999.0f, -9999.0f);
    }

    public static BackgroundRenderPass createParallel(BranchGroup branchGroup, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy) {
        return BackgroundRenderPass.createParallel(branchGroup, opaqueSortingPolicy, transparentSortingPolicy, -9999.0f, -9999.0f, -9999.0f, -9999.0f);
    }

    public static BackgroundRenderPass createParallel(View.CameraMode cameraMode, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy) {
        return BackgroundRenderPass.createParallel(new BranchGroup(), cameraMode, opaqueSortingPolicy, transparentSortingPolicy, -9999.0f, -9999.0f, -9999.0f, -9999.0f);
    }

    public static BackgroundRenderPass createParallel(Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy) {
        return BackgroundRenderPass.createParallel(new BranchGroup(), opaqueSortingPolicy, transparentSortingPolicy, -9999.0f, -9999.0f, -9999.0f, -9999.0f);
    }

    public static BackgroundRenderPass createParallel(BranchGroup branchGroup, View.CameraMode cameraMode) {
        return BackgroundRenderPass.createParallel(branchGroup, cameraMode, -9999.0f, -9999.0f, -9999.0f, -9999.0f);
    }

    public static BackgroundRenderPass createParallel(BranchGroup branchGroup) {
        return BackgroundRenderPass.createParallel(branchGroup, -9999.0f, -9999.0f, -9999.0f, -9999.0f);
    }

    public static BackgroundRenderPass createParallel(View.CameraMode cameraMode) {
        return BackgroundRenderPass.createParallel(new BranchGroup(), cameraMode, -9999.0f, -9999.0f, -9999.0f, -9999.0f);
    }

    public static BackgroundRenderPass createParallel() {
        return BackgroundRenderPass.createParallel(new BranchGroup(), -9999.0f, -9999.0f, -9999.0f, -9999.0f);
    }

    public static BackgroundRenderPass createParallel(BranchGroup branchGroup, View.CameraMode cameraMode, int screenWidth, int screenHeight, boolean moveCenterToUpperLeft) {
        Tuple2f centerOfView = moveCenterToUpperLeft ? new Tuple2f(-((float)screenWidth) / 2.0f, (float)screenHeight / 2.0f) : null;
        BaseRenderPassConfig config = new BaseRenderPassConfig(View.ProjectionPolicy.PARALLEL_PROJECTION, (Renderer.OpaqueSortingPolicy)null, Renderer.TransparentSortingPolicy.SORT_BY_Z_VALUE, -9999.0f, -9999.0f, (float)screenWidth / 2.0f, -9999.0f);
        config.setCenterOfView(centerOfView);
        return new BackgroundRenderPass(branchGroup, config);
    }

    public static BackgroundRenderPass createParallel(BranchGroup branchGroup, int screenWidth, int screenHeight, boolean moveCenterToUpperLeft) {
        return BackgroundRenderPass.createParallel(branchGroup, RenderPassConfig.DEFAULT_CAMERA_MODE, screenWidth, screenHeight, moveCenterToUpperLeft);
    }

    public static BackgroundRenderPass createParallel(BranchGroup branchGroup, View.CameraMode cameraMode, Sized2iRO screenSize, boolean moveCenterToUpperLeft) {
        return BackgroundRenderPass.createParallel(branchGroup, cameraMode, screenSize.getWidth(), screenSize.getHeight(), moveCenterToUpperLeft);
    }

    public static BackgroundRenderPass createParallel(BranchGroup branchGroup, Sized2iRO screenSize, boolean moveCenterToUpperLeft) {
        return BackgroundRenderPass.createParallel(branchGroup, screenSize.getWidth(), screenSize.getHeight(), moveCenterToUpperLeft);
    }

    public static BackgroundRenderPass createParallel(View.CameraMode cameraMode, int screenWidth, int screenHeight, boolean moveCenterToUpperLeft) {
        return BackgroundRenderPass.createParallel(new BranchGroup(), cameraMode, screenWidth, screenHeight, moveCenterToUpperLeft);
    }

    public static BackgroundRenderPass createParallel(int screenWidth, int screenHeight, boolean moveCenterToUpperLeft) {
        return BackgroundRenderPass.createParallel(new BranchGroup(), screenWidth, screenHeight, moveCenterToUpperLeft);
    }

    public static BackgroundRenderPass createParallel(View.CameraMode cameraMode, Sized2iRO screenSize, boolean moveCenterToUpperLeft) {
        return BackgroundRenderPass.createParallel(new BranchGroup(), cameraMode, screenSize.getWidth(), screenSize.getHeight(), moveCenterToUpperLeft);
    }

    public static BackgroundRenderPass createParallel(Sized2iRO screenSize, boolean moveCenterToUpperLeft) {
        return BackgroundRenderPass.createParallel(new BranchGroup(), screenSize.getWidth(), screenSize.getHeight(), moveCenterToUpperLeft);
    }
}

