/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render;

import org.openmali.types.twodee.Rect2i;
import org.openmali.vecmath2.Tuple2f;
import org.xith3d.render.RenderOptions;
import org.xith3d.render.RenderPassConfig;
import org.xith3d.render.Renderer;
import org.xith3d.render.preprocessing.sorting.RenderBinSorter;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.View;

public class BaseRenderPassConfig
implements RenderPassConfig {
    private View.ProjectionPolicy projectionPolicy;
    private View.CameraMode cameraMode;
    private RenderBinSorter opaqueRenderBinSorter;
    private RenderBinSorter transparentRenderBinSorter;
    private Renderer.OpaqueSortingPolicy opaqueSortingPolicy;
    private Renderer.TransparentSortingPolicy transparentSortingPolicy;
    private float frontClipDistance;
    private float backClipDistance;
    private float screenScale;
    private float fieldOfView;
    private Tuple2f centerOfView = null;
    private Rect2i viewport;
    private Transform3D viewTransform;
    private RenderOptions renderOptions;
    private int colorMask;

    public View.ProjectionPolicy getProjectionPolicy() {
        return this.projectionPolicy;
    }

    public void setProjectionPolicy(View.ProjectionPolicy policy) {
        if (this.cameraMode == null) {
            throw new IllegalArgumentException("ProjectionPolicy must not be null");
        }
        this.projectionPolicy = policy;
    }

    public void setCameraMode(View.CameraMode cameraMode) {
        this.cameraMode = cameraMode;
    }

    public View.CameraMode getCameraMode() {
        return this.cameraMode;
    }

    public final void setOpaqueSorter(RenderBinSorter sorter) {
        this.opaqueRenderBinSorter = sorter;
        this.opaqueSortingPolicy = Renderer.OpaqueSortingPolicy.CUSTOM;
    }

    public final RenderBinSorter getOpaqueSorter() {
        return this.opaqueRenderBinSorter;
    }

    public final void setTransparentSorter(RenderBinSorter sorter) {
        this.transparentRenderBinSorter = sorter;
        this.transparentSortingPolicy = Renderer.TransparentSortingPolicy.CUSTOM;
    }

    public final RenderBinSorter getTransparentSorter() {
        return this.transparentRenderBinSorter;
    }

    public final void setOpaqueSortingPolicy(Renderer.OpaqueSortingPolicy policy) {
        this.opaqueRenderBinSorter = policy != null ? policy.getSorter() : null;
        this.opaqueSortingPolicy = policy;
    }

    public final Renderer.OpaqueSortingPolicy getOpaqueSortingPolicy() {
        return this.opaqueSortingPolicy;
    }

    public final void setTransparentSortingPolicy(Renderer.TransparentSortingPolicy policy) {
        this.transparentRenderBinSorter = policy != null ? policy.getSorter() : null;
        this.transparentSortingPolicy = policy;
    }

    public final Renderer.TransparentSortingPolicy getTransparentSortingPolicy() {
        return this.transparentSortingPolicy;
    }

    public float getFrontClipDistance() {
        return this.frontClipDistance;
    }

    public void setFrontClipDistance(float frontClipDistance) {
        this.frontClipDistance = frontClipDistance;
    }

    public float getBackClipDistance() {
        return this.backClipDistance;
    }

    public void setBackClipDistance(float backClipDistance) {
        this.backClipDistance = backClipDistance;
    }

    public float getScreenScale() {
        return this.screenScale;
    }

    public void setScreenScale(float screenScale) {
        this.screenScale = screenScale;
    }

    public float getFieldOfView() {
        return this.fieldOfView;
    }

    public void setFieldOfView(float fov) {
        this.fieldOfView = fov;
    }

    public final void setCenterOfView(Tuple2f cov) {
        this.centerOfView = cov;
    }

    public final Tuple2f getCenterOfView() {
        return this.centerOfView;
    }

    public void setViewport(Rect2i rect) {
        this.viewport = rect;
    }

    public Rect2i getViewport() {
        return this.viewport;
    }

    public void setViewTransform(Transform3D viewTransform) {
        this.viewTransform = viewTransform;
    }

    public Transform3D getViewTransform() {
        return this.viewTransform;
    }

    public void setRenderOptions(RenderOptions renderOptions) {
        this.renderOptions = renderOptions;
    }

    public RenderOptions getRenderOptions() {
        return this.renderOptions;
    }

    public final void setColorMask(int colorMask) {
        this.colorMask = colorMask;
    }

    public final void setColorMask(boolean enableRed, boolean enableGreen, boolean enableBlue, boolean enableAlpha) {
        this.colorMask = 0;
        if (enableRed) {
            this.colorMask |= 1;
        }
        if (enableGreen) {
            this.colorMask |= 2;
        }
        if (enableBlue) {
            this.colorMask |= 4;
        }
        if (enableAlpha) {
            this.colorMask |= 8;
        }
    }

    public final int getColorMask() {
        return this.colorMask;
    }

    public void set(RenderPassConfig template) {
        this.projectionPolicy = template.getProjectionPolicy();
        this.cameraMode = template.getCameraMode();
        this.setOpaqueSortingPolicy(template.getOpaqueSortingPolicy());
        this.opaqueRenderBinSorter = template.getOpaqueSorter();
        this.setTransparentSortingPolicy(template.getTransparentSortingPolicy());
        this.transparentRenderBinSorter = template.getTransparentSorter();
        this.frontClipDistance = template.getFrontClipDistance();
        this.backClipDistance = template.getBackClipDistance();
        this.screenScale = template.getScreenScale();
        this.fieldOfView = template.getFieldOfView();
        this.centerOfView = template.getCenterOfView();
        this.viewport = template.getViewport();
        this.viewTransform = template.getViewTransform();
        this.renderOptions = template.getRenderOptions();
        this.colorMask = template.getColorMask();
    }

    public BaseRenderPassConfig(RenderPassConfig template) {
        this.set(template);
    }

    public BaseRenderPassConfig(View.ProjectionPolicy projectionPolicy, View.CameraMode cameraMode, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy, float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView, Rect2i viewport, Transform3D viewTransform) {
        this.projectionPolicy = projectionPolicy;
        this.setCameraMode(cameraMode);
        this.setOpaqueSortingPolicy(opaqueSortingPolicy);
        this.setTransparentSortingPolicy(transparentSortingPolicy);
        this.frontClipDistance = frontClipDistance;
        this.backClipDistance = backClipDistance;
        this.screenScale = screenScale;
        this.fieldOfView = fieldOfView;
        this.centerOfView = null;
        this.viewport = viewport;
        this.viewTransform = viewTransform;
        this.renderOptions = null;
        this.colorMask = -1;
    }

    public BaseRenderPassConfig(View.ProjectionPolicy projectionPolicy, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy, float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView, Rect2i viewport, Transform3D viewTransform) {
        this(projectionPolicy, DEFAULT_CAMERA_MODE, opaqueSortingPolicy, transparentSortingPolicy, frontClipDistance, backClipDistance, screenScale, fieldOfView, viewport, null);
    }

    public BaseRenderPassConfig(View.ProjectionPolicy projectionPolicy, View.CameraMode cameraMode, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy, float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView, Rect2i viewport) {
        this(projectionPolicy, cameraMode, opaqueSortingPolicy, transparentSortingPolicy, frontClipDistance, backClipDistance, screenScale, fieldOfView, viewport, null);
    }

    public BaseRenderPassConfig(View.ProjectionPolicy projectionPolicy, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy, float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView, Rect2i viewport) {
        this(projectionPolicy, opaqueSortingPolicy, transparentSortingPolicy, frontClipDistance, backClipDistance, screenScale, fieldOfView, viewport, null);
    }

    public BaseRenderPassConfig(View.ProjectionPolicy projectionPolicy, View.CameraMode cameraMode, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy, float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView) {
        this(projectionPolicy, cameraMode, opaqueSortingPolicy, transparentSortingPolicy, frontClipDistance, backClipDistance, screenScale, fieldOfView, null);
    }

    public BaseRenderPassConfig(View.ProjectionPolicy projectionPolicy, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy, float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView) {
        this(projectionPolicy, opaqueSortingPolicy, transparentSortingPolicy, frontClipDistance, backClipDistance, screenScale, fieldOfView, null);
    }

    public BaseRenderPassConfig(View.ProjectionPolicy projectionPolicy, View.CameraMode cameraMode, float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView, Rect2i viewport) {
        this(projectionPolicy, cameraMode, null, null, frontClipDistance, backClipDistance, screenScale, fieldOfView, viewport);
    }

    public BaseRenderPassConfig(View.ProjectionPolicy projectionPolicy, float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView, Rect2i viewport) {
        this(projectionPolicy, null, null, frontClipDistance, backClipDistance, screenScale, fieldOfView, viewport);
    }

    public BaseRenderPassConfig(View.ProjectionPolicy projectionPolicy, View.CameraMode cameraMode, float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView) {
        this(projectionPolicy, cameraMode, null, null, frontClipDistance, backClipDistance, screenScale, fieldOfView, null);
    }

    public BaseRenderPassConfig(View.ProjectionPolicy projectionPolicy, float frontClipDistance, float backClipDistance, float screenScale, float fieldOfView) {
        this(projectionPolicy, null, null, frontClipDistance, backClipDistance, screenScale, fieldOfView, null);
    }

    public BaseRenderPassConfig(View.ProjectionPolicy projectionPolicy, View.CameraMode cameraMode, float frontClipDistance, float backClipDistance, float screenScale, Rect2i viewport) {
        this(projectionPolicy, cameraMode, frontClipDistance, backClipDistance, screenScale, -9999.0f, viewport);
    }

    public BaseRenderPassConfig(View.ProjectionPolicy projectionPolicy, float frontClipDistance, float backClipDistance, float screenScale, Rect2i viewport) {
        this(projectionPolicy, frontClipDistance, backClipDistance, screenScale, -9999.0f, viewport);
    }

    public BaseRenderPassConfig(View.ProjectionPolicy projectionPolicy, View.CameraMode cameraMode, float frontClipDistance, float backClipDistance, float screenScale) {
        this(projectionPolicy, cameraMode, frontClipDistance, backClipDistance, screenScale, -9999.0f);
    }

    public BaseRenderPassConfig(View.ProjectionPolicy projectionPolicy, float frontClipDistance, float backClipDistance, float screenScale) {
        this(projectionPolicy, frontClipDistance, backClipDistance, screenScale, -9999.0f);
    }

    public BaseRenderPassConfig(View.ProjectionPolicy projectionPolicy, View.CameraMode cameraMode, float frontClipDistance, float backClipDistance, Rect2i viewport) {
        this(projectionPolicy, cameraMode, frontClipDistance, backClipDistance, -9999.0f, -9999.0f, viewport);
    }

    public BaseRenderPassConfig(View.ProjectionPolicy projectionPolicy, float frontClipDistance, float backClipDistance, Rect2i viewport) {
        this(projectionPolicy, frontClipDistance, backClipDistance, -9999.0f, -9999.0f, viewport);
    }

    public BaseRenderPassConfig(View.ProjectionPolicy projectionPolicy, View.CameraMode cameraMode, float frontClipDistance, float backClipDistance) {
        this(projectionPolicy, cameraMode, frontClipDistance, backClipDistance, -9999.0f, -9999.0f);
    }

    public BaseRenderPassConfig(View.ProjectionPolicy projectionPolicy, float frontClipDistance, float backClipDistance) {
        this(projectionPolicy, frontClipDistance, backClipDistance, -9999.0f, -9999.0f);
    }

    public BaseRenderPassConfig(View.ProjectionPolicy projectionPolicy, View.CameraMode cameraMode, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy, Rect2i viewport) {
        this(projectionPolicy, cameraMode, opaqueSortingPolicy, transparentSortingPolicy, -9999.0f, -9999.0f, -9999.0f, -9999.0f, viewport);
    }

    public BaseRenderPassConfig(View.ProjectionPolicy projectionPolicy, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy, Rect2i viewport) {
        this(projectionPolicy, opaqueSortingPolicy, transparentSortingPolicy, -9999.0f, -9999.0f, -9999.0f, -9999.0f, viewport);
    }

    public BaseRenderPassConfig(View.ProjectionPolicy projectionPolicy, View.CameraMode cameraMode, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy) {
        this(projectionPolicy, cameraMode, opaqueSortingPolicy, transparentSortingPolicy, -9999.0f, -9999.0f, -9999.0f, -9999.0f);
    }

    public BaseRenderPassConfig(View.ProjectionPolicy projectionPolicy, Renderer.OpaqueSortingPolicy opaqueSortingPolicy, Renderer.TransparentSortingPolicy transparentSortingPolicy) {
        this(projectionPolicy, opaqueSortingPolicy, transparentSortingPolicy, -9999.0f, -9999.0f, -9999.0f, -9999.0f);
    }

    public BaseRenderPassConfig(View.ProjectionPolicy projectionPolicy, View.CameraMode cameraMode, Rect2i viewport) {
        this(projectionPolicy, cameraMode, -9999.0f, -9999.0f, -9999.0f, -9999.0f, viewport);
    }

    public BaseRenderPassConfig(View.ProjectionPolicy projectionPolicy, Rect2i viewport) {
        this(projectionPolicy, -9999.0f, -9999.0f, -9999.0f, -9999.0f, viewport);
    }

    public BaseRenderPassConfig(View.ProjectionPolicy projectionPolicy, View.CameraMode cameraMode) {
        this(projectionPolicy, cameraMode, -9999.0f, -9999.0f, -9999.0f, -9999.0f);
    }

    public BaseRenderPassConfig(View.ProjectionPolicy projectionPolicy) {
        this(projectionPolicy, -9999.0f, -9999.0f, -9999.0f, -9999.0f);
    }

    public BaseRenderPassConfig(View.CameraMode cameraMode, Rect2i viewport) {
        this((View.ProjectionPolicy)null, cameraMode, viewport);
    }

    public BaseRenderPassConfig(Rect2i viewport) {
        this((View.ProjectionPolicy)null, viewport);
    }

    public BaseRenderPassConfig(View.CameraMode cameraMode) {
        this((View.ProjectionPolicy)null, cameraMode);
    }

    public BaseRenderPassConfig() {
        this((View.ProjectionPolicy)null);
    }
}

