/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jagatoo.input.devices.InputDeviceFactory;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.input.render.Cursor;
import org.openmali.types.twodee.ExtPositioned2i;
import org.openmali.types.twodee.ExtSized2i;
import org.openmali.types.twodee.Rect2i;
import org.openmali.types.twodee.Sized2i;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.types.twodee.util.RepositionListener2i;
import org.openmali.types.twodee.util.ResizeListener2i;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Matrix4f;
import org.openmali.vecmath2.MatrixMxNf;
import org.openmali.vecmath2.Point2i;
import org.openmali.vecmath2.Tuple2i;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector4f;
import org.openmali.vecmath2.VectorNf;
import org.xith3d.picking.AllPickListener;
import org.xith3d.picking.NearestPickListener;
import org.xith3d.picking.PickEngine;
import org.xith3d.picking.PickPool;
import org.xith3d.picking.PickRequest;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.RenderOptions;
import org.xith3d.render.RenderPass;
import org.xith3d.render.Renderer;
import org.xith3d.render.util.WindowClosingListener;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.View;
import org.xith3d.utility.screenshots.ScreenshotEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Canvas3D
implements ExtPositioned2i,
ExtSized2i,
ScreenshotEngine,
PickEngine {
    protected int oldWidth = -1;
    protected int oldHeight = -1;
    private CanvasPeer peer;
    private View view;
    private Colorf backgroundColor = new Colorf();
    private List<ResizeListener2i> resizeListeners = new ArrayList<ResizeListener2i>();
    private Renderer renderer = null;

    protected final void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    public final Renderer getRenderer() {
        return this.renderer;
    }

    public void addRepositionListener(RepositionListener2i listener) {
    }

    public void removeRepositionListener(RepositionListener2i listener) {
    }

    public void addResizeListener(ResizeListener2i listener) {
        this.resizeListeners.add(listener);
    }

    public void removeResizeListener(ResizeListener2i listener) {
        this.resizeListeners.remove(listener);
    }

    protected void fireResizeEvent() {
        if (this.resizeListeners.size() > 0) {
            int width = this.getWidth();
            int height = this.getHeight();
            for (int i = 0; i < this.resizeListeners.size(); ++i) {
                if (this.oldWidth == -1 && this.oldHeight == -1) {
                    this.resizeListeners.get(i).onObjectResized((Sized2i)this, width, height, width, height);
                    continue;
                }
                this.resizeListeners.get(i).onObjectResized((Sized2i)this, this.oldWidth, this.oldHeight, width, height);
            }
            this.oldWidth = width;
            this.oldHeight = height;
        }
    }

    public void addWindowClosingListener(WindowClosingListener l) {
        this.getPeer().addWindowClosingListener(l);
    }

    public void removeWindowClosingListener(WindowClosingListener l) {
        this.getPeer().removeWindowClosingListener(l);
    }

    protected void checkForResized() {
        if (this.getWidth() != this.oldWidth || this.getHeight() != this.oldHeight) {
            this.fireResizeEvent();
        }
    }

    public final void setView(View view) {
        this.view = view;
    }

    public final View getView() {
        return this.view;
    }

    protected final void setPeer(CanvasPeer peer) {
        this.peer = peer;
        if (this.backgroundColor != null) {
            this.setBackgroundColor(this.backgroundColor);
        }
    }

    public final CanvasPeer getPeer() {
        return this.peer;
    }

    @Deprecated
    public final CanvasPeer getCanvasPeer() {
        return this.getPeer();
    }

    public final String getTitle() {
        return this.peer.getTitle();
    }

    public final void setTitle(String title) {
        this.peer.setTitle(title);
    }

    public final void setIcon(URL iconResource) throws IOException {
        if (this.peer == null) {
            throw new NullPointerException("CanvasPeer not set");
        }
        this.peer.setIcon(iconResource);
    }

    public final void clear() {
        if (this.peer == null) {
            throw new NullPointerException("CanvasPeer not set");
        }
        this.peer.clear();
    }

    public final void setCursor(Cursor cursor) {
        this.getPeer().setCursor(cursor);
    }

    public final Cursor getCursor() {
        return this.getPeer().getCursor();
    }

    public final InputDeviceFactory getInputDeviceFactory() {
        return this.getPeer().getInputDeviceFactory();
    }

    public final Tuple2i getLocation() {
        return new Point2i(this.getLeft(), this.getTop());
    }

    public final Canvas3D setLocation(int left, int top) {
        this.peer.setLocation(left, top);
        return this;
    }

    public void setCentered() {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (d.width - this.getWidth()) / 2;
        int y = (d.height - this.getHeight()) / 2;
        this.setLocation(x, y);
    }

    public final Canvas3D setLocation(Tuple2i loc) {
        return this.setLocation(loc.getX(), loc.getY());
    }

    public final int getLeft() {
        return this.peer.getLeft();
    }

    public final int getTop() {
        return this.peer.getTop();
    }

    public final Tuple2i getSize() {
        return new Point2i(this.peer.getWidth(), this.peer.getHeight());
    }

    public final Canvas3D setSize(int width, int height) {
        this.peer.setSize(width, height);
        return this;
    }

    public final Canvas3D setSize(Sized2iRO size) {
        return this.setSize(size.getWidth(), size.getHeight());
    }

    public final Canvas3D setSize(Tuple2i size) {
        return this.setSize(size.getX(), size.getY());
    }

    public final void setWidth(int width) {
        this.setSize(width, this.getHeight());
    }

    public final void setHeight(int height) {
        this.setSize(this.getWidth(), height);
    }

    public final int getWidth() {
        return this.peer.getWidth();
    }

    public final int getHeight() {
        return this.peer.getHeight();
    }

    public final float getAspect() {
        return (float)this.getWidth() / (float)this.getHeight();
    }

    public final boolean setFullscreen(boolean fullscreen) {
        boolean oldState = this.isFullscreen();
        if (oldState == fullscreen) {
            return oldState;
        }
        this.peer.setFullscreen(fullscreen);
        return oldState;
    }

    public final boolean isFullscreen() {
        return this.peer.isFullscreen();
    }

    public final boolean isUndecorated() {
        return this.peer.isUndecorated();
    }

    public final void setViewport(Rect2i viewport) {
        this.peer.setViewport(viewport);
    }

    public final Rect2i getViewport() {
        return this.peer.getViewport();
    }

    public final void setBackgroundColor(float red, float green, float blue) {
        this.backgroundColor.set(red, green, blue);
        this.getPeer().getRenderPeer().setClearColor(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue(), this.backgroundColor.getAlpha());
    }

    public final void setBackgroundColor(Colorf color) {
        assert (color != null);
        this.setBackgroundColor(color.getRed(), color.getGreen(), color.getBlue());
    }

    public final Colorf getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setRenderOptions(RenderOptions ro) {
        this.getPeer().getRenderPeer().setRenderOptions(ro);
    }

    public final RenderOptions getRenderOptions() {
        return this.getPeer().getRenderPeer().getRenderOptions();
    }

    public void setWireframeMode(boolean enabled) {
        this.getRenderOptions().setWireframeModeEnabled(enabled);
    }

    public boolean isWireframeMode() {
        return this.getRenderOptions().isWireframeModeEnabled();
    }

    public boolean switchWireframeMode() {
        return this.getRenderOptions().switchWireframeMode();
    }

    public void enableLighting() {
        this.getRenderOptions().setLightingEnabled(true);
    }

    public void disableLighting() {
        this.getRenderOptions().setLightingEnabled(false);
    }

    public void setGamma(float gamma, float brightness, float contrast) {
        this.getPeer().setGamma(gamma, brightness, contrast);
    }

    public float getGamma() {
        return this.getPeer().getGamma();
    }

    public float getBrightness() {
        return this.getPeer().getBrightness();
    }

    public float getContrast() {
        return this.getPeer().getContrast();
    }

    @Override
    public final void takeScreenshot(File file, boolean alpha) {
        this.getPeer().takeScreenshot(file, alpha);
    }

    @Override
    public final File takeScreenshot(String filenameBase, boolean alpha) {
        return this.getPeer().takeScreenshot(filenameBase, alpha);
    }

    @Override
    public final File takeScreenshot(boolean alpha) {
        return this.getPeer().takeScreenshot(alpha);
    }

    private final void pick(List<? extends GroupNode> rootGroups, MouseButton button, int x, int y, int width, int height, Object pickListener, boolean pickAll, Object userObject) {
        List<RenderPass> renderPasses = this.getRenderer().getRenderPasses(rootGroups.get(0).getRoot());
        for (int i = 0; i < rootGroups.size(); ++i) {
            PickRequest preq = PickPool.allocatePickRequest(renderPasses.get(0), rootGroups.get(i), this, button, x, y, pickListener, userObject, pickAll);
            this.getRenderer().addPickRequest(preq);
        }
    }

    private final void pick(GroupNode rootGroup, MouseButton button, int x, int y, int width, int height, Object pickListener, boolean pickAll, Object userObject) {
        List<RenderPass> renderPasses = this.getRenderer().getRenderPasses(rootGroup.getRoot());
        PickRequest preq = PickPool.allocatePickRequest(renderPasses.get(0), rootGroup, this, button, x, y, pickListener, userObject, pickAll);
        this.getRenderer().addPickRequest(preq);
    }

    public final void pickAll(List<? extends GroupNode> groups, MouseButton button, int x, int y, int width, int height, AllPickListener pl, Object userObject) {
        this.pick(groups, button, x, y, width, height, (Object)pl, true, userObject);
    }

    public final void pickNearest(List<? extends GroupNode> groups, MouseButton button, int x, int y, int width, int height, NearestPickListener pl, Object userObject) {
        this.pick(groups, button, x, y, width, height, (Object)pl, false, userObject);
    }

    @Override
    public final void pickAll(List<? extends GroupNode> groups, MouseButton button, int x, int y, AllPickListener pl, Object userObject) {
        this.pick(groups, button, x, y, 1, 1, (Object)pl, true, userObject);
    }

    @Override
    public final void pickAll(List<? extends GroupNode> groups, MouseButton button, int x, int y, AllPickListener pl) {
        this.pick(groups, button, x, y, 1, 1, (Object)pl, true, (Object)null);
    }

    @Override
    public final void pickNearest(List<? extends GroupNode> groups, MouseButton button, int x, int y, NearestPickListener pl, Object userObject) {
        this.pick(groups, button, x, y, 1, 1, (Object)pl, false, userObject);
    }

    @Override
    public final void pickNearest(List<? extends GroupNode> groups, MouseButton button, int x, int y, NearestPickListener pl) {
        this.pick(groups, button, x, y, 1, 1, (Object)pl, false, (Object)null);
    }

    @Override
    public final void pickAll(GroupNode group, MouseButton button, int x, int y, AllPickListener pl, Object userObject) {
        this.pick(group, button, x, y, 1, 1, (Object)pl, true, userObject);
    }

    @Override
    public final void pickAll(GroupNode group, MouseButton button, int x, int y, AllPickListener pl) {
        this.pick(group, button, x, y, 1, 1, (Object)pl, true, (Object)null);
    }

    @Override
    public final void pickNearest(GroupNode group, MouseButton button, int x, int y, NearestPickListener pl, Object userObject) {
        this.pick(group, button, x, y, 1, 1, (Object)pl, false, userObject);
    }

    @Override
    public final void pickNearest(GroupNode group, MouseButton button, int x, int y, NearestPickListener pl) {
        this.pick(group, button, x, y, 1, 1, (Object)pl, false, (Object)null);
    }

    public void worldToScreen(Tuple3f world, Tuple2i screen) {
        Object viewport = this.getViewport();
        if (viewport == null) {
            viewport = this;
        }
        Matrix4f mP = this.getView().calculatePerspective((Sized2iRO)viewport).getMatrix4f();
        Matrix4f mM = this.getView().getModelViewTransform(true).getMatrix4f();
        Vector4f v0 = Vector4f.fromPool();
        v0.set(world.getX(), world.getY(), world.getZ(), 1.0f);
        Vector4f v = Vector4f.fromPool();
        v.mul((MatrixMxNf)mM, (VectorNf)v0);
        v0.set((TupleNf)v);
        v.mul((MatrixMxNf)mP, (VectorNf)v0);
        v.setW(1.0f / v.getW() * 0.5f);
        v.setX(v.getX() * v.getW() + 0.5f);
        v.setY(v.getY() * v.getW() + 0.5f);
        v.setZ(v.getZ() * v.getW() + 0.5f);
        float xs = (float)viewport.getWidth() * v.getX();
        float ys = (float)viewport.getHeight() - (float)viewport.getHeight() * v.getY();
        if (this.getViewport() != null) {
            xs += (float)viewport.getLeft();
            ys += (float)viewport.getTop();
        }
        screen.set(Math.round(xs), Math.round(ys));
        Vector4f.toPool((Vector4f)v);
        Vector4f.toPool((Vector4f)v0);
    }

    protected Canvas3D(CanvasPeer peer, float backgroundColorR, float backgroundColorG, float backgroundColorB) {
        assert (peer != null);
        this.peer = peer;
        peer.setCanvas3D(this);
        this.setBackgroundColor(backgroundColorR, backgroundColorG, backgroundColorB);
    }

    protected Canvas3D(CanvasPeer peer, Colorf backgroundColor) {
        this(peer, backgroundColor.getRed(), backgroundColor.getGreen(), backgroundColor.getBlue());
    }

    protected Canvas3D(CanvasPeer peer) {
        this(peer, 0.2f, 0.2f, 0.2f);
    }
}

