/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render;

import java.io.File;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.List;
import org.xith3d.picking.PickRequest;
import org.xith3d.picking.PickResult;
import org.xith3d.render.BillboardManager;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.OpenGLCapabilities;
import org.xith3d.render.OpenGLStatesCache;
import org.xith3d.render.RenderOptions;
import org.xith3d.render.RenderPass;
import org.xith3d.render.StateUnitPeerRegistry;
import org.xith3d.render.preprocessing.RenderAtom;
import org.xith3d.render.preprocessing.RenderBinProvider;
import org.xith3d.render.states.StateUnit;
import org.xith3d.render.states.units.StateUnitPeer;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.View;
import org.xith3d.utility.general.SortableList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RenderPeer {
    private CanvasPeer canvasPeer;
    private StateUnitPeerRegistry stateUnitRegistry;
    private RenderOptions renderOptions;
    protected boolean forceNoSwap = false;
    protected boolean disableClearBuffer = false;
    protected boolean fullOverpaint = false;
    protected float[] clearColor = new float[]{0.2f, 0.2f, 0.2f, 0.0f};
    protected int colorMask = 15;
    protected boolean backgroundCachingEnabled = false;
    private static final long[] nulledStates = new long[17];
    private final long[] stateIDs = new long[nulledStates.length];
    protected IntBuffer selectBuffer = null;
    private SortableList<PickResult> pickResults = new SortableList();
    private PickResult pickResult = null;
    private final OpenGLStatesCache statesCache;
    private static boolean gcRequested;

    protected static void setGCRequested(boolean gcReq) {
        gcRequested = gcReq;
    }

    protected static final void checkGCRequested() {
        if (gcRequested) {
            gcRequested = false;
        }
    }

    protected void setCanvasPeer(CanvasPeer canvasPeer) {
        this.canvasPeer = canvasPeer;
    }

    public final CanvasPeer getCanvasPeer() {
        return this.canvasPeer;
    }

    public final StateUnitPeerRegistry getShaderRegistry() {
        return this.stateUnitRegistry;
    }

    public void setRenderOptions(RenderOptions renderOptions) {
        this.renderOptions = renderOptions;
    }

    public final RenderOptions getRenderOptions() {
        return this.renderOptions;
    }

    public final OpenGLStatesCache getStatesCache() {
        return this.statesCache;
    }

    public final void setClearColor(float r, float g, float b, float a) {
        this.clearColor[0] = r;
        this.clearColor[1] = g;
        this.clearColor[2] = b;
        this.clearColor[3] = a;
    }

    public final void setDisableClearBuffer(boolean val) {
        this.disableClearBuffer = val;
    }

    public final void setFullOverpaint(boolean val) {
        this.fullOverpaint = val;
    }

    public final void setForceNoSwap(boolean forceNoSwap) {
        this.forceNoSwap = forceNoSwap;
    }

    public final void setColorMask(boolean enableRed, boolean enableGreen, boolean enableBlue, boolean enableAlpha) {
        this.colorMask = 0;
        if (enableRed) {
            this.colorMask |= 1;
        }
        if (enableGreen) {
            this.colorMask |= 2;
        }
        if (enableBlue) {
            this.colorMask |= 4;
        }
        if (enableAlpha) {
            this.colorMask |= 8;
        }
    }

    public void setBackgroundCachingEnabled(boolean enabled) {
        this.backgroundCachingEnabled = enabled;
    }

    protected final void resetStateUnitStateArrays() {
        System.arraycopy(nulledStates, 0, this.stateIDs, 0, this.stateIDs.length);
    }

    protected void renderStart(PickRequest pickRequest) {
        this.resetStateUnitStateArrays();
        if (pickRequest != null) {
            if (pickRequest.getPickAll()) {
                this.pickResults.clear();
            } else {
                this.pickResult = null;
            }
        }
    }

    public final void forceState(int stateType) {
        this.stateIDs[stateType] = -1L;
    }

    public final int renderAtom(RenderAtom<?> atom, Object glObj, CanvasPeer canvasPeer, OpenGLCapabilities glCaps, OpenGLStatesCache statesCache, View view, RenderOptions options, long nanoTime, long nanoStep, RenderMode renderMode, long frameId) {
        int atomType;
        if (((Node)atom.getNode()).isBillboard()) {
            BillboardManager.updateBillboardGeometry(atom, view, this.getCanvasPeer().getWidth(), this.getCanvasPeer().getHeight(), nanoTime, nanoStep, frameId);
        }
        if ((atomType = atom.getStateType()) != 1 && renderMode == RenderMode.NORMAL) {
            StateUnit[] stateUnits = atom.getStateUnits();
            for (int stateType = 0; stateType < 17; ++stateType) {
                StateUnit stateUnit = stateUnits[stateType];
                long stateId = stateUnit.getCachedStateId();
                if (this.stateIDs[stateType] == stateId) continue;
                StateUnitPeer stateUnitPeer = this.stateUnitRegistry.getStateUnitPeer(stateType);
                stateUnitPeer.apply(atom, stateUnit, glObj, canvasPeer, this, glCaps, view, statesCache, options, nanoTime, nanoStep, renderMode, frameId);
                this.stateIDs[stateType] = stateId;
            }
        }
        return this.stateUnitRegistry.getRenderAtomPeer(atomType).renderAtom(atom, glObj, this, glCaps, view, options, nanoTime, nanoStep, renderMode, frameId);
    }

    public final List<PickResult> getPickResults() {
        return this.pickResults;
    }

    public final PickResult getPickResult() {
        return this.pickResult;
    }

    protected final RenderAtom<?> getAtomByGlobalIndex(int index, List<RenderPass> renderPasses) {
        int offset = 0;
        for (int i = 0; i < renderPasses.size(); ++i) {
            RenderPass pass = renderPasses.get(i);
            RenderBinProvider binProvider = pass.getRenderBinProvider();
            if (pass.isEnabled()) {
                if (index < offset + binProvider.getOpaqueBin().size()) {
                    return binProvider.getOpaqueBin().getAtom(index - offset);
                }
                if (index < (offset += binProvider.getOpaqueBin().size()) + binProvider.getTransparentBin().size()) {
                    return binProvider.getTransparentBin().getAtom(index - offset);
                }
                offset += binProvider.getTransparentBin().size();
                continue;
            }
            offset += binProvider.getAtomsCount();
        }
        return null;
    }

    protected final Object convertSelectBuffer(int hits, List<RenderPass> renderPasses, boolean pickAll) {
        int position = 0;
        for (int i = 0; i < hits; ++i) {
            int namesCount = this.selectBuffer.get(position++);
            float zMin = (float)this.selectBuffer.get(position++) / 2.1474836E9f;
            float zMax = (float)this.selectBuffer.get(position++) / 2.1474836E9f;
            float zMed = zMin + (zMax - zMin) / 2.0f;
            for (int j = 0; j < namesCount; ++j) {
                int selectName = this.selectBuffer.get(position++);
                try {
                    RenderAtom<?> atom = this.getAtomByGlobalIndex(selectName, renderPasses);
                    Shape3D shape = (Shape3D)atom.getNode();
                    PickResult result = new PickResult(shape, zMin, zMax, zMed);
                    if (pickAll) {
                        this.pickResults.add(result);
                        continue;
                    }
                    if (this.pickResult != null && !(result.getMinimumDistance() < this.pickResult.getMinimumDistance())) continue;
                    this.pickResult = result;
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        if (pickAll) {
            this.pickResults.sort();
            return this.pickResults;
        }
        return this.pickResult;
    }

    protected final void renderDone(long frameId) {
        long[] lastFrameIDs = this.getStatesCache().lastFrameId;
        for (int i = 0; i < lastFrameIDs.length; ++i) {
            lastFrameIDs[i] = frameId;
        }
    }

    public abstract Object render(Object var1, View var2, List<RenderPass> var3, boolean var4, long var5, long var7, long var9, PickRequest var11);

    public abstract void takeScreenshot(File var1, boolean var2);

    public RenderPeer(CanvasPeer canvasPeer, StateUnitPeerRegistry shaderRegistry, OpenGLStatesCache statesCache, RenderOptions renderOptions) {
        this.canvasPeer = canvasPeer;
        this.stateUnitRegistry = shaderRegistry;
        this.statesCache = statesCache;
        this.renderOptions = renderOptions;
    }

    public RenderPeer(CanvasPeer canvasPeer, StateUnitPeerRegistry shaderRegistry, OpenGLStatesCache statesCache) {
        this(canvasPeer, shaderRegistry, statesCache, new RenderOptions());
    }

    static {
        Arrays.fill(nulledStates, -1L);
        gcRequested = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RenderMode {
        NORMAL,
        PICKING,
        SHADOW_MAP_GENERATION;

    }
}

