/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render;

import java.util.Arrays;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.SceneGraphOpenGLReferences;

public abstract class SceneGraphOpenGLReference {
    public static final int UNSET_NAME = -1;
    private final CanvasPeer context;
    private final SceneGraphOpenGLReferences references;
    private final int[] names;
    private final boolean[] namesValid;

    public final CanvasPeer getContext() {
        return this.context;
    }

    public final SceneGraphOpenGLReferences getReferences() {
        return this.references;
    }

    public final void setName(int index, int name) {
        this.names[index] = name;
        this.namesValid[index] = name != -1;
    }

    public final int deleteName(int index) {
        this.names[index] = -1;
        this.namesValid[index] = false;
        return this.names[index];
    }

    public final void setName(int name) {
        this.names[0] = name;
        this.namesValid[0] = name != -1;
    }

    public final int deleteName() {
        this.names[0] = -1;
        this.namesValid[0] = false;
        return this.names[0];
    }

    public final int getName(int index) {
        return this.names[index];
    }

    public final boolean nameExists(int index) {
        return this.names.length > index && this.names[index] != -1;
    }

    public final int getName() {
        return this.names[0];
    }

    public final boolean nameExists() {
        return this.names[0] != -1;
    }

    public final void setNameValid(int index, boolean valid) {
        this.namesValid[index] = valid;
    }

    public final void invalidateName(int index) {
        this.namesValid[index] = false;
    }

    public final void setNameValid(boolean valid) {
        this.namesValid[0] = valid;
    }

    public final void invalidateName() {
        this.namesValid[0] = false;
    }

    public final boolean isNameValid(int index) {
        return this.namesValid[index];
    }

    public final boolean isNameValid() {
        return this.namesValid[0];
    }

    public final int getNumNames(boolean onlyExisting) {
        if (this.names == null) {
            return 0;
        }
        if (onlyExisting) {
            int num = 0;
            for (int i = 0; i < this.names.length; ++i) {
                if (this.names[i] == -1) continue;
                ++num;
            }
            return num;
        }
        return this.names.length;
    }

    public abstract void prepareObjectForDestroy();

    public abstract void destroyObject(int var1, int var2);

    public final void destroyObject() {
        int n = this.getNumNames(false);
        for (int i = 0; i < n; ++i) {
            int name = this.getName(i);
            if (name == -1) continue;
            if (!this.context.isDestroyed()) {
                this.destroyObject(i, name);
            }
            this.deleteName(i);
        }
    }

    public SceneGraphOpenGLReference(CanvasPeer context, SceneGraphOpenGLReferences references, int numNames) {
        this.context = context;
        this.references = references;
        this.names = new int[numNames];
        Arrays.fill(this.names, -1);
        this.namesValid = new boolean[numNames];
        Arrays.fill(this.namesValid, false);
    }
}

