/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render;

import java.util.Arrays;
import java.util.Vector;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.SceneGraphOpenGLReference;

public class SceneGraphOpenGLReferences {
    private static final Vector<SceneGraphOpenGLReferences> instances = new Vector();
    private SceneGraphOpenGLReference[] references = new SceneGraphOpenGLReference[0];
    private final int numNamesPerContext;

    private final boolean ensureCanvasID(int canvasID) {
        if (this.references.length >= canvasID) {
            return true;
        }
        Object[] newReferences = new SceneGraphOpenGLReference[canvasID];
        System.arraycopy(this.references, 0, newReferences, 0, this.references.length);
        Arrays.fill(newReferences, this.references.length, newReferences.length, null);
        this.references = newReferences;
        return false;
    }

    public final SceneGraphOpenGLReference getReference(CanvasPeer canvasPeer, Provider provider) {
        int canvasID = canvasPeer.getCanvasID();
        int canvasIDm1 = canvasID - 1;
        if (this.references.length < canvasID) {
            this.ensureCanvasID(canvasID);
            this.references[canvasIDm1] = provider.newReference(canvasPeer, this, this.numNamesPerContext);
        } else if (this.references[canvasIDm1] == null) {
            this.references[canvasIDm1] = provider.newReference(canvasPeer, this, this.numNamesPerContext);
        }
        return this.references[canvasIDm1];
    }

    public SceneGraphOpenGLReference removeReference(int canvasID) {
        if (this.references.length < canvasID) {
            return null;
        }
        int canvasIDm1 = canvasID - 1;
        SceneGraphOpenGLReference result = this.references[canvasIDm1];
        this.references[canvasIDm1] = null;
        return result;
    }

    public final boolean referenceExists(CanvasPeer canvasPeer) {
        int canvasIDm1 = canvasPeer.getCanvasID() - 1;
        if (canvasIDm1 >= this.references.length) {
            return false;
        }
        return this.references[canvasIDm1] != null;
    }

    public final int getNumReferences() {
        return this.references.length;
    }

    public final int getNumExistingNames() {
        int num = 0;
        for (int i = 0; i < this.references.length; ++i) {
            if (this.references[i] == null) continue;
            num += this.references[i].getNumNames(true);
        }
        return num;
    }

    public void set(SceneGraphOpenGLReferences other) {
        this.ensureCanvasID(other.references.length);
        Arrays.fill(this.references, other.references.length + 1, this.references.length, null);
        System.arraycopy(other.references, 0, this.references, 0, other.references.length);
    }

    public final void prepareObjectForDestroy(CanvasPeer canvasPeer) {
        if (this.references.length == 0) {
            return;
        }
        if (canvasPeer == null) {
            return;
        }
        SceneGraphOpenGLReference ref = this.references[canvasPeer.getCanvasID() - 1];
        if (ref != null) {
            ref.prepareObjectForDestroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void prepareObjectForDestroy() {
        for (int i = 0; i < this.references.length; ++i) {
            if (this.references[i] == null) continue;
            this.references[i].prepareObjectForDestroy();
        }
        Vector<SceneGraphOpenGLReferences> vector = instances;
        synchronized (vector) {
            instances.remove(this);
        }
    }

    public final void invalidateNames() {
        for (int i = 0; i < this.references.length; ++i) {
            if (this.references[i] == null) continue;
            int numNames = this.references[i].getNumNames(false);
            for (int j = 0; j < numNames; ++j) {
                this.references[i].invalidateName(j);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyObjects(CanvasPeer context) {
        Vector<SceneGraphOpenGLReferences> vector = instances;
        synchronized (vector) {
            for (int i = instances.size() - 1; i >= 0; --i) {
                SceneGraphOpenGLReferences object = instances.get(i);
                for (int j = 0; j < object.references.length; ++j) {
                    if (object.references[j] == null || object.references[j].getContext() != context) continue;
                    object.references[j].destroyObject();
                    object.references[j] = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SceneGraphOpenGLReferences(int numNamesPerContext) {
        this.numNamesPerContext = numNamesPerContext;
        Vector<SceneGraphOpenGLReferences> vector = instances;
        synchronized (vector) {
            instances.add(this);
        }
    }

    public static interface Provider {
        public SceneGraphOpenGLReference newReference(CanvasPeer var1, SceneGraphOpenGLReferences var2, int var3);
    }
}

