/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render;

import org.openmali.vecmath2.Colorf;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.RenderTarget;
import org.xith3d.render.SceneGraphOpenGLReferences;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;

public class TextureRenderTarget
implements RenderTarget {
    private GroupNode group;
    private Texture texture;
    private Colorf backgroundColor = null;
    private boolean backgroundRenderingEnabled = false;
    private boolean pixelReadbackEnabled = false;
    private final SceneGraphOpenGLReferences openGLReferences = new SceneGraphOpenGLReferences(2);

    public final SceneGraphOpenGLReferences getOpenGLReferences() {
        return this.openGLReferences;
    }

    public void setGroup(GroupNode group) {
        if (group == null) {
            throw new NullPointerException("group must not be null");
        }
        this.group = group;
    }

    public final GroupNode getGroup() {
        return this.group;
    }

    public void setTexture(Texture texture) {
        if (texture == null) {
            throw new NullPointerException("texture must not be null");
        }
        this.texture = texture;
        if (!(texture instanceof Texture2D)) {
            this.pixelReadbackEnabled = false;
        }
    }

    public final Texture getTexture() {
        return this.texture;
    }

    public void setBackgroundColor(Colorf color) {
        this.backgroundColor = color;
    }

    public final Colorf getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundRenderingEnabled(boolean enabled) {
        this.backgroundRenderingEnabled = enabled;
    }

    public final boolean isBackgroundRenderingEnabled() {
        return this.backgroundRenderingEnabled;
    }

    public void setPixelReadbackEnabled(boolean enabled) {
        if (enabled && !(this.texture instanceof Texture2D)) {
            throw new Error("This flag cannot be enabled, if the used texture is not an instance of Texture2D.");
        }
        this.pixelReadbackEnabled = enabled;
    }

    public final boolean isPixelReadbackEnabled() {
        return this.pixelReadbackEnabled;
    }

    public void freeOpenGLResources(CanvasPeer canvasPeer) {
        if (this.getTexture() != null) {
            this.getTexture().freeOpenGLResources(canvasPeer);
        }
        if (this.getGroup() != null) {
            this.getGroup().freeOpenGLResources(canvasPeer);
        }
    }

    public final void freeOpenGLResources(Canvas3D canvas) {
        if (canvas.getPeer() == null) {
            throw new Error("The given Canvas3D is not linked to a CanvasPeer.");
        }
        this.freeOpenGLResources(canvas.getPeer());
    }

    protected void finalize() {
        this.openGLReferences.prepareObjectForDestroy();
    }

    public TextureRenderTarget(GroupNode group, Texture texture, Colorf backgroundColor, boolean pixelReadbackEnabled) {
        if (group == null) {
            throw new NullPointerException("group must not be null");
        }
        if (texture == null) {
            throw new NullPointerException("texture must not be null");
        }
        this.group = group;
        this.texture = texture;
        this.backgroundColor = backgroundColor;
        this.pixelReadbackEnabled = pixelReadbackEnabled;
    }

    public TextureRenderTarget(GroupNode group, Texture texture, boolean pixelReadbackEnabled) {
        this(group, texture, null, pixelReadbackEnabled);
    }

    public TextureRenderTarget(GroupNode group, Texture texture, Colorf backgroundColor) {
        this(group, texture, backgroundColor, false);
    }

    public TextureRenderTarget(GroupNode group, Texture texture) {
        this(group, texture, null, false);
    }
}

