/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.jsr231;

import com.sun.opengl.util.BufferUtil;
import java.nio.IntBuffer;
import java.util.List;
import javax.media.opengl.GL;
import org.openmali.types.twodee.Rect2i;
import org.xith3d.picking.PickRequest;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.OpenGLCapabilities;
import org.xith3d.render.OpenGLInfo;
import org.xith3d.render.OpenGLStatesCache;
import org.xith3d.render.OpenGlExtensions;
import org.xith3d.render.RenderPass;
import org.xith3d.render.SceneGraphOpenGLReference;
import org.xith3d.render.StateUnitPeerRegistry;
import org.xith3d.render.config.DisplayMode;
import org.xith3d.render.config.FSAA;
import org.xith3d.render.jsr231.OpenGLStatesCacheImpl;
import org.xith3d.render.jsr231.RenderPeerImpl;
import org.xith3d.render.jsr231.StateUnitPeerRegistryImpl;
import org.xith3d.render.jsr231.TextureUnitStateUnitPeer;
import org.xith3d.scenegraph.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CanvasPeerImplBase
extends CanvasPeer {
    private Rect2i maxViewport = new Rect2i(-1, -1, -1, -1);
    private Rect2i currentViewport = null;
    private boolean isDefaultViewport = true;
    private int swapInterval = -1;
    protected boolean swapIntervalChanged = false;
    private long renderedFrames = 0L;
    private boolean isInitialized = false;

    @Override
    protected RenderPeerImpl createRenderPeer() {
        return new RenderPeerImpl(this, (StateUnitPeerRegistry)new StateUnitPeerRegistryImpl(), (OpenGLStatesCache)new OpenGLStatesCacheImpl());
    }

    public CanvasPeerImplBase(DisplayMode displayMode, DisplayMode.FullscreenMode fullscreen, boolean vsync, FSAA fsaa, int depthBufferSize) {
        super(displayMode, fullscreen, vsync, fsaa, depthBufferSize);
    }

    protected final void init() {
        int maxVAs;
        this.oglInfo = new OpenGLInfo(this.getGL().glGetString(7937), this.getGL().glGetString(7938), this.getGL().glGetString(7936), this.getGL().glGetString(7939));
        OpenGlExtensions.setExtensions(this.oglInfo);
        IntBuffer intBuffer = BufferUtil.newIntBuffer((int)2);
        this.getGL().glGetIntegerv(3379, intBuffer);
        int maxTexSize = intBuffer.get(0);
        intBuffer.rewind();
        this.getGL().glGetIntegerv(34018, intBuffer);
        int maxTUs = intBuffer.get(0);
        if (this.oglInfo.getVersionMajor() >= 2) {
            intBuffer.rewind();
            this.getGL().glGetIntegerv(34921, intBuffer);
            maxVAs = intBuffer.get(0);
        } else {
            maxVAs = 0;
        }
        intBuffer.rewind();
        this.getGL().glGetIntegerv(3386, intBuffer);
        this.maxViewport.set(0, 0, intBuffer.get(0), intBuffer.get(1));
        this.setOpenGLCapabilities(new OpenGLCapabilities(maxTexSize, maxTUs, TextureUnitStateUnitPeer.getMaxAnisotropicLevel(this.getGL()), maxVAs, this.oglInfo));
        this.getRenderPeer().getStatesCache().update(this.getGL(), this.getOpenGLCapabilities());
        int[] depth_bits = new int[1];
        this.getGL().glGetIntegerv(3414, depth_bits, 0);
        this.setDepthBufferSize(depth_bits[0]);
        this.getGL().glViewport(0, 0, this.getWidth(), this.getHeight());
        boolean showInfos = true;
        try {
            showInfos = System.getProperty("org.xith3d.render.jsr231.displayGLInfos", "true").equals("true");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (showInfos) {
            System.out.println("Init GL is " + this.getGL().getClass().getName());
            this.oglInfo.dump();
        }
        this.isInitialized = true;
    }

    protected final boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    protected final Class<?> getExpectedNativeDisplayModeClass() {
        return java.awt.DisplayMode.class;
    }

    public abstract GL getGL();

    @Override
    public final RenderPeerImpl getRenderPeer() {
        return (RenderPeerImpl)super.getRenderPeer();
    }

    @Override
    public long getRenderedFrames() {
        return this.renderedFrames;
    }

    public final void setSwapInterval(int swapInterval) {
        this.swapInterval = swapInterval;
        this.swapIntervalChanged = true;
    }

    public final int getSwapInterval() {
        return this.swapInterval;
    }

    protected abstract void setAutoSwapBufferMode(boolean var1);

    @Override
    public final void addDestroyableObject(SceneGraphOpenGLReference ref) {
        super.addDestroyableObject(ref);
    }

    protected void beforeRenderStart(PickRequest pickRequest, boolean forceNoSwap) {
        this.setAutoSwapBufferMode(!(pickRequest != null | forceNoSwap));
        this.setTriangles(0L);
        this.destroyGLNames(true);
    }

    @Override
    public Rect2i getMaxViewport() {
        return this.maxViewport;
    }

    public Rect2i getCurrentViewport() {
        return this.currentViewport;
    }

    public final void updateViewport(GL gl, Rect2i viewport) {
        boolean viewportChanged = false;
        if (this.currentViewport == null) {
            if (viewport == null) {
                if (this.getViewport() == null) {
                    this.currentViewport = new Rect2i(0, 0, this.getWidth(), this.getHeight());
                } else {
                    this.currentViewport = new Rect2i(this.getViewport());
                    this.getViewport().setClean();
                }
                this.isDefaultViewport = true;
            } else {
                this.currentViewport = new Rect2i(viewport);
                this.isDefaultViewport = false;
            }
            viewportChanged = true;
        } else if (viewport != null) {
            if (this.getViewport() != null && this.getViewport().isDirty()) {
                this.currentViewport.set(this.getViewport());
                this.getViewport().setClean();
            }
            if (!this.currentViewport.equals(viewport)) {
                this.currentViewport.set(viewport);
                this.isDefaultViewport = false;
                viewportChanged = true;
            }
        } else if (!this.isDefaultViewport) {
            if (this.getViewport() == null) {
                this.currentViewport.set(0, 0, this.getWidth(), this.getHeight());
            } else {
                this.currentViewport.set(this.getViewport());
                this.getViewport().setClean();
            }
            this.isDefaultViewport = true;
            viewportChanged = true;
        } else if (this.isDefaultViewport && !this.currentViewport.equals((Object)(this.getViewport() == null ? this : this.getViewport()))) {
            if (this.getViewport() == null) {
                this.currentViewport.set(0, 0, this.getWidth(), this.getHeight());
            } else {
                this.currentViewport.set(this.getViewport());
                this.getViewport().setClean();
            }
            viewportChanged = true;
        }
        if (viewportChanged) {
            int y = this.getHeight() - this.currentViewport.getTop() - this.currentViewport.getHeight();
            gl.glViewport(this.currentViewport.getLeft(), y, this.currentViewport.getWidth(), this.currentViewport.getHeight());
        }
    }

    @Override
    public void clear() {
        this.getRenderPeer().clearViewport(this.getGL());
    }

    protected final Object doRender(View view, List<RenderPass> renderPasses, boolean layeredMode, long frameId, long nanoTime, long nanoStep, PickRequest pickRequest) {
        Object result = this.getRenderPeer().render(this.getGL(), view, renderPasses, layeredMode, frameId, nanoTime, nanoStep, pickRequest);
        ++this.renderedFrames;
        return result;
    }
}

