/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.jsr231;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.opengl.GLCanvas;
import org.eclipse.swt.opengl.GLData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.Mouse;
import org.jagatoo.input.impl.swt.SWTInputDeviceFactory;
import org.jagatoo.input.render.InputSourceWindow;
import org.jagatoo.logging.LogChannel;
import org.jagatoo.logging.ProfileTimer;
import org.xith3d.picking.PickRequest;
import org.xith3d.render.RenderPass;
import org.xith3d.render.config.DisplayMode;
import org.xith3d.render.config.FSAA;
import org.xith3d.render.config.OpenGLLayer;
import org.xith3d.render.jsr231.CanvasPeerImplBase;
import org.xith3d.render.jsr231.ShapeAtomPeer;
import org.xith3d.scenegraph.View;
import org.xith3d.utility.logging.X3DLog;
import org.xith3d.utility.platform.EnvironmentCapabilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CanvasPeerImplSWT
extends CanvasPeerImplBase {
    private Display display = null;
    private GLContext context = null;
    private GLCanvas glCanvas = null;
    private GL gl = null;
    private Composite owner = null;
    private boolean destroyed = false;
    private boolean earlyLocation = false;
    private boolean earlySize = false;
    private volatile boolean initialized = false;
    private View view;
    private List<RenderPass> renderPasses;
    private boolean layeredMode;
    private long frameId;
    private long nanoTime;
    private long nanoStep;
    private PickRequest pickRequest = null;
    private Object pickResult = null;
    private boolean isClearOnlyMode = false;
    private boolean isRendering = false;
    private boolean activeInputReceiver = true;
    private URL iconURL = null;
    private String shellTitle = null;
    private Runnable renderRunnable = new Runnable(){

        public void run() {
            if (!CanvasPeerImplSWT.this.destroyed && !CanvasPeerImplSWT.this.glCanvas.isDisposed()) {
                CanvasPeerImplSWT.this.activeInputReceiver = !CanvasPeerImplSWT.this.owner.isDisposed() && CanvasPeerImplSWT.this.glCanvas.isFocusControl();
                CanvasPeerImplSWT.this.isRendering = true;
                EnvironmentCapabilities capabilities = EnvironmentCapabilities.getInstance();
                CanvasPeerImplSWT.this.glCanvas.setCurrent();
                if (capabilities.isIllegalMakeCurrentRequired()) {
                    CanvasPeerImplSWT.this.context.makeCurrent();
                }
                CanvasPeerImplSWT.this.gl = CanvasPeerImplSWT.this.context.getGL();
                if (CanvasPeerImplSWT.this.swapIntervalChanged) {
                    CanvasPeerImplSWT.this.swapIntervalChanged = false;
                    if (capabilities.isVSyncSwitchingAllowed(OpenGLLayer.JOGL_SWT)) {
                        CanvasPeerImplSWT.this.gl.setSwapInterval(CanvasPeerImplSWT.this.getSwapInterval());
                    }
                }
                if (capabilities.isIllegalMakeCurrentRequired()) {
                    CanvasPeerImplSWT.this.context.release();
                }
                CanvasPeerImplSWT.this.display();
                CanvasPeerImplSWT.this.glCanvas.swapBuffers();
                CanvasPeerImplSWT.this.isRendering = false;
            }
        }
    };
    private int left = -1;
    private int top = -1;
    private int width;
    private int height;
    private SWTInputDeviceFactory inputDeviceFactory = null;

    public SWTInputDeviceFactory getInputDeviceFactory(InputSystem inputSystem) {
        if (this.inputDeviceFactory == null) {
            this.inputDeviceFactory = new SWTInputDeviceFactory((InputSourceWindow)this, inputSystem.getEventQueue());
        }
        return this.inputDeviceFactory;
    }

    public final GLCanvas getDrawable() {
        this.ensureSWT();
        return this.glCanvas;
    }

    public void refreshCursor(Mouse mouse) {
        if (!this.owner.isDisposed()) {
            if (!mouse.isAbsolute() || this.getCursor() == null) {
                this.glCanvas.setCursor(null);
            } else {
                this.glCanvas.setCursor(new Cursor((Device)this.display, 0));
            }
        }
    }

    public final boolean receivesInputEvents() {
        return this.activeInputReceiver;
    }

    public CanvasPeerImplSWT(Object owner, DisplayMode displayMode, DisplayMode.FullscreenMode fullscreen, boolean vsync, FSAA fsaa, int depthBufferSize) {
        super(displayMode, fullscreen, vsync, fsaa, depthBufferSize);
        if (owner == null || !(owner instanceof Composite)) {
            String message = "To construct an SWT Canvas, you must provide an owner of type org.eclipse.swt.Composite. At present, this means that you need to run as an Eclipse plug-in or as an Eclipse Rich Client Platform application.  In the future, we will provide XithRCP to simplify this process; however, it is fairly easy to create a default RCP application using the Eclipse wizard 'New plug-in project' and selecting 'Yes' when asked 'Do you want to create a rich client application' on the 2nd page.";
            throw new IllegalArgumentException(message);
        }
        try {
            System.setProperty("org.xith3d.render.jsr231.displayGLInfos", String.valueOf(false));
        }
        catch (SecurityException ignore) {
            // empty catch block
        }
        this.owner = (Composite)owner;
        this.width = this.getDisplayMode().getWidth();
        this.height = this.getDisplayMode().getHeight();
        this.setVSyncEnabled(vsync);
    }

    protected synchronized void initSWT() {
        if (!this.initialized) {
            Runnable initializationRunnable = new Runnable(){

                public void run() {
                    if (CanvasPeerImplSWT.this.iconURL != null) {
                        try {
                            CanvasPeerImplSWT.this.setIcon(CanvasPeerImplSWT.this.iconURL);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        CanvasPeerImplSWT.this.iconURL = null;
                    }
                    if (CanvasPeerImplSWT.this.shellTitle != null) {
                        CanvasPeerImplSWT.this.setTitle(CanvasPeerImplSWT.this.shellTitle);
                        CanvasPeerImplSWT.this.shellTitle = null;
                    }
                    if (CanvasPeerImplSWT.this.earlyLocation) {
                        CanvasPeerImplSWT.this.setLocation(CanvasPeerImplSWT.this.left, CanvasPeerImplSWT.this.top);
                    }
                    if (CanvasPeerImplSWT.this.earlySize) {
                        CanvasPeerImplSWT.this.setSize(CanvasPeerImplSWT.this.width, CanvasPeerImplSWT.this.height);
                    }
                    GLData data = new GLData();
                    data.doubleBuffer = true;
                    data.stencilSize = 8;
                    data.depthSize = CanvasPeerImplSWT.this.getDepthBufferSize();
                    if (CanvasPeerImplSWT.this.getFSAA() != FSAA.OFF) {
                        data.sampleBuffers = 1;
                        data.samples = CanvasPeerImplSWT.this.getFSAA().getIntValue();
                    }
                    CanvasPeerImplSWT.this.glCanvas = new GLCanvas(CanvasPeerImplSWT.this.owner, 0, data);
                    CanvasPeerImplSWT.this.glCanvas.addDisposeListener(new DisposeListener(){
                        private boolean executed = false;

                        public synchronized void widgetDisposed(DisposeEvent event) {
                            if (!this.executed) {
                                CanvasPeerImplSWT.this.context.destroy();
                                CanvasPeerImplSWT.this.context = null;
                                this.executed = true;
                            }
                        }
                    });
                    CanvasPeerImplSWT.this.glCanvas.addControlListener(new ControlListener(){

                        public void controlMoved(ControlEvent e) {
                        }

                        public void controlResized(ControlEvent e) {
                            Point size = CanvasPeerImplSWT.this.glCanvas.getSize();
                            CanvasPeerImplSWT.this.setSize(size.x, size.y);
                        }
                    });
                    CanvasPeerImplSWT.this.glCanvas.setCurrent();
                    CanvasPeerImplSWT.this.glCanvas.setFocus();
                    CanvasPeerImplSWT.this.context = GLDrawableFactory.getFactory().createExternalGLContext();
                    CanvasPeerImplSWT.this.gl = CanvasPeerImplSWT.this.context.getGL();
                    CanvasPeerImplSWT.this.initialized = true;
                    CanvasPeerImplSWT.this.earlyLocation = false;
                    CanvasPeerImplSWT.this.earlySize = false;
                    CanvasPeerImplSWT.this.shellTitle = null;
                    CanvasPeerImplSWT.this.iconURL = null;
                    CanvasPeerImplSWT.this.init();
                }
            };
            this.display = this.owner.getDisplay();
            if (this.display.getThread() == Thread.currentThread()) {
                initializationRunnable.run();
            } else {
                this.display.syncExec(initializationRunnable);
            }
        }
    }

    protected final void ensureSWT() {
        if (this.destroyed) {
            throw new SWTException("Canvas has already been destroyed");
        }
        if (!this.initialized) {
            this.initSWT();
        }
    }

    @Override
    public OpenGLLayer getType() {
        return OpenGLLayer.JOGL_SWT;
    }

    @Override
    public void setVSyncEnabled(boolean vsync) {
        super.setVSyncEnabled(vsync);
        this.setSwapInterval(vsync ? 1 : 0);
    }

    @Override
    public final GL getGL() {
        this.ensureSWT();
        return this.gl;
    }

    public final Composite getWindow() {
        return this.owner;
    }

    public final GLCanvas getComponent() {
        this.ensureSWT();
        return this.glCanvas;
    }

    @Override
    public void setIcon(URL iconResource) throws IOException {
        if (this.owner == null) {
            this.iconURL = iconResource;
        } else if ((this.owner.getStyle() & 1) == 1) {
            this.owner.getShell().setImage(new Image((Device)this.display, iconResource.openStream()));
        }
    }

    @Override
    public final void setTitle(String title) {
        if (this.owner == null) {
            this.shellTitle = title;
        } else if ((this.owner.getStyle() & 0x20) == 32) {
            this.owner.getShell().setText(title);
        }
    }

    @Override
    public final String getTitle() {
        boolean hasTitle = this.owner != null && (this.owner.getStyle() & 0x20) == 32;
        return hasTitle ? this.owner.getShell().getText() : null;
    }

    @Override
    public final boolean setLocation(int x, int y) {
        if (this.left == x && this.top == y) {
            return false;
        }
        if (this.owner == null) {
            this.earlyLocation = true;
        } else {
            this.owner.setLocation(x, y);
        }
        this.left = x;
        this.top = y;
        return true;
    }

    @Override
    public final int getLeft() {
        return this.left;
    }

    @Override
    public final int getTop() {
        return this.top;
    }

    @Override
    public final boolean setSize(int width, int height) {
        if (this.width == width && this.height == height) {
            return false;
        }
        if (this.owner == null) {
            this.earlySize = true;
        } else {
            this.owner.setSize(width, height);
        }
        this.width = width;
        this.height = height;
        return true;
    }

    @Override
    public final int getWidth() {
        return this.width;
    }

    @Override
    public final int getHeight() {
        return this.height;
    }

    @Override
    protected boolean setDisplayModeImpl(DisplayMode displayMode) {
        boolean result = true;
        this.setSize(displayMode.getWidth(), displayMode.getHeight());
        return true;
    }

    @Override
    protected void setAutoSwapBufferMode(boolean mode) {
    }

    @Override
    public final boolean isRendering() {
        return this.isRendering;
    }

    private final void display() {
        if (this.isClearOnlyMode) {
            super.clear();
            return;
        }
        this.pickResult = this.doRender(this.view, this.renderPasses, this.layeredMode, this.frameId, this.nanoTime, this.nanoStep, this.pickRequest);
    }

    @Override
    public void beforeThreadChanged() {
    }

    private final void doRender() {
        ShapeAtomPeer.reset();
        this.ensureSWT();
        if (!this.destroyed && !this.display.isDisposed()) {
            if (Thread.currentThread() == this.display.getThread()) {
                this.renderRunnable.run();
            } else {
                this.display.syncExec(this.renderRunnable);
            }
        }
    }

    @Override
    protected Object initRenderingImpl(View view, List<RenderPass> renderPasses, boolean layeredMode, long frameId, long nanoTime, long nanoStep, PickRequest pickRequest) {
        ProfileTimer.startProfile((LogChannel)X3DLog.LOG_CHANNEL, (String)"CanvasPeerImpl::initRendering");
        this.isClearOnlyMode = false;
        this.view = view;
        this.renderPasses = renderPasses;
        this.layeredMode = layeredMode;
        this.frameId = frameId;
        this.nanoTime = nanoTime;
        this.nanoStep = nanoStep;
        this.pickRequest = pickRequest;
        this.pickResult = null;
        this.doRender();
        Object result = this.pickResult;
        this.pickResult = null;
        ProfileTimer.endProfile();
        return result;
    }

    @Override
    public void clear() {
        this.isClearOnlyMode = true;
        this.doRender();
    }

    @Override
    public synchronized void destroy() {
        super.destroy();
        this.destroyed = true;
        if (this.display != null && !this.display.isDisposed()) {
            this.display.syncExec(new Runnable(){

                public void run() {
                    CanvasPeerImplSWT.this.owner.dispose();
                }
            });
            this.owner = null;
            this.display = null;
            this.glCanvas = null;
            this.gl = null;
        }
    }
}

