/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.jsr231;

import com.sun.opengl.util.Gamma;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.imageio.ImageIO;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLJPanel;
import javax.swing.JFrame;
import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.Mouse;
import org.jagatoo.input.impl.awt.AWTCursorConverter;
import org.jagatoo.input.impl.mixed.AWTJInputInputDeviceFactory;
import org.jagatoo.input.render.Cursor;
import org.jagatoo.input.render.InputSourceWindow;
import org.jagatoo.logging.LogChannel;
import org.jagatoo.logging.ProfileTimer;
import org.xith3d.picking.PickRequest;
import org.xith3d.render.RenderPass;
import org.xith3d.render.config.DisplayMode;
import org.xith3d.render.config.FSAA;
import org.xith3d.render.config.OpenGLLayer;
import org.xith3d.render.jsr231.CanvasPeerImplBase;
import org.xith3d.render.jsr231.OldStyleGLCapabilitiesChooser;
import org.xith3d.render.jsr231.ShapeAtomPeer;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph._SG_PrivilegedAccess;
import org.xith3d.utility.logging.X3DLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CanvasPeerImplSwing
extends CanvasPeerImplBase
implements GLEventListener {
    private static final int RENDER_MODE_CLEAR = 1;
    private static final int RENDER_MODE_DESTROY = 2;
    private GLCapabilities gc;
    private GLCapabilitiesChooser gcc;
    private GLJPanel glJPanel;
    private GL gl;
    private View view;
    private List<RenderPass> renderPasses;
    private boolean layeredMode;
    private long frameId;
    private long nanoTime;
    private long nanoStep;
    private PickRequest pickRequest = null;
    private Object pickResult = null;
    private int renderMode = 0;
    private Window window;
    private boolean closeRequested = false;
    private boolean isRendering = false;
    private AWTJInputInputDeviceFactory inputDeviceFactory = null;

    public AWTJInputInputDeviceFactory getInputDeviceFactory(InputSystem inputSystem) {
        if (this.inputDeviceFactory == null) {
            this.inputDeviceFactory = new AWTJInputInputDeviceFactory((InputSourceWindow)this, inputSystem.getEventQueue());
        }
        return this.inputDeviceFactory;
    }

    public final GLJPanel getDrawable() {
        return this.glJPanel;
    }

    public void refreshCursor(Mouse mouse) {
        if (this.getCursor() == null) {
            this.glJPanel.setCursor(AWTCursorConverter.HIDDEN_CURSOR);
        } else if (this.getCursor() == Cursor.DEFAULT_CURSOR) {
            this.glJPanel.setCursor(java.awt.Cursor.getDefaultCursor());
        } else {
            AWTCursorConverter.convertCursor((Cursor)this.getCursor());
            this.glJPanel.setCursor((java.awt.Cursor)this.getCursor().getCursorObject());
        }
    }

    public final boolean receivesInputEvents() {
        return this.glJPanel.hasFocus();
    }

    public CanvasPeerImplSwing(Object owner, DisplayMode displayMode, DisplayMode.FullscreenMode fullscreen, boolean vsync, FSAA fsaa, int depthBufferSize) {
        super(displayMode, fullscreen, vsync, fsaa, depthBufferSize);
        if (owner == null) {
            String message = "The " + this.getClass().getSimpleName() + " must be used with an owner (integrated into an AWT/Swing environment).";
            X3DLog.error(message);
            throw new Error(message);
        }
        try {
            System.setProperty("org.xith3d.render.jsr231.displayGLInfos", String.valueOf(false));
        }
        catch (SecurityException ignore) {
            // empty catch block
        }
        this.gc = new GLCapabilities();
        this.gc.setStencilBits(8);
        this.gc.setDepthBits(depthBufferSize);
        if (fsaa != FSAA.OFF) {
            this.gc.setSampleBuffers(true);
        }
        this.gc.setNumSamples(fsaa.getIntValue());
        this.gcc = new OldStyleGLCapabilitiesChooser();
        this.glJPanel = new GLJPanel(this.gc, this.gcc, null);
        this.glJPanel.setBounds(0, 0, displayMode.getWidth(), displayMode.getHeight());
        this.setVSyncEnabled(vsync);
        this.glJPanel.addGLEventListener((GLEventListener)this);
        this.glJPanel.setFocusable(true);
        this.clear();
        if (owner == null) {
            JFrame frame = new JFrame("Xith3D (JOGL)");
            frame.setLayout(null);
            if (fullscreen.isFullscreen()) {
                frame.setBackground(Color.BLACK);
                frame.getContentPane().setBackground(Color.BLACK);
            }
            frame.setUndecorated(fullscreen != DisplayMode.FullscreenMode.WINDOWED);
            frame.setSize(displayMode.getWidth(), displayMode.getHeight());
            this.setWindow(frame);
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    CanvasPeerImplSwing.this.closeRequested = true;
                }
            });
            boolean exclusive = fullscreen.isFullscreen() && displayMode.getNativeMode() != null;
            frame.getContentPane().add((Component)this.glJPanel);
            frame.setVisible(true);
            if (!exclusive) {
                Dimension frameSize;
                Thread.yield();
                if (!fullscreen.isFullscreen()) {
                    Insets insets = frame.getInsets();
                    frameSize = new Dimension(displayMode.getWidth() + insets.left + insets.right, displayMode.getHeight() + insets.top + insets.bottom);
                    frame.setSize(frameSize);
                } else {
                    frameSize = new Dimension(displayMode.getWidth(), displayMode.getHeight());
                }
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                Point upperLeft = new Point((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
                frame.setLocation(upperLeft);
            } else {
                java.awt.DisplayMode awtMode = (java.awt.DisplayMode)displayMode.getNativeMode();
                GraphicsDevice graphDev = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                graphDev.setFullScreenWindow(frame);
                graphDev.setDisplayMode(awtMode);
            }
        } else {
            this.glJPanel.setBounds(0, 0, displayMode.getWidth(), displayMode.getHeight());
            ((Container)owner).add((Component)this.glJPanel);
        }
        Thread.yield();
        if (owner == null) {
            ((Frame)this.window).setResizable(false);
            Dimension size = this.window.getSize();
            this.window.setSize(size.width - 2, size.height - 2);
        }
    }

    public final void init(GLAutoDrawable drawable) {
        this.gl = this.glJPanel.getGL();
        this.destroyGLNames(false);
        super.init();
    }

    @Override
    public OpenGLLayer getType() {
        return OpenGLLayer.JOGL_SWING;
    }

    @Override
    public void setVSyncEnabled(boolean vsync) {
        super.setVSyncEnabled(vsync);
        this.setSwapInterval(vsync ? 1 : 0);
    }

    @Override
    public final GL getGL() {
        return this.gl;
    }

    protected final void setWindow(Window w) {
        this.window = w;
    }

    @Override
    public final Window getWindow() {
        return this.window;
    }

    @Override
    public final Component getComponent() {
        return this.glJPanel;
    }

    @Override
    public void setIcon(URL iconResource) throws IOException {
        assert (this.window instanceof Frame) : "Window isn't a Frame";
        ((Frame)this.window).setIconImage(ImageIO.read(iconResource));
    }

    @Override
    public final void setTitle(String title) {
        if (this.window != null) {
            assert (this.window instanceof Frame) : "Window isn't a Frame";
            ((Frame)this.window).setTitle(title);
        }
    }

    @Override
    public final String getTitle() {
        if (this.window == null) {
            return "";
        }
        assert (this.window instanceof Frame) : "Window isn't a Frame";
        return ((Frame)this.window).getTitle();
    }

    @Override
    public final boolean setLocation(int x, int y) {
        if (this.window.getLocation().x == x && this.window.getLocation().y == y) {
            return false;
        }
        this.window.setLocation(x, y);
        return true;
    }

    @Override
    public final int getLeft() {
        return this.glJPanel.getLocationOnScreen().x;
    }

    @Override
    public final int getTop() {
        return this.glJPanel.getLocationOnScreen().y;
    }

    @Override
    public final boolean setSize(int width, int height) {
        if (this.glJPanel.getSize().width != width || this.glJPanel.getSize().height != height) {
            this.glJPanel.setSize(width, height);
            if (this.getWindow() != null) {
                Insets insets = this.getWindow().getInsets();
                this.glJPanel.setLocation(insets.left, insets.top);
                Dimension frameSize = new Dimension(width + insets.left + insets.right, height + insets.top + insets.bottom);
                this.getWindow().setSize(frameSize);
            }
            this.setDisplayMode(new DisplayMode(this.getType(), null, width, height, this.getBPP(), this.getFrequency()));
            return true;
        }
        return false;
    }

    @Override
    public final int getWidth() {
        return this.glJPanel.getWidth();
    }

    @Override
    public final int getHeight() {
        return this.glJPanel.getHeight();
    }

    @Override
    protected boolean setDisplayModeImpl(DisplayMode displayMode) {
        boolean result = true;
        this.setSize(displayMode.getWidth(), displayMode.getHeight());
        return true;
    }

    public final void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
        _SG_PrivilegedAccess.incGlobalOptionsChangeId();
        this.gl = drawable.getGL();
    }

    @Override
    public void setGamma(float gamma, float brightness, float contrast) {
        super.setGamma(gamma, brightness, contrast);
        try {
            Gamma.setDisplayGamma((float)gamma, (float)brightness, (float)contrast);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public final void displayChanged(GLAutoDrawable drawable, boolean modeChanged, boolean deviceChanged) {
    }

    @Override
    protected void setAutoSwapBufferMode(boolean mode) {
        this.glJPanel.setAutoSwapBufferMode(mode);
    }

    @Override
    public final boolean isRendering() {
        return this.isRendering;
    }

    @Override
    public void beforeThreadChanged() {
    }

    public final void display(GLAutoDrawable drawable) {
        if (!this.isInitialized() || this.isRendering) {
            return;
        }
        this.isRendering = true;
        ShapeAtomPeer.reset();
        if (this.closeRequested) {
            this.closeRequested = false;
            this.fireClosingEvent();
        }
        this.gl = drawable.getGL();
        if (this.swapIntervalChanged) {
            this.swapIntervalChanged = false;
            this.gl.setSwapInterval(this.getSwapInterval());
        }
        if (this.renderMode != 0) {
            boolean proceed = true;
            if ((this.renderMode & 1) != 0) {
                super.clear();
                this.isRendering = false;
                proceed = false;
            }
            if ((this.renderMode & 2) != 0) {
                this.destroy();
                this.isRendering = false;
                proceed = false;
            }
            if (!proceed) {
                return;
            }
        }
        this.pickResult = this.doRender(this.view, this.renderPasses, this.layeredMode, this.frameId, this.nanoTime, this.nanoStep, this.pickRequest);
        this.isRendering = false;
    }

    @Override
    protected Object initRenderingImpl(View view, List<RenderPass> renderPasses, boolean layeredMode, long frameId, long nanoTime, long nanoStep, PickRequest pickRequest) {
        ProfileTimer.startProfile((LogChannel)X3DLog.LOG_CHANNEL, (String)"CanvasPeerImpl::initRendering");
        this.renderMode = 0;
        this.view = view;
        this.renderPasses = renderPasses;
        this.layeredMode = layeredMode;
        this.frameId = frameId;
        this.nanoTime = nanoTime;
        this.nanoStep = nanoStep;
        this.pickRequest = pickRequest;
        this.pickResult = null;
        this.glJPanel.display();
        Object result = this.pickResult;
        this.pickResult = null;
        ProfileTimer.endProfile();
        return result;
    }

    @Override
    public void clear() {
        this.renderMode |= 1;
        this.glJPanel.display();
    }

    @Override
    public void destroy() {
        if ((this.renderMode & 2) == 0) {
            this.renderMode |= 3;
            if (this.isGammaChanged) {
                try {
                    Gamma.resetDisplayGamma();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            this.glJPanel.display();
        } else {
            super.destroy();
            if (this.getWindow() != null) {
                this.getWindow().dispose();
            }
        }
    }
}

