/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.jsr231;

import com.sun.opengl.util.BufferUtil;
import java.nio.FloatBuffer;
import javax.media.opengl.GL;
import org.jagatoo.logging.LogChannel;
import org.jagatoo.logging.ProfileTimer;
import org.openmali.vecmath2.Colorf;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.OpenGLCapabilities;
import org.xith3d.render.OpenGLStatesCache;
import org.xith3d.render.RenderOptions;
import org.xith3d.render.RenderPeer;
import org.xith3d.render.preprocessing.RenderAtom;
import org.xith3d.render.states.StateUnit;
import org.xith3d.render.states.units.FogStateUnit;
import org.xith3d.render.states.units.StateUnitPeer;
import org.xith3d.scenegraph.ExponentialFog;
import org.xith3d.scenegraph.Fog;
import org.xith3d.scenegraph.LinearFog;
import org.xith3d.scenegraph.View;
import org.xith3d.utility.logging.X3DLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FogStateUnitPeer
implements StateUnitPeer {
    private float[] colorArray = new float[4];
    private FloatBuffer colorBuffer = BufferUtil.newFloatBuffer((int)3);

    public FogStateUnitPeer() {
        this.colorArray[3] = 1.0f;
    }

    @Override
    public void apply(RenderAtom<?> atom, StateUnit stateUnit, Object glObj, CanvasPeer canvasPeer, RenderPeer renderPeer, OpenGLCapabilities glCaps, View view, OpenGLStatesCache statesCache, RenderOptions options, long nanoTime, long nanoStep, RenderPeer.RenderMode renderMode, long frameId) {
        if (renderMode != RenderPeer.RenderMode.NORMAL) {
            return;
        }
        ProfileTimer.startProfile((LogChannel)X3DLog.LOG_CHANNEL, (String)"FogStateUnitPeer::apply()");
        GL gl = (GL)glObj;
        FogStateUnit fsu = (FogStateUnit)stateUnit;
        if (fsu.numFogs() == 0) {
            if (!statesCache.enabled || statesCache.fogEnabled) {
                gl.glDisable(2912);
                statesCache.fogEnabled = false;
            }
            ProfileTimer.endProfile();
            return;
        }
        for (int i = 0; i < fsu.numFogs(); ++i) {
            Fog fog = fsu.getFog(i);
            Colorf color = fog.getColor();
            this.colorBuffer.put(color.getRed());
            this.colorBuffer.put(color.getGreen());
            this.colorBuffer.put(color.getBlue());
            this.colorBuffer.rewind();
            if (fog instanceof LinearFog) {
                LinearFog linearFog = (LinearFog)fog;
                gl.glFogi(2917, 9729);
                gl.glFogfv(2918, this.colorBuffer);
                gl.glHint(3156, 4354);
                gl.glFogf(2915, linearFog.getFrontDistance());
                gl.glFogf(2916, linearFog.getBackDistance());
                if (statesCache.enabled && statesCache.fogEnabled) continue;
                gl.glEnable(2912);
                statesCache.fogEnabled = true;
                continue;
            }
            if (!(fog instanceof ExponentialFog)) continue;
            ExponentialFog expFog = (ExponentialFog)fog;
            switch (expFog.getFogMode()) {
                case EXP: {
                    gl.glFogi(2917, 2048);
                    break;
                }
                case EXP2: {
                    gl.glFogi(2917, 2049);
                    break;
                }
                default: {
                    throw new Error("Unknown/Unsupported FogMode");
                }
            }
            gl.glFogfv(2918, this.colorBuffer);
            gl.glFogf(2914, expFog.getDensity());
            gl.glHint(3156, 4354);
            if (statesCache.enabled && statesCache.fogEnabled) continue;
            gl.glEnable(2912);
            statesCache.fogEnabled = true;
        }
        ProfileTimer.endProfile();
    }
}

