/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.jsr231;

import com.sun.opengl.util.BufferUtil;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL;
import org.jagatoo.logging.LogChannel;
import org.jagatoo.logging.ProfileTimer;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.OpenGLStatesCache;
import org.xith3d.render.OpenGlExtensions;
import org.xith3d.render.RenderPeer;
import org.xith3d.render.SceneGraphOpenGLReference;
import org.xith3d.render.SceneGraphOpenGLReferences;
import org.xith3d.render.jsr231.CanvasPeerImplBase;
import org.xith3d.scenegraph.GLSLContext;
import org.xith3d.scenegraph.GLSLFragmentShader;
import org.xith3d.scenegraph.GLSLParameters;
import org.xith3d.scenegraph.GLSLShader;
import org.xith3d.scenegraph.GLSLShaderProgram;
import org.xith3d.scenegraph.GLSLVertexShader;
import org.xith3d.scenegraph.Shader;
import org.xith3d.scenegraph._SG_PrivilegedAccess;
import org.xith3d.utility.debug.DebugStrings;
import org.xith3d.utility.logging.X3DLog;

public class GLSLShaderProgramStateUnitPeer {
    private static boolean ARB_shader_objects_supported = false;
    private static final IntBuffer tmpIntBuffer = BufferUtil.newIntBuffer((int)1);
    private static ByteBuffer tmpByteBuffer = BufferUtil.newByteBuffer((int)128);
    private static SceneGraphOpenGLReferences.Provider shaderProgramNameProvider = new SceneGraphOpenGLReferences.Provider(){

        public SceneGraphOpenGLReference newReference(CanvasPeer canvasPeer, SceneGraphOpenGLReferences references, int numNamesPerContext) {
            return new SceneGraphOpenGLReference(canvasPeer, references, numNamesPerContext){

                public void prepareObjectForDestroy() {
                    SceneGraphOpenGLReference ref = this.getReferences().removeReference(this.getContext().getCanvasID());
                    ((CanvasPeerImplBase)this.getContext()).addDestroyableObject(ref);
                }

                public void destroyObject(int index, int name) {
                    GL gl = ((CanvasPeerImplBase)this.getContext()).getGL();
                    gl.glDeleteObjectARB(name);
                }
            };
        }
    };
    private static SceneGraphOpenGLReferences.Provider shaderNameProvider = new SceneGraphOpenGLReferences.Provider(){

        public SceneGraphOpenGLReference newReference(CanvasPeer canvasPeer, SceneGraphOpenGLReferences references, int numNamesPerContext) {
            return new SceneGraphOpenGLReference(canvasPeer, references, numNamesPerContext){

                public void prepareObjectForDestroy() {
                    SceneGraphOpenGLReference ref = this.getReferences().removeReference(this.getContext().getCanvasID());
                    ((CanvasPeerImplBase)this.getContext()).addDestroyableObject(ref);
                }

                public void destroyObject(int index, int name) {
                }
            };
        }
    };
    private static boolean checkedOnce = false;

    private static void checkOnce(GL gl) {
        String extensions = gl.glGetString(7939);
        if (extensions.indexOf("GL_ARB_shader_objects") != -1) {
            ARB_shader_objects_supported = true;
        } else {
            X3DLog.error("GL_ARB_fragment_shader and/or GL_ARB_vertex_shader not supported, skipping");
        }
        checkedOnce = true;
    }

    protected static final boolean areARBShaderObjectsSupported(GL gl) {
        if (!checkedOnce) {
            GLSLShaderProgramStateUnitPeer.checkOnce(gl);
        }
        return ARB_shader_objects_supported;
    }

    private static void compileShader(GL gl, GLSLShader s, SceneGraphOpenGLReference shaderOpenGLRef) {
        if (s.hasCompilationError()) {
            return;
        }
        X3DLog.debug("compiling Shader:\n" + s.getShaderCode() + "\n");
        int shaderType = s.getType() == Shader.ShaderType.VERTEX ? 35633 : 35632;
        int glHandle = gl.glCreateShaderObjectARB(shaderType);
        shaderOpenGLRef.setName(glHandle);
        tmpIntBuffer.clear();
        tmpIntBuffer.put(s.getShaderCode().length());
        tmpIntBuffer.rewind();
        gl.glShaderSourceARB(glHandle, 1, new String[]{s.getShaderCode()}, tmpIntBuffer);
        gl.glCompileShaderARB(glHandle);
        int[] params = new int[1];
        gl.glGetObjectParameterivARB(glHandle, 35713, params, 0);
        if (params[0] != 1) {
            if (GLSLContext.isDebuggingEnabled()) {
                tmpIntBuffer.clear();
                gl.glGetObjectParameterivARB(glHandle, 35716, tmpIntBuffer);
                int length = tmpIntBuffer.get();
                if (tmpByteBuffer.limit() < length) {
                    tmpByteBuffer = BufferUtil.newByteBuffer((int)((int)((double)length * 1.5)));
                }
                tmpIntBuffer.flip();
                tmpByteBuffer.clear();
                gl.glGetInfoLogARB(glHandle, length, tmpIntBuffer, tmpByteBuffer);
                byte[] infoBytes = new byte[length];
                tmpByteBuffer.get(infoBytes);
                String errMsg = new String(infoBytes);
                String message = "Failed to compile GLSL Shader.\nMessage:\n" + errMsg + "\n" + "+++++++++++++++++++++++++++++++++++\n" + "Source:\n" + "+++++++++++++++++++++++++++++++++++\n" + DebugStrings.numerateLines(s.getShaderCode(), 1, 3) + "\n" + "+++++++++++++++++++++++++++++++++++\n";
                System.err.println(message);
                X3DLog.error(message);
            }
            s.setCompilationError(true);
            return;
        }
        X3DLog.debug("done glHandle: " + glHandle);
        _SG_PrivilegedAccess.setDirty(s, false);
    }

    private static void mapAttributes(GL gl, GLSLShaderProgram shaderProgram, SceneGraphOpenGLReference shaderProgOpenGLRef) {
        if (!OpenGlExtensions.GL_CUSTOM_VERTEX_ATTRIBUTES) {
            return;
        }
        for (int i = 0; i < shaderProgram.getNumVertexShaders(); ++i) {
            GLSLVertexShader shader = (GLSLVertexShader)shaderProgram.getVertexShader(i);
            int numAttribs = shader.getVertexAttributesCount();
            for (int j = 0; j < numAttribs; ++j) {
                int index = shader.getNthVertexAttributeIndex(j);
                String name = shader.getVertexAttributeMapping(index);
                gl.glBindAttribLocation(shaderProgOpenGLRef.getName(), index, name);
            }
        }
    }

    private static void linkShaderProgram(GL gl, GLSLShaderProgram shaderProgram, CanvasPeer canvasPeer) {
        GLSLShader s;
        int i;
        if (shaderProgram.hasLinkingError()) {
            return;
        }
        X3DLog.debug("linking GLSL shader program: ", shaderProgram.getName());
        SceneGraphOpenGLReference shaderProgOpenGLRef = shaderProgram.getOpenGLReferences().getReference(canvasPeer, shaderProgramNameProvider);
        int glHandle = gl.glCreateProgramObjectARB();
        shaderProgOpenGLRef.setName(glHandle);
        for (i = 0; i < shaderProgram.getNumVertexShaders(); ++i) {
            s = (GLSLVertexShader)shaderProgram.getVertexShader(i);
            gl.glAttachObjectARB(glHandle, s.getOpenGLReferences().getReference(canvasPeer, shaderNameProvider).getName());
        }
        for (i = 0; i < shaderProgram.getNumFragmentShaders(); ++i) {
            s = (GLSLFragmentShader)shaderProgram.getFragmentShader(i);
            gl.glAttachObjectARB(glHandle, s.getOpenGLReferences().getReference(canvasPeer, shaderNameProvider).getName());
        }
        GLSLShaderProgramStateUnitPeer.mapAttributes(gl, shaderProgram, shaderProgOpenGLRef);
        gl.glLinkProgramARB(glHandle);
        int[] params = new int[1];
        gl.glGetObjectParameterivARB(glHandle, 35714, params, 0);
        if (params[0] != 1) {
            X3DLog.error("failed to link glsl program shader id:", glHandle);
            _SG_PrivilegedAccess.setGLSLShaderProgramLinkError(shaderProgram, true);
            return;
        }
        X3DLog.debug("done ... glHandle: ", glHandle);
        _SG_PrivilegedAccess.setGLSLShaderProgramLinked(shaderProgram, true);
    }

    private static void applyUniformVariables(GL gl, GLSLContext shaderProgram, CanvasPeer canvasPeer) {
        GLSLShaderProgram program = (GLSLShaderProgram)shaderProgram.getProgram();
        GLSLParameters params = shaderProgram.getUniformParameters();
        if (program.hasLinkingError()) {
            return;
        }
        if (!params.hasUniformVars()) {
            return;
        }
        SceneGraphOpenGLReference shaderProgOpenGLRef = program.getOpenGLReferences().getReference(canvasPeer, shaderProgramNameProvider);
        int numFloatUniformVars = params.getNumUniformVarsFloat();
        block14: for (int k = 0; k < numFloatUniformVars; ++k) {
            String key = params.getFloatUniformVarName(k);
            int location = gl.glGetUniformLocationARB(shaderProgOpenGLRef.getName(), key);
            float[] value = params.getUniformVarValueFloat(k);
            switch (params.getUniformVarBaseSizeFloat(k)) {
                case 1: {
                    gl.glUniform1fvARB(location, value.length, value, 0);
                    continue block14;
                }
                case 2: {
                    gl.glUniform2fvARB(location, value.length / 2, value, 0);
                    continue block14;
                }
                case 3: {
                    gl.glUniform3fvARB(location, value.length / 3, value, 0);
                    continue block14;
                }
                case 4: {
                    gl.glUniform4fvARB(location, value.length / 4, value, 0);
                    continue block14;
                }
                case 9: {
                    gl.glUniformMatrix3fv(location, value.length / 9, true, value, 0);
                    continue block14;
                }
                case 16: {
                    gl.glUniformMatrix4fv(location, value.length / 16, true, value, 0);
                }
            }
        }
        int numIntUniformVars = params.getNumUniformVarsInt();
        block15: for (int k = 0; k < numIntUniformVars; ++k) {
            String key = params.getIntUniformVarName(k);
            int location = gl.glGetUniformLocationARB(shaderProgOpenGLRef.getName(), key);
            int[] value = params.getUniformVarValueInt(k);
            switch (params.getUniformVarBaseSizeInt(k)) {
                case 1: {
                    gl.glUniform1ivARB(location, value.length, value, 0);
                    continue block15;
                }
                case 2: {
                    gl.glUniform2ivARB(location, value.length / 2, value, 0);
                    continue block15;
                }
                case 3: {
                    gl.glUniform3ivARB(location, value.length / 3, value, 0);
                    continue block15;
                }
                case 4: {
                    gl.glUniform4ivARB(location, value.length / 4, value, 0);
                }
            }
        }
    }

    protected static final int getCurrentShaderProgram(GL gl) {
        if (!checkedOnce) {
            GLSLShaderProgramStateUnitPeer.checkOnce(gl);
        }
        if (!ARB_shader_objects_supported) {
            return 0;
        }
        return gl.glGetHandleARB(35648);
    }

    protected static final void disableGLSLShaders(GL gl, OpenGLStatesCache statesCache) {
        if (statesCache.currentGLSLShaderProgram == 0) {
            return;
        }
        if (!checkedOnce) {
            GLSLShaderProgramStateUnitPeer.checkOnce(gl);
        }
        if (ARB_shader_objects_supported) {
            gl.glUseProgramObjectARB(0);
        }
        statesCache.currentGLSLShaderProgram = 0;
    }

    public static final void apply(Object glObj, GLSLContext shaderProgram, CanvasPeer canvasPeer, OpenGLStatesCache statesCache, RenderPeer.RenderMode renderMode) {
        ProfileTimer.startProfile((LogChannel)X3DLog.LOG_CHANNEL, (String)"GLSLShaderProgramShaderPeer:shade");
        GL gl = (GL)glObj;
        if (renderMode != RenderPeer.RenderMode.NORMAL) {
            GLSLShaderProgramStateUnitPeer.disableGLSLShaders(gl, statesCache);
            return;
        }
        if (!checkedOnce) {
            GLSLShaderProgramStateUnitPeer.checkOnce(gl);
        }
        GLSLShaderProgram program = (GLSLShaderProgram)shaderProgram.getProgram();
        if (shaderProgram.isEnabled() && !program.isLinked()) {
            SceneGraphOpenGLReference shaderOpenGLRef;
            GLSLShader s;
            int i;
            for (i = 0; i < program.getNumVertexShaders(); ++i) {
                s = (GLSLShader)program.getVertexShader(i);
                shaderOpenGLRef = s.getOpenGLReferences().getReference(canvasPeer, shaderNameProvider);
                if (!_SG_PrivilegedAccess.isDirty(s)) continue;
                GLSLShaderProgramStateUnitPeer.compileShader(gl, s, shaderOpenGLRef);
            }
            for (i = 0; i < program.getNumFragmentShaders(); ++i) {
                s = (GLSLShader)program.getFragmentShader(i);
                shaderOpenGLRef = s.getOpenGLReferences().getReference(canvasPeer, shaderNameProvider);
                if (!_SG_PrivilegedAccess.isDirty(s)) continue;
                GLSLShaderProgramStateUnitPeer.compileShader(gl, s, shaderOpenGLRef);
            }
            GLSLShaderProgramStateUnitPeer.linkShaderProgram(gl, program, canvasPeer);
        }
        if (shaderProgram.isEnabled()) {
            if (program.isLinked() && ARB_shader_objects_supported) {
                int shaderProgGLHandle = program.getOpenGLReferences().getReference(canvasPeer, shaderProgramNameProvider).getName();
                X3DLog.debug("Use glsl program id ", shaderProgGLHandle);
                if (!statesCache.enabled || statesCache.currentGLSLShaderProgram != shaderProgGLHandle) {
                    gl.glUseProgramObjectARB(shaderProgGLHandle);
                    statesCache.currentGLSLShaderProgram = shaderProgGLHandle;
                }
                GLSLShaderProgramStateUnitPeer.applyUniformVariables(gl, shaderProgram, canvasPeer);
            }
        } else {
            GLSLShaderProgramStateUnitPeer.disableGLSLShaders(gl, statesCache);
        }
        ProfileTimer.endProfile();
    }
}

