/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.jsr231;

import com.sun.opengl.util.BufferUtil;
import java.nio.FloatBuffer;
import javax.media.opengl.GL;
import org.jagatoo.logging.LogChannel;
import org.jagatoo.logging.ProfileTimer;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.OpenGLCapabilities;
import org.xith3d.render.OpenGLStatesCache;
import org.xith3d.render.RenderOptions;
import org.xith3d.render.RenderPeer;
import org.xith3d.render.preprocessing.RenderAtom;
import org.xith3d.render.states.StateUnit;
import org.xith3d.render.states.units.LightingStateUnit;
import org.xith3d.render.states.units.StateUnitPeer;
import org.xith3d.scenegraph.AmbientLight;
import org.xith3d.scenegraph.DirectionalLight;
import org.xith3d.scenegraph.Light;
import org.xith3d.scenegraph.PointLight;
import org.xith3d.scenegraph.SpotLight;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph._SG_PrivilegedAccess;
import org.xith3d.utility.logging.X3DLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LightingStateUnitPeer
implements StateUnitPeer {
    private final FloatBuffer floatBuffer = BufferUtil.newFloatBuffer((int)4);
    private static final FloatBuffer blackColorBuffer = BufferUtil.newFloatBuffer((int)4);
    private final Point3f tmpPoint = new Point3f();
    private final Vector3f tmpVector = new Vector3f();

    public static final int getGlLight(int l) {
        switch (l) {
            case 0: {
                return 16384;
            }
            case 1: {
                return 16385;
            }
            case 2: {
                return 16386;
            }
            case 3: {
                return 16387;
            }
            case 4: {
                return 16388;
            }
            case 5: {
                return 16389;
            }
            case 6: {
                return 16390;
            }
            case 7: {
                return 16391;
            }
        }
        Error e = new Error("Invalid Light");
        X3DLog.print(e);
        throw e;
    }

    private final boolean shadeLight(GL gl, OpenGLStatesCache statesCache, Light light, Transform3D transform, int lightIndex) {
        if (light == null || !light.isEnabled() || lightIndex > 7) {
            return false;
        }
        if (light instanceof AmbientLight) {
            AmbientLight aLight = (AmbientLight)light;
            Colorf color = aLight.getColor();
            this.floatBuffer.clear();
            this.floatBuffer.put(color.getRed());
            this.floatBuffer.put(color.getGreen());
            this.floatBuffer.put(color.getBlue());
            this.floatBuffer.put(1.0f);
            this.floatBuffer.rewind();
            gl.glLightModelfv(2899, this.floatBuffer);
            return false;
        }
        if (light instanceof DirectionalLight) {
            int glLight = LightingStateUnitPeer.getGlLight(lightIndex);
            DirectionalLight dLight = (DirectionalLight)light;
            Colorf color = dLight.getColor();
            this.floatBuffer.clear();
            this.floatBuffer.put(color.getRed());
            this.floatBuffer.put(color.getGreen());
            this.floatBuffer.put(color.getBlue());
            this.floatBuffer.put(1.0f);
            this.floatBuffer.rewind();
            gl.glLightfv(glLight, 4609, this.floatBuffer);
            gl.glLightfv(glLight, 4610, this.floatBuffer);
            gl.glLightfv(glLight, 4608, blackColorBuffer);
            if (transform == null) {
                this.tmpVector.set((TupleNf)dLight.getDirection());
            } else {
                transform.getMatrix4f().transform(dLight.getDirection(), this.tmpVector);
            }
            this.floatBuffer.clear();
            this.floatBuffer.put(-this.tmpVector.getX());
            this.floatBuffer.put(-this.tmpVector.getY());
            this.floatBuffer.put(-this.tmpVector.getZ());
            this.floatBuffer.put(0.0f);
            this.floatBuffer.rewind();
            gl.glLightfv(glLight, 4611, this.floatBuffer);
            gl.glLightf(glLight, 4613, 0.0f);
            gl.glLightf(glLight, 4614, 180.0f);
            if (!statesCache.enabled || !statesCache.lightEnabled[lightIndex]) {
                gl.glEnable(glLight);
                statesCache.lightEnabled[lightIndex] = true;
            }
        } else if (light instanceof PointLight) {
            int glLight = LightingStateUnitPeer.getGlLight(lightIndex);
            PointLight pLight = (PointLight)light;
            Colorf color = pLight.getColor();
            this.floatBuffer.clear();
            this.floatBuffer.put(color.getRed());
            this.floatBuffer.put(color.getGreen());
            this.floatBuffer.put(color.getBlue());
            this.floatBuffer.put(1.0f);
            this.floatBuffer.rewind();
            gl.glLightfv(glLight, 4609, this.floatBuffer);
            gl.glLightfv(glLight, 4610, this.floatBuffer);
            gl.glLightfv(glLight, 4608, blackColorBuffer);
            if (transform == null) {
                this.tmpPoint.set((TupleNf)pLight.getLocation());
            } else {
                transform.transform(pLight.getLocation(), this.tmpPoint);
            }
            this.floatBuffer.clear();
            this.floatBuffer.put(this.tmpPoint.getX());
            this.floatBuffer.put(this.tmpPoint.getY());
            this.floatBuffer.put(this.tmpPoint.getZ() + 1.0E-5f);
            this.floatBuffer.put(1.0f);
            this.floatBuffer.rewind();
            gl.glLightfv(glLight, 4611, this.floatBuffer);
            Tuple3f att = pLight.getAttenuation();
            gl.glLightf(glLight, 4615, att.getX());
            gl.glLightf(glLight, 4616, att.getY());
            gl.glLightf(glLight, 4617, att.getZ());
            if (light instanceof SpotLight) {
                SpotLight sLight = (SpotLight)pLight;
                if (transform == null) {
                    this.tmpVector.set((TupleNf)sLight.getDirection());
                } else {
                    transform.getMatrix4f().transform(sLight.getDirection(), this.tmpVector);
                }
                this.floatBuffer.clear();
                this.floatBuffer.put(this.tmpVector.getX());
                this.floatBuffer.put(this.tmpVector.getY());
                this.floatBuffer.put(this.tmpVector.getZ());
                this.floatBuffer.put(1.0f);
                this.floatBuffer.rewind();
                gl.glLightfv(glLight, 4612, this.floatBuffer);
                gl.glLightf(glLight, 4613, sLight.getConcentration());
                gl.glLightf(glLight, 4614, sLight.getSpreadAngleDeg());
            } else {
                gl.glLightf(glLight, 4613, 0.0f);
                gl.glLightf(glLight, 4614, 180.0f);
            }
            if (!statesCache.enabled || !statesCache.lightEnabled[lightIndex]) {
                gl.glEnable(glLight);
                statesCache.lightEnabled[lightIndex] = true;
            }
        }
        return true;
    }

    private static final Transform3D getTrackedNodeTransform(Light light) {
        DirectionalLight dLight;
        if (light instanceof PointLight) {
            PointLight pLight = (PointLight)light;
            if (pLight.getTrackedNode() != null) {
                return pLight.getTrackedNode().getWorldTransform();
            }
        } else if (light instanceof DirectionalLight && (dLight = (DirectionalLight)light).getTrackedNode() != null) {
            return dLight.getTrackedNode().getWorldTransform();
        }
        return null;
    }

    @Override
    public void apply(RenderAtom<?> atom, StateUnit stateUnit, Object glObj, CanvasPeer canvasPeer, RenderPeer renderPeer, OpenGLCapabilities glCaps, View view, OpenGLStatesCache statesCache, RenderOptions options, long nanoTime, long nanoStep, RenderPeer.RenderMode renderMode, long frameId) {
        int i;
        boolean hasLights;
        ProfileTimer.startProfile((LogChannel)X3DLog.LOG_CHANNEL, (String)"LightingStateUnitPeer::apply()");
        GL gl = (GL)glObj;
        LightingStateUnit ls = (LightingStateUnit)stateUnit;
        int lightIndex = 0;
        boolean bl = hasLights = ls.numLights() > 0 || view.getAttachedLight() != null;
        if (renderMode == RenderPeer.RenderMode.NORMAL && hasLights) {
            gl.glPushMatrix();
            gl.glLoadMatrixf(_SG_PrivilegedAccess.getFloatBuffer(view.getModelViewTransform(false), true));
            for (i = 0; i < ls.numLights(); ++i) {
                Light light = ls.getLight(i);
                if (!this.shadeLight(gl, statesCache, light, LightingStateUnitPeer.getTrackedNodeTransform(light), lightIndex)) continue;
                ++lightIndex;
            }
            if (this.shadeLight(gl, statesCache, view.getAttachedLight(), view.getTransform(), lightIndex)) {
                ++lightIndex;
            }
        }
        for (i = lightIndex; i <= 7; ++i) {
            if (statesCache.enabled && !statesCache.lightEnabled[i]) continue;
            gl.glDisable(LightingStateUnitPeer.getGlLight(i));
            statesCache.lightEnabled[i] = false;
        }
        if (renderMode == RenderPeer.RenderMode.NORMAL && hasLights) {
            gl.glPopMatrix();
        }
        ProfileTimer.endProfile();
    }

    static {
        blackColorBuffer.put(0.0f);
        blackColorBuffer.put(0.0f);
        blackColorBuffer.put(0.0f);
        blackColorBuffer.put(1.0f);
        blackColorBuffer.rewind();
    }
}

