/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.jsr231;

import com.sun.opengl.util.BufferUtil;
import java.awt.image.BufferedImage;
import java.nio.Buffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL;
import org.jagatoo.opengl.enums.TextureFormat;
import org.openmali.types.twodee.Rect2i;
import org.openmali.vecmath2.Colorf;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.ImageRenderTarget;
import org.xith3d.render.OpenGLCapabilities;
import org.xith3d.render.OpenGLStatesCache;
import org.xith3d.render.RenderTarget;
import org.xith3d.render.SceneGraphOpenGLReference;
import org.xith3d.render.SceneGraphOpenGLReferences;
import org.xith3d.render.TextureRenderTarget;
import org.xith3d.render.jsr231.CanvasPeerImplBase;
import org.xith3d.render.jsr231.RenderPeerImpl;
import org.xith3d.render.jsr231.TextureUnitStateUnitPeer;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;

public class RenderTargetPeer {
    private final IntBuffer intBuffer = BufferUtil.newIntBuffer((int)1);
    private final RenderPeerImpl renderPeer;
    private final SceneGraphOpenGLReferences.Provider frameBufferNameProvider = new SceneGraphOpenGLReferences.Provider(){

        public SceneGraphOpenGLReference newReference(CanvasPeer canvasPeer, SceneGraphOpenGLReferences references, int numNamesPerContext) {
            return new SceneGraphOpenGLReference(canvasPeer, references, numNamesPerContext){

                public void prepareObjectForDestroy() {
                    SceneGraphOpenGLReference ref = this.getReferences().removeReference(this.getContext().getCanvasID());
                    ((CanvasPeerImplBase)this.getContext()).addDestroyableObject(ref);
                }

                public void destroyObject(int index, int name) {
                    GL gl = ((CanvasPeerImplBase)this.getContext()).getGL();
                    RenderTargetPeer.this.intBuffer.clear();
                    RenderTargetPeer.this.intBuffer.put(name).rewind();
                    if (index == 0) {
                        gl.glDeleteFramebuffersEXT(1, RenderTargetPeer.this.intBuffer);
                    } else if (index == 1) {
                        gl.glDeleteRenderbuffersEXT(1, RenderTargetPeer.this.intBuffer);
                    }
                }
            };
        }
    };

    private final void setupRenderTarget(GL gl, OpenGLCapabilities glCaps, OpenGLStatesCache statesCache, CanvasPeer canvasPeer, TextureRenderTarget renderTarget) {
        SceneGraphOpenGLReference openGLRef = renderTarget.getOpenGLReferences().getReference(canvasPeer, this.frameBufferNameProvider);
        Texture texture = renderTarget.getTexture();
        int texWidth = texture.getWidth();
        int texHeight = texture.getHeight();
        if (texWidth <= 0 || texHeight <= 0) {
            throw new Error("The Texture \"" + texture.getName() + "\" of TextureRenderTarget \"" + renderTarget + "\" doesn't seem to have an InputComponent.");
        }
        if (!openGLRef.nameExists(0)) {
            this.intBuffer.clear();
            gl.glGenFramebuffersEXT(1, this.intBuffer);
            openGLRef.setName(0, this.intBuffer.get(0));
        }
        int fb = openGLRef.getName(0);
        gl.glBindFramebufferEXT(36160, fb);
        int tex = TextureUnitStateUnitPeer.setTextureState2(gl, glCaps, statesCache, texture, statesCache.currentServerTextureUnit, texture.isChanged2(), canvasPeer, this.renderPeer.getCanvasPeer().getDepthBufferSize());
        if (texture.getFormat() == TextureFormat.DEPTH) {
            gl.glFramebufferTexture2DEXT(36160, 36096, 3553, tex, 0);
            gl.glDrawBuffer(0);
            gl.glReadBuffer(0);
        } else {
            if (!openGLRef.nameExists(1)) {
                this.intBuffer.clear();
                gl.glGenRenderbuffersEXT(1, this.intBuffer);
                openGLRef.setName(1, this.intBuffer.get(0));
            }
            int rb = openGLRef.getName(1);
            gl.glBindRenderbufferEXT(36161, rb);
            gl.glRenderbufferStorageEXT(36161, 33190, texWidth, texHeight);
            gl.glFramebufferRenderbufferEXT(36160, 36096, 36161, rb);
            gl.glFramebufferTexture2DEXT(36160, 36064, 3553, tex, 0);
        }
        gl.glPushAttrib(2048);
        gl.glViewport(0, 0, texWidth, texHeight);
        Colorf bgCol = renderTarget.getBackgroundColor();
        if (bgCol != null) {
            gl.glClearColor(bgCol.getRed(), bgCol.getGreen(), bgCol.getBlue(), 1.0f - bgCol.getAlpha());
            gl.glClear(17664);
            float[] clearColor = this.renderPeer.getClearColor();
            gl.glClearColor(clearColor[0], clearColor[1], clearColor[2], clearColor[3]);
        }
    }

    private final void finishRenderTarget(GL gl, TextureRenderTarget renderTarget) {
        Texture2D texture;
        if (renderTarget.isPixelReadbackEnabled() && (texture = (Texture2D)renderTarget.getTexture()).getImage0().getDataBuffer() != null) {
            gl.glReadPixels(0, 0, texture.getWidth(), texture.getHeight(), texture.getFormat().hasAlpha() ? 6408 : 6407, 5121, (Buffer)texture.getImage0().getDataBuffer());
        }
        gl.glPopAttrib();
        gl.glBindFramebufferEXT(36160, 0);
    }

    private final void setupRenderTarget(ImageRenderTarget renderTarget) {
        Rect2i viewport = ((CanvasPeerImplBase)this.renderPeer.getCanvasPeer()).getCurrentViewport();
        BufferedImage image = renderTarget.getImage();
        if (image == null || image.getWidth() != viewport.getWidth() || image.getHeight() != viewport.getHeight()) {
            renderTarget.setImage(new BufferedImage(viewport.getWidth(), viewport.getHeight(), 2));
        }
    }

    private final void finishRenderTarget(GL gl, ImageRenderTarget renderTarget) {
        BufferedImage image = renderTarget.getImage();
        gl.glReadPixels(0, 0, image.getWidth(), image.getHeight(), 6408, 5121, (Buffer)renderTarget.getByteBuffer());
        renderTarget.copyBufferToImage();
    }

    public final void setupRenderTarget(GL gl, OpenGLCapabilities glCaps, OpenGLStatesCache statesCache, CanvasPeer canvasPeer, RenderTarget renderTarget) {
        if (renderTarget instanceof TextureRenderTarget) {
            this.setupRenderTarget(gl, glCaps, statesCache, canvasPeer, (TextureRenderTarget)renderTarget);
        } else if (renderTarget instanceof ImageRenderTarget) {
            this.setupRenderTarget((ImageRenderTarget)renderTarget);
        }
    }

    public final void finishRenderTarget(GL gl, RenderTarget renderTarget) {
        if (renderTarget instanceof TextureRenderTarget) {
            this.finishRenderTarget(gl, (TextureRenderTarget)renderTarget);
        } else if (renderTarget instanceof ImageRenderTarget) {
            this.finishRenderTarget(gl, (ImageRenderTarget)renderTarget);
        }
    }

    public RenderTargetPeer(RenderPeerImpl renderPeer) {
        this.renderPeer = renderPeer;
    }
}

