/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.jsr231;

import com.sun.opengl.util.BufferUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import javax.media.opengl.GL;
import org.jagatoo.logging.LogChannel;
import org.jagatoo.logging.ProfileTimer;
import org.jagatoo.opengl.enums.CompareFunction;
import org.jagatoo.opengl.enums.TextureCompareMode;
import org.jagatoo.opengl.enums.TextureFilter;
import org.jagatoo.opengl.enums.TextureFormat;
import org.jagatoo.opengl.enums.TextureImageInternalFormat;
import org.jagatoo.opengl.enums.TextureMode;
import org.jagatoo.opengl.enums.TextureType;
import org.openmali.types.twodee.Rect2i;
import org.openmali.vecmath2.Colorf;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.OpenGLCapabilities;
import org.xith3d.render.OpenGLInfo;
import org.xith3d.render.OpenGLStatesCache;
import org.xith3d.render.OpenGlExtensions;
import org.xith3d.render.RenderOptions;
import org.xith3d.render.RenderPeer;
import org.xith3d.render.SceneGraphOpenGLReference;
import org.xith3d.render.SceneGraphOpenGLReferences;
import org.xith3d.render.jsr231.CanvasPeerImplBase;
import org.xith3d.render.jsr231.RenderPeerImpl;
import org.xith3d.render.jsr231.ShapeAtomPeer;
import org.xith3d.render.preprocessing.RenderAtom;
import org.xith3d.render.states.StateUnit;
import org.xith3d.render.states.units.StateUnitPeer;
import org.xith3d.render.states.units.TextureUnitStateUnit;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.GlobalOptions;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.ProjectiveTextureUnit;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.TexCoordGeneration;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Texture3D;
import org.xith3d.scenegraph.TextureAttributes;
import org.xith3d.scenegraph.TextureCubeMap;
import org.xith3d.scenegraph.TextureImage;
import org.xith3d.scenegraph.TextureImage2D;
import org.xith3d.scenegraph.TextureImage3D;
import org.xith3d.scenegraph.TextureUnit;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph._SG_PrivilegedAccess;
import org.xith3d.utility.logging.X3DLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextureUnitStateUnitPeer
implements StateUnitPeer {
    private static final IntBuffer tmpIntBuffer = BufferUtil.newIntBuffer((int)1);
    private static SceneGraphOpenGLReferences.Provider textureNameProvider = new SceneGraphOpenGLReferences.Provider(){

        public SceneGraphOpenGLReference newReference(CanvasPeer canvasPeer, SceneGraphOpenGLReferences references, int numNamesPerContext) {
            return new SceneGraphOpenGLReference(canvasPeer, references, numNamesPerContext){

                public void prepareObjectForDestroy() {
                    SceneGraphOpenGLReference ref = this.getReferences().removeReference(this.getContext().getCanvasID());
                    ((CanvasPeerImplBase)this.getContext()).addDestroyableObject(ref);
                }

                public void destroyObject(int index, int name) {
                    GL gl = ((CanvasPeerImplBase)this.getContext()).getGL();
                    tmpIntBuffer.clear();
                    tmpIntBuffer.put(name).rewind();
                    gl.glDeleteTextures(1, tmpIntBuffer);
                }
            };
        }
    };
    private static final FloatBuffer tmpBorderColor = BufferUtil.newFloatBuffer((int)4);
    private static final FloatBuffer texBlendColor = BufferUtil.newFloatBuffer((int)4);
    private static final FloatBuffer tmpPlaneBuffer = BufferUtil.newFloatBuffer((int)4);
    private static final ByteBuffer textureDataBuffer = BufferUtil.newByteBuffer((int)0x100000);
    private static final FloatBuffer DEFAULT_TEXTURE_BLEND_COLOR = BufferUtil.newFloatBuffer((int)4);

    public static final int getMaxAnisotropicLevel(GL gl) {
        if (!OpenGlExtensions.GL_EXT_texture_filter_anisotropic) {
            return 0;
        }
        FloatBuffer buffer = BufferUtil.newFloatBuffer((int)16);
        buffer.rewind();
        gl.glGetFloatv(34047, buffer);
        return (int)buffer.get(0);
    }

    public static final void selectServerTextureUnit(GL gl, int unit, OpenGLStatesCache statesCache, boolean force) {
        if (statesCache.enabled && statesCache.currentServerTextureUnit == unit && !force) {
            return;
        }
        X3DLog.debug("Activating (server) texture unit ", unit);
        int glUnit = 33984 + unit;
        gl.glActiveTexture(glUnit);
        statesCache.currentServerTextureUnit = unit;
    }

    public static final int translateInternalFormat(TextureFormat format, TextureImageInternalFormat internalFormat, int depthBuffersize) {
        if (format == TextureFormat.DEPTH) {
            if (depthBuffersize == 16) {
                internalFormat = TextureImageInternalFormat.DEPTH16;
            } else if (depthBuffersize == 24) {
                internalFormat = TextureImageInternalFormat.DEPTH24;
            } else if (depthBuffersize == 32) {
                internalFormat = TextureImageInternalFormat.DEPTH32;
            }
        }
        return internalFormat.toOpenGL();
    }

    private static final int getCubeMapFace(int i) {
        return 34069 + i;
    }

    private static final void applyTextureAttachedAttributes(GL gl, Texture texture, boolean mipmapping, OpenGLCapabilities glCaps) {
        TextureType texType = texture.getType();
        int glTexType = texType.toOpenGL();
        gl.glTexParameteri(glTexType, 10242, texture.getBoundaryModeS().toOpenGL());
        gl.glTexParameteri(glTexType, 10243, texture.getBoundaryModeT().toOpenGL());
        if (texType == TextureType.TEXTURE_3D) {
            gl.glTexParameteri(glTexType, 32882, ((Texture3D)texture).getBoundaryModeR().toOpenGL());
        }
        texture.getBoundaryColor().writeToBuffer(true, tmpBorderColor, true, true);
        gl.glTexParameterfv(glTexType, 4100, tmpBorderColor);
        TextureFilter filter = texture.getFilter();
        if (filter == null) {
            filter = GlobalOptions.getInstance().getTextureFilter();
        }
        gl.glTexParameteri(glTexType, 10240, filter.getOpenGLMagFilter());
        gl.glTexParameteri(glTexType, 10241, filter.getOpenGLMinFilter(mipmapping));
        if (OpenGlExtensions.GL_EXT_texture_filter_anisotropic) {
            int maxAniso;
            int aniso = filter.getAnisotropicLevel();
            if (aniso > (maxAniso = glCaps.getMaxAnisotropicLevel())) {
                aniso = maxAniso;
            }
            gl.glTexParameteri(glTexType, 34046, aniso);
        }
    }

    private static final int defineTexture(GL gl, int unit, Texture texture, CanvasPeer canvasPeer, int depthBufferSize, OpenGLStatesCache statesCache) {
        int numMipmaps = texture.getImagesCount();
        if (numMipmaps == 0) {
            X3DLog.debug("Found texture without images. Skipping!");
            return -1;
        }
        SceneGraphOpenGLReference openGLRef = texture.getOpenGLReferences().getReference(canvasPeer, textureNameProvider);
        int textureId = openGLRef.getName();
        if (textureId == -1) {
            tmpIntBuffer.clear();
            gl.glGenTextures(1, tmpIntBuffer);
            textureId = tmpIntBuffer.get(0);
            openGLRef.setName(textureId);
        }
        int glTexType = texture.getType().toOpenGL();
        gl.glBindTexture(glTexType, textureId);
        statesCache.currentBoundTexture[unit] = texture;
        switch (glTexType) {
            case 3553: {
                TextureImage2D image = null;
                int format = 0;
                int internalFormat = 0;
                int border = 0;
                for (int level = 0; level < numMipmaps; ++level) {
                    ByteBuffer buff;
                    image = (TextureImage2D)texture.getImage(level);
                    if (!image.hasData()) continue;
                    format = image.getFormat().toOpenGL();
                    internalFormat = TextureUnitStateUnitPeer.translateInternalFormat(texture.getFormat(), image.getInternalFormat(), depthBufferSize);
                    if (image.getDataBuffer() != null) {
                        buff = image.getDataBuffer();
                    } else if (image.getDataSize() > textureDataBuffer.capacity()) {
                        buff = BufferUtil.newByteBuffer((int)image.getDataSize());
                        image.getData(buff);
                    } else {
                        buff = textureDataBuffer;
                        image.getData(buff);
                    }
                    if (image.isCompressed()) {
                        gl.glCompressedTexImage2D(glTexType, level, internalFormat, image.getWidth() + 2 * border, image.getHeight() + 2 * border, border, buff.limit(), (Buffer)buff);
                    } else {
                        gl.glTexImage2D(glTexType, level, internalFormat, image.getWidth(), image.getHeight(), border, format, 5121, (Buffer)buff);
                    }
                    if (!texture.isMarkedAsLocalDataToBeFreed()) continue;
                    image.freeLocalData();
                    RenderPeerImpl.setGCRequested();
                }
                break;
            }
            case 32879: {
                TextureImage3D image = null;
                int format = 0;
                int internalFormat = 0;
                int border = texture.getBoundaryWidth();
                int depth = 0;
                for (int level = 0; level < numMipmaps; ++level) {
                    image = (TextureImage3D)texture.getImage(level);
                    internalFormat = TextureUnitStateUnitPeer.translateInternalFormat(texture.getFormat(), image.getInternalFormat(), depthBufferSize);
                    depth = image.getDepth();
                    ByteBuffer buff = image.getDataBuffer();
                    if (image.isCompressed()) {
                        gl.glCompressedTexImage3D(glTexType, level, internalFormat, image.getWidth() + 2 * border, image.getHeight() + 2 * border, depth, border, buff.limit(), (Buffer)buff);
                        continue;
                    }
                    format = image.getFormat().toOpenGL();
                    gl.glTexImage3D(glTexType, level, internalFormat, image.getWidth() + 2 * border, image.getHeight() + 2 * border, depth, border, format, 5121, (Buffer)buff);
                }
                break;
            }
            case 34067: {
                for (int i = 0; i < 6; ++i) {
                    int face = 0;
                    boolean border = false;
                    for (int level = 0; level < numMipmaps; ++level) {
                        ByteBuffer buff;
                        TextureImage image = ((TextureCubeMap)texture).getImage(level, i);
                        int format = image.getFormat().toOpenGL();
                        int internalFormat = TextureUnitStateUnitPeer.translateInternalFormat(texture.getFormat(), image.getInternalFormat(), depthBufferSize);
                        face = TextureUnitStateUnitPeer.getCubeMapFace(i);
                        if (image instanceof TextureImage2D) {
                            TextureImage2D image2D = (TextureImage2D)image;
                            if (image2D.getDataBuffer() != null) {
                                buff = image2D.getDataBuffer();
                            } else if (image2D.getDataSize() > textureDataBuffer.capacity()) {
                                buff = BufferUtil.newByteBuffer((int)image2D.getDataSize());
                                image2D.getData(buff);
                            } else {
                                buff = textureDataBuffer;
                                image2D.getData(buff);
                            }
                        } else if (image instanceof TextureImage3D) {
                            TextureImage3D image3D = (TextureImage3D)image;
                            buff = image3D.getDataBuffer();
                        } else {
                            throw new Error("Unknown TextureImage type " + image.getClass());
                        }
                        if (image.isCompressed()) {
                            gl.glCompressedTexImage2D(face, level, internalFormat, image.getWidth() + 0, image.getHeight() + 0, 0, buff.limit(), (Buffer)buff);
                            continue;
                        }
                        gl.glTexImage2D(face, level, internalFormat, image.getWidth(), image.getHeight(), 0, format, 5121, (Buffer)buff);
                    }
                }
                break;
            }
        }
        return textureId;
    }

    private static final void updateTexture(GL gl, Texture2D texture) {
        if (!texture.hasUpdateList()) {
            return;
        }
        int numLevel = texture.getImagesCount();
        for (int level = 0; level < numLevel; ++level) {
            TextureImage2D image = (TextureImage2D)texture.getImage(level);
            ArrayList<Rect2i> list = image.getUpdateList();
            if (list.isEmpty()) continue;
            int format = image.getFormat().toOpenGL();
            int listSize = list.size();
            for (int i = 0; i < listSize; ++i) {
                ByteBuffer buff;
                Rect2i r = list.get(i);
                gl.glPixelStorei(3314, image.getWidth());
                gl.glPixelStorei(3316, r.getLeft());
                gl.glPixelStorei(3315, r.getTop());
                if (image.getDataBuffer() != null) {
                    buff = image.getDataBuffer();
                } else if (image.getDataSize() > textureDataBuffer.capacity()) {
                    buff = BufferUtil.newByteBuffer((int)image.getDataSize());
                    image.getData(buff);
                } else {
                    buff = textureDataBuffer;
                    image.getData(buff);
                }
                gl.glTexSubImage2D(3553, level, r.getLeft(), r.getTop(), r.getWidth(), r.getHeight(), format, 5121, (Buffer)buff);
            }
            image.clearUpdateList();
            gl.glPixelStorei(3314, 0);
            gl.glPixelStorei(3316, 0);
            gl.glPixelStorei(3315, 0);
        }
        texture.setHasUpdateList(false);
    }

    private static final int bindTexture(GL gl, OpenGLStatesCache statesCache, Texture texture, int unit, CanvasPeer canvasPeer, int depthBuffersize) {
        boolean texCMEnabled;
        boolean tex3DEnabled;
        boolean tex2DEnabled;
        TextureType texType = texture.getType();
        switch (texType) {
            case TEXTURE_CUBE_MAP: {
                tex2DEnabled = false;
                tex3DEnabled = false;
                texCMEnabled = true;
                break;
            }
            case TEXTURE_3D: {
                tex2DEnabled = false;
                tex3DEnabled = true;
                texCMEnabled = false;
                break;
            }
            default: {
                tex2DEnabled = true;
                tex3DEnabled = false;
                texCMEnabled = false;
            }
        }
        if (!(!tex2DEnabled || statesCache.enabled && statesCache.texture2DEnabled[unit])) {
            gl.glEnable(3553);
        } else if (!(tex2DEnabled || statesCache.enabled && !statesCache.texture2DEnabled[unit])) {
            gl.glDisable(3553);
        }
        if (!(!tex3DEnabled || statesCache.enabled && statesCache.texture3DEnabled[unit])) {
            gl.glEnable(32879);
        } else if (!(tex3DEnabled || statesCache.enabled && !statesCache.texture3DEnabled[unit])) {
            gl.glDisable(32879);
        }
        if (!(!texCMEnabled || statesCache.enabled && statesCache.textureCMEnabled[unit])) {
            gl.glEnable(34067);
        } else if (!(texCMEnabled || statesCache.enabled && !statesCache.textureCMEnabled[unit])) {
            gl.glDisable(34067);
        }
        statesCache.texture2DEnabled[unit] = tex2DEnabled;
        statesCache.texture3DEnabled[unit] = tex3DEnabled;
        statesCache.textureCMEnabled[unit] = texCMEnabled;
        SceneGraphOpenGLReference openGLRef = texture.getOpenGLReferences().getReference(canvasPeer, textureNameProvider);
        int texHandle = openGLRef.getName();
        if (texture.isDirty()) {
            if (texHandle != -1) {
                tmpIntBuffer.clear();
                tmpIntBuffer.put(texHandle).flip();
                gl.glDeleteTextures(1, tmpIntBuffer);
                texHandle = openGLRef.deleteName();
            }
            _SG_PrivilegedAccess.setDirty(texture, false);
        }
        if (texHandle != -1 && !texture.hasSizeChanged()) {
            gl.glBindTexture(texType.toOpenGL(), texHandle);
            statesCache.currentBoundTexture[unit] = texture;
            if (texType == TextureType.TEXTURE_2D) {
                TextureUnitStateUnitPeer.updateTexture(gl, (Texture2D)texture);
            }
        } else {
            texHandle = TextureUnitStateUnitPeer.defineTexture(gl, unit, texture, canvasPeer, depthBuffersize, statesCache);
            _SG_PrivilegedAccess.resetSizeChanged(texture);
        }
        return texHandle;
    }

    private static final int setTextureState(GL gl, OpenGLCapabilities glCaps, OpenGLStatesCache statesCache, Texture texture, int unit, boolean texChanged, CanvasPeer canvasPeer, int depthBuffersize) {
        int texHandle = TextureUnitStateUnitPeer.bindTexture(gl, statesCache, texture, unit, canvasPeer, depthBuffersize);
        if (texChanged) {
            TextureUnitStateUnitPeer.applyTextureAttachedAttributes(gl, texture, texture.getImagesCount() > 1, glCaps);
            _SG_PrivilegedAccess.setChanged(texture, false);
        }
        return texHandle;
    }

    private static final void disableTextureState(GL gl, OpenGLStatesCache statesCache, Texture texture, int unit, boolean texChanged) {
        TextureUnitStateUnitPeer.selectServerTextureUnit(gl, unit, statesCache, false);
        if (!statesCache.enabled || statesCache.texture2DEnabled[unit]) {
            gl.glDisable(3553);
            statesCache.texture2DEnabled[unit] = false;
        }
        if (!statesCache.enabled || statesCache.texture3DEnabled[unit]) {
            gl.glDisable(32879);
            statesCache.texture3DEnabled[unit] = false;
        }
        if (!statesCache.enabled || statesCache.textureCMEnabled[unit]) {
            gl.glDisable(34067);
            statesCache.textureCMEnabled[unit] = false;
        }
        if (texChanged) {
            _SG_PrivilegedAccess.setChanged(texture, false);
        }
    }

    protected static final int setTextureState2(GL gl, OpenGLCapabilities glCaps, OpenGLStatesCache statesCache, Texture texture, int unit, boolean texChanged, CanvasPeer canvasPeer, int depthBuffersize) {
        if (texture == null || !texture.isEnabled()) {
            TextureUnitStateUnitPeer.disableTextureState(gl, statesCache, texture, unit, texChanged);
            return -1;
        }
        return TextureUnitStateUnitPeer.setTextureState(gl, glCaps, statesCache, texture, unit, texChanged, canvasPeer, depthBuffersize);
    }

    private static final void setCompareMode(GL gl, OpenGLInfo glInfo, int glTexType, TextureCompareMode mode) {
        if (glInfo.getNormalizedVersion() >= OpenGLInfo.NORM_VERSION_1_4) {
            gl.glTexParameteri(glTexType, 34892, mode.toOpenGL());
        } else if (OpenGlExtensions.ARB_shadow) {
            gl.glTexParameteri(glTexType, 34892, mode.toOpenGL());
        }
    }

    private static final void setCompareFunc(GL gl, OpenGLInfo glInfo, int glTexType, CompareFunction func) {
        if (glInfo.getNormalizedVersion() >= OpenGLInfo.NORM_VERSION_1_4) {
            gl.glTexParameteri(glTexType, 34893, func.toOpenGL());
        } else if (OpenGlExtensions.ARB_shadow) {
            gl.glTexParameteri(glTexType, 34893, func.toOpenGL());
        }
    }

    private static final void setTextureMatrix(GL gl, Transform3D trans) {
        gl.glMatrixMode(5890);
        gl.glLoadMatrixf(_SG_PrivilegedAccess.getFloatBuffer(trans, true));
        gl.glMatrixMode(5888);
    }

    private static final void setIdentityTexMat(GL gl) {
        gl.glMatrixMode(5890);
        gl.glLoadIdentity();
        gl.glMatrixMode(5888);
    }

    private void setTextureAttributes(GL gl, int unit, TextureType texType, TextureAttributes ta, OpenGLInfo glInfo, OpenGLStatesCache statesCache) {
        if (!(ta != null && ta.getTextureTransform() != null || statesCache.enabled && statesCache.currentTextureMatrix[unit] == null)) {
            TextureUnitStateUnitPeer.setIdentityTexMat(gl);
            statesCache.currentTextureMatrix[unit] = null;
        }
        if (ta == null) {
            if (!statesCache.enabled || statesCache.currentTextureMode[unit] != TextureMode.MODULATE) {
                gl.glTexEnvi(8960, 8704, 8448);
                statesCache.currentTextureMode[unit] = TextureMode.MODULATE;
            }
            return;
        }
        Transform3D texTrans = ta.getTextureTransform();
        if (texTrans != null && (!statesCache.enabled || statesCache.currentTextureMatrix[unit] != texTrans || texTrans.isChanged())) {
            TextureUnitStateUnitPeer.setTextureMatrix(gl, texTrans);
            statesCache.currentTextureMatrix[unit] = texTrans;
            _SG_PrivilegedAccess.setChanged(texTrans, false);
        }
        TextureMode textureMode = ta.getTextureMode();
        if (!statesCache.enabled || statesCache.currentTextureMode[unit] != textureMode) {
            gl.glTexEnvi(8960, 8704, textureMode.toOpenGL());
            statesCache.currentTextureMode[unit] = textureMode;
        }
        if (textureMode == TextureMode.COMBINE) {
            Colorf tbc = ta.getTextureBlendColor();
            if (tbc == null) {
                if (!statesCache.enabled || statesCache.currentTextureBlendColor[unit] != null) {
                    gl.glTexEnvfv(8960, 8705, DEFAULT_TEXTURE_BLEND_COLOR);
                    statesCache.currentTextureBlendColor[unit] = null;
                }
            } else if (!statesCache.enabled || statesCache.currentTextureBlendColor[unit] != tbc || tbc.isDirty()) {
                tbc.writeToBuffer(true, texBlendColor, true, true);
                gl.glTexEnvfv(8960, 8705, texBlendColor);
                statesCache.currentTextureBlendColor[unit] = tbc;
                tbc.setClean();
            }
            if (!statesCache.enabled || statesCache.currentCombineMode_RGB[unit] != ta.getCombineRGBMode()) {
                gl.glTexEnvf(8960, 34161, (float)ta.getCombineRGBMode().toOpenGL());
                statesCache.currentCombineMode_RGB[unit] = ta.getCombineRGBMode();
            }
            if (!statesCache.enabled || statesCache.currentCombineMode_Alpha[unit] != ta.getCombineAlphaMode()) {
                gl.glTexEnvf(8960, 34162, (float)ta.getCombineAlphaMode().toOpenGL());
                statesCache.currentCombineMode_Alpha[unit] = ta.getCombineAlphaMode();
            }
            if (!statesCache.enabled || statesCache.currentCombineSource0_RGB[unit] != ta.getCombineRGBSource(0)) {
                gl.glTexEnvf(8960, 34176, (float)ta.getCombineRGBSource(0).toOpenGL());
                statesCache.currentCombineSource0_RGB[unit] = ta.getCombineRGBSource(0);
            }
            if (!statesCache.enabled || statesCache.currentCombineSource0_Alpha[unit] != ta.getCombineAlphaSource(0)) {
                gl.glTexEnvf(8960, 34184, (float)ta.getCombineAlphaSource(0).toOpenGL());
                statesCache.currentCombineSource0_Alpha[unit] = ta.getCombineAlphaSource(0);
            }
            if (!statesCache.enabled || statesCache.currentCombineFunction0_RGB[unit] != ta.getCombineRGBFunction(0)) {
                gl.glTexEnvf(8960, 34192, (float)ta.getCombineRGBFunction(0).toOpenGL());
                statesCache.currentCombineFunction0_RGB[unit] = ta.getCombineRGBFunction(0);
            }
            if (!statesCache.enabled || statesCache.currentCombineFunction0_Alpha[unit] != ta.getCombineAlphaFunction(0)) {
                gl.glTexEnvf(8960, 34200, (float)ta.getCombineAlphaFunction(0).toOpenGL());
                statesCache.currentCombineFunction0_Alpha[unit] = ta.getCombineAlphaFunction(0);
            }
            if (!statesCache.enabled || statesCache.currentCombineSource1_RGB[unit] != ta.getCombineRGBSource(1)) {
                gl.glTexEnvf(8960, 34177, (float)ta.getCombineRGBSource(1).toOpenGL());
                statesCache.currentCombineSource1_RGB[unit] = ta.getCombineRGBSource(1);
            }
            if (!statesCache.enabled || statesCache.currentCombineSource1_Alpha[unit] != ta.getCombineAlphaSource(1)) {
                gl.glTexEnvf(8960, 34185, (float)ta.getCombineAlphaSource(1).toOpenGL());
                statesCache.currentCombineSource1_Alpha[unit] = ta.getCombineAlphaSource(1);
            }
            if (!statesCache.enabled || statesCache.currentCombineFunction0_RGB[unit] != ta.getCombineRGBFunction(1)) {
                gl.glTexEnvf(8960, 34193, (float)ta.getCombineRGBFunction(1).toOpenGL());
                statesCache.currentCombineFunction0_RGB[unit] = ta.getCombineRGBFunction(1);
            }
            if (!statesCache.enabled || statesCache.currentCombineFunction0_Alpha[unit] != ta.getCombineAlphaFunction(1)) {
                gl.glTexEnvf(8960, 34201, (float)ta.getCombineAlphaFunction(1).toOpenGL());
                statesCache.currentCombineFunction0_Alpha[unit] = ta.getCombineAlphaFunction(1);
            }
            if (!statesCache.enabled || statesCache.currentCombineSource2_RGB[unit] != ta.getCombineRGBSource(2)) {
                gl.glTexEnvf(8960, 34178, (float)ta.getCombineRGBSource(2).toOpenGL());
                statesCache.currentCombineSource2_RGB[unit] = ta.getCombineRGBSource(2);
            }
            if (!statesCache.enabled || statesCache.currentCombineSource2_Alpha[unit] != ta.getCombineAlphaSource(2)) {
                gl.glTexEnvf(8960, 34186, (float)ta.getCombineAlphaSource(2).toOpenGL());
                statesCache.currentCombineSource2_Alpha[unit] = ta.getCombineAlphaSource(2);
            }
            if (!statesCache.enabled || statesCache.currentCombineFunction0_RGB[unit] != ta.getCombineRGBFunction(2)) {
                gl.glTexEnvf(8960, 34194, (float)ta.getCombineRGBFunction(2).toOpenGL());
                statesCache.currentCombineFunction0_RGB[unit] = ta.getCombineRGBFunction(2);
            }
            if (!statesCache.enabled || statesCache.currentCombineFunction0_Alpha[unit] != ta.getCombineAlphaFunction(2)) {
                gl.glTexEnvf(8960, 34202, (float)ta.getCombineAlphaFunction(2).toOpenGL());
                statesCache.currentCombineFunction0_Alpha[unit] = ta.getCombineAlphaFunction(2);
            }
            if (!statesCache.enabled || statesCache.currentCombineRGBScale[unit] != ta.getCombineRGBScale()) {
                gl.glTexEnvi(8960, 34163, ta.getCombineRGBScale());
                statesCache.currentCombineRGBScale[unit] = ta.getCombineRGBScale();
            }
        }
        if (texType == TextureType.TEXTURE_2D || texType == TextureType.TEXTURE_1D) {
            int glTexType = texType.toOpenGL();
            if (!statesCache.enabled || statesCache.currentCompareMode[unit] != ta.getCompareMode()) {
                TextureUnitStateUnitPeer.setCompareMode(gl, glInfo, glTexType, ta.getCompareMode());
                statesCache.currentCompareMode[unit] = ta.getCompareMode();
            }
            if (!statesCache.enabled || statesCache.currentCompareFunc[unit] != ta.getCompareFunction()) {
                TextureUnitStateUnitPeer.setCompareFunc(gl, glInfo, glTexType, ta.getCompareFunction());
                statesCache.currentCompareFunc[unit] = ta.getCompareFunction();
            }
        }
    }

    private final void updateProjectiveTexture(Shape3D shape, int tuIndex, CanvasPeerImplBase canvas, long frameId) {
        Appearance app = shape.getAppearance();
        if (app == null) {
            return;
        }
        TextureUnit tu = app.getTextureUnit(tuIndex);
        if (!(tu instanceof ProjectiveTextureUnit)) {
            return;
        }
        ProjectiveTextureUnit projTU = (ProjectiveTextureUnit)tu;
        float viewportAspect = canvas.getCurrentViewport() == null ? canvas.getDisplayMode().getAspect() : canvas.getCurrentViewport().getAspect();
        projTU.update(viewportAspect, frameId);
    }

    private static final void setupTextureCoordsGeneration(GL gl, TexCoordGeneration texGen) {
        int glGenMode = texGen.getGenMode().toOpenGL();
        int glPlaneName = 9474;
        FloatBuffer planeBuf = null;
        switch (texGen.getGenMode()) {
            case OBJECT_LINEAR: {
                glPlaneName = 9473;
                planeBuf = tmpPlaneBuffer;
                break;
            }
            case EYE_LINEAR: {
                glPlaneName = 9474;
                planeBuf = tmpPlaneBuffer;
                break;
            }
            case SPHERE_MAP: {
                break;
            }
            case NORMAL_MAP: {
                break;
            }
            case REFLECTION_MAP: {
                break;
            }
            default: {
                throw new Error("Unsupported Texture-generation-mode " + texGen.getGenMode());
            }
        }
        switch (texGen.getFormat()) {
            case TEXTURE_COORDINATES_1: {
                gl.glTexGeni(8192, 9472, glGenMode);
                if (planeBuf == null) break;
                texGen.getPlaneS().writeToBuffer(planeBuf, true, true);
                gl.glTexGenfv(8192, glPlaneName, planeBuf);
                break;
            }
            case TEXTURE_COORDINATES_2: {
                gl.glTexGeni(8192, 9472, glGenMode);
                gl.glTexGeni(8193, 9472, glGenMode);
                if (planeBuf == null) break;
                texGen.getPlaneS().writeToBuffer(planeBuf, true, true);
                gl.glTexGenfv(8192, glPlaneName, planeBuf);
                texGen.getPlaneT().writeToBuffer(planeBuf, true, true);
                gl.glTexGenfv(8193, glPlaneName, planeBuf);
                break;
            }
            case TEXTURE_COORDINATES_3: {
                gl.glTexGeni(8192, 9472, glGenMode);
                gl.glTexGeni(8193, 9472, glGenMode);
                gl.glTexGeni(8194, 9472, glGenMode);
                if (planeBuf == null) break;
                texGen.getPlaneS().writeToBuffer(planeBuf, true, true);
                gl.glTexGenfv(8192, glPlaneName, planeBuf);
                texGen.getPlaneT().writeToBuffer(planeBuf, true, true);
                gl.glTexGenfv(8193, glPlaneName, planeBuf);
                texGen.getPlaneR().writeToBuffer(planeBuf, true, true);
                gl.glTexGenfv(8194, glPlaneName, planeBuf);
                break;
            }
            case TEXTURE_COORDINATES_4: {
                gl.glTexGeni(8192, 9472, glGenMode);
                gl.glTexGeni(8193, 9472, glGenMode);
                gl.glTexGeni(8194, 9472, glGenMode);
                gl.glTexGeni(8195, 9472, glGenMode);
                if (planeBuf == null) break;
                texGen.getPlaneS().writeToBuffer(planeBuf, true, true);
                gl.glTexGenfv(8192, glPlaneName, planeBuf);
                texGen.getPlaneT().writeToBuffer(planeBuf, true, true);
                gl.glTexGenfv(8193, glPlaneName, planeBuf);
                texGen.getPlaneR().writeToBuffer(planeBuf, true, true);
                gl.glTexGenfv(8194, glPlaneName, planeBuf);
                texGen.getPlaneQ().writeToBuffer(planeBuf, true, true);
                gl.glTexGenfv(8195, glPlaneName, planeBuf);
            }
        }
    }

    private static final void applyTexCoordGenStates(GL gl, int unit, int statesMask, OpenGLStatesCache statesCache) {
        if ((statesMask & 1) != 0) {
            if (!statesCache.enabled || (statesCache.texGenEnableMask[unit] & 1) == 0) {
                gl.glEnable(3168);
                int n = unit;
                statesCache.texGenEnableMask[n] = statesCache.texGenEnableMask[n] | 1;
            }
        } else if (!statesCache.enabled || (statesCache.texGenEnableMask[unit] & 1) != 0) {
            gl.glDisable(3168);
            int n = unit;
            statesCache.texGenEnableMask[n] = statesCache.texGenEnableMask[n] & 0xFFFFFFFE;
        }
        if ((statesMask & 2) != 0) {
            if (!statesCache.enabled || (statesCache.texGenEnableMask[unit] & 2) == 0) {
                gl.glEnable(3169);
                int n = unit;
                statesCache.texGenEnableMask[n] = statesCache.texGenEnableMask[n] | 2;
            }
        } else if (!statesCache.enabled || (statesCache.texGenEnableMask[unit] & 2) != 0) {
            gl.glDisable(3169);
            int n = unit;
            statesCache.texGenEnableMask[n] = statesCache.texGenEnableMask[n] & 0xFFFFFFFD;
        }
        if ((statesMask & 4) != 0) {
            if (!statesCache.enabled || (statesCache.texGenEnableMask[unit] & 4) == 0) {
                gl.glEnable(3170);
                int n = unit;
                statesCache.texGenEnableMask[n] = statesCache.texGenEnableMask[n] | 4;
            }
        } else if (!statesCache.enabled || (statesCache.texGenEnableMask[unit] & 4) != 0) {
            gl.glDisable(3170);
            int n = unit;
            statesCache.texGenEnableMask[n] = statesCache.texGenEnableMask[n] & 0xFFFFFFFB;
        }
        if ((statesMask & 8) != 0) {
            if (!statesCache.enabled || (statesCache.texGenEnableMask[unit] & 8) == 0) {
                gl.glEnable(3171);
                int n = unit;
                statesCache.texGenEnableMask[n] = statesCache.texGenEnableMask[n] | 8;
            }
        } else if (!statesCache.enabled || (statesCache.texGenEnableMask[unit] & 8) != 0) {
            gl.glDisable(3171);
            int n = unit;
            statesCache.texGenEnableMask[n] = statesCache.texGenEnableMask[n] & 0xFFFFFFF7;
        }
    }

    @Override
    public void apply(RenderAtom<?> atom, StateUnit stateUnit, Object glObj, CanvasPeer canvasPeer, RenderPeer renderPeer, OpenGLCapabilities glCaps, View view, OpenGLStatesCache statesCache, RenderOptions options, long nanoTime, long nanoStep, RenderPeer.RenderMode renderMode, long frameId) {
        if (!options.isTextureMappingEnabled() || renderMode != RenderPeer.RenderMode.NORMAL) {
            return;
        }
        ProfileTimer.startProfile((LogChannel)X3DLog.LOG_CHANNEL, (String)"TextureUnitStateUnitPeer::apply()");
        GL gl = (GL)glObj;
        TextureUnitStateUnit texStateUnit = (TextureUnitStateUnit)stateUnit;
        int unit = texStateUnit.getUnit();
        if (unit >= glCaps.getMaxTextureUnits()) {
            ProfileTimer.endProfile();
            return;
        }
        Texture texture = texStateUnit.getTexture();
        if (texture == null) {
            TextureUnitStateUnitPeer.disableTextureState(gl, statesCache, texture, unit, false);
            statesCache.currentBoundTexture[unit] = texture;
            ProfileTimer.endProfile();
            return;
        }
        if (!texture.isEnabled()) {
            TextureUnitStateUnitPeer.disableTextureState(gl, statesCache, texture, unit, texture.isChanged2());
            statesCache.currentBoundTexture[unit] = texture;
            ProfileTimer.endProfile();
            return;
        }
        boolean changed = texture.isChanged2();
        if (texture instanceof Texture2D && (((Texture2D)texture).hasTextureCanvas() && _SG_PrivilegedAccess.notifyDrawCallbacks(((Texture2D)texture).getTextureCanvas(), nanoTime) || ((Texture2D)texture).hasUpdateList()) || !statesCache.enabled || statesCache.currentBoundTexture[unit] != texture || changed) {
            TextureUnitStateUnitPeer.selectServerTextureUnit(gl, unit, statesCache, false);
            TextureUnitStateUnitPeer.setTextureState(gl, glCaps, statesCache, texture, unit, changed, canvasPeer, canvasPeer.getDepthBufferSize());
            statesCache.currentBoundTexture[unit] = texture;
        }
        TextureAttributes texAttribs = texStateUnit.getTextureAttributes();
        changed = texAttribs.isChanged();
        boolean hasProjectiveTex = atom.getNode() instanceof Shape3D;
        if (hasProjectiveTex) {
            Appearance app = ((Shape3D)atom.getNode()).getAppearance();
            hasProjectiveTex = app == null ? false : app.getTextureUnit(unit) instanceof ProjectiveTextureUnit;
        }
        if (hasProjectiveTex) {
            this.updateProjectiveTexture((Shape3D)atom.getNode(), unit, (CanvasPeerImplBase)renderPeer.getCanvasPeer(), frameId);
        }
        TextureUnitStateUnitPeer.selectServerTextureUnit(gl, unit, statesCache, false);
        this.setTextureAttributes(gl, unit, texture.getType(), texAttribs, renderPeer.getCanvasPeer().getOpenGLInfo(), statesCache);
        statesCache.currentTexAttribs[unit] = texAttribs;
        if (changed) {
            _SG_PrivilegedAccess.setChanged(texAttribs, false);
        }
        TexCoordGeneration texCoordGen = texStateUnit.getTexCoordGeneration();
        changed = texCoordGen.isChanged();
        if (texCoordGen.isEnabled()) {
            ShapeAtomPeer.setMatrix(gl, view, ((Node)atom.getNode()).getWorldTransform(), ((Node)atom.getNode()).isBillboard(), false);
            TextureUnitStateUnitPeer.selectServerTextureUnit(gl, unit, statesCache, false);
            TextureUnitStateUnitPeer.setupTextureCoordsGeneration(gl, texCoordGen);
            int texGenMask = texCoordGen.getFormat().getBitMask();
            if (!statesCache.enabled || statesCache.texGenEnableMask[unit] != texGenMask) {
                TextureUnitStateUnitPeer.applyTexCoordGenStates(gl, unit, texGenMask, statesCache);
            }
        } else if (!statesCache.enabled || statesCache.texGenEnableMask[unit] != 0) {
            TextureUnitStateUnitPeer.selectServerTextureUnit(gl, unit, statesCache, false);
            TextureUnitStateUnitPeer.applyTexCoordGenStates(gl, unit, 0, statesCache);
        }
        statesCache.currentTexCoordGen[unit] = texCoordGen;
        if (changed) {
            _SG_PrivilegedAccess.setChanged(texCoordGen, false);
        }
        ProfileTimer.endProfile();
    }

    static {
        DEFAULT_TEXTURE_BLEND_COLOR.put(0, 0.0f);
        DEFAULT_TEXTURE_BLEND_COLOR.put(1, 0.0f);
        DEFAULT_TEXTURE_BLEND_COLOR.put(2, 0.0f);
        DEFAULT_TEXTURE_BLEND_COLOR.put(3, 1.0f);
        DEFAULT_TEXTURE_BLEND_COLOR.rewind();
    }
}

