/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.jsr231;

import javax.media.opengl.GL;
import org.jagatoo.logging.LogChannel;
import org.jagatoo.logging.ProfileTimer;
import org.openmali.FastMath;
import org.openmali.vecmath2.Point3f;
import org.xith3d.effects.EffectFactory;
import org.xith3d.effects.shadows.VolumeShadowFactory;
import org.xith3d.effects.shadows.occluder.Occluder;
import org.xith3d.render.OpenGLCapabilities;
import org.xith3d.render.OpenGLStatesCache;
import org.xith3d.render.jsr231.RenderPeerImpl;
import org.xith3d.render.jsr231.ShadowRenderPeer;
import org.xith3d.render.jsr231.ShapeAtomPeer;
import org.xith3d.render.preprocessing.RenderBin;
import org.xith3d.scenegraph.Light;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.View;
import org.xith3d.utility.logging.X3DLog;

public class VolumeShadowRenderPeer
implements ShadowRenderPeer.ShadowRenderPeerInterface {
    private float[] openGLProjMatrix = new float[16];
    private float[] viewTrans = new float[16];

    public final int initShadows(GL gl, View view, Light light, RenderBin shadowBin, RenderPeerImpl renderPeer, long frameId) {
        return 0;
    }

    private final int drawObjectShadow(GL gl, OpenGLStatesCache statesCache, OpenGLCapabilities glCaps, Occluder object) {
        boolean statesCacheDisabled = !statesCache.enabled;
        gl.glPushMatrix();
        gl.glLoadMatrixf(this.viewTrans, 0);
        object.getWorldTransform().getColumnMajor(this.openGLProjMatrix);
        gl.glMultMatrixf(this.openGLProjMatrix, 0);
        if (statesCacheDisabled || statesCache.colorsArrayEnabled) {
            gl.glDisableClientState(32886);
            statesCache.colorsArrayEnabled = false;
        }
        if (statesCacheDisabled || statesCache.normalsArrayEnabled) {
            gl.glDisableClientState(32885);
            statesCache.normalsArrayEnabled = false;
        }
        for (int i = 0; i < glCaps.getMaxTextureUnits(); ++i) {
            int tuMaskValue = FastMath.pow((int)2, (int)i);
            if (!statesCacheDisabled && (statesCache.texCoordArraysEnableMask & tuMaskValue) == 0) continue;
            ShapeAtomPeer.selectClientTextureUnit(gl, i, statesCache, false);
            gl.glDisableClientState(32888);
            statesCache.texCoordArraysEnableMask &= ~tuMaskValue;
        }
        if (statesCacheDisabled || !statesCache.coordsArrayEnabled) {
            gl.glEnableClientState(32884);
            statesCache.coordsArrayEnabled = true;
        }
        gl.glVertexPointer(3, 5126, 0, object.getBuffer().getCoordinatesData().getBuffer().rewind());
        gl.glDrawArrays(4, 0, object.getBuffer().getValidVertexCount());
        gl.glPopMatrix();
        return object.getBuffer().getValidVertexCount() / 3;
    }

    public final int drawShadows(GL gl, View view, Light light, RenderBin shadowBin, RenderPeerImpl renderPeer, long frameId) {
        Occluder occluder;
        Node node;
        int i;
        OpenGLStatesCache statesCache = renderPeer.getStatesCache();
        OpenGLCapabilities glCaps = renderPeer.getCanvasPeer().getOpenGLCapabilities();
        VolumeShadowFactory shadowFactory = (VolumeShadowFactory)EffectFactory.getInstance().getShadowFactory();
        Point3f lightSourcePos = shadowFactory.getLightSourcePosition();
        int numTriangles = 0;
        ProfileTimer.startProfile((LogChannel)X3DLog.LOG_CHANNEL, (String)"ShadowShaderPeer::drawShadows");
        RenderBin bin = shadowBin;
        for (i = 0; i < bin.size(); ++i) {
            node = bin.getAtom(i).getNode();
            occluder = (Occluder)node.getShadowAttachment();
            occluder.determineVisibleEdges(lightSourcePos);
        }
        gl.glDisable(2896);
        statesCache.lightingEnabled = true;
        gl.glEnable(2884);
        statesCache.cullFaceEnabled = true;
        gl.glCullFace(1029);
        gl.glDepthMask(false);
        gl.glDepthFunc(515);
        gl.glEnable(2960);
        statesCache.stencilTestEnabled = true;
        gl.glColorMask(false, false, false, false);
        gl.glStencilFunc(519, 1, -1);
        gl.glFrontFace(2305);
        gl.glStencilOp(7680, 7680, 7682);
        for (i = 0; i < bin.size(); ++i) {
            node = bin.getAtom(i).getNode();
            occluder = (Occluder)node.getShadowAttachment();
            numTriangles += this.drawObjectShadow(gl, statesCache, glCaps, occluder);
        }
        gl.glFrontFace(2304);
        gl.glStencilOp(7680, 7680, 7683);
        gl.glColor3f(0.0f, 0.0f, 0.0f);
        for (i = 0; i < bin.size(); ++i) {
            node = bin.getAtom(i).getNode();
            occluder = (Occluder)node.getShadowAttachment();
            this.drawObjectShadow(gl, statesCache, glCaps, occluder);
        }
        gl.glFrontFace(2305);
        gl.glColorMask((statesCache.colorWriteMask & 1) != 0, (statesCache.colorWriteMask & 2) != 0, (statesCache.colorWriteMask & 4) != 0, (statesCache.colorWriteMask & 8) != 0);
        gl.glColor4f(0.0f, 0.0f, 0.0f, 0.2f);
        gl.glEnable(3042);
        statesCache.blendingEnabled = true;
        gl.glBlendFunc(770, 771);
        gl.glStencilFunc(517, 0, -1);
        gl.glStencilOp(7680, 7680, 7680);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glBegin(5);
        gl.glVertex3f(-1.0f, 1.0f, -0.2f);
        gl.glVertex3f(-1.0f, -1.0f, -0.2f);
        gl.glVertex3f(1.0f, 1.0f, -0.2f);
        gl.glVertex3f(1.0f, -1.0f, -0.2f);
        gl.glEnd();
        gl.glPopMatrix();
        gl.glDisable(3042);
        statesCache.blendingEnabled = false;
        gl.glDepthFunc(515);
        gl.glDepthMask(true);
        gl.glEnable(2896);
        statesCache.lightingEnabled = true;
        gl.glDisable(2960);
        statesCache.stencilTestEnabled = false;
        gl.glShadeModel(7425);
        ProfileTimer.endProfile();
        return numTriangles;
    }
}

