/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.lwjgl;

import java.nio.IntBuffer;
import java.util.List;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.openmali.types.twodee.Rect2i;
import org.xith3d.picking.PickRequest;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.OpenGLCapabilities;
import org.xith3d.render.OpenGLInfo;
import org.xith3d.render.OpenGLStatesCache;
import org.xith3d.render.OpenGlExtensions;
import org.xith3d.render.RenderPass;
import org.xith3d.render.SceneGraphOpenGLReference;
import org.xith3d.render.StateUnitPeerRegistry;
import org.xith3d.render.config.DisplayMode;
import org.xith3d.render.config.FSAA;
import org.xith3d.render.lwjgl.OpenGLStatesCacheImpl;
import org.xith3d.render.lwjgl.RenderPeerImpl;
import org.xith3d.render.lwjgl.StateUnitPeerRegistryImpl;
import org.xith3d.render.lwjgl.TextureUnitStateUnitPeer;
import org.xith3d.scenegraph.View;
import org.xith3d.utility.logging.X3DLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CanvasPeerImplBase
extends CanvasPeer {
    protected static Boolean DEBUG_GL = null;
    private Rect2i currentViewport = null;
    private boolean isDefaultViewport = true;
    private Rect2i maxViewport = new Rect2i(-1, -1, -1, -1);
    protected Thread renderingThread = null;
    protected boolean vsyncSwitched = false;
    private long renderedFrames = 0L;
    private boolean isInitialized = false;

    @Override
    protected RenderPeerImpl createRenderPeer() {
        return new RenderPeerImpl(this, (StateUnitPeerRegistry)new StateUnitPeerRegistryImpl(), (OpenGLStatesCache)new OpenGLStatesCacheImpl());
    }

    public CanvasPeerImplBase(org.xith3d.render.config.DisplayMode displayMode, DisplayMode.FullscreenMode fullscreen, boolean vsync, FSAA fsaa, int depthBufferSize) {
        super(displayMode, fullscreen, vsync, fsaa, depthBufferSize);
    }

    protected void init() throws Throwable {
        int maxVAs;
        this.oglInfo = new OpenGLInfo(GL11.glGetString((int)7937), GL11.glGetString((int)7938), GL11.glGetString((int)7936), GL11.glGetString((int)7939));
        OpenGlExtensions.setExtensions(this.oglInfo);
        IntBuffer intBuffer = BufferUtils.createIntBuffer((int)16);
        GL11.glGetInteger((int)3379, (IntBuffer)intBuffer);
        int maxTexSize = intBuffer.get(0);
        intBuffer.clear();
        GL11.glGetInteger((int)34018, (IntBuffer)intBuffer);
        int maxTUs = intBuffer.get(0);
        if (this.oglInfo.getVersionMajor() >= 2) {
            intBuffer.clear();
            GL11.glGetInteger((int)34921, (IntBuffer)intBuffer);
            maxVAs = intBuffer.get(0);
        } else {
            maxVAs = 0;
        }
        intBuffer.clear();
        GL11.glGetInteger((int)3386, (IntBuffer)intBuffer);
        this.maxViewport.set(0, 0, intBuffer.get(0), intBuffer.get(1));
        this.setOpenGLCapabilities(new OpenGLCapabilities(maxTexSize, maxTUs, TextureUnitStateUnitPeer.getMaxAnisotropicLevel(), maxVAs, this.oglInfo));
        this.getRenderPeer().getStatesCache().update(null, this.getOpenGLCapabilities());
        IntBuffer ib = BufferUtils.createIntBuffer((int)16);
        GL11.glGetInteger((int)3414, (IntBuffer)ib);
        this.setDepthBufferSize(ib.get(0));
        boolean showInfos = true;
        try {
            showInfos = System.getProperty("org.xith3d.render.lwjgl.displayGLInfos", "true").equals("true");
        }
        catch (SecurityException ignore) {
            // empty catch block
        }
        if (showInfos) {
            System.out.println("Init GL is " + GL11.class.getName());
            this.oglInfo.dump();
        }
        this.isInitialized = true;
    }

    protected final boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public final RenderPeerImpl getRenderPeer() {
        return (RenderPeerImpl)super.getRenderPeer();
    }

    @Override
    public long getRenderedFrames() {
        return this.renderedFrames;
    }

    @Override
    protected Class<?> getExpectedNativeDisplayModeClass() {
        return DisplayMode.class;
    }

    public final DisplayMode getNativeDisplayMode() {
        if (this.getDisplayMode() == null) {
            return null;
        }
        return (DisplayMode)this.getDisplayMode().getNativeMode();
    }

    protected abstract void applyVSync();

    protected abstract Thread makeCurrent();

    @Override
    public final void addDestroyableObject(SceneGraphOpenGLReference ref) {
        super.addDestroyableObject(ref);
    }

    protected void beforeRenderStart() {
        if (this.renderingThread == null) {
            this.renderingThread = this.makeCurrent();
        }
        if (this.vsyncSwitched) {
            this.applyVSync();
            this.vsyncSwitched = false;
        }
        this.setTriangles(0L);
        this.destroyGLNames(true);
    }

    @Override
    public Rect2i getMaxViewport() {
        return this.maxViewport;
    }

    public Rect2i getCurrentViewport() {
        return this.currentViewport;
    }

    public void updateViewport(Rect2i viewport) {
        boolean viewportChanged = false;
        if (this.currentViewport == null) {
            if (viewport == null) {
                if (this.getViewport() == null) {
                    this.currentViewport = new Rect2i(0, 0, this.getWidth(), this.getHeight());
                } else {
                    this.currentViewport = new Rect2i(this.getViewport());
                    this.getViewport().setClean();
                }
                this.isDefaultViewport = true;
            } else {
                this.currentViewport = new Rect2i(viewport);
                this.isDefaultViewport = false;
            }
            viewportChanged = true;
        } else if (viewport != null) {
            if (this.getViewport() != null && this.getViewport().isDirty()) {
                this.currentViewport.set(this.getViewport());
                this.getViewport().setClean();
            }
            if (!this.currentViewport.equals(viewport)) {
                this.currentViewport.set(viewport);
                this.isDefaultViewport = false;
                viewportChanged = true;
            }
        } else if (!this.isDefaultViewport) {
            if (this.getViewport() == null) {
                this.currentViewport.set(0, 0, this.getWidth(), this.getHeight());
            } else {
                this.currentViewport.set(this.getViewport());
                this.getViewport().setClean();
            }
            this.isDefaultViewport = true;
            viewportChanged = true;
        } else if (this.isDefaultViewport && !this.currentViewport.equals((Object)(this.getViewport() == null ? this : this.getViewport()))) {
            if (this.getViewport() == null) {
                this.currentViewport.set(0, 0, this.getWidth(), this.getHeight());
            } else {
                this.currentViewport.set(this.getViewport());
                this.getViewport().setClean();
            }
            viewportChanged = true;
        }
        if (viewportChanged) {
            int y = this.getHeight() - this.currentViewport.getTop() - this.currentViewport.getHeight();
            GL11.glViewport((int)this.currentViewport.getLeft(), (int)y, (int)this.currentViewport.getWidth(), (int)this.currentViewport.getHeight());
        }
    }

    @Override
    public void clear() {
        this.getRenderPeer().clearViewport();
    }

    protected final Object doRender(View view, List<RenderPass> renderPasses, boolean layeredMode, long frameId, long nanoTime, long nanoStep, PickRequest pickRequest) {
        Object result = this.getRenderPeer().render(null, view, renderPasses, layeredMode, frameId, nanoTime, nanoStep, pickRequest);
        ++this.renderedFrames;
        return result;
    }

    @Override
    public void destroy() {
        super.destroy();
        try {
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            if (Mouse.isCreated()) {
                Mouse.destroy();
            }
            if (Keyboard.isCreated()) {
                Keyboard.destroy();
            }
        }
        catch (Throwable t) {
            X3DLog.print(t);
        }
    }
}

