/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.lwjgl;

import org.jagatoo.logging.LogChannel;
import org.jagatoo.logging.ProfileTimer;
import org.jagatoo.opengl.enums.LinePattern;
import org.lwjgl.opengl.GL11;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.OpenGLCapabilities;
import org.xith3d.render.OpenGLStatesCache;
import org.xith3d.render.RenderOptions;
import org.xith3d.render.RenderPeer;
import org.xith3d.render.preprocessing.RenderAtom;
import org.xith3d.render.states.StateUnit;
import org.xith3d.render.states.units.LineAttribsStateUnit;
import org.xith3d.render.states.units.StateUnitPeer;
import org.xith3d.scenegraph.LineAttributes;
import org.xith3d.scenegraph.View;
import org.xith3d.utility.logging.X3DLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineAttribsStateUnitPeer
implements StateUnitPeer {
    private static final int PATTERN_SOLID_MASK = 65535;
    private static final int PATTERN_DASH_MASK = 255;
    private static final int PATTERN_DOT_MASK = 257;
    private static final int PATTERN_DASH_DOT_MASK = 2175;

    @Override
    public void apply(RenderAtom<?> atom, StateUnit stateUnit, Object glObj, CanvasPeer canvasPeer, RenderPeer renderPeer, OpenGLCapabilities glCaps, View view, OpenGLStatesCache statesCache, RenderOptions options, long nanoTime, long nanoStep, RenderPeer.RenderMode renderMode, long frameId) {
        ProfileTimer.startProfile((LogChannel)X3DLog.LOG_CHANNEL, (String)"LineAttribsStateUnitPeer::apply()");
        LineAttributes la = ((LineAttribsStateUnit)stateUnit).getLineAttributes();
        GL11.glLineWidth((float)la.getLineWidth());
        LinePattern pattern = la.getLinePattern();
        if (pattern == LineAttributes.PATTERN_SOLID) {
            if (!statesCache.enabled || statesCache.lineStippleEnabled) {
                GL11.glDisable((int)2852);
                statesCache.lineStippleEnabled = false;
            }
        } else {
            if (!statesCache.enabled || !statesCache.lineStippleEnabled) {
                GL11.glEnable((int)2852);
                statesCache.lineStippleEnabled = true;
            }
            int mask = la.getPatternMask();
            switch (pattern) {
                case SOLID: {
                    mask = 65535;
                    break;
                }
                case DASHED: {
                    mask = 255;
                    break;
                }
                case DOTTED: {
                    mask = 257;
                    break;
                }
                case DASHED_DOTTED: {
                    mask = 2175;
                }
            }
            GL11.glLineStipple((int)la.getPatternScaleFactor(), (short)((short)mask));
        }
        if (!(!la.isLineAntialiasingEnabled() || statesCache.enabled && statesCache.lineSmoothEnabled)) {
            GL11.glEnable((int)2848);
        } else if (!(la.isLineAntialiasingEnabled() || statesCache.enabled && !statesCache.lineSmoothEnabled)) {
            GL11.glDisable((int)2848);
        }
        statesCache.lineSmoothEnabled = la.isLineAntialiasingEnabled();
        ProfileTimer.endProfile();
    }
}

