/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.lwjgl;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.List;
import org.jagatoo.logging.LogChannel;
import org.jagatoo.logging.ProfileTimer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.openmali.types.twodee.Rect2i;
import org.openmali.types.twodee.Sized2iRO;
import org.xith3d.picking.PickRequest;
import org.xith3d.render.BackgroundRenderPass;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.Clipper;
import org.xith3d.render.ClipperInfo;
import org.xith3d.render.OpenGLCapabilities;
import org.xith3d.render.OpenGLStatesCache;
import org.xith3d.render.OpenGlExtensions;
import org.xith3d.render.RenderOptions;
import org.xith3d.render.RenderPass;
import org.xith3d.render.RenderPassConfig;
import org.xith3d.render.RenderPeer;
import org.xith3d.render.ScissorRect;
import org.xith3d.render.StateUnitPeerRegistry;
import org.xith3d.render.lwjgl.CanvasPeerImplBase;
import org.xith3d.render.lwjgl.RenderTargetPeer;
import org.xith3d.render.lwjgl.ShadowRenderPeer;
import org.xith3d.render.lwjgl.ShapeAtomPeer;
import org.xith3d.render.preprocessing.RenderAtom;
import org.xith3d.render.preprocessing.RenderBin;
import org.xith3d.render.preprocessing.RenderBinProvider;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph._SG_PrivilegedAccess;
import org.xith3d.utility.logging.X3DLog;
import org.xith3d.utility.screenshots.ScreenshotCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RenderPeerImpl
extends RenderPeer {
    private final FloatBuffer gluPickMatrixBuffer = BufferUtils.createFloatBuffer((int)16);
    private final DoubleBuffer planeBuffer = BufferUtils.createDoubleBuffer((int)4);
    private ScissorRect lastScissorBox = null;
    private int lastClipperId = -1;
    private int activeClipperId = -1;
    private RenderOptions effectiveRenderOptions = new RenderOptions();
    private final RenderTargetPeer renderTargetPeer = new RenderTargetPeer(this);
    private final ShadowRenderPeer shadowPeer = new ShadowRenderPeer(this);
    private ScreenshotCreator scheduledShotCreator = null;
    private ScreenshotCreator shotCreator = null;
    private final FloatBuffer defaultLightColorArray = BufferUtils.createFloatBuffer((int)4);

    public RenderPeerImpl(CanvasPeerImplBase canvasPeer, StateUnitPeerRegistry shaderRegistry, OpenGLStatesCache statesCache, RenderOptions renderOptions) {
        super(canvasPeer, shaderRegistry, statesCache, renderOptions);
        this.defaultLightColorArray.put(0.2f).put(0.2f).put(0.2f).put(1.0f).flip();
    }

    public RenderPeerImpl(CanvasPeerImplBase canvasPeer, StateUnitPeerRegistry shaderRegistry, OpenGLStatesCache statesCache) {
        this(canvasPeer, shaderRegistry, statesCache, new RenderOptions());
    }

    protected static void setGCRequested() {
        RenderPeerImpl.setGCRequested(true);
    }

    @Override
    protected void setCanvasPeer(CanvasPeer canvasPeer) {
        super.setCanvasPeer(canvasPeer);
    }

    public CanvasPeerImplBase getCanvasPeerBase() {
        return (CanvasPeerImplBase)this.getCanvasPeer();
    }

    public final void setDefaultLightColor(float r, float g, float b, float a) {
        this.defaultLightColorArray.put(r).put(g).put(b).put(a).flip();
    }

    public final float[] getClearColor() {
        return this.clearColor;
    }

    private final void drawFloor(OpenGLStatesCache statesCache) {
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glDisable((int)2884);
        statesCache.cullFaceEnabled = false;
        GL11.glDisable((int)2896);
        statesCache.lightingEnabled = false;
        GL11.glDisable((int)3553);
        statesCache.texture2DEnabled[statesCache.currentServerTextureUnit] = false;
        GL11.glDisable((int)32879);
        statesCache.texture3DEnabled[statesCache.currentServerTextureUnit] = false;
        GL11.glDisable((int)3042);
        statesCache.blendingEnabled = false;
        GL11.glDepthMask((boolean)false);
        GL11.glColor3f((float)0.2f, (float)0.2f, (float)0.7f);
        GL11.glBegin((int)7);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)-200.0f, (float)0.0f, (float)-200.0f);
        GL11.glVertex3f((float)-200.0f, (float)0.0f, (float)200.0f);
        GL11.glVertex3f((float)200.0f, (float)0.0f, (float)200.0f);
        GL11.glVertex3f((float)200.0f, (float)0.0f, (float)-200.0f);
        GL11.glEnd();
        GL11.glPopMatrix();
        GL11.glDepthMask((boolean)statesCache.depthWriteMask);
    }

    private final void finishScissors(OpenGLStatesCache statesCache) {
        if (!statesCache.enabled || statesCache.scissorTestEnabled) {
            GL11.glDisable((int)3089);
            statesCache.scissorTestEnabled = false;
        }
        this.lastScissorBox = null;
    }

    private final void startScissors(OpenGLStatesCache statesCache, ScissorRect scissorBox) {
        if (scissorBox == null && (this.lastScissorBox != null || GL11.glIsEnabled((int)3089))) {
            this.finishScissors(statesCache);
            return;
        }
        if (scissorBox != null) {
            boolean ok;
            if (!scissorBox.equals(this.lastScissorBox)) {
                scissorBox.clamp((Sized2iRO)this.getCanvasPeerBase().getCurrentViewport());
                ok = scissorBox.check((Sized2iRO)this.getCanvasPeerBase().getCurrentViewport());
                if (ok) {
                    GL11.glScissor((int)scissorBox.getX(), (int)scissorBox.getY(), (int)scissorBox.getWidth(), (int)scissorBox.getHeight());
                }
            } else {
                ok = true;
            }
            if (!(!ok || this.lastScissorBox != null && statesCache.enabled && statesCache.scissorTestEnabled)) {
                GL11.glEnable((int)3089);
                statesCache.scissorTestEnabled = true;
            }
            this.lastScissorBox = scissorBox;
        }
    }

    public static final int translateClipPlaneIndex(int index) {
        switch (index) {
            case 0: {
                return 12288;
            }
            case 1: {
                return 12289;
            }
            case 2: {
                return 12290;
            }
            case 3: {
                return 12291;
            }
            case 4: {
                return 12292;
            }
            case 5: {
                return 12293;
            }
        }
        throw new Error("unknown clip plane " + index);
    }

    private final void finishClipper(OpenGLStatesCache statesCache) {
        for (int i = 0; i < 6; ++i) {
            if (statesCache.enabled && !statesCache.clipPlaneEnabled[i]) continue;
            GL11.glDisable((int)RenderPeerImpl.translateClipPlaneIndex(i));
            statesCache.clipPlaneEnabled[i] = false;
        }
        this.activeClipperId = -1;
    }

    private final void startClipper(OpenGLStatesCache statesCache, ClipperInfo info, View view) {
        Clipper clipper;
        Clipper clipper2 = clipper = info == null ? null : info.getClipper();
        if (clipper != null && clipper.isEnabled()) {
            if (clipper.getId() == this.activeClipperId) {
                return;
            }
            this.activeClipperId = clipper.getId();
            if (this.lastClipperId != clipper.getId()) {
                Transform3D modelView;
                GL11.glPushMatrix();
                GL11.glLoadMatrix((FloatBuffer)_SG_PrivilegedAccess.getFloatBuffer(view.getModelViewTransform(false), false));
                if (!clipper.isWorldCoordinateSystemUsed() && (modelView = info.getModelView()) != null) {
                    GL11.glMultMatrix((FloatBuffer)_SG_PrivilegedAccess.getFloatBuffer(modelView, true));
                }
            }
            for (int i = 0; i < 6; ++i) {
                int glI = RenderPeerImpl.translateClipPlaneIndex(i);
                if (clipper.isPlaneEnabled(i)) {
                    if (this.lastClipperId != clipper.getId()) {
                        this.planeBuffer.clear();
                        this.planeBuffer.put(clipper.getPlane(i).getA());
                        this.planeBuffer.put(clipper.getPlane(i).getB());
                        this.planeBuffer.put(clipper.getPlane(i).getC());
                        this.planeBuffer.put(clipper.getPlane(i).getD());
                        this.planeBuffer.rewind();
                        GL11.glClipPlane((int)glI, (DoubleBuffer)this.planeBuffer);
                    }
                    if (statesCache.enabled && statesCache.clipPlaneEnabled[i]) continue;
                    GL11.glEnable((int)glI);
                    statesCache.clipPlaneEnabled[i] = true;
                    continue;
                }
                if (statesCache.enabled && !statesCache.clipPlaneEnabled[i]) continue;
                GL11.glDisable((int)glI);
                statesCache.clipPlaneEnabled[i] = false;
            }
            if (this.lastClipperId != clipper.getId()) {
                GL11.glPopMatrix();
                this.lastClipperId = clipper.getId();
            }
        } else {
            this.finishClipper(statesCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int drawBin(OpenGLStatesCache statesCache, OpenGLCapabilities glCaps, RenderOptions options, boolean isScissorEnabled, boolean isClipperEnabled, RenderBin bin, View view, long frameId, int nameOffset, long nanoTime, long nanoStep, RenderPeer.RenderMode renderMode) {
        CanvasPeer canvasPeer = this.getCanvasPeer();
        int triangles = 0;
        int n = bin.size();
        for (int i = 0; i < n; ++i) {
            RenderAtom<? extends Node> atom = bin.getAtom(i);
            try {
                if (renderMode == RenderPeer.RenderMode.PICKING) {
                    GL11.glPushName((int)(nameOffset + i));
                }
                if (isScissorEnabled) {
                    this.startScissors(statesCache, atom.getScissorRect());
                }
                if (isClipperEnabled) {
                    this.startClipper(statesCache, atom.getClipper(), view);
                }
                triangles += this.renderAtom(atom, null, canvasPeer, glCaps, statesCache, view, options, nanoTime, nanoStep, renderMode, frameId);
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
                System.exit(0);
                continue;
            }
            finally {
                if (renderMode == RenderPeer.RenderMode.PICKING) {
                    GL11.glPopName();
                }
            }
        }
        if (isClipperEnabled) {
            this.finishClipper(statesCache);
        }
        return triangles;
    }

    private final void setColorMask(int colorMask, OpenGLStatesCache statesCache) {
        if (statesCache.enabled && colorMask == statesCache.colorWriteMask) {
            return;
        }
        GL11.glColorMask(((colorMask & 1) != 0 ? 1 : 0) != 0, ((colorMask & 2) != 0 ? 1 : 0) != 0, ((colorMask & 4) != 0 ? 1 : 0) != 0, ((colorMask & 8) != 0 ? 1 : 0) != 0);
        statesCache.colorWriteMask = colorMask;
    }

    private final void renderStart(OpenGLStatesCache statesCache, int atomsCount, PickRequest pickRequest) {
        super.renderStart(pickRequest);
        this.getCanvasPeerBase().beforeRenderStart();
        if (pickRequest == null) {
            this.selectBuffer = null;
            GL11.glRenderMode((int)7168);
            GL11.glClearDepth((double)1.0);
            if (this.shotCreator != null && this.shotCreator.getFormat() == ScreenshotCreator.Format.RGBA) {
                GL11.glClearColor((float)this.clearColor[0], (float)this.clearColor[1], (float)this.clearColor[2], (float)1.0f);
            } else {
                GL11.glClearColor((float)this.clearColor[0], (float)this.clearColor[1], (float)this.clearColor[2], (float)this.clearColor[3]);
            }
            this.lastScissorBox = null;
            if (!statesCache.enabled || statesCache.scissorTestEnabled) {
                GL11.glDisable((int)3089);
                statesCache.scissorTestEnabled = false;
            }
            if (!this.disableClearBuffer) {
                if (this.fullOverpaint) {
                    GL11.glClear((int)1280);
                } else {
                    GL11.glClear((int)17664);
                }
            }
        } else {
            GL11.glRenderMode((int)7168);
            GL11.glClearDepth((double)1.0);
            GL11.glClear((int)1280);
            this.selectBuffer = BufferUtils.createIntBuffer((int)(atomsCount * 4));
            GL11.glSelectBuffer((IntBuffer)this.selectBuffer);
            GL11.glRenderMode((int)7170);
            GL11.glInitNames();
        }
        GL11.glDepthFunc((int)513);
        GL11.glHint((int)3152, (int)4354);
        GL11.glHint((int)3154, (int)4354);
        GL11.glHint((int)3155, (int)4354);
        GL11.glShadeModel((int)7425);
        GL11.glLightModel((int)2899, (FloatBuffer)this.defaultLightColorArray);
        if (OpenGlExtensions.GL_EXT_separate_specular_color) {
            GL11.glLightModeli((int)33272, (int)33274);
        }
        GL11.glPixelStorei((int)3317, (int)1);
    }

    private final void gluPickMatrix(float x, float y, float width, float height, int[] viewport) {
        float sx = (float)viewport[2] / width;
        float sy = (float)viewport[3] / height;
        float tx = ((float)viewport[2] + 2.0f * ((float)viewport[0] - x)) / width;
        float ty = ((float)viewport[3] + 2.0f * ((float)viewport[1] - y)) / height;
        this.gluPickMatrixBuffer.clear();
        this.gluPickMatrixBuffer.put(sx).put(0.0f).put(0.0f).put(0.0f);
        this.gluPickMatrixBuffer.put(0.0f).put(sy).put(0.0f).put(0.0f);
        this.gluPickMatrixBuffer.put(0.0f).put(0.0f).put(1.0f).put(0.0f);
        this.gluPickMatrixBuffer.put(tx).put(ty).put(0.0f).put(1.0f);
        this.gluPickMatrixBuffer.flip();
        GL11.glMultMatrix((FloatBuffer)this.gluPickMatrixBuffer);
    }

    private final void renderStartView(View view, PickRequest pickRequest) {
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        if (pickRequest != null) {
            Rect2i currentViewport = this.getCanvasPeerBase().getCurrentViewport();
            int y = this.getCanvasPeer().getHeight() - currentViewport.getTop() - currentViewport.getHeight();
            int[] viewport = new int[]{currentViewport.getLeft(), y, currentViewport.getWidth(), currentViewport.getHeight()};
            this.gluPickMatrix(pickRequest.getMouseX(), viewport[3] - pickRequest.getMouseY(), 1.0f, 1.0f, viewport);
        }
        GL11.glMultMatrix((FloatBuffer)_SG_PrivilegedAccess.getFloatBuffer(view.getProjection(), true));
        GL11.glMatrixMode((int)5888);
    }

    private final void setGLModelViewMatrix(View view, View.CameraMode mode) {
        GL11.glLoadMatrix((FloatBuffer)_SG_PrivilegedAccess.getFloatBuffer(view.getModelViewTransform(mode, true), true));
    }

    private final int renderMain(OpenGLCapabilities glCaps, OpenGLStatesCache statesCache, RenderOptions options, boolean isScissorEnabled, boolean isClipperEnabled, View view, RenderPass renderPass, long frameId, int nameOffset, long nanoTime, long nanoStep, RenderPeer.RenderMode renderMode) throws Throwable {
        X3DLog.debug("Rendering ", 2, " bins");
        int triangles = 0;
        ProfileTimer.startProfile((LogChannel)X3DLog.LOG_CHANNEL, (String)"CanvasPeerImpl::Drawing Main Scene");
        RenderBinProvider binProvider = renderPass.getRenderBinProvider();
        if (binProvider.getOpaqueBin().size() > 0) {
            if (!statesCache.enabled || !statesCache.depthTestEnabled) {
                GL11.glEnable((int)2929);
                statesCache.depthTestEnabled = true;
            }
            triangles += this.drawBin(statesCache, glCaps, options, isScissorEnabled, isClipperEnabled, binProvider.getOpaqueBin(), view, frameId, nameOffset, nanoTime, nanoStep, renderMode);
            nameOffset += binProvider.getOpaqueBin().size();
        }
        if (binProvider.getTransparentBin().size() > 0) {
            triangles += this.drawBin(statesCache, glCaps, options, isScissorEnabled, isClipperEnabled, binProvider.getTransparentBin(), view, frameId, nameOffset, nanoTime, nanoStep, renderMode);
            nameOffset += binProvider.getTransparentBin().size();
        }
        ProfileTimer.endProfile();
        if (!statesCache.enabled || !statesCache.depthTestEnabled) {
            GL11.glEnable((int)2929);
            statesCache.depthTestEnabled = true;
        }
        if (renderMode != RenderPeer.RenderMode.PICKING && (this.shotCreator == null || this.shotCreator.getFormat() == ScreenshotCreator.Format.RGB)) {
            triangles += this.shadowPeer.drawShadows(view, renderPass.getShadowCasterLight(), binProvider.getShadowsBin(), frameId);
        }
        this.getCanvasPeer().addTriangles(triangles);
        return nameOffset;
    }

    private Object renderDone(List<RenderPass> renderPasses, PickRequest pickRequest, OpenGLStatesCache statesCache, long frameId) {
        if (!statesCache.enabled || !statesCache.depthWriteMask) {
            GL11.glDepthMask((boolean)true);
            statesCache.depthWriteMask = true;
        }
        if (!statesCache.enabled || statesCache.colorWriteMask != 15) {
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            statesCache.colorWriteMask = 15;
        }
        super.renderDone(frameId);
        if (pickRequest != null) {
            GL11.glFlush();
            return this.convertSelectBuffer(GL11.glRenderMode((int)7168), renderPasses, pickRequest.getPickAll());
        }
        return null;
    }

    public final int renderRenderPass(Object glObj, OpenGLCapabilities glCaps, OpenGLStatesCache statesCache, List<RenderPass> renderPasses, RenderPass renderPass, int rpIndex, boolean isRenderTargetMode, RenderPeer.RenderMode renderMode, View view, boolean layeredMode, long frameId, long nanoTime, long nanoStep, PickRequest pickRequest, int nameOffset) throws Throwable {
        RenderPassConfig passConfig = renderPass.getConfig();
        if (pickRequest == null) {
            renderPass.getRenderCallbackNotifier().notifyBeforeRenderPassIsRendered(renderPass, this.getCanvasPeer().getType(), glObj);
        }
        if (passConfig.getColorMask() == -1) {
            this.setColorMask(this.colorMask, statesCache);
        } else {
            this.setColorMask(passConfig.getColorMask(), statesCache);
        }
        _SG_PrivilegedAccess.set(view, true, passConfig);
        this.setGLModelViewMatrix(view, passConfig.getCameraMode());
        if (renderPass.isEnabled()) {
            if (passConfig != null) {
                if (passConfig.getRenderOptions() != null) {
                    this.effectiveRenderOptions.loadOptions(passConfig.getRenderOptions());
                } else {
                    this.effectiveRenderOptions.loadOptions(this.getRenderOptions());
                }
                if (isRenderTargetMode && renderMode != RenderPeer.RenderMode.SHADOW_MAP_GENERATION) {
                    this.getCanvasPeerBase().updateViewport(passConfig.getViewport());
                }
            } else {
                this.effectiveRenderOptions.loadOptions(this.getRenderOptions());
                if (isRenderTargetMode && renderMode != RenderPeer.RenderMode.SHADOW_MAP_GENERATION) {
                    this.getCanvasPeerBase().updateViewport(null);
                }
            }
            statesCache.enabled = this.effectiveRenderOptions.isGLStatesCacheEnabled();
            view.getFrustum((Sized2iRO)(this.getCanvasPeerBase().getCurrentViewport() == null ? this.getCanvasPeer().getCanvas3D() : this.getCanvasPeerBase().getCurrentViewport()));
            if (isRenderTargetMode && renderPass.getRenderTarget() != null) {
                renderPass.getRenderCallbackNotifier().notifyBeforeRenderTargetIsActivated(renderPass, renderPass.getRenderTarget(), this.getCanvasPeer().getType(), glObj);
                this.renderTargetPeer.setupRenderTarget(glCaps, statesCache, this.getCanvasPeer(), renderPass.getRenderTarget());
                renderPass.getRenderCallbackNotifier().notifyAfterRenderTargetIsActivated(renderPass, renderPass.getRenderTarget(), this.getCanvasPeer().getType(), glObj);
            }
            this.renderStartView(view, pickRequest);
            if (isRenderTargetMode && renderPass.getRenderTarget() != null && renderPass.getRenderTarget().isBackgroundRenderingEnabled()) {
                for (int i = 0; i < renderPasses.size(); ++i) {
                    RenderPass bgPass = renderPasses.get(i);
                    if (!(bgPass instanceof BackgroundRenderPass)) continue;
                    nameOffset += this.renderRenderPass(glObj, glCaps, statesCache, renderPasses, bgPass, i, false, renderMode, view, layeredMode, frameId, nanoTime, nanoStep, pickRequest, nameOffset);
                }
                GL11.glClear((int)256);
                this.setGLModelViewMatrix(view, passConfig.getCameraMode());
                view.getFrustum((Sized2iRO)this.getCanvasPeerBase().getCurrentViewport());
                this.renderStartView(view, pickRequest);
            }
            if ((layeredMode && !renderPass.isUnlayeredModeForced() || !layeredMode && renderPass.isLayeredModeForced()) && rpIndex > 0) {
                GL11.glClear((int)256);
            }
            if (pickRequest == null) {
                renderPass.getRenderCallbackNotifier().notifyAfterRenderPassIsSetUp(renderPass, this.getCanvasPeer().getType(), glObj);
            }
            nameOffset += this.renderMain(glCaps, statesCache, this.effectiveRenderOptions, renderPass.isScissorEnabled(), renderPass.isClipperEnabled(), view, renderPass, frameId, nameOffset, nanoTime, nanoStep, renderMode);
            if (isRenderTargetMode && renderPass.getRenderTarget() != null) {
                renderPass.getRenderCallbackNotifier().notifyBeforeRenderTargetIsDeactivated(renderPass, renderPass.getRenderTarget(), this.getCanvasPeer().getType(), glObj);
                this.renderTargetPeer.finishRenderTarget(renderPass.getRenderTarget());
                renderPass.getRenderCallbackNotifier().notifyAfterRenderTargetIsDeactivated(renderPass, renderPass.getRenderTarget(), this.getCanvasPeer().getType(), glObj);
            }
        } else if (pickRequest != null) {
            nameOffset += renderPass.getRenderBinProvider().getAtomsCount();
        }
        if (renderMode == RenderPeer.RenderMode.SHADOW_MAP_GENERATION || passConfig != null && passConfig.getRenderOptions() != null || rpIndex + 1 < renderPasses.size() && renderPasses.get(rpIndex + 1).getConfig() != null && renderPasses.get(rpIndex + 1).getConfig().getRenderOptions() != null) {
            super.renderDone(frameId);
            super.resetStateUnitStateArrays();
        }
        _SG_PrivilegedAccess.set(view, false, null);
        if (pickRequest == null) {
            renderPass.getRenderCallbackNotifier().notifyAfterRenderPassCompleted(renderPass, this.getCanvasPeer().getType(), glObj);
        }
        return nameOffset;
    }

    @Override
    public final Object render(Object glObj, View view, List<RenderPass> renderPasses, boolean layeredMode, long frameId, long nanoTime, long nanoStep, PickRequest pickRequest) {
        if (view == null) {
            return null;
        }
        this.lastClipperId = -1;
        this.shotCreator = this.scheduledShotCreator;
        this.scheduledShotCreator = null;
        OpenGLCapabilities glCaps = this.getCanvasPeer().getOpenGLCapabilities();
        OpenGLStatesCache statesCache = this.getStatesCache();
        statesCache.enabled = this.getRenderOptions().isGLStatesCacheEnabled();
        Object result = null;
        ShapeAtomPeer.reset();
        X3DLog.debug("Starting to render the frame");
        try {
            if (renderPasses != null && renderPasses.size() > 0) {
                RenderBinProvider firstBinProvider = renderPasses.get(0).getRenderBinProvider();
                this.renderStart(statesCache, firstBinProvider.getAtomsCount(), pickRequest);
            } else {
                this.renderStart(statesCache, 0, pickRequest);
            }
            int nameOffset = 0;
            for (int i = 0; i < renderPasses.size(); ++i) {
                RenderPass renderPass = renderPasses.get(i);
                if (!renderPass.isEnabled()) continue;
                if (this.shotCreator == null || this.shotCreator.getFormat() == ScreenshotCreator.Format.RGB) {
                    nameOffset += this.shadowPeer.initShadows(view, renderPass.getShadowCasterLight(), renderPass.getRenderBinProvider().getShadowsBin(), frameId);
                }
                nameOffset += this.renderRenderPass(glObj, glCaps, statesCache, renderPasses, renderPass, i, true, pickRequest == null ? RenderPeer.RenderMode.NORMAL : RenderPeer.RenderMode.PICKING, view, layeredMode, frameId, nanoTime, nanoStep, pickRequest, nameOffset);
            }
            result = this.renderDone(renderPasses, pickRequest, statesCache, frameId);
            if (this.shotCreator != null) {
                GL11.glReadPixels((int)0, (int)0, (int)this.getCanvasPeer().getWidth(), (int)this.getCanvasPeer().getHeight(), (int)this.shotCreator.getFormat().getIntGL(), (int)5121, (ByteBuffer)this.shotCreator.getBuffer());
                this.shotCreator.createScreenshot();
                this.shotCreator = null;
            }
        }
        catch (Throwable terr) {
            X3DLog.print(terr);
            terr.printStackTrace();
            if (terr instanceof RuntimeException) {
                throw (RuntimeException)terr;
            }
            if (terr instanceof Error) {
                throw (Error)terr;
            }
            throw new Error(terr);
        }
        RenderPeerImpl.checkGCRequested();
        X3DLog.debug("Done rendering the frame");
        return result;
    }

    public void clearViewport(float r, float g, float b, float a) {
        GL11.glClearColor((float)r, (float)g, (float)b, (float)a);
        GL11.glClear((int)16384);
        GL11.glClearColor((float)this.clearColor[0], (float)this.clearColor[1], (float)this.clearColor[2], (float)this.clearColor[3]);
    }

    public void clearViewport() {
        this.clearViewport(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public final void takeScreenshot(File file, boolean alpha) {
        ScreenshotCreator.Format format = alpha ? ScreenshotCreator.Format.RGBA : ScreenshotCreator.Format.RGB;
        this.scheduledShotCreator = new ScreenshotCreator(this.getCanvasPeer().getWidth(), this.getCanvasPeer().getHeight(), format, file);
    }
}

