/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.lwjgl;

import java.util.HashMap;
import org.xith3d.effects.EffectFactory;
import org.xith3d.effects.shadows.GLSLShadowMappingFactory;
import org.xith3d.effects.shadows.ShadowFactory;
import org.xith3d.effects.shadows.VolumeShadowFactory;
import org.xith3d.render.lwjgl.RenderPeerImpl;
import org.xith3d.render.lwjgl.ShadowMappingRenderPeer;
import org.xith3d.render.lwjgl.VolumeShadowRenderPeer;
import org.xith3d.render.preprocessing.RenderBin;
import org.xith3d.scenegraph.Light;
import org.xith3d.scenegraph.View;

public class ShadowRenderPeer {
    private RenderPeerImpl renderPeer;
    private final HashMap<ShadowFactory.ShadowFactoryIdentifier, ShadowRenderPeerInterface> peerMap = new HashMap();

    public RenderPeerImpl getRenderPeer() {
        return this.renderPeer;
    }

    private static final ShadowFactory getShadowFactory() {
        EffectFactory effFact = EffectFactory.getInstance();
        if (effFact == null) {
            return null;
        }
        return effFact.getShadowFactory();
    }

    public final int initShadows(View view, Light light, RenderBin shadowBin, long frameId) {
        ShadowFactory shadowFact = ShadowRenderPeer.getShadowFactory();
        if (shadowFact == null || !shadowFact.isEnabled()) {
            return 0;
        }
        ShadowRenderPeerInterface peer = this.peerMap.get(shadowFact.getShadowFactoryId());
        return peer.initShadows(view, light, shadowBin, this.renderPeer, frameId);
    }

    public final int drawShadows(View view, Light light, RenderBin shadowBin, long frameId) {
        ShadowFactory shadowFact = ShadowRenderPeer.getShadowFactory();
        if (shadowFact == null || !shadowFact.isEnabled()) {
            return 0;
        }
        ShadowRenderPeerInterface peer = this.peerMap.get(shadowFact.getShadowFactoryId());
        return peer.drawShadows(view, light, shadowBin, this.renderPeer, frameId);
    }

    public ShadowRenderPeer(RenderPeerImpl renderPeer) {
        this.renderPeer = renderPeer;
        this.peerMap.put(VolumeShadowFactory.SHADOW_FACTORY_ID, new VolumeShadowRenderPeer());
        this.peerMap.put(GLSLShadowMappingFactory.SHADOW_FACTORY_ID, new ShadowMappingRenderPeer());
    }

    public static interface ShadowRenderPeerInterface {
        public int initShadows(View var1, Light var2, RenderBin var3, RenderPeerImpl var4, long var5);

        public int drawShadows(View var1, Light var2, RenderBin var3, RenderPeerImpl var4, long var5);
    }
}

