/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.lwjgl;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import org.jagatoo.logging.LogChannel;
import org.jagatoo.logging.ProfileTimer;
import org.jagatoo.opengl.enums.CompareFunction;
import org.jagatoo.opengl.enums.TextureCompareMode;
import org.jagatoo.opengl.enums.TextureFilter;
import org.jagatoo.opengl.enums.TextureFormat;
import org.jagatoo.opengl.enums.TextureImageInternalFormat;
import org.jagatoo.opengl.enums.TextureMode;
import org.jagatoo.opengl.enums.TextureType;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;
import org.lwjgl.opengl.GL13;
import org.openmali.types.twodee.Rect2i;
import org.openmali.vecmath2.Colorf;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.OpenGLCapabilities;
import org.xith3d.render.OpenGLInfo;
import org.xith3d.render.OpenGLStatesCache;
import org.xith3d.render.OpenGlExtensions;
import org.xith3d.render.RenderOptions;
import org.xith3d.render.RenderPeer;
import org.xith3d.render.SceneGraphOpenGLReference;
import org.xith3d.render.SceneGraphOpenGLReferences;
import org.xith3d.render.lwjgl.CanvasPeerImplBase;
import org.xith3d.render.lwjgl.RenderPeerImpl;
import org.xith3d.render.lwjgl.ShapeAtomPeer;
import org.xith3d.render.preprocessing.RenderAtom;
import org.xith3d.render.states.StateUnit;
import org.xith3d.render.states.units.StateUnitPeer;
import org.xith3d.render.states.units.TextureUnitStateUnit;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.GlobalOptions;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.ProjectiveTextureUnit;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.TexCoordGeneration;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.Texture3D;
import org.xith3d.scenegraph.TextureAttributes;
import org.xith3d.scenegraph.TextureCubeMap;
import org.xith3d.scenegraph.TextureImage;
import org.xith3d.scenegraph.TextureImage2D;
import org.xith3d.scenegraph.TextureImage3D;
import org.xith3d.scenegraph.TextureUnit;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph._SG_PrivilegedAccess;
import org.xith3d.utility.logging.X3DLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextureUnitStateUnitPeer
implements StateUnitPeer {
    private static final IntBuffer tmpIntBuffer = BufferUtils.createIntBuffer((int)1);
    private static SceneGraphOpenGLReferences.Provider textureNameProvider = new SceneGraphOpenGLReferences.Provider(){

        public SceneGraphOpenGLReference newReference(CanvasPeer canvasPeer, SceneGraphOpenGLReferences references, int numNamesPerContext) {
            return new SceneGraphOpenGLReference(canvasPeer, references, numNamesPerContext){

                public void prepareObjectForDestroy() {
                    SceneGraphOpenGLReference ref = this.getReferences().removeReference(this.getContext().getCanvasID());
                    ((CanvasPeerImplBase)this.getContext()).addDestroyableObject(ref);
                }

                public void destroyObject(int index, int name) {
                    tmpIntBuffer.clear();
                    tmpIntBuffer.put(name).flip();
                    GL11.glDeleteTextures((IntBuffer)tmpIntBuffer);
                }
            };
        }
    };
    private static final FloatBuffer tmpBorderColor = BufferUtils.createFloatBuffer((int)4);
    private static final FloatBuffer texBlendColor = BufferUtils.createFloatBuffer((int)4);
    private static final FloatBuffer tmpPlaneBuffer = BufferUtils.createFloatBuffer((int)4);
    private static final ByteBuffer textureDataBuffer = BufferUtils.createByteBuffer((int)0x100000);
    private static final FloatBuffer DEFAULT_TEXTURE_BLEND_COLOR = BufferUtils.createFloatBuffer((int)4);

    public static final int getMaxAnisotropicLevel() {
        if (!OpenGlExtensions.GL_EXT_texture_filter_anisotropic) {
            return 0;
        }
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)16);
        buffer.rewind();
        GL11.glGetFloat((int)34047, (FloatBuffer)buffer);
        return (int)buffer.get(0);
    }

    public static final void selectServerTextureUnit(int unit, OpenGLStatesCache statesCache, boolean force) {
        if (statesCache.enabled && statesCache.currentServerTextureUnit == unit && !force) {
            return;
        }
        X3DLog.debug("Activating (server) texture unit ", unit);
        int glUnit = 33984 + unit;
        GL13.glActiveTexture((int)glUnit);
        statesCache.currentServerTextureUnit = unit;
    }

    public static final int translateInternalFormat(TextureFormat format, TextureImageInternalFormat internalFormat, int depthBuffersize) {
        if (format == TextureFormat.DEPTH) {
            if (depthBuffersize == 16) {
                internalFormat = TextureImageInternalFormat.DEPTH16;
            } else if (depthBuffersize == 24) {
                internalFormat = TextureImageInternalFormat.DEPTH24;
            } else if (depthBuffersize == 32) {
                internalFormat = TextureImageInternalFormat.DEPTH32;
            }
        }
        return internalFormat.toOpenGL();
    }

    private static final int getCubeMapFace(int i) {
        return 34069 + i;
    }

    private static final void applyTextureAttachedAttributes(Texture texture, boolean mipmapping, OpenGLCapabilities glCaps) {
        TextureType texType = texture.getType();
        int glTexType = texType.toOpenGL();
        GL11.glTexParameteri((int)glTexType, (int)10242, (int)texture.getBoundaryModeS().toOpenGL());
        GL11.glTexParameteri((int)glTexType, (int)10243, (int)texture.getBoundaryModeT().toOpenGL());
        if (texType == TextureType.TEXTURE_3D) {
            GL11.glTexParameteri((int)glTexType, (int)32882, (int)((Texture3D)texture).getBoundaryModeR().toOpenGL());
        }
        texture.getBoundaryColor().writeToBuffer(true, tmpBorderColor, true, true);
        GL11.glTexParameter((int)glTexType, (int)4100, (FloatBuffer)tmpBorderColor);
        TextureFilter filter = texture.getFilter();
        if (filter == null) {
            filter = GlobalOptions.getInstance().getTextureFilter();
        }
        GL11.glTexParameteri((int)glTexType, (int)10240, (int)filter.getOpenGLMagFilter());
        GL11.glTexParameteri((int)glTexType, (int)10241, (int)filter.getOpenGLMinFilter(mipmapping));
        if (OpenGlExtensions.GL_EXT_texture_filter_anisotropic) {
            int maxAniso;
            int aniso = filter.getAnisotropicLevel();
            if (aniso > (maxAniso = glCaps.getMaxAnisotropicLevel())) {
                aniso = maxAniso;
            }
            GL11.glTexParameteri((int)glTexType, (int)34046, (int)aniso);
        }
    }

    private static final int defineTexture(int unit, Texture texture, CanvasPeer canvasPeer, int depthBufferSize, OpenGLStatesCache statesCache) {
        int numMipmaps = texture.getImagesCount();
        if (numMipmaps == 0) {
            X3DLog.debug("Found texture without images. Skipping!");
            return -1;
        }
        SceneGraphOpenGLReference openGLRef = texture.getOpenGLReferences().getReference(canvasPeer, textureNameProvider);
        int textureId = openGLRef.getName();
        if (textureId == -1) {
            tmpIntBuffer.clear();
            GL11.glGenTextures((IntBuffer)tmpIntBuffer);
            textureId = tmpIntBuffer.get(0);
            openGLRef.setName(textureId);
        }
        int glTexType = texture.getType().toOpenGL();
        GL11.glBindTexture((int)glTexType, (int)textureId);
        statesCache.currentBoundTexture[unit] = texture;
        switch (glTexType) {
            case 3553: {
                TextureImage2D image = null;
                int format = 0;
                int internalFormat = 0;
                int border = texture.getBoundaryWidth();
                for (int level = 0; level < numMipmaps; ++level) {
                    ByteBuffer buff;
                    image = (TextureImage2D)texture.getImage(level);
                    if (!image.hasData()) continue;
                    format = image.getFormat().toOpenGL();
                    internalFormat = TextureUnitStateUnitPeer.translateInternalFormat(texture.getFormat(), image.getInternalFormat(), depthBufferSize);
                    if (image.getDataBuffer() != null) {
                        buff = image.getDataBuffer();
                    } else if (image.getDataSize() > textureDataBuffer.capacity()) {
                        buff = BufferUtils.createByteBuffer((int)image.getDataSize());
                        image.getData(buff);
                    } else {
                        buff = textureDataBuffer;
                        image.getData(buff);
                    }
                    if (image.isCompressed()) {
                        GL13.glCompressedTexImage2D((int)glTexType, (int)level, (int)internalFormat, (int)image.getWidth(), (int)image.getHeight(), (int)border, (ByteBuffer)buff);
                    } else {
                        GL11.glTexImage2D((int)glTexType, (int)level, (int)internalFormat, (int)image.getWidth(), (int)image.getHeight(), (int)border, (int)format, (int)5121, (ByteBuffer)buff);
                    }
                    if (!texture.isMarkedAsLocalDataToBeFreed()) continue;
                    image.freeLocalData();
                    RenderPeerImpl.setGCRequested();
                }
                break;
            }
            case 32879: {
                TextureImage3D image = null;
                int format = 0;
                int internalFormat = 0;
                int border = texture.getBoundaryWidth();
                int depth = 0;
                for (int level = 0; level < numMipmaps; ++level) {
                    image = (TextureImage3D)texture.getImage(level);
                    internalFormat = TextureUnitStateUnitPeer.translateInternalFormat(texture.getFormat(), image.getInternalFormat(), depthBufferSize);
                    depth = image.getDepth();
                    ByteBuffer buff = image.getDataBuffer();
                    if (image.isCompressed()) {
                        GL13.glCompressedTexImage3D((int)glTexType, (int)level, (int)internalFormat, (int)(image.getWidth() + 2 * border), (int)(image.getHeight() + 2 * border), (int)depth, (int)border, (ByteBuffer)buff);
                        continue;
                    }
                    format = image.getFormat().toOpenGL();
                    GL12.glTexImage3D((int)glTexType, (int)level, (int)internalFormat, (int)(image.getWidth() + 2 * border), (int)(image.getHeight() + 2 * border), (int)depth, (int)border, (int)format, (int)5121, (ByteBuffer)buff);
                }
                break;
            }
            case 34067: {
                for (int i = 0; i < 6; ++i) {
                    int face = 0;
                    boolean border = false;
                    for (int level = 0; level < numMipmaps; ++level) {
                        ByteBuffer buff;
                        TextureImage image = ((TextureCubeMap)texture).getImage(level, i);
                        int format = image.getFormat().toOpenGL();
                        int internalFormat = TextureUnitStateUnitPeer.translateInternalFormat(texture.getFormat(), image.getInternalFormat(), depthBufferSize);
                        face = TextureUnitStateUnitPeer.getCubeMapFace(i);
                        if (image instanceof TextureImage2D) {
                            TextureImage2D image2D = (TextureImage2D)image;
                            if (image2D.getDataBuffer() != null) {
                                buff = image2D.getDataBuffer();
                            } else if (image2D.getDataSize() > textureDataBuffer.capacity()) {
                                buff = BufferUtils.createByteBuffer((int)image2D.getDataSize());
                                image2D.getData(buff);
                            } else {
                                buff = textureDataBuffer;
                                image2D.getData(buff);
                            }
                        } else if (image instanceof TextureImage3D) {
                            TextureImage3D image3D = (TextureImage3D)image;
                            buff = image3D.getDataBuffer();
                        } else {
                            throw new Error("Unknown TextureImage type " + image.getClass());
                        }
                        if (image.isCompressed()) {
                            GL13.glCompressedTexImage2D((int)face, (int)level, (int)internalFormat, (int)image.getWidth(), (int)image.getHeight(), (int)0, (ByteBuffer)buff);
                            continue;
                        }
                        GL11.glTexImage2D((int)face, (int)level, (int)internalFormat, (int)image.getWidth(), (int)image.getHeight(), (int)0, (int)format, (int)5121, (ByteBuffer)buff);
                    }
                }
                break;
            }
        }
        return textureId;
    }

    private static final void updateTexture(Texture2D texture) {
        if (!texture.hasUpdateList()) {
            return;
        }
        int numLevel = texture.getImagesCount();
        for (int level = 0; level < numLevel; ++level) {
            TextureImage2D image = (TextureImage2D)texture.getImage(level);
            ArrayList<Rect2i> list = image.getUpdateList();
            if (list.isEmpty()) continue;
            int format = image.getFormat().toOpenGL();
            int listSize = list.size();
            for (int i = 0; i < listSize; ++i) {
                ByteBuffer buff;
                Rect2i r = list.get(i);
                GL11.glPixelStorei((int)3314, (int)image.getWidth());
                GL11.glPixelStorei((int)3316, (int)r.getLeft());
                GL11.glPixelStorei((int)3315, (int)r.getTop());
                if (image.getDataBuffer() != null) {
                    buff = image.getDataBuffer();
                } else if (image.getDataSize() > textureDataBuffer.capacity()) {
                    buff = BufferUtils.createByteBuffer((int)image.getDataSize());
                    image.getData(buff);
                } else {
                    buff = textureDataBuffer;
                    image.getData(buff);
                }
                GL11.glTexSubImage2D((int)3553, (int)level, (int)r.getLeft(), (int)r.getTop(), (int)r.getWidth(), (int)r.getHeight(), (int)format, (int)5121, (ByteBuffer)buff);
            }
            image.clearUpdateList();
            GL11.glPixelStorei((int)3314, (int)0);
            GL11.glPixelStorei((int)3316, (int)0);
            GL11.glPixelStorei((int)3315, (int)0);
        }
        texture.setHasUpdateList(false);
    }

    private static final int bindTexture(OpenGLStatesCache statesCache, Texture texture, int unit, CanvasPeer canvasPeer, int depthBuffersize) {
        boolean texCMEnabled;
        boolean tex3DEnabled;
        boolean tex2DEnabled;
        TextureType texType = texture.getType();
        switch (texType) {
            case TEXTURE_CUBE_MAP: {
                tex2DEnabled = false;
                tex3DEnabled = false;
                texCMEnabled = true;
                break;
            }
            case TEXTURE_3D: {
                tex2DEnabled = false;
                tex3DEnabled = true;
                texCMEnabled = false;
                break;
            }
            default: {
                tex2DEnabled = true;
                tex3DEnabled = false;
                texCMEnabled = false;
            }
        }
        if (!(!tex2DEnabled || statesCache.enabled && statesCache.texture2DEnabled[unit])) {
            GL11.glEnable((int)3553);
        } else if (!(tex2DEnabled || statesCache.enabled && !statesCache.texture2DEnabled[unit])) {
            GL11.glDisable((int)3553);
        }
        if (!(!tex3DEnabled || statesCache.enabled && statesCache.texture3DEnabled[unit])) {
            GL11.glEnable((int)32879);
        } else if (!(tex3DEnabled || statesCache.enabled && !statesCache.texture3DEnabled[unit])) {
            GL11.glDisable((int)32879);
        }
        if (!(!texCMEnabled || statesCache.enabled && statesCache.textureCMEnabled[unit])) {
            GL11.glEnable((int)34067);
        } else if (!(texCMEnabled || statesCache.enabled && !statesCache.textureCMEnabled[unit])) {
            GL11.glDisable((int)34067);
        }
        statesCache.texture2DEnabled[unit] = tex2DEnabled;
        statesCache.texture3DEnabled[unit] = tex3DEnabled;
        statesCache.textureCMEnabled[unit] = texCMEnabled;
        SceneGraphOpenGLReference openGLRef = texture.getOpenGLReferences().getReference(canvasPeer, textureNameProvider);
        int texHandle = openGLRef.getName();
        if (texture.isDirty()) {
            if (texHandle != -1) {
                tmpIntBuffer.clear();
                tmpIntBuffer.put(texHandle).flip();
                GL11.glDeleteTextures((IntBuffer)tmpIntBuffer);
                texHandle = openGLRef.deleteName();
            }
            _SG_PrivilegedAccess.setDirty(texture, false);
        }
        if (texHandle != -1 && !texture.hasSizeChanged()) {
            GL11.glBindTexture((int)texType.toOpenGL(), (int)texHandle);
            statesCache.currentBoundTexture[unit] = texture;
            if (texType == TextureType.TEXTURE_2D) {
                TextureUnitStateUnitPeer.updateTexture((Texture2D)texture);
            }
        } else {
            texHandle = TextureUnitStateUnitPeer.defineTexture(unit, texture, canvasPeer, depthBuffersize, statesCache);
            _SG_PrivilegedAccess.resetSizeChanged(texture);
        }
        return texHandle;
    }

    private static final int setTextureState(OpenGLCapabilities glCaps, OpenGLStatesCache statesCache, Texture texture, int unit, boolean texChanged, CanvasPeer canvasPeer, int depthBuffersize) {
        int texHandle = TextureUnitStateUnitPeer.bindTexture(statesCache, texture, unit, canvasPeer, depthBuffersize);
        if (texChanged) {
            TextureUnitStateUnitPeer.applyTextureAttachedAttributes(texture, texture.getImagesCount() > 1, glCaps);
            _SG_PrivilegedAccess.setChanged(texture, false);
        }
        return texHandle;
    }

    private static final void disableTextureState(OpenGLStatesCache statesCache, Texture texture, int unit, boolean texChanged) {
        TextureUnitStateUnitPeer.selectServerTextureUnit(unit, statesCache, false);
        if (!statesCache.enabled || statesCache.texture2DEnabled[unit]) {
            GL11.glDisable((int)3553);
            statesCache.texture2DEnabled[unit] = false;
        }
        if (!statesCache.enabled || statesCache.texture3DEnabled[unit]) {
            GL11.glDisable((int)32879);
            statesCache.texture3DEnabled[unit] = false;
        }
        if (!statesCache.enabled || statesCache.textureCMEnabled[unit]) {
            GL11.glDisable((int)34067);
            statesCache.textureCMEnabled[unit] = false;
        }
        if (texChanged) {
            _SG_PrivilegedAccess.setChanged(texture, false);
        }
    }

    protected static final int setTextureState2(OpenGLCapabilities glCaps, OpenGLStatesCache statesCache, Texture texture, int unit, boolean texChanged, CanvasPeer canvasPeer, int depthBuffersize) {
        if (texture == null || !texture.isEnabled()) {
            TextureUnitStateUnitPeer.disableTextureState(statesCache, texture, unit, texChanged);
            return -1;
        }
        return TextureUnitStateUnitPeer.setTextureState(glCaps, statesCache, texture, unit, texChanged, canvasPeer, depthBuffersize);
    }

    private static final void setCompareMode(OpenGLInfo glInfo, int glTexType, TextureCompareMode mode) {
        if (glInfo.getVersionMajor() > 1 || glInfo.getVersionMinor() >= 4) {
            GL11.glTexParameteri((int)glTexType, (int)34892, (int)mode.toOpenGL());
        } else if (OpenGlExtensions.ARB_shadow) {
            GL11.glTexParameteri((int)glTexType, (int)34892, (int)34894);
        }
    }

    private static final void setCompareFunc(OpenGLInfo glInfo, int glTexType, CompareFunction func) {
        if (glInfo.getNormalizedVersion() >= OpenGLInfo.NORM_VERSION_1_4) {
            GL11.glTexParameteri((int)glTexType, (int)34893, (int)func.toOpenGL());
        } else if (OpenGlExtensions.ARB_shadow) {
            GL11.glTexParameteri((int)glTexType, (int)34893, (int)func.toOpenGL());
        }
    }

    private static final void setTextureMatrix(Transform3D trans) {
        GL11.glMatrixMode((int)5890);
        GL11.glLoadMatrix((FloatBuffer)_SG_PrivilegedAccess.getFloatBuffer(trans, true));
        GL11.glMatrixMode((int)5888);
    }

    private static final void setIdentityTexMat() {
        GL11.glMatrixMode((int)5890);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
    }

    private void setTextureAttributes(int unit, TextureType texType, TextureAttributes ta, OpenGLInfo glInfo, OpenGLStatesCache statesCache) {
        if (!(ta != null && ta.getTextureTransform() != null || statesCache.enabled && statesCache.currentTextureMatrix[unit] == null)) {
            TextureUnitStateUnitPeer.setIdentityTexMat();
            statesCache.currentTextureMatrix[unit] = null;
        }
        if (ta == null) {
            if (!statesCache.enabled || statesCache.currentTextureMode[unit] != TextureMode.MODULATE) {
                GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
                statesCache.currentTextureMode[unit] = TextureMode.MODULATE;
            }
            return;
        }
        Transform3D texTrans = ta.getTextureTransform();
        if (texTrans != null && (!statesCache.enabled || statesCache.currentTextureMatrix[unit] != texTrans || texTrans.isChanged())) {
            TextureUnitStateUnitPeer.setTextureMatrix(texTrans);
            statesCache.currentTextureMatrix[unit] = texTrans;
            _SG_PrivilegedAccess.setChanged(texTrans, false);
        }
        TextureMode textureMode = ta.getTextureMode();
        if (!statesCache.enabled || statesCache.currentTextureMode[unit] != textureMode) {
            GL11.glTexEnvi((int)8960, (int)8704, (int)textureMode.toOpenGL());
            statesCache.currentTextureMode[unit] = textureMode;
        }
        if (textureMode == TextureMode.COMBINE) {
            Colorf tbc = ta.getTextureBlendColor();
            if (tbc == null) {
                if (!statesCache.enabled || statesCache.currentTextureBlendColor[unit] != null) {
                    GL11.glTexEnv((int)8960, (int)8705, (FloatBuffer)DEFAULT_TEXTURE_BLEND_COLOR);
                    statesCache.currentTextureBlendColor[unit] = null;
                }
            } else if (!statesCache.enabled || statesCache.currentTextureBlendColor[unit] != tbc || tbc.isDirty()) {
                tbc.writeToBuffer(true, texBlendColor, true, true);
                GL11.glTexEnv((int)8960, (int)8705, (FloatBuffer)texBlendColor);
                statesCache.currentTextureBlendColor[unit] = tbc;
                tbc.setClean();
            }
            if (!statesCache.enabled || statesCache.currentCombineMode_RGB[unit] != ta.getCombineRGBMode()) {
                GL11.glTexEnvf((int)8960, (int)34161, (float)ta.getCombineRGBMode().toOpenGL());
                statesCache.currentCombineMode_RGB[unit] = ta.getCombineRGBMode();
            }
            if (!statesCache.enabled || statesCache.currentCombineMode_Alpha[unit] != ta.getCombineAlphaMode()) {
                GL11.glTexEnvf((int)8960, (int)34162, (float)ta.getCombineAlphaMode().toOpenGL());
                statesCache.currentCombineMode_Alpha[unit] = ta.getCombineAlphaMode();
            }
            if (!statesCache.enabled || statesCache.currentCombineSource0_RGB[unit] != ta.getCombineRGBSource(0)) {
                GL11.glTexEnvf((int)8960, (int)34176, (float)ta.getCombineRGBSource(0).toOpenGL());
                statesCache.currentCombineSource0_RGB[unit] = ta.getCombineRGBSource(0);
            }
            if (!statesCache.enabled || statesCache.currentCombineSource0_Alpha[unit] != ta.getCombineAlphaSource(0)) {
                GL11.glTexEnvf((int)8960, (int)34184, (float)ta.getCombineAlphaSource(0).toOpenGL());
                statesCache.currentCombineSource0_Alpha[unit] = ta.getCombineAlphaSource(0);
            }
            if (!statesCache.enabled || statesCache.currentCombineFunction0_RGB[unit] != ta.getCombineRGBFunction(0)) {
                GL11.glTexEnvf((int)8960, (int)34192, (float)ta.getCombineRGBFunction(0).toOpenGL());
                statesCache.currentCombineFunction0_RGB[unit] = ta.getCombineRGBFunction(0);
            }
            if (!statesCache.enabled || statesCache.currentCombineFunction0_Alpha[unit] != ta.getCombineAlphaFunction(0)) {
                GL11.glTexEnvf((int)8960, (int)34200, (float)ta.getCombineAlphaFunction(0).toOpenGL());
                statesCache.currentCombineFunction0_Alpha[unit] = ta.getCombineAlphaFunction(0);
            }
            if (!statesCache.enabled || statesCache.currentCombineSource1_RGB[unit] != ta.getCombineRGBSource(1)) {
                GL11.glTexEnvf((int)8960, (int)34177, (float)ta.getCombineRGBSource(1).toOpenGL());
                statesCache.currentCombineSource1_RGB[unit] = ta.getCombineRGBSource(1);
            }
            if (!statesCache.enabled || statesCache.currentCombineSource1_Alpha[unit] != ta.getCombineAlphaSource(1)) {
                GL11.glTexEnvf((int)8960, (int)34185, (float)ta.getCombineAlphaSource(1).toOpenGL());
                statesCache.currentCombineSource1_Alpha[unit] = ta.getCombineAlphaSource(1);
            }
            if (!statesCache.enabled || statesCache.currentCombineFunction0_RGB[unit] != ta.getCombineRGBFunction(1)) {
                GL11.glTexEnvf((int)8960, (int)34193, (float)ta.getCombineRGBFunction(1).toOpenGL());
                statesCache.currentCombineFunction0_RGB[unit] = ta.getCombineRGBFunction(1);
            }
            if (!statesCache.enabled || statesCache.currentCombineFunction0_Alpha[unit] != ta.getCombineAlphaFunction(1)) {
                GL11.glTexEnvf((int)8960, (int)34201, (float)ta.getCombineAlphaFunction(1).toOpenGL());
                statesCache.currentCombineFunction0_Alpha[unit] = ta.getCombineAlphaFunction(1);
            }
            if (!statesCache.enabled || statesCache.currentCombineSource2_RGB[unit] != ta.getCombineRGBSource(2)) {
                GL11.glTexEnvf((int)8960, (int)34178, (float)ta.getCombineRGBSource(2).toOpenGL());
                statesCache.currentCombineSource2_RGB[unit] = ta.getCombineRGBSource(2);
            }
            if (!statesCache.enabled || statesCache.currentCombineSource2_Alpha[unit] != ta.getCombineAlphaSource(2)) {
                GL11.glTexEnvf((int)8960, (int)34186, (float)ta.getCombineAlphaSource(2).toOpenGL());
                statesCache.currentCombineSource2_Alpha[unit] = ta.getCombineAlphaSource(2);
            }
            if (!statesCache.enabled || statesCache.currentCombineFunction0_RGB[unit] != ta.getCombineRGBFunction(2)) {
                GL11.glTexEnvf((int)8960, (int)34194, (float)ta.getCombineRGBFunction(2).toOpenGL());
                statesCache.currentCombineFunction0_RGB[unit] = ta.getCombineRGBFunction(2);
            }
            if (!statesCache.enabled || statesCache.currentCombineFunction0_Alpha[unit] != ta.getCombineAlphaFunction(2)) {
                GL11.glTexEnvf((int)8960, (int)34202, (float)ta.getCombineAlphaFunction(2).toOpenGL());
                statesCache.currentCombineFunction0_Alpha[unit] = ta.getCombineAlphaFunction(2);
            }
            if (!statesCache.enabled || statesCache.currentCombineRGBScale[unit] != ta.getCombineRGBScale()) {
                GL11.glTexEnvi((int)8960, (int)34163, (int)ta.getCombineRGBScale());
                statesCache.currentCombineRGBScale[unit] = ta.getCombineRGBScale();
            }
        }
        if (texType == TextureType.TEXTURE_2D || texType == TextureType.TEXTURE_1D) {
            int glTexType = texType.toOpenGL();
            if (!statesCache.enabled || statesCache.currentCompareMode[unit] != ta.getCompareMode()) {
                TextureUnitStateUnitPeer.setCompareMode(glInfo, glTexType, ta.getCompareMode());
                statesCache.currentCompareMode[unit] = ta.getCompareMode();
            }
            if (!statesCache.enabled || statesCache.currentCompareFunc[unit] != ta.getCompareFunction()) {
                TextureUnitStateUnitPeer.setCompareFunc(glInfo, glTexType, ta.getCompareFunction());
                statesCache.currentCompareFunc[unit] = ta.getCompareFunction();
            }
        }
    }

    private final void updateProjectiveTexture(Shape3D shape, int tuIndex, CanvasPeerImplBase canvas, long frameId) {
        Appearance app = shape.getAppearance();
        if (app == null) {
            return;
        }
        TextureUnit tu = app.getTextureUnit(tuIndex);
        if (!(tu instanceof ProjectiveTextureUnit)) {
            return;
        }
        ProjectiveTextureUnit projTU = (ProjectiveTextureUnit)tu;
        float viewportAspect = canvas.getCurrentViewport() == null ? canvas.getDisplayMode().getAspect() : canvas.getCurrentViewport().getAspect();
        projTU.update(viewportAspect, frameId);
    }

    private static final void setupTextureCoordsGeneration(TexCoordGeneration texGen) {
        int glGenMode = texGen.getGenMode().toOpenGL();
        int glPlaneName = 9474;
        FloatBuffer planeBuf = null;
        switch (texGen.getGenMode()) {
            case OBJECT_LINEAR: {
                glPlaneName = 9473;
                planeBuf = tmpPlaneBuffer;
                break;
            }
            case EYE_LINEAR: {
                glPlaneName = 9474;
                planeBuf = tmpPlaneBuffer;
                break;
            }
            case SPHERE_MAP: {
                break;
            }
            case NORMAL_MAP: {
                break;
            }
            case REFLECTION_MAP: {
                break;
            }
            default: {
                throw new Error("Unsupported TExture-generation-mode " + texGen.getGenMode());
            }
        }
        switch (texGen.getFormat()) {
            case TEXTURE_COORDINATES_1: {
                GL11.glTexGeni((int)8192, (int)9472, (int)glGenMode);
                if (planeBuf == null) break;
                texGen.getPlaneS().writeToBuffer(planeBuf, true, true);
                GL11.glTexGen((int)8192, (int)glPlaneName, (FloatBuffer)planeBuf);
                break;
            }
            case TEXTURE_COORDINATES_2: {
                GL11.glTexGeni((int)8192, (int)9472, (int)glGenMode);
                GL11.glTexGeni((int)8193, (int)9472, (int)glGenMode);
                if (planeBuf == null) break;
                texGen.getPlaneS().writeToBuffer(planeBuf, true, true);
                GL11.glTexGen((int)8192, (int)glPlaneName, (FloatBuffer)planeBuf);
                texGen.getPlaneT().writeToBuffer(planeBuf, true, true);
                GL11.glTexGen((int)8193, (int)glPlaneName, (FloatBuffer)planeBuf);
                break;
            }
            case TEXTURE_COORDINATES_3: {
                GL11.glTexGeni((int)8192, (int)9472, (int)glGenMode);
                GL11.glTexGeni((int)8193, (int)9472, (int)glGenMode);
                GL11.glTexGeni((int)8194, (int)9472, (int)glGenMode);
                if (planeBuf == null) break;
                texGen.getPlaneS().writeToBuffer(planeBuf, true, true);
                GL11.glTexGen((int)8192, (int)glPlaneName, (FloatBuffer)planeBuf);
                texGen.getPlaneT().writeToBuffer(planeBuf, true, true);
                GL11.glTexGen((int)8193, (int)glPlaneName, (FloatBuffer)planeBuf);
                texGen.getPlaneR().writeToBuffer(planeBuf, true, true);
                GL11.glTexGen((int)8194, (int)glPlaneName, (FloatBuffer)planeBuf);
                break;
            }
            case TEXTURE_COORDINATES_4: {
                GL11.glTexGeni((int)8192, (int)9472, (int)glGenMode);
                GL11.glTexGeni((int)8193, (int)9472, (int)glGenMode);
                GL11.glTexGeni((int)8194, (int)9472, (int)glGenMode);
                GL11.glTexGeni((int)8195, (int)9472, (int)glGenMode);
                if (planeBuf == null) break;
                texGen.getPlaneS().writeToBuffer(planeBuf, true, true);
                GL11.glTexGen((int)8192, (int)glPlaneName, (FloatBuffer)planeBuf);
                texGen.getPlaneT().writeToBuffer(planeBuf, true, true);
                GL11.glTexGen((int)8193, (int)glPlaneName, (FloatBuffer)planeBuf);
                texGen.getPlaneR().writeToBuffer(planeBuf, true, true);
                GL11.glTexGen((int)8194, (int)glPlaneName, (FloatBuffer)planeBuf);
                texGen.getPlaneQ().writeToBuffer(planeBuf, true, true);
                GL11.glTexGen((int)8195, (int)glPlaneName, (FloatBuffer)planeBuf);
            }
        }
    }

    private static final void applyTexCoordGenStates(int unit, int statesMask, OpenGLStatesCache statesCache) {
        if ((statesMask & 1) != 0) {
            if (!statesCache.enabled || (statesCache.texGenEnableMask[unit] & 1) == 0) {
                GL11.glEnable((int)3168);
                int n = unit;
                statesCache.texGenEnableMask[n] = statesCache.texGenEnableMask[n] | 1;
            }
        } else if (!statesCache.enabled || (statesCache.texGenEnableMask[unit] & 1) != 0) {
            GL11.glDisable((int)3168);
            int n = unit;
            statesCache.texGenEnableMask[n] = statesCache.texGenEnableMask[n] & 0xFFFFFFFE;
        }
        if ((statesMask & 2) != 0) {
            if (!statesCache.enabled || (statesCache.texGenEnableMask[unit] & 2) == 0) {
                GL11.glEnable((int)3169);
                int n = unit;
                statesCache.texGenEnableMask[n] = statesCache.texGenEnableMask[n] | 2;
            }
        } else if (!statesCache.enabled || (statesCache.texGenEnableMask[unit] & 2) != 0) {
            GL11.glDisable((int)3169);
            int n = unit;
            statesCache.texGenEnableMask[n] = statesCache.texGenEnableMask[n] & 0xFFFFFFFD;
        }
        if ((statesMask & 4) != 0) {
            if (!statesCache.enabled || (statesCache.texGenEnableMask[unit] & 4) == 0) {
                GL11.glEnable((int)3170);
                int n = unit;
                statesCache.texGenEnableMask[n] = statesCache.texGenEnableMask[n] | 4;
            }
        } else if (!statesCache.enabled || (statesCache.texGenEnableMask[unit] & 4) != 0) {
            GL11.glDisable((int)3170);
            int n = unit;
            statesCache.texGenEnableMask[n] = statesCache.texGenEnableMask[n] & 0xFFFFFFFB;
        }
        if ((statesMask & 8) != 0) {
            if (!statesCache.enabled || (statesCache.texGenEnableMask[unit] & 8) == 0) {
                GL11.glEnable((int)3171);
                int n = unit;
                statesCache.texGenEnableMask[n] = statesCache.texGenEnableMask[n] | 8;
            }
        } else if (!statesCache.enabled || (statesCache.texGenEnableMask[unit] & 8) != 0) {
            GL11.glDisable((int)3171);
            int n = unit;
            statesCache.texGenEnableMask[n] = statesCache.texGenEnableMask[n] & 0xFFFFFFF7;
        }
    }

    @Override
    public void apply(RenderAtom<?> atom, StateUnit stateUnit, Object glObj, CanvasPeer canvasPeer, RenderPeer renderPeer, OpenGLCapabilities glCaps, View view, OpenGLStatesCache statesCache, RenderOptions options, long nanoTime, long nanoStep, RenderPeer.RenderMode renderMode, long frameId) {
        if (!options.isTextureMappingEnabled() || renderMode != RenderPeer.RenderMode.NORMAL) {
            return;
        }
        ProfileTimer.startProfile((LogChannel)X3DLog.LOG_CHANNEL, (String)"TextureUnitStateUnitPeer::apply()");
        TextureUnitStateUnit texStateUnit = (TextureUnitStateUnit)stateUnit;
        int unit = texStateUnit.getUnit();
        if (unit >= glCaps.getMaxTextureUnits()) {
            ProfileTimer.endProfile();
            return;
        }
        Texture texture = texStateUnit.getTexture();
        if (texture == null) {
            TextureUnitStateUnitPeer.disableTextureState(statesCache, texture, unit, false);
            statesCache.currentBoundTexture[unit] = texture;
            ProfileTimer.endProfile();
            return;
        }
        if (!texture.isEnabled()) {
            TextureUnitStateUnitPeer.disableTextureState(statesCache, texture, unit, texture.isChanged2());
            statesCache.currentBoundTexture[unit] = texture;
            ProfileTimer.endProfile();
            return;
        }
        boolean changed = texture.isChanged2();
        if (texture instanceof Texture2D && (((Texture2D)texture).hasTextureCanvas() && _SG_PrivilegedAccess.notifyDrawCallbacks(((Texture2D)texture).getTextureCanvas(), nanoTime) || ((Texture2D)texture).hasUpdateList()) || !statesCache.enabled || statesCache.currentBoundTexture[unit] != texture || changed) {
            TextureUnitStateUnitPeer.selectServerTextureUnit(unit, statesCache, false);
            TextureUnitStateUnitPeer.setTextureState(glCaps, statesCache, texture, unit, changed, canvasPeer, canvasPeer.getDepthBufferSize());
            statesCache.currentBoundTexture[unit] = texture;
        }
        TextureAttributes texAttribs = texStateUnit.getTextureAttributes();
        changed = texAttribs.isChanged();
        boolean hasProjectiveTex = atom.getNode() instanceof Shape3D;
        if (hasProjectiveTex) {
            Appearance app = ((Shape3D)atom.getNode()).getAppearance();
            hasProjectiveTex = app == null ? false : app.getTextureUnit(unit) instanceof ProjectiveTextureUnit;
        }
        if (hasProjectiveTex) {
            this.updateProjectiveTexture((Shape3D)atom.getNode(), unit, (CanvasPeerImplBase)renderPeer.getCanvasPeer(), frameId);
        }
        TextureUnitStateUnitPeer.selectServerTextureUnit(unit, statesCache, false);
        this.setTextureAttributes(unit, texture.getType(), texAttribs, renderPeer.getCanvasPeer().getOpenGLInfo(), statesCache);
        statesCache.currentTexAttribs[unit] = texAttribs;
        if (changed) {
            _SG_PrivilegedAccess.setChanged(texAttribs, false);
        }
        TexCoordGeneration texCoordGen = texStateUnit.getTexCoordGeneration();
        changed = texCoordGen.isChanged();
        if (texCoordGen.isEnabled()) {
            ShapeAtomPeer.setMatrix(view, ((Node)atom.getNode()).getWorldTransform(), ((Node)atom.getNode()).isBillboard(), false);
            TextureUnitStateUnitPeer.selectServerTextureUnit(unit, statesCache, false);
            TextureUnitStateUnitPeer.setupTextureCoordsGeneration(texCoordGen);
            int texGenMask = texCoordGen.getFormat().getBitMask();
            if (!statesCache.enabled || statesCache.texGenEnableMask[unit] != texGenMask) {
                TextureUnitStateUnitPeer.applyTexCoordGenStates(unit, texGenMask, statesCache);
            }
        } else if (!statesCache.enabled || statesCache.texGenEnableMask[unit] != 0) {
            TextureUnitStateUnitPeer.selectServerTextureUnit(unit, statesCache, false);
            TextureUnitStateUnitPeer.applyTexCoordGenStates(unit, 0, statesCache);
        }
        statesCache.currentTexCoordGen[unit] = texCoordGen;
        if (changed) {
            _SG_PrivilegedAccess.setChanged(texCoordGen, false);
        }
        ProfileTimer.endProfile();
    }

    static {
        DEFAULT_TEXTURE_BLEND_COLOR.put(0, 0.0f);
        DEFAULT_TEXTURE_BLEND_COLOR.put(1, 0.0f);
        DEFAULT_TEXTURE_BLEND_COLOR.put(2, 0.0f);
        DEFAULT_TEXTURE_BLEND_COLOR.put(3, 1.0f);
        DEFAULT_TEXTURE_BLEND_COLOR.rewind();
    }
}

