/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.lwjgl;

import java.nio.FloatBuffer;
import org.jagatoo.logging.LogChannel;
import org.jagatoo.logging.ProfileTimer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.openmali.FastMath;
import org.openmali.vecmath2.Point3f;
import org.xith3d.effects.EffectFactory;
import org.xith3d.effects.shadows.VolumeShadowFactory;
import org.xith3d.effects.shadows.occluder.Occluder;
import org.xith3d.render.OpenGLCapabilities;
import org.xith3d.render.OpenGLStatesCache;
import org.xith3d.render.lwjgl.RenderPeerImpl;
import org.xith3d.render.lwjgl.ShadowRenderPeer;
import org.xith3d.render.lwjgl.ShapeAtomPeer;
import org.xith3d.render.preprocessing.RenderBin;
import org.xith3d.scenegraph.Light;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.View;
import org.xith3d.utility.logging.X3DLog;

public class VolumeShadowRenderPeer
implements ShadowRenderPeer.ShadowRenderPeerInterface {
    private final FloatBuffer floatBuffer4x4 = BufferUtils.createFloatBuffer((int)16);
    private float[] trans = new float[16];

    public final int initShadows(View view, Light light, RenderBin shadowBin, RenderPeerImpl renderPeer, long frameId) {
        return 0;
    }

    private final int drawObjectShadow(OpenGLStatesCache statesCache, OpenGLCapabilities glCaps, Occluder occluder) {
        occluder.getWorldTransform().getColumnMajor(this.trans);
        this.floatBuffer4x4.clear();
        this.floatBuffer4x4.put(this.trans).flip();
        this.floatBuffer4x4.rewind();
        GL11.glLoadMatrix((FloatBuffer)this.floatBuffer4x4);
        if (!statesCache.enabled || statesCache.normalsArrayEnabled) {
            GL11.glDisableClientState((int)32885);
            statesCache.normalsArrayEnabled = false;
        }
        if (!statesCache.enabled || statesCache.colorsArrayEnabled) {
            GL11.glDisableClientState((int)32886);
            statesCache.colorsArrayEnabled = false;
        }
        for (int i = 0; i < glCaps.getMaxTextureUnits(); ++i) {
            int tuMaskValue = FastMath.pow((int)2, (int)i);
            if (statesCache.enabled && (statesCache.texCoordArraysEnableMask & tuMaskValue) == 0) continue;
            ShapeAtomPeer.selectClientTextureUnit(i, statesCache, false);
            GL11.glDisableClientState((int)32888);
            statesCache.texCoordArraysEnableMask &= ~tuMaskValue;
        }
        if (!statesCache.enabled || !statesCache.coordsArrayEnabled) {
            GL11.glEnableClientState((int)32884);
            statesCache.coordsArrayEnabled = true;
        }
        GL11.glVertexPointer((int)3, (int)0, (FloatBuffer)occluder.getBuffer().getCoordinatesData().getBuffer());
        GL11.glDrawArrays((int)4, (int)0, (int)occluder.getBuffer().getValidVertexCount());
        return occluder.getBuffer().getValidVertexCount() / 3;
    }

    public final int drawShadows(View view, Light light, RenderBin shadowBin, RenderPeerImpl renderPeer, long frameId) {
        Occluder occluder;
        Node node;
        int i;
        OpenGLStatesCache statesCache = renderPeer.getStatesCache();
        OpenGLCapabilities glCaps = renderPeer.getCanvasPeer().getOpenGLCapabilities();
        VolumeShadowFactory shadowFactory = (VolumeShadowFactory)EffectFactory.getInstance().getShadowFactory();
        Point3f lightSourcePos = shadowFactory.getLightSourcePosition();
        int numTriangles = 0;
        ProfileTimer.startProfile((LogChannel)X3DLog.LOG_CHANNEL, (String)"ShadowShaderPeer::drawShadows");
        int FULLMASK = -1;
        int STENCIL_VAL = 128;
        RenderBin bin = shadowBin;
        for (i = 0; i < bin.size(); ++i) {
            node = bin.getAtom(i).getNode();
            occluder = (Occluder)node.getShadowAttachment();
            occluder.determineVisibleEdges(lightSourcePos);
        }
        GL11.glPushAttrib((int)25864);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glDisable((int)2896);
        statesCache.lightingEnabled = false;
        GL11.glDisable((int)3553);
        statesCache.texture2DEnabled[statesCache.currentServerTextureUnit] = false;
        GL11.glDisable((int)32879);
        statesCache.texture3DEnabled[statesCache.currentServerTextureUnit] = false;
        GL11.glDisable((int)3042);
        statesCache.blendingEnabled = false;
        GL11.glStencilFunc((int)512, (int)255, (int)-1);
        GL11.glDepthMask((boolean)true);
        GL11.glDepthFunc((int)515);
        GL11.glEnable((int)2929);
        statesCache.depthTestEnabled = true;
        GL11.glPopMatrix();
        GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glClearStencil((int)128);
        GL11.glClear((int)1024);
        GL11.glDisable((int)2896);
        statesCache.lightingEnabled = false;
        GL11.glFrontFace((int)2305);
        GL11.glEnable((int)2884);
        statesCache.cullFaceEnabled = true;
        GL11.glCullFace((int)1028);
        GL11.glDepthMask((boolean)false);
        GL11.glDepthFunc((int)515);
        GL11.glEnable((int)2960);
        statesCache.stencilTestEnabled = true;
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GL11.glStencilFunc((int)519, (int)128, (int)-1);
        GL11.glStencilOp((int)7680, (int)7680, (int)7682);
        for (i = 0; i < bin.size(); ++i) {
            node = bin.getAtom(i).getNode();
            occluder = (Occluder)node.getShadowAttachment();
            numTriangles += this.drawObjectShadow(statesCache, glCaps, occluder);
        }
        GL11.glCullFace((int)1029);
        GL11.glStencilOp((int)7680, (int)7680, (int)7683);
        GL11.glColor3f((float)0.5f, (float)0.5f, (float)0.0f);
        for (i = 0; i < bin.size(); ++i) {
            node = bin.getAtom(i).getNode();
            occluder = (Occluder)node.getShadowAttachment();
            this.drawObjectShadow(statesCache, glCaps, occluder);
        }
        GL11.glColorMask(((statesCache.colorWriteMask & 1) != 0 ? 1 : 0) != 0, ((statesCache.colorWriteMask & 2) != 0 ? 1 : 0) != 0, ((statesCache.colorWriteMask & 4) != 0 ? 1 : 0) != 0, ((statesCache.colorWriteMask & 8) != 0 ? 1 : 0) != 0);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
        GL11.glEnable((int)3042);
        statesCache.blendingEnabled = true;
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        view.getProjection().getColumnMajor(this.trans);
        this.floatBuffer4x4.clear();
        this.floatBuffer4x4.put(this.trans).flip();
        this.floatBuffer4x4.rewind();
        GL11.glLoadMatrix((FloatBuffer)this.floatBuffer4x4);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glDepthMask((boolean)false);
        GL11.glStencilFunc((int)517, (int)128, (int)-1);
        GL11.glStencilOp((int)7680, (int)7680, (int)7680);
        GL11.glCullFace((int)1029);
        GL11.glDisable((int)2884);
        statesCache.cullFaceEnabled = false;
        GL11.glAlphaFunc((int)519, (float)0.0f);
        GL11.glBegin((int)5);
        GL11.glVertex3f((float)-100.0f, (float)100.0f, (float)-2.0f);
        GL11.glVertex3f((float)-100.0f, (float)-1000.0f, (float)-2.0f);
        GL11.glVertex3f((float)100.0f, (float)100.0f, (float)-2.0f);
        GL11.glVertex3f((float)100.0f, (float)-1000.0f, (float)-2.0f);
        GL11.glEnd();
        GL11.glPopMatrix();
        GL11.glPopAttrib();
        ProfileTimer.endProfile();
        return numTriangles;
    }
}

