/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.preprocessing;

import org.openmali.spatial.bodies.Classifier;
import org.xith3d.render.preprocessing.RenderAtom;
import org.xith3d.render.preprocessing.RenderBin;
import org.xith3d.render.preprocessing.RenderBinType;
import org.xith3d.render.preprocessing.sorting.RenderBinSorter;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.Transform3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderBinProvider {
    protected RenderBin opaqueBin;
    protected RenderBin transparentBin;
    protected RenderBin shadowsBin;

    public RenderBinProvider(RenderBin opaqueBin, RenderBin transparentBin, RenderBin shadowsBin) {
        this.opaqueBin = opaqueBin;
        this.transparentBin = transparentBin;
        this.shadowsBin = shadowsBin;
    }

    public RenderBinProvider() {
        this(new RenderBin(RenderBinType.MAIN_OPAQUE, "Main Opaque RenderBin", 2048), new RenderBin(RenderBinType.MAIN_TRANSPARENT, "Main Transparent RenderBin", 128), new RenderBin(RenderBinType.MAIN_OPAQUE, "Shadows RenderBin", 2048));
    }

    public final RenderBin getOpaqueBin() {
        return this.opaqueBin;
    }

    public final RenderBin getTransparentBin() {
        return this.transparentBin;
    }

    public final RenderBin getShadowsBin() {
        return this.shadowsBin;
    }

    public final int getAtomsCount() {
        return this.transparentBin.size() + this.opaqueBin.size();
    }

    public final void addMainAtom(RenderAtom<? extends Node> atom, Classifier.Classification classify, long frameId) {
        if (!atom.isTranslucent()) {
            this.opaqueBin.addAtom(atom, classify, frameId);
        } else {
            this.transparentBin.addAtom(atom, classify, frameId);
        }
    }

    public final void addShadowAtom(RenderAtom<? extends Node> atom, Classifier.Classification classify, long frameId) {
        this.shadowsBin.addAtom(atom, classify, frameId);
    }

    private static final void sortRenderBin(RenderBin renderBin, RenderBinSorter opaqueSorter, RenderBinSorter transparentSorter, Transform3D viewTransform) {
        if (renderBin.size() > 0) {
            if (renderBin.getType().isTransparent()) {
                if (transparentSorter != null) {
                    transparentSorter.sortRenderBin(renderBin, viewTransform);
                }
            } else if (opaqueSorter != null) {
                opaqueSorter.sortRenderBin(renderBin, viewTransform);
            }
        }
    }

    public final void sortAllAtoms(RenderBinSorter opaqueSorter, RenderBinSorter transparentSorter, Transform3D viewTransform) {
        RenderBinProvider.sortRenderBin(this.opaqueBin, opaqueSorter, transparentSorter, viewTransform);
        RenderBinProvider.sortRenderBin(this.transparentBin, opaqueSorter, transparentSorter, viewTransform);
        RenderBinProvider.sortRenderBin(this.shadowsBin, opaqueSorter, transparentSorter, viewTransform);
    }

    public final void clearAllBins() {
        this.opaqueBin.clear();
        this.transparentBin.clear();
        this.shadowsBin.clear();
    }

    public final void shrinkAllBins() {
        this.opaqueBin.shrink();
        this.transparentBin.shrink();
        this.shadowsBin.shrink();
    }
}

