/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.preprocessing.sorting;

import java.util.Comparator;
import org.xith3d.render.preprocessing.RenderAtom;
import org.xith3d.render.preprocessing.RenderBin;
import org.xith3d.render.preprocessing.sorting.RenderBinSorter;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.utility.comparator.Sorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomRenderBinSorter
extends RenderBinSorter
implements Comparator<RenderAtom<?>> {
    private static final Comparable<Object> DEFAULT_COMPARABLE = new Comparable<Object>(){

        @Override
        public int compareTo(Object o) {
            return -1;
        }
    };

    @Override
    public int compare(RenderAtom<?> atom1, RenderAtom<?> atom2) {
        return atom1.getCustomComparable().compareTo(atom2.getCustomComparable());
    }

    @Override
    public boolean equals(Object o) {
        return false;
    }

    @Override
    public void updateDistancesToView(RenderBin renderBin, Transform3D viewTransform) {
        super.updateDistancesToView(renderBin, viewTransform);
        RenderBin.DynamicAtomArray atoms = renderBin.getAtoms();
        for (int i = 0; i < atoms.size(); ++i) {
            RenderAtom<?> atom = atoms.get(i);
            if (atom.getNode() instanceof Shape3D) {
                atom.setCompareIndicators(0.0f, 0.0f, ((Shape3D)atom.getNode()).getCustomComparable());
                continue;
            }
            atom.setCompareIndicators(0.0f, 0.0f, DEFAULT_COMPARABLE);
        }
    }

    @Override
    public void sortRenderBin(RenderBin renderBin, Transform3D viewTransform) {
        this.updateDistancesToView(renderBin, null);
        RenderBin.DynamicAtomArray atoms = renderBin.getAtoms();
        Sorter.quickSort(atoms.getRawArray(), 0, atoms.size() - 1, this);
    }
}

