/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.preprocessing.sorting;

import java.util.Comparator;
import org.xith3d.render.preprocessing.OrderedState;
import org.xith3d.render.preprocessing.RenderAtom;
import org.xith3d.render.preprocessing.RenderBin;
import org.xith3d.render.preprocessing.sorting.RenderBinSorter;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.utility.comparator.Sorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedBackToFrontRenderBinSorter
extends RenderBinSorter
implements Comparator<RenderAtom<?>> {
    @Override
    public int compare(RenderAtom<?> atom1, RenderAtom<?> atom2) {
        OrderedState os2;
        OrderedState os1 = atom1.getOrderedState();
        if (os1 != (os2 = atom2.getOrderedState())) {
            if (os1 == null) {
                return -1;
            }
            if (os2 == null) {
                return 1;
            }
            for (int index = 0; index < os1.depth && index < os2.depth; ++index) {
                if (os1.orderIds[index] < os2.orderIds[index]) {
                    return -1;
                }
                if (os1.orderIds[index] <= os2.orderIds[index]) continue;
                return 1;
            }
            if (os1.depth < os2.depth) {
                return -1;
            }
            if (os1.depth > os2.depth) {
                return 1;
            }
            throw new Error("Completely impossible order state condition (comparing " + os1 + " and " + os2 + ")");
        }
        if (atom1.getSquaredDistanceToView() > atom2.getSquaredDistanceToView()) {
            return -1;
        }
        if (atom1.getSquaredDistanceToView() < atom2.getSquaredDistanceToView()) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        return false;
    }

    @Override
    public void sortRenderBin(RenderBin renderBin, Transform3D viewTransform) {
        this.updateDistancesToView(renderBin, null);
        RenderBin.DynamicAtomArray atoms = renderBin.getAtoms();
        Sorter.quickSort(atoms.getRawArray(), 0, atoms.size() - 1, this);
    }
}

