/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.preprocessing.sorting;

import java.util.Comparator;
import org.xith3d.render.preprocessing.OrderedState;
import org.xith3d.render.preprocessing.RenderAtom;
import org.xith3d.render.preprocessing.RenderBin;
import org.xith3d.render.preprocessing.sorting.RenderBinSorter;
import org.xith3d.render.preprocessing.sorting.StatePriorities;
import org.xith3d.render.states.StateSortable;
import org.xith3d.render.states.StateSortableMap;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.utility.comparator.Sorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedStateRenderBinSorter
extends RenderBinSorter
implements Comparator<RenderAtom<?>> {
    private final StatePriorities priorities;

    public final StatePriorities getPriorities() {
        return this.priorities;
    }

    @Override
    public int compare(RenderAtom<?> atom1, RenderAtom<?> atom2) {
        OrderedState os2;
        int stateType2;
        if (atom1 == atom2) {
            return 0;
        }
        int stateType1 = atom1.getStateType();
        if (stateType1 < (stateType2 = atom2.getStateType())) {
            return -1;
        }
        if (stateType1 > stateType2) {
            return 1;
        }
        if (atom1.getSortableStates().hash == atom2.getSortableStates().hash) {
            return 0;
        }
        OrderedState os1 = atom1.getOrderedState();
        if (os1 != (os2 = atom2.getOrderedState())) {
            if (os1 == null) {
                return -1;
            }
            if (os2 == null) {
                return 1;
            }
            for (int index = 0; index < os1.depth && index < os2.depth; ++index) {
                if (os1.orderIds[index] < os2.orderIds[index]) {
                    return -1;
                }
                if (os1.orderIds[index] <= os2.orderIds[index]) continue;
                return 1;
            }
            if (os1.depth < os2.depth) {
                return -1;
            }
            if (os1.depth > os2.depth) {
                return 1;
            }
            throw new Error("Completely impossible order state condition (comparing " + os1 + " and " + os2 + ")");
        }
        StateSortableMap ssMap1 = atom1.getSortableStates();
        StateSortableMap ssMap2 = atom2.getSortableStates();
        for (int i = 0; i < this.priorities.numStatePriorities; ++i) {
            int prio = this.priorities.statePriorities[i];
            StateSortable ss1 = ssMap1.map[prio];
            StateSortable ss2 = ssMap2.map[prio];
            if (ss1 == ss2) continue;
            if (ss1 == null) {
                return -1;
            }
            if (ss2 == null) {
                return 1;
            }
            long bid1 = ssMap1.mapID[prio];
            long bid2 = ssMap2.mapID[prio];
            if (bid1 < bid2) {
                return -1;
            }
            if (bid1 <= bid2) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        return false;
    }

    @Override
    public void sortRenderBin(RenderBin renderBin, Transform3D viewTransform) {
        RenderBin.DynamicAtomArray atoms = renderBin.getAtoms();
        Sorter.quickSort(atoms.getRawArray(), 0, atoms.size() - 1, this);
    }

    public OrderedStateRenderBinSorter(StatePriorities priorities) {
        this.priorities = priorities;
    }

    public OrderedStateRenderBinSorter() {
        this(StatePriorities.getDefaultPriorities());
    }
}

