/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.states.units;

import org.xith3d.render.states.StateMap;
import org.xith3d.render.states.StateUnit;
import org.xith3d.scenegraph.Fog;
import org.xith3d.scenegraph.InheritedNodeAttributes;
import org.xith3d.scenegraph.NodeComponent;

public class FogStateUnit
extends StateUnit {
    public static final int STATE_TYPE = StateMap.newStateType();
    private final InheritedNodeAttributes inheritedNodeAttribs;

    public final int numFogs() {
        return this.inheritedNodeAttribs.getFogsCount();
    }

    public final Fog getFog(int index) {
        return this.inheritedNodeAttribs.getFog(index);
    }

    public NodeComponent getNodeComponent() {
        return null;
    }

    public final boolean isTranslucent() {
        return false;
    }

    public final long getStateId() {
        long stateId = 0L;
        for (int i = 0; i < this.inheritedNodeAttribs.getEffectiveFogsCount(); ++i) {
            stateId |= (long)(this.inheritedNodeAttribs.getFog(i).getFogID() << i * 16);
        }
        return stateId;
    }

    public String toString() {
        String s = "FogStateUnit: ";
        for (int i = 0; i < this.numFogs(); ++i) {
            s = s + this.getFog(i).getName() + " ";
        }
        return s;
    }

    private final void update(boolean forced) {
        if (this.inheritedNodeAttribs.getFogsDirty() || forced) {
            this.updateCachedStateId();
            this.inheritedNodeAttribs.setFogsClean();
        }
    }

    public final void update() {
        this.update(false);
    }

    private FogStateUnit(InheritedNodeAttributes inheritedNodeAttribs) {
        super(STATE_TYPE, false);
        this.inheritedNodeAttribs = inheritedNodeAttribs;
    }

    public static FogStateUnit makeFogStateUnit(InheritedNodeAttributes inheritedNodeAttribs) {
        FogStateUnit stateUnit = new FogStateUnit(inheritedNodeAttribs);
        stateUnit.update(true);
        return stateUnit;
    }
}

