/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.render.states.units;

import org.xith3d.render.states.StateMap;
import org.xith3d.render.states.StateUnit;
import org.xith3d.scenegraph.ColoringAttributes;
import org.xith3d.scenegraph.TexCoordGeneration;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.TextureAttributes;
import org.xith3d.scenegraph.TextureUnit;

public class TextureUnitStateUnit
extends StateUnit {
    public static final int[] STATE_TYPES = new int[8];
    public static final StateMap texAttribsStateMap = new StateMap();
    public static final StateMap texCoorGenStateMap = new StateMap();
    public static final TextureAttributes DEFAULT_TEX_ATTR = new TextureAttributes();
    public static final TexCoordGeneration DEFAULT_TEXCOORD_GEN = new TexCoordGeneration(false);
    public static final TextureUnitStateUnit[] DEFAULT_UNIT = new TextureUnitStateUnit[8];
    private final int unit;
    private Texture texture;
    private TextureAttributes texAttribs;
    private TexCoordGeneration texCoordGen;

    public final int getUnit() {
        return this.unit;
    }

    public final Texture getTexture() {
        return this.texture;
    }

    public final TextureAttributes getTextureAttributes() {
        return this.texAttribs;
    }

    public final TexCoordGeneration getTexCoordGeneration() {
        return this.texCoordGen;
    }

    public ColoringAttributes getNodeComponent() {
        throw new Error();
    }

    public final boolean isTranslucent() {
        return false;
    }

    public final long getStateId() {
        if (this.texture == null) {
            return this.texAttribs.getStateId() << 16 | this.texCoordGen.getStateId();
        }
        return this.texture.getStateId() << 50 | this.texAttribs.getStateId() << 16 | this.texCoordGen.getStateId();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "( unit: " + this.getUnit() + ", state-type: " + this.getStateType() + ", " + "state-ID: " + this.getStateId() + " )";
    }

    public final void update(Texture texture, TextureAttributes texAttribs, TexCoordGeneration texCoordGen) {
        this.texture = texture;
        this.texAttribs = texAttribs != null ? texAttribs : DEFAULT_TEX_ATTR;
        this.texCoordGen = texCoordGen != null ? texCoordGen : DEFAULT_TEXCOORD_GEN;
        texAttribsStateMap.assignState(this.texAttribs);
        texCoorGenStateMap.assignState(this.texCoordGen);
    }

    private TextureUnitStateUnit(int unit, Texture texture, TextureAttributes texAttribs, TexCoordGeneration texCoordGen, boolean isDefault) {
        super(STATE_TYPES[unit], isDefault);
        this.unit = unit;
        this.update(texture, texAttribs, texCoordGen);
    }

    public static TextureUnitStateUnit makeTextureUnitStateUnit(int unit, TextureUnit tu, StateUnit[] cache) {
        if (tu == null) {
            return DEFAULT_UNIT[unit];
        }
        int stateType = STATE_TYPES[unit];
        if (cache[stateType] != null) {
            TextureUnitStateUnit stateUnit = (TextureUnitStateUnit)cache[STATE_TYPES[unit]];
            stateUnit.update(tu.getTexture(), tu.getTextureAttributes(), tu.getTexCoordGeneration());
            return stateUnit;
        }
        TextureUnitStateUnit stateUnit = new TextureUnitStateUnit(unit, tu.getTexture(), tu.getTextureAttributes(), tu.getTexCoordGeneration(), false);
        cache[stateType] = stateUnit;
        return stateUnit;
    }

    static {
        for (int i = 0; i < STATE_TYPES.length; ++i) {
            TextureUnitStateUnit.STATE_TYPES[i] = StateMap.newStateType();
            TextureUnitStateUnit.DEFAULT_UNIT[i] = new TextureUnitStateUnit(i, null, DEFAULT_TEX_ATTR, DEFAULT_TEXCOORD_GEN, true);
        }
    }
}

