/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.resources;

import java.io.IOException;
import java.net.URL;
import org.xith3d.loaders.models.Model;
import org.xith3d.loaders.models.ModelLoader;
import org.xith3d.resources.ResourceBag;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.resources.ResourceRequest;

public class ModelResourceRequest
implements ResourceRequest {
    private final String name;
    private final String bagName;
    private final URL baseURL;
    private final String skin;
    private final float scale;
    private final int flags;

    public final String getName() {
        return this.name;
    }

    public final String getBagName() {
        return this.bagName;
    }

    public final URL getBaseURL() {
        return this.baseURL;
    }

    public final String getSkin() {
        return this.skin;
    }

    public final float getScale() {
        return this.scale;
    }

    public final int getLoadFlags() {
        return this.flags;
    }

    public Object loadResource(ResourceLocator resLoc, ResourceBag resBag) throws IOException {
        ModelLoader loader = ModelLoader.getInstance();
        Model model = this.getSkin() == null ? loader.loadModel(resLoc.getResource(this.getName()), this.getScale(), this.getLoadFlags()) : loader.loadModel(resLoc.getResource(this.getName()), this.getSkin(), this.getScale(), this.getLoadFlags());
        resBag.addModel(this.getBagName(), model);
        return model;
    }

    public ModelResourceRequest(String name, String bagName, URL baseURL, int flags, String skin, float scale) {
        this.name = name;
        this.bagName = bagName;
        this.baseURL = baseURL;
        this.flags = flags;
        this.skin = skin;
        this.scale = scale;
    }

    public ModelResourceRequest(String name, String bagName, URL baseURL, int flags, String skin) {
        this(name, bagName, baseURL, flags, skin, 1.0f);
    }

    public ModelResourceRequest(String name, String bagName, URL baseURL, int flags, float scale) {
        this(name, bagName, baseURL, flags, null, scale);
    }

    public ModelResourceRequest(String name, String bagName, URL baseURL, int flags) {
        this(name, bagName, baseURL, flags, null);
    }

    public ModelResourceRequest(String name, String bagName, URL baseURL) {
        this(name, bagName, baseURL, -1, null);
    }

    public ModelResourceRequest(String name, String bagName, float scale) {
        this(name, bagName, null, -1, null, scale);
    }

    public ModelResourceRequest(String name, String bagName) {
        this(name, bagName, null, -1, null);
    }
}

