/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.resources;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jagatoo.loaders.textures.locators.TextureStreamLocator;
import org.jagatoo.loaders.textures.locators.TextureStreamLocatorURL;
import org.xith3d.loaders.texture.TextureLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceLocator {
    private static ResourceLocator singletonInstance = null;
    private URL baseURL;

    public static void setSingletonInstance(ResourceLocator resLoc) {
        singletonInstance = resLoc;
    }

    public void useAsSingletonInstance() {
        singletonInstance = this;
    }

    public static ResourceLocator getInstance() {
        return singletonInstance;
    }

    protected void setBaseURL(URL baseURL) {
        this.baseURL = baseURL;
    }

    protected void setBaseURL(File baseFolder) throws FileNotFoundException, IllegalArgumentException {
        if (!baseFolder.exists()) {
            throw new FileNotFoundException("The base-folder does not exist (\"" + baseFolder + "\").");
        }
        if (!baseFolder.isDirectory()) {
            throw new IllegalArgumentException("The given base-folder is not a directory (\"" + baseFolder + "\").");
        }
        try {
            this.setBaseURL(baseFolder.toURI().toURL());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    protected void setBaseURL(String foldername) throws FileNotFoundException, IllegalArgumentException {
        this.setBaseURL(new File(foldername));
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    public ResourceLocator getSubLocator(String subResource) throws MalformedURLException {
        if (!(subResource = subResource.replace('\\', '/')).endsWith("/")) {
            subResource = subResource + "/";
        }
        URL subURL = new URL(this.getBaseURL(), subResource);
        return new ResourceLocator(subURL);
    }

    public URL getResource(String name) throws MalformedURLException {
        name = name.replace('\\', '/');
        return new URL(this.getBaseURL(), name);
    }

    public InputStream getResourceAsStream(String name) throws MalformedURLException, IOException {
        URL resource = this.getResource(name);
        return resource.openStream();
    }

    private final int findAllResources(JarEntry[] entries, int i0, String basePath, String extension, boolean recursively, boolean foldersToo, List<URL> resources) {
        for (int i = i0; i < entries.length; ++i) {
            boolean isCandidate;
            JarEntry entry = entries[i];
            if (recursively) {
                isCandidate = entry.getName().startsWith(basePath);
            } else if (entry.isDirectory()) {
                isCandidate = entry.getName().equals(basePath);
            } else {
                int lastSlashPos = entry.getName().lastIndexOf(47);
                isCandidate = entry.getName().substring(lastSlashPos).equals(basePath);
            }
            if (isCandidate) {
                if (!(extension != null && !entry.getName().endsWith(extension) || entry.isDirectory() && !foldersToo)) {
                    resources.add(ResourceLocator.class.getClassLoader().getResource(entry.getName()));
                }
                if (!entry.isDirectory() || !recursively) continue;
                i = this.findAllResources(entries, i + 1, entry.getName(), extension, recursively, foldersToo, resources);
                continue;
            }
            if (resources.size() <= 0) continue;
            return i + 1;
        }
        return 2147483547;
    }

    private final void findAllResources(JarFile jarFile, String basePath, String extension, boolean recursively, boolean foldersToo, List<URL> resources) {
        JarEntry[] entries = new JarEntry[jarFile.size()];
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        int i = 0;
        while (jarEntries.hasMoreElements()) {
            entries[i++] = jarEntries.nextElement();
        }
        this.findAllResources(entries, 0, basePath, extension, recursively, foldersToo, resources);
    }

    private final void findAllResources(File baseFolder, String extension, boolean recursively, boolean foldersToo, List<URL> resources) {
        for (File file : baseFolder.listFiles()) {
            if (!(extension != null && !file.getName().endsWith(extension) || file.isDirectory() && !foldersToo)) {
                try {
                    resources.add(file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            if (!file.isDirectory() || !recursively) continue;
            this.findAllResources(file, extension, recursively, foldersToo, resources);
        }
    }

    public List<URL> findAllResources(String extension, boolean recursively, boolean foldersToo) {
        ArrayList<URL> resources = new ArrayList<URL>();
        if (this.getBaseURL().getProtocol().equals("jar") && this.getBaseURL().getPath().startsWith("file:")) {
            String jarFileName = this.getBaseURL().getPath().substring(5, this.getBaseURL().getPath().indexOf(".jar!") + 4);
            String basePath = this.getBaseURL().getPath().substring(this.getBaseURL().getPath().indexOf(".jar!") + 6);
            try {
                this.findAllResources(new JarFile(jarFileName), basePath, extension, recursively, foldersToo, resources);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.getBaseURL().getProtocol().equals("file")) {
            try {
                this.findAllResources(new File(this.getBaseURL().toURI()), extension, recursively, foldersToo, resources);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return resources;
    }

    public TextureStreamLocatorURL getTSL(String resourceName) throws MalformedURLException {
        if (!(resourceName = resourceName.replace('\\', '/')).endsWith("/")) {
            resourceName = resourceName + "/";
        }
        URL resource = this.getResource(resourceName);
        return new TextureStreamLocatorURL(resource);
    }

    public TextureStreamLocatorURL getTSL() {
        return new TextureStreamLocatorURL(this.getBaseURL());
    }

    public TextureStreamLocator createAndAddTSL(String resourceName) throws MalformedURLException {
        if (!(resourceName = resourceName.replace('\\', '/')).endsWith("/")) {
            resourceName = resourceName + "/";
        }
        URL resource = this.getResource(resourceName);
        TextureStreamLocatorURL tsl = new TextureStreamLocatorURL(resource);
        TextureLoader.getInstance().addTextureStreamLocator((TextureStreamLocator)tsl);
        return tsl;
    }

    public TextureStreamLocator createAndAddTSL() {
        TextureStreamLocatorURL tsl = new TextureStreamLocatorURL(this.getBaseURL());
        TextureLoader.getInstance().addTextureStreamLocator((TextureStreamLocator)tsl);
        return tsl;
    }

    public ResourceLocator(URL baseURL) {
        this.setBaseURL(baseURL);
    }

    protected ResourceLocator(File baseFolder) throws FileNotFoundException, IllegalArgumentException {
        this.setBaseURL(baseFolder);
    }

    protected ResourceLocator(String foldername) throws FileNotFoundException, IllegalArgumentException {
        this.setBaseURL(foldername);
    }

    protected ResourceLocator(Object dummy, String baseResource) {
        baseResource = baseResource.replace('\\', '/');
        if (!baseResource.endsWith("/")) {
            baseResource = baseResource + "/";
        }
        try {
            URL baseURL = ResourceLocator.class.getResource(baseResource);
            if (baseURL != null) {
                this.setBaseURL(baseURL);
                return;
            }
            baseURL = ResourceLocator.class.getClassLoader().getResource(baseResource);
            if (baseURL != null) {
                this.setBaseURL(baseURL);
                return;
            }
            File baseFile = new File(baseResource);
            if (baseFile.exists()) {
                if (!baseFile.isDirectory()) {
                    this.setBaseURL(new File(baseResource).getParentFile());
                    return;
                }
                this.setBaseURL(baseFile);
                return;
            }
            baseFile = new File(System.getProperty("user.dir"), baseResource);
            if (baseFile.exists()) {
                if (!baseFile.isDirectory()) {
                    this.setBaseURL(new File(baseResource).getParentFile());
                    return;
                }
                this.setBaseURL(new File(baseResource));
                return;
            }
            throw new IllegalArgumentException("Resource not found \"" + baseResource + "\"");
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Resource not found \"" + baseResource + "\"", e);
        }
    }

    public static ResourceLocator create(String baseResource) {
        return new ResourceLocator(null, baseResource);
    }
}

