/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.resources;

import java.io.IOException;
import java.net.URL;
import org.xith3d.loaders.shaders.base.ShaderLoader;
import org.xith3d.resources.ResourceBag;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.resources.ResourceRequest;
import org.xith3d.scenegraph.Shader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShaderResourceRequest
implements ResourceRequest {
    private final String name;
    private final String bagName;
    private final Shader.ShaderType type;
    private final URL baseURL;
    private final ShaderLoader<?> loader;

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getBagName() {
        return this.bagName;
    }

    public final Shader.ShaderType getType() {
        return this.type;
    }

    public final URL getBaseURL() {
        return this.baseURL;
    }

    public final ShaderLoader<?> getShaderLoader() {
        return this.loader;
    }

    @Override
    public Object loadResource(ResourceLocator resLoc, ResourceBag resBag) throws IOException {
        ShaderLoader<?> loader = this.getShaderLoader();
        URL tmpURL = loader.getBaseURL();
        if (this.getBaseURL() != null) {
            loader.setBaseURL(this.getBaseURL());
        }
        Object shader = loader.loadShader(resLoc.getResource(this.getName()), this.getType());
        resBag.addShader(this.getBagName(), (Shader)shader);
        if (this.getBaseURL() != null) {
            loader.setBaseURL(tmpURL);
        }
        return shader;
    }

    public ShaderResourceRequest(String name, String bagName, Shader.ShaderType type, URL baseURL, ShaderLoader<?> loader) {
        this.name = name;
        this.bagName = bagName;
        this.type = type;
        this.baseURL = baseURL;
        this.loader = loader;
    }

    public ShaderResourceRequest(String name, String bagName, Shader.ShaderType type, ShaderLoader<?> loader) {
        this(name, bagName, type, null, loader);
    }
}

