/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.jagatoo.opengl.enums.DrawMode;
import org.jagatoo.opengl.enums.FaceCullMode;
import org.openmali.vecmath2.Colorf;
import org.xith3d.effects.EffectFactory;
import org.xith3d.effects.textureprojection.TextureProjectionFactory;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.OpenGLCapabilities;
import org.xith3d.scenegraph.ColoringAttributes;
import org.xith3d.scenegraph.LineAttributes;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.NodeComponent;
import org.xith3d.scenegraph.PointAttributes;
import org.xith3d.scenegraph.PolygonAttributes;
import org.xith3d.scenegraph.ProjectiveTextureUnit;
import org.xith3d.scenegraph.RenderingAttributes;
import org.xith3d.scenegraph.ShaderProgramContext;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.TexCoordGeneration;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.TextureAttributes;
import org.xith3d.scenegraph.TextureUnit;
import org.xith3d.scenegraph.TransparencyAttributes;
import org.xith3d.scenegraph.modifications.ScenegraphModificationsListener;

public class Appearance
extends NodeComponent {
    private ShaderProgramContext<?> shaderProgramContext = null;
    private TransparencyAttributes transparencyAttrs = null;
    private Material material = null;
    private ColoringAttributes coloringAttrs = null;
    private RenderingAttributes renderingAttrs = null;
    private PolygonAttributes polygonAttrs = null;
    private LineAttributes lineAttrs = null;
    private PointAttributes pointAttrs = null;
    private TextureUnit[] textureUnits = null;
    private static long nextChangeId = 1L;
    private long changeID = 0L;
    private static boolean defaultStaticApp = false;
    private boolean staticApp = defaultStaticApp;
    private boolean staticDirty = true;

    public static final void setDefaultStatic(boolean b) {
        defaultStaticApp = b;
    }

    public static final boolean isDefaultStatic() {
        return defaultStaticApp;
    }

    public final void setStatic(boolean b) {
        this.staticApp = b;
    }

    public final boolean isStatic() {
        return this.staticApp;
    }

    public void markStaticDirty() {
        this.staticDirty = true;
    }

    final void markStaticClean() {
        this.staticDirty = false;
    }

    public final boolean isStaticDirty() {
        return this.staticDirty;
    }

    public void setModListener(ScenegraphModificationsListener modListener) {
        super.setModListener(modListener);
        if (this.shaderProgramContext != null) {
            this.shaderProgramContext.setModListener(modListener);
        }
        if (this.transparencyAttrs != null) {
            this.transparencyAttrs.setModListener(modListener);
        }
        if (this.material != null) {
            this.material.setModListener(modListener);
        }
        if (this.coloringAttrs != null) {
            this.coloringAttrs.setModListener(modListener);
        }
        if (this.renderingAttrs != null) {
            this.renderingAttrs.setModListener(modListener);
        }
        if (this.polygonAttrs != null) {
            this.polygonAttrs.setModListener(modListener);
        }
        if (this.lineAttrs != null) {
            this.lineAttrs.setModListener(modListener);
        }
        if (this.pointAttrs != null) {
            this.pointAttrs.setModListener(modListener);
        }
        if (this.textureUnits != null) {
            for (int i = 0; i < this.textureUnits.length; ++i) {
                if (this.textureUnits[i] == null) continue;
                this.textureUnits[i].setModListener(modListener);
            }
        }
    }

    public final void setMaterial(Material material) {
        this.material = material;
        this.setChanged(true);
        if (material != null) {
            material.setModListener(this.getModListener());
        }
    }

    public final Material getMaterial() {
        return this.material;
    }

    public final Material getMaterial(boolean forceExistence) {
        if (forceExistence && this.getMaterial() == null) {
            this.setMaterial(new Material());
        }
        return this.getMaterial();
    }

    public final void setTexture(int unit, Texture texture) {
        if (this.textureUnits == null) {
            this.textureUnits = new TextureUnit[unit + 1];
            this.textureUnits[unit] = new TextureUnit(texture);
        } else if (this.textureUnits.length <= unit) {
            TextureUnit[] textureUnits = new TextureUnit[unit + 1];
            System.arraycopy(this.textureUnits, 0, textureUnits, 0, this.textureUnits.length);
            textureUnits[unit] = new TextureUnit(texture);
            this.textureUnits = textureUnits;
        } else if (this.textureUnits[unit] == null) {
            this.textureUnits[unit] = new TextureUnit(texture);
        } else {
            this.textureUnits[unit].setTexture(texture);
        }
        if (texture != null) {
            texture.setChanged(true);
        }
        this.setChanged(true);
        if (texture != null) {
            texture.setModListener(this.getModListener());
        }
    }

    public final void setTexture(Texture texture) {
        this.setTexture(0, texture);
    }

    public final void setTexture(int unit, String texture) {
        if (texture == null) {
            this.setTexture(unit, (Texture)null);
        } else {
            this.setTexture(unit, TextureLoader.getInstance().getTexture(texture));
        }
    }

    public final void setTexture(String texture) {
        if (texture == null) {
            this.setTexture(0, (Texture)null);
        } else {
            this.setTexture(0, TextureLoader.getInstance().getTexture(texture));
        }
    }

    public final Texture getTexture(int unit) {
        if (this.textureUnits == null || this.textureUnits.length <= unit || this.textureUnits[unit] == null) {
            return null;
        }
        return this.textureUnits[unit].getTexture();
    }

    public final Texture getTexture() {
        return this.getTexture(0);
    }

    public final void setTextureAttributes(int unit, TextureAttributes textureAttribs) {
        if (this.textureUnits == null) {
            this.textureUnits = new TextureUnit[unit + 1];
            this.textureUnits[unit] = new TextureUnit((Texture)null, textureAttribs);
        } else if (this.textureUnits.length <= unit) {
            TextureUnit[] textureUnits = new TextureUnit[unit + 1];
            System.arraycopy(this.textureUnits, 0, textureUnits, 0, this.textureUnits.length);
            textureUnits[unit] = new TextureUnit((Texture)null, textureAttribs);
            this.textureUnits = textureUnits;
        } else if (this.textureUnits[unit] == null) {
            this.textureUnits[unit] = new TextureUnit((Texture)null, textureAttribs);
        } else {
            this.textureUnits[unit].setTextureAttributes(textureAttribs);
        }
        if (textureAttribs != null) {
            textureAttribs.setChanged(true);
        }
        this.setChanged(true);
        if (textureAttribs != null) {
            textureAttribs.setModListener(this.getModListener());
        }
    }

    public final void setTextureAttributes(TextureAttributes textureAttribs) {
        this.setTextureAttributes(0, textureAttribs);
    }

    public final TextureAttributes getTextureAttributes(int unit) {
        if (this.textureUnits == null || this.textureUnits.length <= unit || this.textureUnits[unit] == null) {
            return null;
        }
        return this.textureUnits[unit].getTextureAttributes();
    }

    public final TextureAttributes getTextureAttributes(int unit, boolean forceExistence) {
        if (this.getTextureAttributes(unit) == null && forceExistence) {
            this.setTextureAttributes(unit, new TextureAttributes());
        }
        return this.getTextureAttributes(unit);
    }

    public final TextureAttributes getTextureAttributes() {
        return this.getTextureAttributes(0);
    }

    public final TextureAttributes getTextureAttributes(boolean forceExistence) {
        if (this.getTextureAttributes() == null && forceExistence) {
            this.setTextureAttributes(new TextureAttributes());
        }
        return this.getTextureAttributes();
    }

    public final void setTexCoordGeneration(int unit, TexCoordGeneration texCoordGen) {
        if (this.textureUnits == null) {
            this.textureUnits = new TextureUnit[unit + 1];
            this.textureUnits[unit] = new TextureUnit((Texture)null, null, texCoordGen);
        } else if (this.textureUnits.length <= unit) {
            TextureUnit[] textureUnits = new TextureUnit[unit + 1];
            System.arraycopy(this.textureUnits, 0, textureUnits, 0, this.textureUnits.length);
            textureUnits[unit] = new TextureUnit((Texture)null, null, texCoordGen);
            this.textureUnits = textureUnits;
        } else if (this.textureUnits[unit] == null) {
            this.textureUnits[unit] = new TextureUnit((Texture)null, null, texCoordGen);
        } else {
            this.textureUnits[unit].setTexCoordGeneration(texCoordGen);
        }
        if (texCoordGen != null) {
            texCoordGen.setChanged(true);
        }
        this.setChanged(true);
        if (texCoordGen != null) {
            texCoordGen.setModListener(this.getModListener());
        }
    }

    public final void setTexCoordGeneration(TexCoordGeneration texCoordGen) {
        this.setTexCoordGeneration(0, texCoordGen);
    }

    public final TexCoordGeneration getTexCoordGeneration(int unit) {
        if (this.textureUnits == null || this.textureUnits.length <= unit || this.textureUnits[unit] == null) {
            return null;
        }
        return this.textureUnits[unit].getTexCoordGeneration();
    }

    public final TexCoordGeneration getTexCoordGeneration(int unit, boolean forceExistence) {
        if (this.getTexCoordGeneration(unit) == null && forceExistence) {
            this.setTexCoordGeneration(unit, new TexCoordGeneration());
        }
        return this.getTexCoordGeneration(unit);
    }

    public final TexCoordGeneration getTexCoordGeneration() {
        return this.getTexCoordGeneration(0);
    }

    public final TexCoordGeneration getTexCoordGeneration(boolean forceExistence) {
        if (this.getTexCoordGeneration() == null && forceExistence) {
            this.setTexCoordGeneration(new TexCoordGeneration());
        }
        return this.getTexCoordGeneration();
    }

    private static final void applyProjTU(Appearance app, ProjectiveTextureUnit projTU) {
        TextureProjectionFactory texProjFact;
        EffectFactory effFact = EffectFactory.getInstance();
        if (effFact != null && (texProjFact = effFact.getTextureProjectionFactory()) != null) {
            texProjFact.onProjectiveTextureApplied(app, projTU);
        }
    }

    public final void setTextureUnits(TextureUnit ... textureUnits) {
        TextureUnit tu;
        int i;
        if (this.textureUnits != null) {
            for (i = 0; i < this.textureUnits.length; ++i) {
                tu = this.textureUnits[i];
                if (tu instanceof ProjectiveTextureUnit) {
                    Appearance.applyProjTU(null, (ProjectiveTextureUnit)tu);
                }
                tu.setModListener(null);
            }
        }
        if (textureUnits == null) {
            this.textureUnits = null;
        } else {
            if (this.textureUnits == null || this.textureUnits.length != textureUnits.length) {
                this.textureUnits = new TextureUnit[textureUnits.length];
            }
            System.arraycopy(textureUnits, 0, this.textureUnits, 0, textureUnits.length);
        }
        if (this.textureUnits != null) {
            for (i = 0; i < this.textureUnits.length; ++i) {
                tu = this.textureUnits[i];
                if (tu instanceof ProjectiveTextureUnit) {
                    Appearance.applyProjTU(this, (ProjectiveTextureUnit)tu);
                }
                tu.setModListener(this.getModListener());
            }
        }
        this.setChanged(true);
    }

    public final void setTextureUnit(int index, TextureUnit tu) {
        TextureUnit tu_;
        if (this.textureUnits != null && this.textureUnits.length > index && this.textureUnits[index] != null) {
            tu_ = this.textureUnits[index];
            if (tu_ instanceof ProjectiveTextureUnit) {
                Appearance.applyProjTU(null, (ProjectiveTextureUnit)tu_);
            }
            tu_.setModListener(null);
        }
        if (this.textureUnits == null) {
            this.textureUnits = new TextureUnit[index + 1];
        } else if (this.textureUnits.length <= index) {
            TextureUnit[] textureUnits2 = new TextureUnit[index + 1];
            System.arraycopy(this.textureUnits, 0, textureUnits2, 0, this.textureUnits.length);
            this.textureUnits = textureUnits2;
        }
        this.textureUnits[index] = tu;
        this.setChanged(true);
        if (this.textureUnits[index] != null) {
            tu_ = this.textureUnits[index];
            if (tu_ instanceof ProjectiveTextureUnit) {
                Appearance.applyProjTU(this, (ProjectiveTextureUnit)tu_);
            }
            tu_.setModListener(this.getModListener());
        }
    }

    public final TextureUnit[] getTextureUnits() {
        return this.textureUnits;
    }

    public TextureUnit getTextureUnit(int index) {
        if (this.textureUnits == null || this.textureUnits.length <= index) {
            return null;
        }
        return this.textureUnits[index];
    }

    public int getTextureUnitsCount() {
        if (this.textureUnits == null) {
            return 0;
        }
        return this.textureUnits.length;
    }

    public final void setShaderProgramContext(ShaderProgramContext shaderProgramContext) {
        this.shaderProgramContext = shaderProgramContext;
        this.setChanged(true);
        if (shaderProgramContext != null) {
            shaderProgramContext.setModListener(this.getModListener());
        }
    }

    public final ShaderProgramContext getShaderProgramContext() {
        return this.shaderProgramContext;
    }

    public final void setColoringAttributes(ColoringAttributes coloringAttrs) {
        this.coloringAttrs = coloringAttrs;
        this.setChanged(true);
        if (coloringAttrs != null) {
            coloringAttrs.setModListener(this.getModListener());
        }
    }

    public final ColoringAttributes getColoringAttributes() {
        return this.coloringAttrs;
    }

    public final ColoringAttributes getColoringAttributes(boolean forceExistance) {
        if (this.getColoringAttributes() == null && forceExistance) {
            this.setColoringAttributes(new ColoringAttributes());
        }
        return this.getColoringAttributes();
    }

    public final void setTransparencyAttributes(TransparencyAttributes transparencyAttrs) {
        this.transparencyAttrs = transparencyAttrs;
        this.setChanged(true);
        if (transparencyAttrs != null) {
            transparencyAttrs.setModListener(this.getModListener());
        }
    }

    public final TransparencyAttributes getTransparencyAttributes() {
        return this.transparencyAttrs;
    }

    public final TransparencyAttributes getTransparencyAttributes(boolean forceExistance) {
        if (this.getTransparencyAttributes() == null && forceExistance) {
            this.setTransparencyAttributes(new TransparencyAttributes());
        }
        return this.getTransparencyAttributes();
    }

    public final void setRenderingAttributes(RenderingAttributes renderingAttrs) {
        this.renderingAttrs = renderingAttrs;
        this.setChanged(true);
        if (renderingAttrs != null) {
            renderingAttrs.setModListener(this.getModListener());
        }
    }

    public final RenderingAttributes getRenderingAttributes() {
        return this.renderingAttrs;
    }

    public final RenderingAttributes getRenderingAttributes(boolean forceExistence) {
        if (this.getRenderingAttributes() == null && forceExistence) {
            this.setRenderingAttributes(new RenderingAttributes());
        }
        return this.getRenderingAttributes();
    }

    public final void setPolygonAttributes(PolygonAttributes polygonAttrs) {
        this.polygonAttrs = polygonAttrs;
        this.setChanged(true);
        if (polygonAttrs != null) {
            polygonAttrs.setModListener(this.getModListener());
        }
    }

    public final PolygonAttributes getPolygonAttributes() {
        return this.polygonAttrs;
    }

    public final PolygonAttributes getPolygonAttributes(boolean forceExistence) {
        if (this.getPolygonAttributes() == null && forceExistence) {
            this.setPolygonAttributes(new PolygonAttributes());
        }
        return this.getPolygonAttributes();
    }

    public final void setLineAttributes(LineAttributes lineAttrs) {
        this.lineAttrs = lineAttrs;
        this.setChanged(true);
        if (lineAttrs != null) {
            lineAttrs.setModListener(this.getModListener());
        }
    }

    public final LineAttributes getLineAttributes() {
        return this.lineAttrs;
    }

    public final LineAttributes getLineAttributes(boolean forceExistence) {
        if (this.getLineAttributes() == null && forceExistence) {
            this.setLineAttributes(new LineAttributes());
        }
        return this.getLineAttributes();
    }

    public final void setPointAttributes(PointAttributes pointAttrs) {
        this.pointAttrs = pointAttrs;
        this.setChanged(true);
        if (pointAttrs != null) {
            pointAttrs.setModListener(this.getModListener());
        }
    }

    public final PointAttributes getPointAttributes() {
        return this.pointAttrs;
    }

    public final PointAttributes getPointAttributes(boolean forceExistance) {
        if (this.getPointAttributes() == null && forceExistance) {
            this.setPointAttributes(new PointAttributes());
        }
        return this.getPointAttributes();
    }

    public void setChanged(boolean changed) {
        super.setChanged(changed);
        if (!changed) {
            if (this.shaderProgramContext != null) {
                this.shaderProgramContext.setChanged(false);
            }
            if (this.coloringAttrs != null) {
                this.coloringAttrs.setChanged(false);
            }
            if (this.material != null) {
                this.material.setChanged(false);
            }
            if (this.transparencyAttrs != null) {
                this.transparencyAttrs.setChanged(false);
            }
            if (this.renderingAttrs != null) {
                this.renderingAttrs.setChanged(false);
            }
            if (this.polygonAttrs != null) {
                this.polygonAttrs.setChanged(false);
            }
            if (this.lineAttrs != null) {
                this.lineAttrs.setChanged(false);
            }
            if (this.pointAttrs != null) {
                this.pointAttrs.setChanged(false);
            }
            if (this.textureUnits != null) {
                for (int i = 0; i < this.textureUnits.length; ++i) {
                    if (this.textureUnits[i] == null) continue;
                    this.textureUnits[i].setChanged(false);
                }
            }
        }
    }

    public void setChangedRecursive(boolean changed) {
        super.setChanged(changed);
        if (this.shaderProgramContext != null) {
            this.shaderProgramContext.setChanged(changed);
        }
        if (this.coloringAttrs != null) {
            this.coloringAttrs.setChanged(changed);
        }
        if (this.material != null) {
            this.material.setChanged(changed);
        }
        if (this.transparencyAttrs != null) {
            this.transparencyAttrs.setChanged(changed);
        }
        if (this.renderingAttrs != null) {
            this.renderingAttrs.setChanged(changed);
        }
        if (this.polygonAttrs != null) {
            this.polygonAttrs.setChanged(changed);
        }
        if (this.lineAttrs != null) {
            this.lineAttrs.setChanged(changed);
        }
        if (this.pointAttrs != null) {
            this.pointAttrs.setChanged(changed);
        }
        if (this.textureUnits != null) {
            for (int i = 0; i < this.textureUnits.length; ++i) {
                if (this.textureUnits[i] == null) continue;
                this.textureUnits[i].setChangedRecursive(changed);
            }
        }
    }

    public final long verifyChange(Shape3D shape, OpenGLCapabilities glCaps) {
        if (this.isChanged()) {
            this.changeID = nextChangeId++;
            if (!this.isStatic() || this.isStaticDirty()) {
                shape.getAtom().updateStateUnits(this, glCaps);
            }
            this.setChanged(false);
        }
        return this.changeID;
    }

    public void setColor(Colorf color) {
        this.getColoringAttributes(true).setColor(color);
    }

    public void setColor(float r, float g, float b) {
        this.getColoringAttributes(true).setColor(r, g, b);
    }

    public void setFaceCullMode(FaceCullMode mode) {
        this.getPolygonAttributes(true).setFaceCullMode(mode);
    }

    public void setDrawMode(DrawMode drawMode) {
        this.getPolygonAttributes(true).setDrawMode(drawMode);
    }

    public boolean isChanged() {
        if (super.isChanged()) {
            return true;
        }
        if (this.shaderProgramContext != null && this.shaderProgramContext.isChanged()) {
            return true;
        }
        if (this.coloringAttrs != null && this.coloringAttrs.isChanged()) {
            return true;
        }
        if (this.material != null && this.material.isChanged()) {
            return true;
        }
        if (this.transparencyAttrs != null && this.transparencyAttrs.isChanged()) {
            return true;
        }
        if (this.renderingAttrs != null && this.renderingAttrs.isChanged()) {
            return true;
        }
        if (this.polygonAttrs != null && this.polygonAttrs.isChanged()) {
            return true;
        }
        if (this.lineAttrs != null && this.lineAttrs.isChanged()) {
            return true;
        }
        if (this.pointAttrs != null && this.pointAttrs.isChanged()) {
            return true;
        }
        if (this.textureUnits != null) {
            for (int i = 0; i < this.textureUnits.length; ++i) {
                if (this.textureUnits[i] == null || !this.textureUnits[i].isChanged()) continue;
                return true;
            }
        }
        return false;
    }

    protected void duplicateNodeComponent(NodeComponent originalNodeComponent, boolean forceDuplicate) {
        super.duplicateNodeComponent(originalNodeComponent, forceDuplicate);
        Appearance origApp = (Appearance)originalNodeComponent;
        if (origApp.getTextureUnits() != null) {
            TextureUnit[] origTUs = origApp.getTextureUnits();
            TextureUnit[] clonedTUs = new TextureUnit[origTUs.length];
            for (int i = 0; i < origTUs.length; ++i) {
                clonedTUs[i] = origTUs[i].cloneNodeComponent(forceDuplicate);
            }
            this.setTextureUnits(clonedTUs);
        }
        if (forceDuplicate) {
            if (origApp.getMaterial() != null) {
                this.setMaterial(origApp.getMaterial().cloneNodeComponent(true));
            }
            this.setShaderProgramContext(origApp.getShaderProgramContext());
            if (origApp.getColoringAttributes() != null) {
                this.setColoringAttributes(origApp.getColoringAttributes().cloneNodeComponent(true));
            }
            if (origApp.getTransparencyAttributes() != null) {
                this.setTransparencyAttributes(origApp.getTransparencyAttributes().cloneNodeComponent(true));
            }
            if (origApp.getRenderingAttributes() != null) {
                this.setRenderingAttributes(origApp.getRenderingAttributes().cloneNodeComponent(true));
            }
            if (origApp.getPolygonAttributes() != null) {
                this.setPolygonAttributes(origApp.getPolygonAttributes().cloneNodeComponent(true));
            }
            if (origApp.getLineAttributes() != null) {
                this.setLineAttributes(origApp.getLineAttributes().cloneNodeComponent(true));
            }
            if (origApp.getPointAttributes() != null) {
                this.setPointAttributes(origApp.getPointAttributes().cloneNodeComponent(true));
            }
        } else {
            this.setMaterial(origApp.getMaterial());
            this.setShaderProgramContext(origApp.getShaderProgramContext());
            this.setColoringAttributes(origApp.getColoringAttributes());
            this.setTransparencyAttributes(origApp.getTransparencyAttributes());
            this.setRenderingAttributes(origApp.getRenderingAttributes());
            this.setPolygonAttributes(origApp.getPolygonAttributes());
            this.setLineAttributes(origApp.getLineAttributes());
            this.setPointAttributes(origApp.getPointAttributes());
        }
    }

    public Appearance cloneNodeComponent(boolean forceDuplicate) {
        Appearance a = new Appearance();
        a.duplicateNodeComponent(this, forceDuplicate);
        return a;
    }

    public void freeOpenGLResources(CanvasPeer canvasPeer) {
        if (this.shaderProgramContext != null) {
            this.shaderProgramContext.freeOpenGLResources(canvasPeer);
        }
        if (this.transparencyAttrs != null) {
            this.transparencyAttrs.freeOpenGLResources(canvasPeer);
        }
        if (this.material != null) {
            this.material.freeOpenGLResources(canvasPeer);
        }
        if (this.coloringAttrs != null) {
            this.coloringAttrs.freeOpenGLResources(canvasPeer);
        }
        if (this.renderingAttrs != null) {
            this.renderingAttrs.freeOpenGLResources(canvasPeer);
        }
        if (this.polygonAttrs != null) {
            this.polygonAttrs.freeOpenGLResources(canvasPeer);
        }
        if (this.lineAttrs != null) {
            this.lineAttrs.freeOpenGLResources(canvasPeer);
        }
        if (this.pointAttrs != null) {
            this.pointAttrs.freeOpenGLResources(canvasPeer);
        }
        if (this.textureUnits != null) {
            for (int i = 0; i < this.textureUnits.length; ++i) {
                if (this.textureUnits[i] == null) continue;
                this.textureUnits[i].freeOpenGLResources(canvasPeer);
            }
        }
    }

    public Appearance() {
        super(false);
    }

    public Appearance(Texture texture) {
        this();
        this.setTexture(texture);
    }

    public Appearance(String texture) {
        this();
        this.setTexture(texture);
    }
}

