/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.jagatoo.opengl.enums.ShadeModel;
import org.openmali.vecmath2.Colorf;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.states.StateNode;
import org.xith3d.render.states.StateTrackable;
import org.xith3d.scenegraph.NodeComponent;
import org.xith3d.utility.comparator.ComparatorHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColoringAttributes
extends NodeComponent
implements StateTrackable<ColoringAttributes> {
    public static final ShadeModel SHADE_FLAT = ShadeModel.FLAT;
    public static final ShadeModel SHADE_GOURAUD = ShadeModel.GOURAUD;
    public static final ShadeModel FASTEST = ShadeModel.FASTEST;
    public static final ShadeModel NICEST = ShadeModel.NICEST;
    private final Colorf color = new Colorf(1.0f, 1.0f, 1.0f);
    private ShadeModel shadeModel = ShadeModel.GOURAUD;
    private StateNode stateNode = null;
    private long stateId = -1L;

    public final void setColor(float r, float g, float b) {
        this.color.set(r, g, b);
        this.setChanged(true);
    }

    public final void setColor(Colorf color) {
        this.color.set(color);
        this.setChanged(true);
    }

    public final Colorf getColor(Colorf color) {
        color.set(this.color);
        return color;
    }

    public final Colorf getColor() {
        return this.color.getReadOnly();
    }

    public final void setShadeModel(ShadeModel model) {
        this.shadeModel = model;
        this.setChanged(true);
    }

    public final ShadeModel getShadeModel() {
        return this.shadeModel;
    }

    @Override
    public final void setStateNode(StateNode node) {
        this.stateNode = node;
        this.stateId = node.getId();
    }

    @Override
    public final StateNode getStateNode() {
        return this.stateNode;
    }

    public final long getStateId() {
        return this.stateId;
    }

    @Override
    public ColoringAttributes getCopy() {
        return this.cloneNodeComponent(true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ColoringAttributes)) {
            return false;
        }
        ColoringAttributes co = (ColoringAttributes)o;
        if (ComparatorHelper.compare(this.color, co.color) != 0) {
            return false;
        }
        return this.shadeModel == co.shadeModel;
    }

    @Override
    public int compareTo(ColoringAttributes o) {
        if (this == o) {
            return 0;
        }
        int val = ComparatorHelper.compare(this.color, o.color);
        if (val != 0) {
            return val;
        }
        if (this.shadeModel.ordinal() < o.shadeModel.ordinal()) {
            return -1;
        }
        if (this.shadeModel.ordinal() > o.shadeModel.ordinal()) {
            return 1;
        }
        return 0;
    }

    @Override
    protected void duplicateNodeComponent(NodeComponent original, boolean forceDuplicate) {
        super.duplicateNodeComponent(original, forceDuplicate);
        ColoringAttributes o = (ColoringAttributes)original;
        this.setColor(o.getColor());
        this.setShadeModel(o.getShadeModel());
    }

    @Override
    public ColoringAttributes cloneNodeComponent(boolean forceDuplicate) {
        ColoringAttributes ca = new ColoringAttributes();
        ca.duplicateNodeComponent(this, forceDuplicate);
        return ca;
    }

    @Override
    public void freeOpenGLResources(CanvasPeer canvasPeer) {
    }

    public ColoringAttributes() {
        super(false);
    }

    public ColoringAttributes(float r, float g, float b, ShadeModel shadeModel) {
        this();
        this.color.set(r, g, b);
        this.shadeModel = shadeModel;
    }

    public ColoringAttributes(float r, float g, float b) {
        this(r, g, b, ShadeModel.GOURAUD);
    }

    public ColoringAttributes(Colorf color, ShadeModel shadeModel) {
        this(color.getRed(), color.getGreen(), color.getBlue(), shadeModel);
    }

    public ColoringAttributes(Colorf color) {
        this(color.getRed(), color.getGreen(), color.getBlue());
    }

    public ColoringAttributes(ShadeModel shadeModel) {
        this(Colorf.WHITE, shadeModel);
    }
}

