/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Tuple3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.scenegraph.Light;
import org.xith3d.scenegraph.Node;

public class DirectionalLight
extends Light {
    public static final Vector3f DEFAULT_DIRECTION = Vector3f.newReadOnly((float)0.0f, (float)0.0f, (float)-1.0f);
    private Node trackedNode = null;
    private final Vector3f direction = new Vector3f((Tuple3f)DEFAULT_DIRECTION);

    public void setTrackedNode(Node node) {
        this.trackedNode = node;
    }

    public final Node getTrackedNode() {
        return this.trackedNode;
    }

    public void setDirection(float dirX, float dirY, float dirZ) {
        this.direction.set(dirX, dirY, dirZ);
    }

    public final void setDirection(Vector3f direction) {
        this.setDirection(direction.getX(), direction.getY(), direction.getZ());
    }

    public final Vector3f getDirection() {
        return this.direction.getReadOnly();
    }

    public final Vector3f getDirection(Vector3f direction) {
        direction.set((TupleNf)this.direction);
        return direction;
    }

    public final void getComputedDirection(Vector3f direction) {
        if (this.getTrackedNode() == null) {
            this.getDirection(direction);
        } else {
            this.getTrackedNode().getWorldTransform().transform(this.getDirection(), direction);
        }
    }

    public DirectionalLight(boolean enabled, float colorR, float colorG, float colorB, float dirX, float dirY, float dirZ) {
        super(enabled, colorR, colorG, colorB);
        this.direction.set(dirX, dirY, dirZ);
    }

    public DirectionalLight(float colorR, float colorG, float colorB, float dirX, float dirY, float dirZ) {
        this(true, colorR, colorG, colorB, dirX, dirY, dirZ);
    }

    protected static final Vector3f getDir(Vector3f dir) {
        return dir == null ? DEFAULT_DIRECTION : dir;
    }

    public DirectionalLight(boolean enabled, Colorf color, Vector3f direction) {
        this(enabled, DirectionalLight.getCol(color).getRed(), DirectionalLight.getCol(color).getGreen(), DirectionalLight.getCol(color).getBlue(), DirectionalLight.getDir(direction).getX(), DirectionalLight.getDir(direction).getY(), DirectionalLight.getDir(direction).getZ());
    }

    public DirectionalLight(Colorf color, Vector3f direction) {
        this(true, color, direction);
    }

    public DirectionalLight(boolean enabled) {
        this(enabled, DEFAULT_COLOR, DEFAULT_DIRECTION);
    }

    public DirectionalLight() {
        this(true);
    }

    public DirectionalLight(boolean enabled, float colorR, float colorG, float colorB, Node trackedNode, float dirX, float dirY, float dirZ) {
        this(enabled, colorR, colorG, colorB, dirX, dirY, dirZ);
        this.setTrackedNode(trackedNode);
    }

    public DirectionalLight(boolean enabled, float colorR, float colorG, float colorB, Node trackedNode) {
        this(enabled, colorR, colorG, colorB, trackedNode, DEFAULT_DIRECTION.getX(), DEFAULT_DIRECTION.getY(), DEFAULT_DIRECTION.getZ());
    }

    public DirectionalLight(float colorR, float colorG, float colorB, Node trackedNode) {
        this(true, colorR, colorG, colorB, trackedNode);
    }

    public DirectionalLight(boolean enabled, Colorf color, Node trackedNode) {
        this(enabled, DirectionalLight.getCol(color).getRed(), DirectionalLight.getCol(color).getGreen(), DirectionalLight.getCol(color).getBlue(), trackedNode);
    }

    public DirectionalLight(boolean enabled, Colorf color, Node trackedNode, Vector3f direction) {
        this(enabled, DirectionalLight.getCol(color).getRed(), DirectionalLight.getCol(color).getGreen(), DirectionalLight.getCol(color).getBlue(), trackedNode, direction.getX(), direction.getY(), direction.getZ());
    }

    public DirectionalLight(Colorf color, Node trackedNode) {
        this(true, color, trackedNode);
    }

    public DirectionalLight(Colorf color, Node trackedNode, Vector3f direction) {
        this(true, color, trackedNode, direction);
    }

    public DirectionalLight(boolean enabled, Node trackedNode) {
        this(enabled);
        this.setTrackedNode(trackedNode);
    }

    public DirectionalLight(Node trackedNode) {
        this(true, trackedNode);
    }
}

