/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.xith3d.render.CanvasPeer;
import org.xith3d.render.SceneGraphOpenGLReferences;
import org.xith3d.scenegraph.GLSLFragmentShader;
import org.xith3d.scenegraph.GLSLShader;
import org.xith3d.scenegraph.GLSLVertexShader;
import org.xith3d.scenegraph.NodeComponent;
import org.xith3d.scenegraph.ShaderProgram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GLSLShaderProgram
extends ShaderProgram<GLSLShader> {
    protected boolean linked = false;
    protected boolean linkingError = false;
    private final SceneGraphOpenGLReferences openGLReferences = new SceneGraphOpenGLReferences(1);

    public final SceneGraphOpenGLReferences getOpenGLReferences() {
        return this.openGLReferences;
    }

    protected void finalize() {
        this.openGLReferences.prepareObjectForDestroy();
    }

    @Override
    public void freeOpenGLResources(CanvasPeer canvasPeer) {
        if (this.openGLReferences.referenceExists(canvasPeer)) {
            this.openGLReferences.prepareObjectForDestroy(canvasPeer);
        }
        super.freeOpenGLResources(canvasPeer);
    }

    final void setLinked(boolean linked) {
        this.linked = linked;
    }

    public final boolean isLinked() {
        return this.linked;
    }

    final void setLinkingError(boolean linkingError) {
        this.linkingError = linkingError;
    }

    public final boolean hasLinkingError() {
        return this.linkingError;
    }

    @Override
    public GLSLShaderProgram getCopy() {
        return this.cloneNodeComponent(true);
    }

    @Override
    protected void duplicateNodeComponent(NodeComponent original, boolean forceDuplicate) {
        GLSLShaderProgram orgSP = (GLSLShaderProgram)original;
        this.removeAllShaders();
        if (forceDuplicate) {
            int i;
            for (i = 0; i < this.getNumVertexShaders(); ++i) {
                this.addShader(orgSP.getVertexShader(i));
            }
            for (i = 0; i < this.getNumFragmentShaders(); ++i) {
                this.addShader(orgSP.getFragmentShader(i));
            }
        } else {
            int i;
            this.openGLReferences.set(orgSP.openGLReferences);
            for (i = 0; i < this.getNumVertexShaders(); ++i) {
                this.addShader(orgSP.getVertexShader(i));
            }
            for (i = 0; i < this.getNumFragmentShaders(); ++i) {
                this.addShader(orgSP.getFragmentShader(i));
            }
            this.linked = orgSP.linked;
        }
    }

    @Override
    public GLSLShaderProgram cloneNodeComponent(boolean forceDuplicate) {
        GLSLShaderProgram clone = new GLSLShaderProgram(this.isEnabled());
        clone.duplicateNodeComponent(this, forceDuplicate);
        return clone;
    }

    @Override
    public boolean equals(Object o) {
        int i;
        if (this == o) {
            return true;
        }
        if (!(o instanceof GLSLShaderProgram)) {
            return false;
        }
        GLSLShaderProgram lo = (GLSLShaderProgram)o;
        if (this.isEnabled() != lo.isEnabled()) {
            return false;
        }
        if (this.getNumVertexShaders() != lo.getNumVertexShaders()) {
            return false;
        }
        if (this.getNumFragmentShaders() != lo.getNumFragmentShaders()) {
            return false;
        }
        for (i = 0; i < this.getNumVertexShaders(); ++i) {
            if (((GLSLShader)this.getVertexShader(i)).equals(lo.getVertexShader(i))) continue;
            return false;
        }
        for (i = 0; i < this.getNumFragmentShaders(); ++i) {
            if (((GLSLShader)this.getFragmentShader(i)).equals(lo.getFragmentShader(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(ShaderProgram<GLSLShader> o) {
        int i;
        if (this == o) {
            return 0;
        }
        if (this.getNumVertexShaders() > o.getNumVertexShaders()) {
            return 1;
        }
        if (this.getNumVertexShaders() < o.getNumVertexShaders()) {
            return -1;
        }
        if (this.getNumFragmentShaders() > o.getNumFragmentShaders()) {
            return 1;
        }
        if (this.getNumFragmentShaders() < o.getNumFragmentShaders()) {
            return -1;
        }
        int result = 0;
        for (i = 0; i < this.getNumVertexShaders(); ++i) {
            result += ((GLSLShader)this.getVertexShader(i)).compareTo(o.getVertexShader(i));
        }
        for (i = 0; i < this.getNumFragmentShaders(); ++i) {
            result += ((GLSLShader)this.getFragmentShader(i)).compareTo(o.getFragmentShader(i));
        }
        if (result > 0) {
            return 1;
        }
        if (result < 0) {
            return -1;
        }
        return 0;
    }

    public GLSLShaderProgram(boolean enabled) {
        super(enabled);
    }

    public GLSLShaderProgram() {
        this(true);
    }

    public GLSLShaderProgram(GLSLVertexShader vertexShader, GLSLFragmentShader fragmentShader, boolean enabled) {
        this(enabled);
        if (vertexShader != null) {
            this.addShader(vertexShader);
        }
        if (fragmentShader != null) {
            this.addShader(fragmentShader);
        }
    }

    public GLSLShaderProgram(GLSLVertexShader vertexShader, GLSLFragmentShader fragmentShader) {
        this(vertexShader, fragmentShader, true);
    }
}

