/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import java.util.ArrayList;
import java.util.List;
import org.jagatoo.logging.LogChannel;
import org.jagatoo.logging.ProfileTimer;
import org.openmali.spatial.bodies.BodyInterface;
import org.openmali.spatial.bounds.BoundingSphere;
import org.openmali.spatial.bounds.Bounds;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.Clipper;
import org.xith3d.render.ClipperInfo;
import org.xith3d.render.ScissorRect;
import org.xith3d.render.preprocessing.ShadowAtom;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Fog;
import org.xith3d.scenegraph.IllegalSceneGraphOperation;
import org.xith3d.scenegraph.InheritedNodeAttributes;
import org.xith3d.scenegraph.Leaf;
import org.xith3d.scenegraph.Light;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.traversal.TraversalCallback;
import org.xith3d.scenegraph.utils.CopyListener;
import org.xith3d.utility.logging.X3DLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GroupNode
extends Node {
    protected final GroupNode hostGroup;
    protected Node[] children = null;
    protected int numChildren = 0;
    protected long totalNumChildren = 0L;
    protected long totalNumShapes = 0L;
    private ShadowAtom shadowAtom = null;
    private ScissorRect scissorRect = null;
    private Clipper clipper = null;
    private static final Bounds EMPTY_BOUNDS = new BoundingSphere();
    private static BoundingSphere tmpBounds = new BoundingSphere();
    private GroupNode pickHost = null;
    private boolean isPickHost = false;

    @Override
    protected boolean setLive(boolean live) {
        if (!super.setLive(live)) {
            return false;
        }
        int n = this.numChildren();
        for (int i = 0; i < n; ++i) {
            this.getChild(i).setLive(live);
        }
        return true;
    }

    protected void setPickHost(GroupNode pickHost) {
        if (!this.isPickHost()) {
            this.pickHost = pickHost;
            int n = this.numChildren();
            for (int i = 0; i < n; ++i) {
                Node child = this.getChild(i);
                if (child instanceof Leaf) {
                    ((Leaf)child).setPickHost(pickHost);
                    continue;
                }
                if (!(child instanceof GroupNode)) continue;
                ((GroupNode)child).setPickHost(pickHost);
            }
        }
    }

    public final GroupNode getPickHost() {
        return this.pickHost;
    }

    public void setPickHost(boolean isPickHost) {
        if (this.isPickHost == isPickHost) {
            return;
        }
        this.isPickHost = isPickHost;
        GroupNode ph = this.isPickHost() ? this : this.getPickHost();
        int n = this.numChildren();
        for (int i = 0; i < n; ++i) {
            GroupNode g;
            Node child = this.getChild(i);
            if (child instanceof Leaf) {
                ((Leaf)child).setPickHost(ph);
                continue;
            }
            if (!(child instanceof GroupNode) || (g = (GroupNode)child).isPickHost()) continue;
            g.setPickHost(ph);
        }
    }

    public boolean isPickHost() {
        return this.isPickHost;
    }

    final void setAtom(ShadowAtom shadowAtom) {
        this.shadowAtom = shadowAtom;
    }

    final ShadowAtom getAtom() {
        return this.shadowAtom;
    }

    protected final void checkChild(Node child, int index) {
        if (child == this) {
            throw new IllegalSceneGraphOperation("You cannot add a Group to itself.");
        }
        if (child == null) {
            throw new IllegalSceneGraphOperation("You cannot add null to a group.");
        }
        if (child.getParent() != null) {
            throw new IllegalSceneGraphOperation("This Node already has a parent.");
        }
        if (child instanceof BranchGroup) {
            throw new IllegalSceneGraphOperation("You cannot add a (root) BranchGroup to another group.");
        }
        if (index > this.numChildren || index < 0) {
            throw new ArrayIndexOutOfBoundsException("Illegal index " + index);
        }
    }

    @Override
    protected void mergeInheritedNodes(InheritedNodeAttributes in) {
        super.mergeInheritedNodes(in);
        int n = this.numChildren();
        for (int i = 0; i < n; ++i) {
            this.getChild(i).mergeInheritedNodes(in);
        }
    }

    @Override
    protected void unmergeInheritedNodes(InheritedNodeAttributes in) {
        super.unmergeInheritedNodes(in);
        int n = this.numChildren();
        for (int i = 0; i < n; ++i) {
            this.getChild(i).unmergeInheritedNodes(in);
        }
    }

    @Override
    protected void unmergeInheritedLight(Light light) {
        super.unmergeInheritedLight(light);
        int n = this.numChildren();
        for (int i = 0; i < n; ++i) {
            this.getChild(i).unmergeInheritedLight(light);
        }
    }

    @Override
    protected void unmergeInheritedFog(Fog fog) {
        super.unmergeInheritedFog(fog);
        int n = this.numChildren();
        for (int i = 0; i < n; ++i) {
            this.getChild(i).unmergeInheritedFog(fog);
        }
    }

    protected boolean ensureCapacity(int minCapacity) {
        if (this.children == null) {
            this.children = new Node[Math.max(minCapacity, 8)];
            return true;
        }
        int oldCapacity = this.children.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            Node[] newArray = new Node[newCapacity];
            System.arraycopy(this.children, 0, newArray, 0, oldCapacity);
            this.children = newArray;
            return true;
        }
        return false;
    }

    void addTotalNumChildrenFromChild(long additionalTotalNumChildren, long additionalTotalNumShapes) {
        this.totalNumChildren += additionalTotalNumChildren;
        this.totalNumShapes += additionalTotalNumShapes;
        if (this.getParent() != null) {
            this.getParent().addTotalNumChildrenFromChild(additionalTotalNumChildren, additionalTotalNumShapes);
        }
    }

    public void addChild(Node child, int index) {
        if (this.hostGroup != null) {
            this.hostGroup.addChild(child, index);
            return;
        }
        this.checkChild(child, index);
        this.ensureCapacity(index + 1);
        if (index < this.numChildren) {
            System.arraycopy(this.children, index, this.children, index + 1, this.numChildren - index);
        }
        this.children[index] = child;
        ++this.numChildren;
        child.setParent(this);
        long tnc = this.totalNumChildren++;
        long tns = this.totalNumShapes++;
        if (child instanceof GroupNode) {
            GroupNode childGroup = (GroupNode)child;
            childGroup.setPickHost(this.isPickHost() ? this : this.getPickHost());
            this.totalNumChildren += 1L + childGroup.totalNumChildren;
            this.totalNumShapes += childGroup.totalNumShapes;
        } else if (child instanceof Leaf) {
            if (child instanceof Shape3D) {
                // empty if block
            }
            ((Leaf)child).setPickHost(this.isPickHost() ? this : this.getPickHost());
        }
        if (this.getParent() != null) {
            this.getParent().addTotalNumChildrenFromChild(this.totalNumChildren - tnc, this.totalNumShapes - tns);
        }
        if (child instanceof Light) {
            this.getInheritedNodeAttributes().addLight((Light)child);
            this.mergeInheritedNodes(this.getInheritedNodeAttributes());
        } else if (child instanceof Fog) {
            this.getInheritedNodeAttributes().addFog((Fog)child);
            this.mergeInheritedNodes(this.getInheritedNodeAttributes());
        } else {
            child.mergeInheritedNodes(this.getInheritedNodeAttributes());
        }
        if (this.getModListener() != null) {
            this.getModListener().onChildAddedToGroup(this, child);
        }
    }

    public final void addChild(Node child) {
        this.addChild(child, this.numChildren());
    }

    public Node removeChild(int index) {
        if (this.hostGroup != null) {
            return this.hostGroup.removeChild(index);
        }
        if (index >= this.numChildren) {
            throw new IllegalArgumentException("This child does not exist in this group");
        }
        Node child = this.children[index];
        if (child == null) {
            throw new IllegalArgumentException("This child does not exist in this group");
        }
        if (this.getModListener() != null) {
            this.getModListener().onChildRemovedFromGroup(this, child);
        }
        this.children[index] = null;
        System.arraycopy(this.children, index + 1, this.children, index, this.numChildren - index - 1);
        --this.numChildren;
        child.setParent(null);
        child.setModListener(null);
        long tnc = this.totalNumChildren--;
        long tns = this.totalNumShapes--;
        if (child instanceof GroupNode) {
            GroupNode childGroup = (GroupNode)child;
            ((GroupNode)child).setPickHost(null);
            this.totalNumChildren -= 1L + childGroup.totalNumChildren;
        } else if (child instanceof Leaf) {
            if (child instanceof Shape3D) {
                // empty if block
            }
            ((Leaf)child).setPickHost(null);
        }
        if (this.getParent() != null) {
            this.getParent().addTotalNumChildrenFromChild(this.totalNumChildren - tnc, this.totalNumShapes - tns);
        }
        if (child instanceof Light) {
            this.unmergeInheritedLight((Light)child);
            child.getInheritedNodeAttributes().removeLight((Light)child);
        } else if (child instanceof Fog) {
            this.unmergeInheritedFog((Fog)child);
            child.getInheritedNodeAttributes().removeFog((Fog)child);
        } else {
            child.unmergeInheritedNodes(this.getInheritedNodeAttributes());
        }
        return child;
    }

    public final int indexOf(Node child) {
        if (this.hostGroup != null) {
            return this.hostGroup.indexOf(child);
        }
        if (child == null) {
            throw new NullPointerException("child is null");
        }
        for (int i = 0; i < this.numChildren; ++i) {
            if (!child.equals(this.children[i])) continue;
            return i;
        }
        return -1;
    }

    public final int removeChild(Node child) {
        int index = this.indexOf(child);
        if (index == -1) {
            throw new IllegalArgumentException("This child does not exist in this group");
        }
        this.removeChild(index);
        return index;
    }

    public void removeAllChildren() {
        int n = this.numChildren();
        for (int i = n - 1; i >= 0; --i) {
            this.removeChild(i);
        }
    }

    public Node setChild(Node child, int index) {
        if (this.hostGroup != null) {
            return this.hostGroup.setChild(child, index);
        }
        this.checkChild(child, index);
        Node prevChild = index == this.numChildren ? null : this.removeChild(index);
        this.addChild(child, index);
        return prevChild;
    }

    public final Node getChild(int index) {
        if (this.hostGroup != null) {
            return this.hostGroup.getChild(index);
        }
        if (index < 0 || index >= this.numChildren) {
            return null;
        }
        return this.children[index];
    }

    public final int numChildren() {
        if (this.hostGroup != null) {
            return this.hostGroup.numChildren();
        }
        return this.numChildren;
    }

    public final long getTotalNumChildren() {
        if (this.hostGroup != null) {
            return this.hostGroup.getTotalNumChildren();
        }
        return this.totalNumChildren;
    }

    public final long getTotalNumShapes() {
        if (this.hostGroup != null) {
            return this.hostGroup.getTotalNumShapes();
        }
        return this.totalNumShapes;
    }

    public final <L extends List<Node>> L getChildren(L list) {
        if (this.hostGroup != null) {
            return this.hostGroup.getChildren(list);
        }
        for (int i = 0; i < this.numChildren; ++i) {
            list.add((Node)this.children[i]);
        }
        return list;
    }

    @Deprecated
    public ArrayList<Node> getChildren() {
        return this.getChildren(new ArrayList(this.numChildren()));
    }

    @Override
    protected void setBoundsDirtyUpward() {
        this.boundsDirty = true;
        if (this.getParent() != null) {
            this.getParent().setBoundsDirtyUpward();
        }
    }

    @Override
    protected void setBoundsDirty() {
        this.setBoundsDirtyUpward();
    }

    protected final void expandBounds(Node node, boolean forceNodeUpdate) {
        if (this.isIgnoreBounds() || node.isIgnoreBounds() || !this.boundsAutoCompute) {
            return;
        }
        ProfileTimer.startProfile((LogChannel)X3DLog.LOG_CHANNEL, (String)"Node::expandBounds");
        node.updateBoundsCheap(false, true, false, true);
        int num = this.numChildren();
        if (num == 0 || num == 1 && this.getChild(0) == node) {
            this.untransformedBounds.set(node.getBounds());
        } else {
            this.untransformedBounds.combine((BodyInterface)node.getBounds());
        }
        this.bounds.set(this.untransformedBounds);
        if (this instanceof TransformGroup) {
            this.bounds.transform(((TransformGroup)this).getTransform().getMatrix4f());
        }
        this.getWorldBounds().set(this.untransformedBounds);
        this.getWorldBounds().transform(this.getWorldTransform().getMatrix4f());
        GroupNode parent = this.getParent();
        if (parent != null) {
            if (!parent.boundsDirty) {
                parent.expandBounds(this, false);
            } else {
                parent.updateBoundsCheap(true, false, true, false);
            }
        }
        ProfileTimer.endProfile();
    }

    @Override
    protected void updateBoundsCheap(boolean onlyDirty, boolean childrenToo, boolean parentToo, boolean onlyWorld) {
        if (this.isIgnoreBounds() || !this.boundsDirty && onlyDirty) {
            return;
        }
        if (this.boundsAutoCompute) {
            GroupNode parent;
            if (this.numChildren() == 0) {
                this.untransformedBounds.set(EMPTY_BOUNDS);
                this.bounds.set(EMPTY_BOUNDS);
                this.getWorldBounds().set(this.untransformedBounds);
                if (this.getWorldTransform() != null) {
                    this.getWorldBounds().transform(this.getWorldTransform().getMatrix4f());
                }
            } else {
                boolean firstValidBounds = true;
                int n = this.numChildren();
                for (int i = 0; i < n; ++i) {
                    Node node = this.getChild(i);
                    if (node.isIgnoreBounds()) continue;
                    if (childrenToo) {
                        node.updateBoundsCheap(onlyDirty, childrenToo, false, onlyWorld);
                    }
                    if (!onlyWorld) {
                        tmpBounds.set(node.untransformedBounds);
                        if (this instanceof TransformGroup) {
                            tmpBounds.transform(((TransformGroup)this).getTransform().getMatrix4f());
                        }
                    }
                    if (firstValidBounds) {
                        firstValidBounds = false;
                        if (!onlyWorld) {
                            this.untransformedBounds.set(node.getBounds());
                        }
                        this.getWorldBounds().set(node.getWorldBounds());
                        continue;
                    }
                    if (!onlyWorld) {
                        this.untransformedBounds.combine((BodyInterface)node.getBounds());
                    }
                    this.getWorldBounds().combine((BodyInterface)node.getWorldBounds());
                }
                this.bounds.set(this.untransformedBounds);
                if (this instanceof TransformGroup) {
                    this.bounds.transform(((TransformGroup)this).getTransform().getMatrix4f());
                }
            }
            this.boundsDirty = false;
            if (parentToo && (parent = this.getParent()) != null) {
                parent.boundsDirty = true;
                parent.updateBoundsCheap(onlyDirty, false, parentToo, onlyWorld);
            }
        } else {
            super.updateBoundsCheap(onlyDirty, childrenToo, parentToo, onlyWorld);
        }
    }

    @Override
    public void updateBounds(boolean onlyDirty) {
        this.updateBoundsCheap(onlyDirty, true, true, false);
    }

    public void setShowBounds(boolean show, boolean childrenToo) {
        super.setShowBounds(show);
        if (childrenToo) {
            int numChildren = this.numChildren();
            for (int i = 0; i < numChildren; ++i) {
                Node child = this.getChild(i);
                if (child instanceof GroupNode) {
                    ((GroupNode)child).setShowBounds(show, childrenToo);
                    continue;
                }
                child.setShowBounds(show);
            }
        }
    }

    @Override
    protected void mergeInheritedScissorRect(ScissorRect scissorRect) {
        if (this.scissorRect != null && this.scissorRect != scissorRect) {
            return;
        }
        super.mergeInheritedScissorRect(scissorRect);
        int n = this.numChildren();
        for (int i = 0; i < n; ++i) {
            this.getChild(i).mergeInheritedScissorRect(scissorRect);
        }
    }

    public void setScissorRect(ScissorRect scissorRect) {
        if (this.scissorRect == scissorRect) {
            return;
        }
        ScissorRect oldValue = this.scissorRect;
        this.scissorRect = scissorRect;
        this.mergeInheritedScissorRect(scissorRect);
        if (this.getModListener() != null) {
            this.getModListener().onScissorRectChanged(this, oldValue, scissorRect);
        }
    }

    public final ScissorRect getScissorRect() {
        return this.scissorRect;
    }

    @Override
    protected void mergeInheritedClipper(Clipper clipper, ClipperInfo clipperInfo) {
        if (this.clipper != null && this.clipper != clipper) {
            return;
        }
        if (clipper != null && clipperInfo == null) {
            TransformGroup tg = this.getTransformGroup();
            clipperInfo = new ClipperInfo(clipper, tg == null ? null : tg.getTransform());
        }
        super.mergeInheritedClipper(clipper, clipperInfo);
        int n = this.numChildren();
        for (int i = 0; i < n; ++i) {
            this.getChild(i).mergeInheritedClipper(clipper, clipperInfo);
        }
    }

    public void setClipper(Clipper clipper) {
        if (this.clipper == clipper) {
            return;
        }
        Clipper oldValue = this.clipper;
        this.clipper = clipper;
        this.mergeInheritedClipper(clipper, null);
        if (this.getModListener() != null) {
            this.getModListener().onClipperChanged(this, oldValue, clipper);
        }
    }

    public final Clipper getClipper() {
        return this.clipper;
    }

    protected abstract GroupNode newInstance();

    @Override
    public GroupNode sharedCopy(CopyListener listener) {
        GroupNode newGroup = this.newInstance();
        int numChildren = this.numChildren();
        for (int i = 0; i < numChildren; ++i) {
            newGroup.addChild(this.getChild(i).sharedCopy(listener));
        }
        if (this.isOccluder()) {
            newGroup.setIsOccluder(true);
        }
        newGroup.boundsDirty = true;
        newGroup.updateBounds(true);
        newGroup.setPickable(this.isPickable());
        newGroup.setRenderable(this.isRenderable());
        newGroup.setName(this.getName());
        if (listener != null) {
            listener.onNodeCopied(this, newGroup, true);
        }
        return newGroup;
    }

    @Override
    public GroupNode sharedCopy() {
        return (GroupNode)super.sharedCopy();
    }

    @Override
    public void absorbDetails(Node node) {
        assert (node instanceof GroupNode) : "The given node is not a GroupNode.";
        GroupNode group = (GroupNode)node;
        this.removeAllChildren();
        int n = this.numChildren();
        for (int i = 0; i < n; ++i) {
            this.addChild(this.getChild(i).sharedCopy());
        }
        this.setIsOccluder(group.isOccluder());
        this.boundsDirty = true;
        this.updateBounds(true);
        this.setPickable(group.isPickable());
        this.setPickable(group.isRenderable());
    }

    @Override
    protected void dump(int indent) {
        System.out.println(this.getIndentString(indent) + this);
        for (int i = 0; i < this.numChildren(); ++i) {
            this.getChild(i).dump(indent + 1);
        }
    }

    public void dump() {
        System.out.println("dumping group " + this.toString());
        this.dump(0);
    }

    @Override
    public void freeOpenGLResources(CanvasPeer canvasPeer) {
        for (int i = 0; i < this.numChildren(); ++i) {
            this.getChild(i).freeOpenGLResources(canvasPeer);
        }
    }

    @Override
    public boolean traverse(TraversalCallback callback) {
        if (!callback.traversalOperation(this)) {
            return false;
        }
        if (callback.traversalCheckGroup(this)) {
            int numChildren = this.numChildren();
            for (int i = 0; i < numChildren; ++i) {
                if (this.getChild(i).traverse(callback)) continue;
                return false;
            }
        }
        return true;
    }

    public Node findFirst(final String name) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MyTraversalCallback
        implements TraversalCallback {
            public Node foundNode = null;

            MyTraversalCallback() {
            }

            @Override
            public boolean traversalCheckGroup(GroupNode group) {
                return true;
            }

            @Override
            public boolean traversalOperation(Node node) {
                if (name == null && node.getName() == null || node.getName().equals(name)) {
                    this.foundNode = node;
                    return false;
                }
                return true;
            }
        }
        MyTraversalCallback tcb = new MyTraversalCallback();
        this.traverse(tcb);
        return tcb.foundNode;
    }

    public List<Node> findAll(final String name) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MyTraversalCallback
        implements TraversalCallback {
            public ArrayList<Node> foundNodes = null;

            MyTraversalCallback() {
            }

            @Override
            public boolean traversalCheckGroup(GroupNode group) {
                return true;
            }

            @Override
            public boolean traversalOperation(Node node) {
                if (name == null && node.getName() == null || node.getName().equals(name)) {
                    if (this.foundNodes == null) {
                        this.foundNodes = new ArrayList();
                    }
                    this.foundNodes.add(node);
                }
                return true;
            }
        }
        MyTraversalCallback tcb = new MyTraversalCallback();
        this.traverse(tcb);
        return tcb.foundNodes;
    }

    public <NT extends Node> NT findFirst(final Class<NT> searchedClass) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MyTraversalCallback
        implements TraversalCallback {
            public NT foundNode = null;

            MyTraversalCallback() {
            }

            @Override
            public boolean traversalCheckGroup(GroupNode group) {
                return true;
            }

            @Override
            public boolean traversalOperation(Node node) {
                if (searchedClass.isAssignableFrom(node.getClass())) {
                    this.foundNode = node;
                    return false;
                }
                return true;
            }
        }
        MyTraversalCallback tcb = new MyTraversalCallback();
        this.traverse(tcb);
        return tcb.foundNode;
    }

    public <NT extends Node> List<NT> findAll(final Class<NT> searchedClass) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MyTraversalCallback
        implements TraversalCallback {
            public ArrayList<NT> foundNodes = null;

            MyTraversalCallback() {
            }

            @Override
            public boolean traversalCheckGroup(GroupNode group) {
                return true;
            }

            @Override
            public boolean traversalOperation(Node node) {
                if (searchedClass.isAssignableFrom(node.getClass())) {
                    if (this.foundNodes == null) {
                        this.foundNodes = new ArrayList();
                    }
                    this.foundNodes.add(node);
                    return true;
                }
                return true;
            }
        }
        MyTraversalCallback tcb = new MyTraversalCallback();
        this.traverse(tcb);
        return tcb.foundNodes;
    }

    public GroupNode(GroupNode hostGroup) {
        this.hostGroup = hostGroup;
        if (hostGroup == null) {
            this.children = null;
            this.numChildren = 0;
        } else {
            this.children = new Node[]{hostGroup};
            this.numChildren = 1;
        }
    }

    public GroupNode() {
        this(null);
    }
}

