/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.jagatoo.opengl.enums.GeometryArrayType;
import org.openmali.spatial.WriteableTriangleContainer;
import org.openmali.spatial.polygons.Triangle;
import org.xith3d.scenegraph.IndexedGeometryStripArray;
import org.xith3d.scenegraph.NodeComponent;

public class IndexedTriangleStripArray
extends IndexedGeometryStripArray
implements WriteableTriangleContainer {
    private final int triangleCount;

    public final boolean isTriangulatable() {
        return true;
    }

    public final boolean isTriangulated() {
        return true;
    }

    public int getTriangleCount() {
        return this.triangleCount;
    }

    public boolean setTriangle(int i, Triangle triangle) {
        int[] stripLengths = this.getStripVertexCounts();
        int offset = 0;
        for (int j = 0; j < stripLengths.length; ++j) {
            int stripTriangCount = stripLengths[j] - 2;
            if (i < offset + stripTriangCount) {
                int[] index = this.getIndex();
                int index_index0 = j * 2 + i;
                int idx0 = index[index_index0 + 0];
                int idx1 = index[index_index0 + 1];
                int idx2 = index[index_index0 + 2];
                return this.setTriangle(idx0, idx1, idx2, triangle);
            }
            offset += stripTriangCount;
        }
        return false;
    }

    public boolean getTriangle(int i, Triangle triangle) {
        int[] stripLengths = this.getStripVertexCounts();
        int offset = 0;
        for (int j = 0; j < stripLengths.length; ++j) {
            int stripTriangCount = stripLengths[j] - 2;
            if (i < offset + stripTriangCount) {
                int idx2;
                int idx1;
                int idx0;
                int[] index = this.getIndex();
                int index_index0 = i;
                if (i % 2 == 0) {
                    idx0 = index[index_index0 + 0];
                    idx1 = index[index_index0 + 1];
                    idx2 = index[index_index0 + 2];
                } else {
                    idx0 = index[index_index0 + 1];
                    idx1 = index[index_index0 + 0];
                    idx2 = index[index_index0 + 2];
                }
                return this.getTriangle(idx0, idx1, idx2, triangle);
            }
            offset += stripTriangCount;
        }
        return false;
    }

    protected void duplicateNodeComponent(NodeComponent original, boolean forceDuplicate) {
        super.duplicateNodeComponent(original, forceDuplicate);
    }

    public IndexedTriangleStripArray cloneNodeComponent(boolean forceDuplicate) {
        IndexedTriangleStripArray itsa = new IndexedTriangleStripArray(this.getCoordinatesSize(), this.getVertexCount(), this.getIndexCount(), this.getStripVertexCounts());
        itsa.duplicateNodeComponent(this, forceDuplicate);
        return itsa;
    }

    private int computeTriangleCount(int[] stripIndexCounts) {
        if (stripIndexCounts != null) {
            int triangleCount = 0;
            for (int i = 0; i < stripIndexCounts.length; ++i) {
                triangleCount += stripIndexCounts[i] - 2;
            }
            return triangleCount;
        }
        return this.getValidVertexCount();
    }

    public IndexedTriangleStripArray(int coordsSize, int vertexCount, int indexCount, int[] stripIndexCounts) {
        super(GeometryArrayType.TRIANGLE_STRIP, coordsSize, vertexCount, indexCount, stripIndexCounts);
        this.triangleCount = this.computeTriangleCount(stripIndexCounts);
    }

    public IndexedTriangleStripArray(int vertexCount, int indexCount, int[] stripIndexCounts) {
        this(3, vertexCount, indexCount, stripIndexCounts);
    }

    public IndexedTriangleStripArray(int coordsSize, int vertexCount, int indexCount) {
        this(coordsSize, vertexCount, indexCount, new int[]{indexCount});
    }

    public IndexedTriangleStripArray(int vertexCount, int indexCount) {
        this(3, vertexCount, indexCount, new int[]{indexCount});
    }
}

