/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.jagatoo.util.arrays.ArrayUtils;
import org.openmali.vecmath2.Point3f;
import org.xith3d.scenegraph.LazyLoadable;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.Switch;
import org.xith3d.scenegraph.utils.CopyListener;
import org.xith3d.scenegraph.utils.LODWorkerThread;
import org.xith3d.utility.logging.X3DLog;

public class LODSwitch
extends Switch {
    private static final long ETERNAL = -1L;
    private static final long INACTIVE = 0L;
    private float[] minDistances = new float[16];
    private float[] maxDistances = new float[16];
    private long[] lastActive = new long[16];
    private boolean first = true;
    private boolean containsLazyLoadables = false;
    private final Point3f translation = new Point3f();
    private int pendingChange = -1;
    private volatile boolean pendingSetUpFinished = false;

    public final float getMinDist(int index) {
        if (index < 0 || index >= this.numChildren()) {
            throw new ArrayIndexOutOfBoundsException("There's no item with the index " + index);
        }
        return this.minDistances[index];
    }

    public final float getMinDist(Node item) {
        int index = this.indexOf(item);
        return this.getMinDist(index);
    }

    public final float getMaxDist(int index) {
        if (index < 0 || index >= this.numChildren()) {
            throw new ArrayIndexOutOfBoundsException("There's no item with the index " + index);
        }
        return this.maxDistances[index];
    }

    public final float getMaxDist(Node item) {
        int index = this.indexOf(item);
        return this.getMaxDist(index);
    }

    protected void setLODChild(int index) {
        final Node child = this.getChild(index);
        if (child == null) {
            super.setWhichChild(-1);
        }
        if (!this.containsLazyLoadables || !(child instanceof LazyLoadable) || ((LazyLoadable)((Object)child)).isSetUp()) {
            super.setWhichChild(index);
            return;
        }
        this.pendingChange = index;
        LODWorkerThread.getInstance().enqueue(new Runnable(){

            public void run() {
                try {
                    ((LazyLoadable)((Object)child)).prepare();
                }
                catch (Throwable t) {
                    X3DLog.print(t);
                }
                LODSwitch.this.pendingSetUpFinished = true;
            }
        });
    }

    @Deprecated
    public void setWhichChild(int whichChild) {
        throw new UnsupportedOperationException("The child selection is managed by the Switch.");
    }

    private void checkAndTearDownChildren() {
        int currentIndex = this.getWhichChild();
        int num = this.numChildren() - 1;
        long current = System.currentTimeMillis();
        long max = 60000L;
        for (int i = 0; i < num; ++i) {
            int x = currentIndex - i;
            if (x == 0 || this.lastActive[i] <= 0L || this.lastActive[i] + 60000L >= current) continue;
            final LazyLoadable child = (LazyLoadable)((Object)this.getChild(i));
            if (!child.isSetUp()) break;
            this.lastActive[i] = 0L;
            child.tearDown();
            LODWorkerThread.getInstance().enqueue(new Runnable(){

                public void run() {
                    child.cleanUp();
                }
            });
            break;
        }
    }

    public void updateWhichChild(Point3f viewPosition) {
        if (this.containsLazyLoadables) {
            this.checkAndTearDownChildren();
        }
        if (this.numChildren() == 0) {
            super.setWhichChild(-1);
            return;
        }
        if (this.first) {
            this.setLODChild(this.numChildren() - 1);
            this.first = false;
            return;
        }
        if (this.pendingChange != -1) {
            if (this.pendingSetUpFinished) {
                Node child = this.getChild(this.pendingChange);
                if (child != null && child instanceof LazyLoadable) {
                    ((LazyLoadable)((Object)child)).setUp();
                }
                this.pendingChange = -1;
                this.pendingSetUpFinished = false;
            }
            return;
        }
        if (this.getWhichChild() < 0) {
            this.setLODChild(0);
            return;
        }
        int currentIndex = this.getWhichChild();
        this.getWorldTransform().getTranslation(this.translation);
        float dist = this.translation.distance(viewPosition);
        if (dist < this.minDistances[currentIndex]) {
            if (this.lastActive[currentIndex] != -1L) {
                this.lastActive[currentIndex] = System.currentTimeMillis();
            }
            for (int i = currentIndex - 1; i >= 0; --i) {
                if (!(dist <= this.maxDistances[i]) || !(dist >= this.minDistances[i])) continue;
                this.setLODChild(i);
                return;
            }
            super.setWhichChild(-1);
        } else if (dist > this.maxDistances[currentIndex]) {
            if (this.lastActive[currentIndex] != -1L) {
                this.lastActive[currentIndex] = System.currentTimeMillis();
            }
            for (int i = currentIndex + 1; i < this.numChildren(); ++i) {
                if (!(dist <= this.maxDistances[i]) || !(dist >= this.minDistances[i])) continue;
                this.setLODChild(i);
                return;
            }
            super.setWhichChild(-1);
        }
    }

    public int addLODItem(Node item, float minDist, float maxDist) {
        if (minDist > maxDist) {
            throw new IllegalArgumentException("minDist (" + minDist + ") is greater than maxDist (" + maxDist + ")");
        }
        if (this.numChildren() == 0) {
            this.minDistances[0] = minDist;
            this.maxDistances[0] = maxDist;
            super.addChild(item, 0);
            return 0;
        }
        int index = -1;
        for (int i = 0; i < this.numChildren(); ++i) {
            if (!(this.minDistances[i] > minDist)) continue;
            index = i;
            break;
        }
        if (index < 0) {
            index = this.numChildren();
        }
        if (index > 0 && this.minDistances[index - 1] > minDist) {
            throw new IllegalArgumentException("minDist MUST NOT overlap two items.");
        }
        if (index < this.numChildren() - 1 && this.maxDistances[index + 1] < maxDist) {
            throw new IllegalArgumentException("maxDist MUST NOT overlap two items.");
        }
        this.minDistances = ArrayUtils.ensureCapacity((float[])this.minDistances, (int)(this.numChildren() + 1));
        this.maxDistances = ArrayUtils.ensureCapacity((float[])this.maxDistances, (int)(this.numChildren() + 1));
        this.lastActive = ArrayUtils.ensureCapacity((long[])this.lastActive, (int)(this.numChildren() + 1));
        if (index < this.numChildren()) {
            System.arraycopy(this.minDistances, index, this.minDistances, index + 1, this.numChildren() - index);
            System.arraycopy(this.maxDistances, index, this.maxDistances, index + 1, this.numChildren() - index);
            System.arraycopy(this.lastActive, index, this.lastActive, index + 1, this.numChildren() - index);
        }
        this.minDistances[index] = minDist;
        this.maxDistances[index] = maxDist;
        this.lastActive[index] = 0L;
        this.containsLazyLoadables |= item instanceof LazyLoadable;
        super.addChild(item, index);
        return index;
    }

    private final boolean recheckContainsLazyLoadables() {
        this.containsLazyLoadables = false;
        int n = this.numChildren();
        for (int i = 0; i < n; ++i) {
            if (!(this.getChild(i) instanceof LazyLoadable)) continue;
            this.containsLazyLoadables = true;
            break;
        }
        return this.containsLazyLoadables;
    }

    protected void setLODItem(int index, Node item, boolean itemChanged, float minDist, float maxDist) {
        if (index < 0 || index >= this.numChildren()) {
            throw new ArrayIndexOutOfBoundsException("There's no item with the index " + index);
        }
        if (index > 0 && this.minDistances[index - 1] > minDist) {
            throw new IllegalArgumentException("minDist MUST NOT overlap two items.");
        }
        if (index < this.numChildren() - 1 && this.maxDistances[index + 1] < maxDist) {
            throw new IllegalArgumentException("maxDist MUST NOT overlap two items.");
        }
        this.minDistances[index] = minDist;
        this.maxDistances[index] = maxDist;
        if (itemChanged) {
            Node oldItem = this.setChild(item, index);
            if (oldItem instanceof LazyLoadable) {
                if (!(item instanceof LazyLoadable)) {
                    this.lastActive[index] = 0L;
                    this.recheckContainsLazyLoadables();
                }
            } else if (item instanceof LazyLoadable) {
                this.lastActive[index] = 0L;
                this.recheckContainsLazyLoadables();
            }
        }
    }

    public final void setLODItem(int index, Node item, float minDist, float maxDist) {
        boolean itemChanged = this.getChild(index) != item;
        this.setLODItem(index, item, itemChanged, minDist, maxDist);
    }

    public final void setLODItem(int index, float minDist, float maxDist) {
        this.setLODItem(index, null, false, minDist, maxDist);
    }

    public void removeLODItem(int index) {
        if (index < 0 || index >= this.numChildren()) {
            throw new IllegalArgumentException("There is no LODItem with that index.");
        }
        int n = this.numChildren();
        System.arraycopy(this.minDistances, 0, this.minDistances, 0, index);
        System.arraycopy(this.minDistances, index + 1, this.minDistances, index, n - index - 1);
        System.arraycopy(this.maxDistances, 0, this.maxDistances, 0, index);
        System.arraycopy(this.maxDistances, index + 1, this.maxDistances, index, n - index - 1);
        System.arraycopy(this.lastActive, 0, this.lastActive, 0, index);
        System.arraycopy(this.lastActive, index + 1, this.lastActive, index, n - index - 1);
        this.removeChild(index);
        if (this.containsLazyLoadables) {
            this.recheckContainsLazyLoadables();
        }
    }

    public void removeLODItem(Node node) {
        int index = this.indexOf(node);
        if (index < 0) {
            throw new IllegalArgumentException("There is no such LODItem.");
        }
        this.removeLODItem(index);
    }

    protected LODSwitch newInstance() {
        boolean gib = Node.globalIgnoreBounds;
        Node.globalIgnoreBounds = this.isIgnoreBounds();
        LODSwitch s = new LODSwitch();
        Node.globalIgnoreBounds = gib;
        return s;
    }

    public LODSwitch sharedCopy(CopyListener listener) {
        LODSwitch copy = (LODSwitch)super.sharedCopy(listener);
        copy.minDistances = new float[this.minDistances.length];
        System.arraycopy(this.minDistances, 0, copy.minDistances, 0, this.minDistances.length);
        copy.maxDistances = new float[this.maxDistances.length];
        System.arraycopy(this.maxDistances, 0, copy.maxDistances, 0, this.maxDistances.length);
        if (listener != null) {
            listener.onNodeCopied(this, copy, true);
        }
        return copy;
    }

    public LODSwitch sharedCopy() {
        return (LODSwitch)super.sharedCopy();
    }

    public LODSwitch() {
        super(-1);
    }
}

