/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.jagatoo.opengl.enums.ColorTarget;
import org.openmali.vecmath2.Colorf;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.states.StateNode;
import org.xith3d.render.states.StateTrackable;
import org.xith3d.scenegraph.NodeComponent;
import org.xith3d.utility.comparator.ComparatorHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Material
extends NodeComponent
implements StateTrackable<Material> {
    private StateNode stateNode = null;
    private long stateId = -1L;
    private final Colorf ambient = new Colorf(0.2f, 0.2f, 0.2f);
    private final Colorf emissive = new Colorf(0.0f, 0.0f, 0.0f);
    private final Colorf diffuse = new Colorf(1.0f, 1.0f, 1.0f);
    private final Colorf specular = new Colorf(1.0f, 1.0f, 1.0f);
    private float shininess = 64.0f;
    private boolean lightingEnabled = true;
    private boolean normalizeNormals = true;
    public static final ColorTarget NONE = ColorTarget.NONE;
    public static final ColorTarget AMBIENT = ColorTarget.AMBIENT;
    public static final ColorTarget EMISSIVE = ColorTarget.EMISSIVE;
    public static final ColorTarget DIFFUSE = ColorTarget.DIFFUSE;
    public static final ColorTarget SPECULAR = ColorTarget.SPECULAR;
    public static final ColorTarget AMBIENT_AND_DIFFUSE = ColorTarget.AMBIENT_AND_DIFFUSE;
    private ColorTarget colorTarget = ColorTarget.NONE;

    public final void setAmbientColor(Colorf color) {
        this.ambient.set(color);
        this.setChanged(true);
    }

    public final void setAmbientColor(float r, float g, float b) {
        this.ambient.set(r, g, b);
        this.setChanged(true);
    }

    public final void getAmbientColor(Colorf c) {
        c.set(this.ambient);
    }

    public final Colorf getAmbientColor() {
        return this.ambient.getReadOnly();
    }

    public final void setEmissiveColor(Colorf color) {
        this.emissive.set(color);
        this.setChanged(true);
    }

    public final void setEmissiveColor(float r, float g, float b) {
        this.emissive.set(r, g, b);
        this.setChanged(true);
    }

    public final void getEmissiveColor(Colorf c) {
        c.set(this.emissive);
    }

    public final Colorf getEmissiveColor() {
        return this.emissive.getReadOnly();
    }

    public final void setDiffuseColor(Colorf color) {
        this.diffuse.set(color);
        this.setChanged(true);
    }

    public final void setDiffuseColor(float r, float g, float b) {
        this.diffuse.set(r, g, b);
        this.setChanged(true);
    }

    public final void getDiffuseColor(Colorf c) {
        c.set(this.diffuse);
    }

    public final Colorf getDiffuseColor() {
        return this.diffuse.getReadOnly();
    }

    public final void setSpecularColor(Colorf color) {
        this.specular.set(color);
        this.setChanged(true);
    }

    public final void setSpecularColor(float r, float g, float b) {
        this.specular.set(r, g, b);
        this.setChanged(true);
    }

    public final void getSpecularColor(Colorf c) {
        c.set(this.specular);
    }

    public final Colorf getSpecularColor() {
        return this.specular.getReadOnly();
    }

    public final void setShininess(float shininess) {
        this.shininess = shininess = Math.max(0.0f, Math.min(shininess, 128.0f));
        this.setChanged(true);
    }

    public final float getShininess() {
        return this.shininess;
    }

    public final void setColorTarget(ColorTarget colorTarget) {
        this.colorTarget = colorTarget;
        this.setChanged(true);
    }

    public final ColorTarget getColorTarget() {
        return this.colorTarget;
    }

    public final void setNormalizeNormals(boolean normalizeNormals) {
        this.normalizeNormals = normalizeNormals;
        this.setChanged(true);
    }

    public final boolean getNormalizeNormals() {
        return this.normalizeNormals;
    }

    public final void setLightingEnabled(boolean enabled) {
        this.lightingEnabled = enabled;
        this.setChanged(true);
    }

    public final boolean isLightingEnabled() {
        return this.lightingEnabled;
    }

    @Override
    public final void setStateNode(StateNode stateNode) {
        this.stateNode = stateNode;
        this.stateId = stateNode.getId();
    }

    @Override
    public final StateNode getStateNode() {
        return this.stateNode;
    }

    public final long getStateId() {
        return this.stateId;
    }

    @Override
    public Material getCopy() {
        return this.cloneNodeComponent(true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Material)) {
            return false;
        }
        Material om = (Material)o;
        if (!this.ambient.equals(om.getAmbientColor())) {
            return false;
        }
        if (!this.diffuse.equals(om.getDiffuseColor())) {
            return false;
        }
        if (!this.emissive.equals(om.getEmissiveColor())) {
            return false;
        }
        if (!this.specular.equals(om.getSpecularColor())) {
            return false;
        }
        if (this.shininess != om.shininess) {
            return false;
        }
        if (this.lightingEnabled != om.lightingEnabled) {
            return false;
        }
        if (this.colorTarget != om.colorTarget) {
            return false;
        }
        return this.normalizeNormals == om.normalizeNormals;
    }

    @Override
    public int compareTo(Material o) {
        boolean bl;
        if (this == o) {
            return 0;
        }
        int val = ComparatorHelper.compare(this.ambient, o.ambient);
        if (val != 0) {
            return val;
        }
        val = ComparatorHelper.compare(this.diffuse, o.diffuse);
        if (val != 0) {
            return val;
        }
        val = ComparatorHelper.compare(this.emissive, o.emissive);
        if (val != 0) {
            return val;
        }
        val = ComparatorHelper.compare(this.specular, o.specular);
        if (val != 0) {
            return val;
        }
        if (this.shininess < o.shininess) {
            return -1;
        }
        if (this.shininess > o.shininess) {
            return 1;
        }
        boolean al = this.lightingEnabled;
        boolean bl2 = bl = o.lightingEnabled;
        if (al < bl) {
            return -1;
        }
        if (al > bl) {
            return 1;
        }
        if (this.colorTarget.ordinal() < o.colorTarget.ordinal()) {
            return -1;
        }
        if (this.colorTarget.ordinal() > o.colorTarget.ordinal()) {
            return 1;
        }
        al = this.normalizeNormals;
        boolean bl3 = bl = o.normalizeNormals;
        if (al < bl) {
            return -1;
        }
        if (al > bl) {
            return 1;
        }
        return 0;
    }

    @Override
    protected void duplicateNodeComponent(NodeComponent original, boolean forceDuplicate) {
        super.duplicateNodeComponent(original, forceDuplicate);
        Material o = (Material)original;
        if (forceDuplicate) {
            o.getAmbientColor(this.ambient);
            o.getEmissiveColor(this.emissive);
            o.getDiffuseColor(this.diffuse);
            o.getSpecularColor(this.specular);
        } else {
            this.setAmbientColor(o.getAmbientColor());
            this.setEmissiveColor(o.getEmissiveColor());
            this.setDiffuseColor(o.getDiffuseColor());
            this.setSpecularColor(o.getSpecularColor());
        }
        this.setShininess(o.getShininess());
        this.setLightingEnabled(o.isLightingEnabled());
        this.setNormalizeNormals(o.getNormalizeNormals());
    }

    @Override
    public Material cloneNodeComponent(boolean forceDuplicate) {
        Material m = new Material();
        m.duplicateNodeComponent(this, forceDuplicate);
        return m;
    }

    @Override
    public void freeOpenGLResources(CanvasPeer canvasPeer) {
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " \"" + this.getName() + "\"\n" + "    ambient: " + this.ambient + "\n" + "    diffuse: " + this.diffuse + "\n" + "    emissive: " + this.emissive + "\n" + "    specular: " + this.specular + "\n" + "    shininess: " + this.shininess + "\n" + "    ColorTarget: " + this.colorTarget + "\n" + "    norm-normals: " + this.normalizeNormals + "\n" + "    lighting-enabled: " + this.lightingEnabled;
    }

    public Material() {
        super(false);
    }

    public Material(boolean lightEnabled) {
        this();
        this.lightingEnabled = lightEnabled;
    }

    public Material(boolean lightEnabled, float shininess) {
        this(lightEnabled);
        this.shininess = shininess;
    }

    public Material(float shininess) {
        this(true, shininess);
    }

    public Material(Colorf ambientColor, Colorf emissiveColor, Colorf diffuseColor, Colorf specularColor, float shininess) {
        this();
        if (ambientColor != null) {
            this.ambient.set(ambientColor);
        }
        if (emissiveColor != null) {
            this.emissive.set(emissiveColor);
        }
        if (diffuseColor != null) {
            this.diffuse.set(diffuseColor);
        }
        if (specularColor != null) {
            this.specular.set(specularColor);
        }
        this.shininess = shininess;
    }

    public Material(Colorf ambientColor, Colorf emissiveColor, Colorf diffuseColor, Colorf specularColor, float shininess, boolean lightingEnabled) {
        this(ambientColor, emissiveColor, diffuseColor, specularColor, shininess);
        this.lightingEnabled = lightingEnabled;
    }

    public Material(Colorf ambientColor, Colorf emissiveColor, Colorf diffuseColor, Colorf specularColor, float shininess, ColorTarget colorTarget, boolean lightingEnabled) {
        this(ambientColor, emissiveColor, diffuseColor, specularColor, shininess);
        this.colorTarget = colorTarget;
        this.lightingEnabled = lightingEnabled;
    }

    public Material(Colorf ambientColor, Colorf emissiveColor, Colorf diffuseColor, Colorf specularColor, float shininess, ColorTarget colorTarget, boolean normalizeNormals, boolean lightingEnabled) {
        this(ambientColor, emissiveColor, diffuseColor, specularColor, shininess);
        this.colorTarget = colorTarget;
        this.normalizeNormals = normalizeNormals;
        this.lightingEnabled = lightingEnabled;
    }
}

