/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.jagatoo.opengl.enums.TextureBoundaryMode;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.scenegraph.NodeComponent;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.TextureAttributes;
import org.xith3d.scenegraph.TextureUnit;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.View;

public class ProjectiveTextureUnit
extends TextureUnit {
    private final View projector;
    private static final Transform3D scaleAndBias = ProjectiveTextureUnit.createScaleAndBias();
    private final Transform3D projectorProj = new Transform3D();
    private long lastFrameId = -1L;

    private static final Transform3D createScaleAndBias() {
        Transform3D scaleAndBias = new Transform3D();
        scaleAndBias.getMatrix4f().set(0.5f, 0.0f, 0.0f, 0.5f, 0.0f, 0.5f, 0.0f, 0.5f, 0.0f, 0.0f, 0.5f, 0.5f, 0.0f, 0.0f, 0.0f, 1.0f);
        return scaleAndBias;
    }

    public void setTexture(Texture texture) {
        super.setTexture(texture);
        if (texture != null) {
            texture.setBoundaryModeS(TextureBoundaryMode.CLAMP_TO_EDGE);
            texture.setBoundaryModeT(TextureBoundaryMode.CLAMP_TO_EDGE);
        }
    }

    public void setTextureAttributes(TextureAttributes textureAttributes) {
        if (textureAttributes == null) {
            throw new IllegalArgumentException("A ProjectiveTextureUnit must not have null TextureAttributes");
        }
        super.setTextureAttributes(textureAttributes);
        if (textureAttributes.getTextureTransform() == null) {
            textureAttributes.setTextureTransform(new Transform3D());
        }
    }

    public final View getProjector() {
        return this.projector;
    }

    public void update(float viewportAspect, long frameId) {
        if (frameId <= this.lastFrameId) {
            return;
        }
        this.lastFrameId = frameId;
        this.projectorProj.perspective(this.projector.getFieldOfView(), viewportAspect, this.projector.getFrontClipDistance(), this.projector.getBackClipDistance());
        Transform3D textureTransform = this.getTextureAttributes().getTextureTransform();
        textureTransform.setIdentity();
        textureTransform.mul(scaleAndBias);
        textureTransform.mul(this.projectorProj);
        textureTransform.mul(this.projector.getModelViewTransform(true));
    }

    protected void duplicateNodeComponent(NodeComponent original, boolean forceDuplicate) {
        super.duplicateNodeComponent(original, forceDuplicate);
    }

    protected ProjectiveTextureUnit newInstance() {
        return new ProjectiveTextureUnit(this.getTexture());
    }

    public ProjectiveTextureUnit(Texture texture) {
        super(texture, new TextureAttributes(), null);
        this.projector = new View();
    }

    public ProjectiveTextureUnit(String texture) {
        this(TextureLoader.getInstance().getTexture(texture));
    }
}

