/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.jagatoo.opengl.enums.StencilOperation;
import org.jagatoo.opengl.enums.TestFunction;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.states.StateNode;
import org.xith3d.render.states.StateTrackable;
import org.xith3d.scenegraph.NodeComponent;
import org.xith3d.scenegraph.StencilFuncSeparate;
import org.xith3d.scenegraph.StencilMaskSeparate;
import org.xith3d.scenegraph.StencilOpSeparate;
import org.xith3d.utility.comparator.ComparatorHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderingAttributes
extends NodeComponent
implements StateTrackable<RenderingAttributes> {
    private StateNode stateNode = null;
    private long stateId = -1L;
    public static final TestFunction ALWAYS = TestFunction.ALWAYS;
    public static final TestFunction NEVER = TestFunction.NEVER;
    public static final TestFunction EQUAL = TestFunction.EQUAL;
    public static final TestFunction NOT_EQUAL = TestFunction.NOT_EQUAL;
    public static final TestFunction LESS = TestFunction.LESS;
    public static final TestFunction LESS_OR_EQUAL = TestFunction.LESS_OR_EQUAL;
    public static final TestFunction GREATER = TestFunction.GREATER;
    public static final TestFunction GREATER_OR_EQUAL = TestFunction.GREATER_OR_EQUAL;
    private boolean depthBufferEnabled = true;
    private boolean depthBufferWriteEnabled = true;
    private float alphaTestValue = 0.0f;
    private TestFunction alphaTestFunction = TestFunction.ALWAYS;
    private StencilFuncSeparate stencilFuncSep = null;
    private StencilOpSeparate stencilOpSep = null;
    private StencilMaskSeparate stencilMaskSep = null;
    private TestFunction depthTestFunction = TestFunction.LESS;
    private boolean ignoreVertexColors = false;
    private boolean stencilEnabled = false;
    public static final StencilOperation KEEP = StencilOperation.KEEP;
    public static final StencilOperation ZERO = StencilOperation.ZERO;
    public static final StencilOperation REPLACE = StencilOperation.REPLACE;
    public static final StencilOperation INCREMENT = StencilOperation.INCREMENT;
    public static final StencilOperation DECREMENT = StencilOperation.DECREMENT;
    public static final StencilOperation INVERT = StencilOperation.INVERT;
    private StencilOperation stencilOpFail = StencilOperation.KEEP;
    private StencilOperation stencilOpZFail = StencilOperation.KEEP;
    private StencilOperation stencilOpZPass = StencilOperation.REPLACE;
    private TestFunction stencilTestFunction = TestFunction.ALWAYS;
    private int stencilRef = 0;
    private int stencilMask = -1;
    public static final int COLOR_WRITE_MASK_ALL = 15;
    private int colorWriteMask = 15;
    private boolean hasCustomColorMask = false;

    public void setDepthTestFunction(TestFunction depthTestFunction) {
        this.depthTestFunction = depthTestFunction;
        this.setChanged(true);
    }

    public TestFunction getDepthTestFunction() {
        return this.depthTestFunction;
    }

    public final void setDepthBufferEnabled(boolean state) {
        this.depthBufferEnabled = state;
        this.setChanged(true);
    }

    public final boolean isDepthBufferEnabled() {
        return this.depthBufferEnabled;
    }

    public final void setDepthBufferWriteEnabled(boolean state) {
        this.depthBufferWriteEnabled = state;
        this.setChanged(true);
    }

    public final boolean isDepthBufferWriteEnabled() {
        return this.depthBufferWriteEnabled;
    }

    public final void setAlphaTestValue(float val) {
        this.alphaTestValue = val;
        this.setChanged(true);
    }

    public final float getAlphaTestValue() {
        return this.alphaTestValue;
    }

    public final void setAlphaTestFunction(TestFunction func) {
        this.alphaTestFunction = func;
        this.setChanged(true);
    }

    public final TestFunction getAlphaTestFunction() {
        return this.alphaTestFunction;
    }

    public void setIgnoreVertexColors(boolean ignoreVertexColors) {
        this.ignoreVertexColors = ignoreVertexColors;
        this.setChanged(true);
    }

    public final boolean getIgnoreVertexColors() {
        return this.ignoreVertexColors;
    }

    public void setStencilEnabled(boolean value) {
        this.stencilEnabled = value;
        this.setChanged(true);
    }

    public final boolean isStencilEnabled() {
        return this.stencilEnabled;
    }

    public void setStencilOpFail(StencilOperation value) {
        this.stencilOpFail = value;
        this.setChanged(true);
    }

    public final StencilOperation getStencilOpFail() {
        return this.stencilOpFail;
    }

    public void setStencilOpZFail(StencilOperation value) {
        this.stencilOpZFail = value;
        this.setChanged(true);
    }

    public final StencilOperation getStencilOpZFail() {
        return this.stencilOpZFail;
    }

    public void setStencilOpZPass(StencilOperation value) {
        this.stencilOpZPass = value;
        this.setChanged(true);
    }

    public final StencilOperation getStencilOpZPass() {
        return this.stencilOpZPass;
    }

    public void setStencilOp(StencilOperation fail, StencilOperation zfail, StencilOperation zpass) {
        this.stencilOpFail = fail;
        this.stencilOpZFail = zfail;
        this.stencilOpZPass = zpass;
        this.setChanged(true);
    }

    public void setStencilTestFunction(TestFunction value) {
        this.stencilTestFunction = value;
        this.setChanged(true);
    }

    public final TestFunction getStencilTestFunction() {
        return this.stencilTestFunction;
    }

    public void setStencilRef(int value) {
        this.stencilRef = value;
        this.setChanged(true);
    }

    public final int getStencilRef() {
        return this.stencilRef;
    }

    public void setStencilMask(int value) {
        this.stencilMask = value;
        this.setChanged(true);
    }

    public final int getStencilMask() {
        return this.stencilMask;
    }

    public void setStencilTestFunction(TestFunction func, int ref, int mask) {
        this.stencilTestFunction = func;
        this.stencilRef = ref;
        this.stencilMask = mask;
        this.setChanged(true);
    }

    public void setColorWriteMask(int mask) {
        this.colorWriteMask = mask;
        this.hasCustomColorMask = true;
        this.setChanged(true);
    }

    public final boolean hasColorWriteMask() {
        return this.hasCustomColorMask;
    }

    public final int getColorWriteMask() {
        return this.colorWriteMask;
    }

    public void setRedWriteEnabled(boolean value) {
        this.colorWriteMask = value ? (this.colorWriteMask |= 1) : (this.colorWriteMask &= 0xFFFFFFFE);
        this.hasCustomColorMask = true;
        this.setChanged(true);
    }

    public final boolean isRedWriteEnabled() {
        return (this.colorWriteMask & 1) != 0;
    }

    public void setGreenWriteEnabled(boolean value) {
        this.colorWriteMask = value ? (this.colorWriteMask |= 2) : (this.colorWriteMask &= 0xFFFFFFFD);
        this.hasCustomColorMask = true;
        this.setChanged(true);
    }

    public final boolean isGreenWriteEnabled() {
        return (this.colorWriteMask & 2) != 0;
    }

    public void setBlueWriteEnabled(boolean value) {
        this.colorWriteMask = value ? (this.colorWriteMask |= 4) : (this.colorWriteMask &= 0xFFFFFFFB);
        this.hasCustomColorMask = true;
        this.setChanged(true);
    }

    public final boolean isBlueWriteEnabled() {
        return (this.colorWriteMask & 4) != 0;
    }

    public void setAlphaWriteEnabled(boolean value) {
        this.colorWriteMask = value ? (this.colorWriteMask |= 8) : (this.colorWriteMask &= 0xFFFFFFF7);
        this.hasCustomColorMask = true;
        this.setChanged(true);
    }

    public final boolean isAlphaWriteEnabled() {
        return (this.colorWriteMask & 8) != 0;
    }

    public void setColorWriteMask(boolean valueR, boolean valueG, boolean valueB, boolean valueA) {
        this.colorWriteMask = 0;
        if (valueR) {
            this.colorWriteMask |= 1;
        } else if (valueG) {
            this.colorWriteMask |= 2;
        } else if (valueB) {
            this.colorWriteMask |= 4;
        } else if (valueA) {
            this.colorWriteMask |= 8;
        }
        this.hasCustomColorMask = true;
        this.setChanged(true);
    }

    public final void setStencilFuncSeparate(StencilFuncSeparate funcSep) {
        this.stencilFuncSep = funcSep;
    }

    public final StencilFuncSeparate getStencilFuncSeparate() {
        return this.stencilFuncSep;
    }

    public final void setStencilOpSeparate(StencilOpSeparate funcSep) {
        this.stencilOpSep = funcSep;
    }

    public final StencilOpSeparate getStencilOpSeparate() {
        return this.stencilOpSep;
    }

    public final void setStencilMaskSeparate(StencilMaskSeparate funcSep) {
        this.stencilMaskSep = funcSep;
    }

    public final StencilMaskSeparate getStencilMaskSeparate() {
        return this.stencilMaskSep;
    }

    @Override
    public void freeOpenGLResources(CanvasPeer canvasPeer) {
    }

    @Override
    public final void setStateNode(StateNode node) {
        this.stateNode = node;
        this.stateId = node.getId();
    }

    @Override
    public final StateNode getStateNode() {
        return this.stateNode;
    }

    public final long getStateId() {
        return this.stateId;
    }

    @Override
    protected void duplicateNodeComponent(NodeComponent originalNodeComponent, boolean forceDuplicate) {
        super.duplicateNodeComponent(originalNodeComponent, forceDuplicate);
        RenderingAttributes a = (RenderingAttributes)originalNodeComponent;
        this.setDepthBufferEnabled(a.isDepthBufferEnabled());
        this.setDepthBufferWriteEnabled(a.isDepthBufferWriteEnabled());
        this.setDepthTestFunction(a.getDepthTestFunction());
        this.setAlphaTestValue(a.getAlphaTestValue());
        this.setAlphaTestFunction(a.getAlphaTestFunction());
        this.setIgnoreVertexColors(a.getIgnoreVertexColors());
        this.setStencilEnabled(a.isStencilEnabled());
        this.setStencilOp(a.getStencilOpFail(), a.getStencilOpZFail(), a.getStencilOpZPass());
        this.setStencilTestFunction(a.getStencilTestFunction(), a.getStencilRef(), a.getStencilMask());
        if (a.hasColorWriteMask()) {
            this.setColorWriteMask(a.isRedWriteEnabled(), a.isGreenWriteEnabled(), a.isBlueWriteEnabled(), a.isAlphaWriteEnabled());
        }
        this.setStencilFuncSeparate(a.getStencilFuncSeparate());
        this.setStencilOpSeparate(a.getStencilOpSeparate());
        this.setStencilMaskSeparate(a.getStencilMaskSeparate());
    }

    @Override
    public RenderingAttributes cloneNodeComponent(boolean forceDuplicate) {
        RenderingAttributes a = new RenderingAttributes();
        a.duplicateNodeComponent(this, forceDuplicate);
        return a;
    }

    @Override
    public RenderingAttributes getCopy() {
        return this.cloneNodeComponent(true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RenderingAttributes)) {
            return false;
        }
        RenderingAttributes ro = (RenderingAttributes)o;
        if (this.depthBufferEnabled != ro.depthBufferEnabled) {
            return false;
        }
        if (this.depthBufferWriteEnabled != ro.depthBufferWriteEnabled) {
            return false;
        }
        if (this.depthTestFunction != ro.depthTestFunction) {
            return false;
        }
        if (this.alphaTestValue != ro.alphaTestValue) {
            return false;
        }
        if (this.alphaTestFunction != ro.alphaTestFunction) {
            return false;
        }
        if (this.ignoreVertexColors != ro.ignoreVertexColors) {
            return false;
        }
        if (this.stencilEnabled != ro.stencilEnabled) {
            return false;
        }
        if (this.stencilOpFail != ro.stencilOpFail) {
            return false;
        }
        if (this.stencilOpZFail != ro.stencilOpZFail) {
            return false;
        }
        if (this.stencilOpZPass != ro.stencilOpZPass) {
            return false;
        }
        if (this.stencilTestFunction != ro.stencilTestFunction) {
            return false;
        }
        if (this.stencilRef != ro.stencilRef) {
            return false;
        }
        if (this.stencilMask != ro.stencilMask) {
            return false;
        }
        return this.colorWriteMask == ro.colorWriteMask;
    }

    @Override
    public int compareTo(RenderingAttributes o) {
        if (this == o) {
            return 0;
        }
        int val = ComparatorHelper.compareBoolean(this.depthBufferEnabled, o.depthBufferEnabled);
        if (val != 0) {
            return val;
        }
        val = ComparatorHelper.compareBoolean(this.depthBufferWriteEnabled, o.depthBufferWriteEnabled);
        if (val != 0) {
            return val;
        }
        if (this.depthTestFunction.ordinal() < o.depthTestFunction.ordinal()) {
            return -1;
        }
        if (this.depthTestFunction.ordinal() > o.depthTestFunction.ordinal()) {
            return 1;
        }
        if (this.alphaTestFunction.ordinal() < o.alphaTestFunction.ordinal()) {
            return -1;
        }
        if (this.alphaTestFunction.ordinal() > o.alphaTestFunction.ordinal()) {
            return 1;
        }
        if (this.alphaTestValue < o.alphaTestValue) {
            return -1;
        }
        if (this.alphaTestValue > o.alphaTestValue) {
            return 1;
        }
        val = ComparatorHelper.compareBoolean(this.ignoreVertexColors, o.ignoreVertexColors);
        if (val != 0) {
            return val;
        }
        val = ComparatorHelper.compareBoolean(this.stencilEnabled, o.stencilEnabled);
        if (val != 0) {
            return val;
        }
        if (this.stencilOpFail.ordinal() < o.stencilOpFail.ordinal()) {
            return -1;
        }
        if (this.stencilOpFail.ordinal() > o.stencilOpFail.ordinal()) {
            return 1;
        }
        if (this.stencilOpZFail.ordinal() < o.stencilOpZFail.ordinal()) {
            return -1;
        }
        if (this.stencilOpZFail.ordinal() > o.stencilOpZFail.ordinal()) {
            return 1;
        }
        if (this.stencilOpZPass.ordinal() < o.stencilOpZPass.ordinal()) {
            return -1;
        }
        if (this.stencilOpZPass.ordinal() > o.stencilOpZPass.ordinal()) {
            return 1;
        }
        if (this.stencilTestFunction.ordinal() < o.stencilTestFunction.ordinal()) {
            return -1;
        }
        if (this.stencilTestFunction.ordinal() > o.stencilTestFunction.ordinal()) {
            return 1;
        }
        if (this.stencilRef < o.stencilRef) {
            return -1;
        }
        if (this.stencilRef > o.stencilRef) {
            return 1;
        }
        if (this.stencilMask < o.stencilMask) {
            return -1;
        }
        if (this.stencilMask > o.stencilMask) {
            return 1;
        }
        if (this.colorWriteMask < o.colorWriteMask) {
            return -1;
        }
        if (this.colorWriteMask > o.colorWriteMask) {
            return 1;
        }
        return 0;
    }

    public RenderingAttributes() {
        super(false);
    }

    public RenderingAttributes(boolean depthBufferEnabled, boolean depthBufferWriteEnabled, float alphaTestValue, TestFunction alphaTestFunction) {
        this();
        this.depthBufferEnabled = depthBufferEnabled;
        this.depthBufferWriteEnabled = depthBufferWriteEnabled;
        this.alphaTestValue = alphaTestValue;
        this.alphaTestFunction = alphaTestFunction;
    }

    public RenderingAttributes(boolean depthBufferEnabled, boolean depthBufferWriteEnabled, TestFunction depthTestFunction, float alphaTestValue, TestFunction alphaTestFunction, boolean ignoreVertexColors, boolean stencilEnabled, StencilOperation stencilOpFail, StencilOperation stencilOpZFail, StencilOperation stencilOpZPass, TestFunction stencilTestFunction, int stencilRef, int stencilMask) {
        this();
        this.depthBufferEnabled = depthBufferEnabled;
        this.depthBufferWriteEnabled = depthBufferWriteEnabled;
        this.depthTestFunction = depthTestFunction;
        this.alphaTestValue = alphaTestValue;
        this.alphaTestFunction = alphaTestFunction;
        this.ignoreVertexColors = ignoreVertexColors;
        this.stencilEnabled = stencilEnabled;
        this.stencilOpFail = stencilOpFail;
        this.stencilOpZFail = stencilOpZFail;
        this.stencilOpZPass = stencilOpZPass;
        this.stencilTestFunction = stencilTestFunction;
        this.stencilRef = stencilRef;
        this.stencilMask = stencilMask;
    }

    public RenderingAttributes(boolean depthBufferEnabled, boolean depthBufferWriteEnabled, TestFunction depthTestFunction, float alphaTestValue, TestFunction alphaTestFunction, boolean ignoreVertexColors, boolean stencilEnabled, StencilOperation stencilOpFail, StencilOperation stencilOpZFail, StencilOperation stencilOpZPass, TestFunction stencilTestFunction, int stencilRef, int stencilMask, boolean enableRedWrite, boolean enableGreenWrite, boolean enableBlueWrite, boolean enableAlphaWrite) {
        this();
        this.depthBufferEnabled = depthBufferEnabled;
        this.depthBufferWriteEnabled = depthBufferWriteEnabled;
        this.depthTestFunction = depthTestFunction;
        this.alphaTestValue = alphaTestValue;
        this.alphaTestFunction = alphaTestFunction;
        this.ignoreVertexColors = ignoreVertexColors;
        this.stencilEnabled = stencilEnabled;
        this.stencilOpFail = stencilOpFail;
        this.stencilOpZFail = stencilOpZFail;
        this.stencilOpZPass = stencilOpZPass;
        this.stencilTestFunction = stencilTestFunction;
        this.stencilRef = stencilRef;
        this.stencilMask = stencilMask;
        this.setColorWriteMask(enableRedWrite, enableGreenWrite, enableBlueWrite, enableAlphaWrite);
    }
}

