/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import java.util.ArrayList;
import org.jagatoo.datatypes.Enableable;
import org.xith3d.render.CanvasPeer;
import org.xith3d.render.states.StateNode;
import org.xith3d.render.states.StateTrackable;
import org.xith3d.scenegraph.NodeComponent;
import org.xith3d.scenegraph.Shader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ShaderProgram<S extends Shader>
extends NodeComponent
implements Enableable,
StateTrackable<ShaderProgram<S>> {
    private StateNode stateNode = null;
    private long stateId = -1L;
    private boolean dirty = false;
    private boolean enabled = true;
    private final ArrayList<S> vertexShaders = new ArrayList(1);
    private final ArrayList<S> fragmentShaders = new ArrayList(1);

    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    protected final void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    final boolean isDirty() {
        return this.dirty;
    }

    public final void addShader(S shader) {
        if (((Shader)shader).getType() == Shader.ShaderType.VERTEX) {
            this.vertexShaders.add(shader);
        } else if (((Shader)shader).getType() == Shader.ShaderType.FRAGMENT) {
            this.fragmentShaders.add(shader);
        }
    }

    public final void removeShader(S shader) {
        if (((Shader)shader).getType() == Shader.ShaderType.VERTEX) {
            this.vertexShaders.remove(shader);
        } else if (((Shader)shader).getType() == Shader.ShaderType.FRAGMENT) {
            this.fragmentShaders.remove(shader);
        }
    }

    public final void removeAllShaders() {
        this.vertexShaders.clear();
        this.fragmentShaders.clear();
    }

    public final int getNumVertexShaders() {
        return this.vertexShaders.size();
    }

    public final int getNumFragmentShaders() {
        return this.fragmentShaders.size();
    }

    public final int getNumShaders() {
        return this.getNumVertexShaders() + this.getNumFragmentShaders();
    }

    public final S getVertexShader(int index) {
        return (S)((Shader)this.vertexShaders.get(index));
    }

    public final S getFragmentShader(int index) {
        return (S)((Shader)this.fragmentShaders.get(index));
    }

    @Override
    public void freeOpenGLResources(CanvasPeer canvasPeer) {
        int i;
        for (i = 0; i < this.vertexShaders.size(); ++i) {
            ((Shader)this.vertexShaders.get(i)).freeOpenGLResources(canvasPeer);
        }
        for (i = 0; i < this.fragmentShaders.size(); ++i) {
            ((Shader)this.fragmentShaders.get(i)).freeOpenGLResources(canvasPeer);
        }
    }

    @Override
    public final void setStateNode(StateNode node) {
        this.stateNode = node;
        this.stateId = node.getId();
    }

    @Override
    public final StateNode getStateNode() {
        return this.stateNode;
    }

    public final long getStateId() {
        return this.stateId;
    }

    @Override
    public abstract int compareTo(ShaderProgram<S> var1);

    public abstract boolean equals(Object var1);

    @Override
    protected void duplicateNodeComponent(NodeComponent original, boolean forceDuplicate) {
        ShaderProgram orgShaderProg = (ShaderProgram)original;
        this.enabled = orgShaderProg.enabled;
        this.setDirty(true);
    }

    public ShaderProgram(boolean enabled) {
        super(false);
        this.enabled = enabled;
        this.dirty = true;
    }

    public ShaderProgram() {
        this(true);
    }
}

