/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.scenegraph;

import org.jagatoo.datatypes.Enableable;
import org.openmali.spatial.bounds.Bounds;
import org.xith3d.render.CanvasPeer;
import org.xith3d.scenegraph.BoundingLeaf;
import org.xith3d.scenegraph.Leaf;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph.traversal.DetailedTraversalCallback;
import org.xith3d.sound.SingletonSoundContainer;
import org.xith3d.sound.SoundContainer;
import org.xith3d.sound.SoundProcessor;
import org.xith3d.sound.SoundSource;

public abstract class Sound
extends Leaf
implements Enableable {
    public static final float NO_FILTER = -1.0f;
    public static final int DURATION_UNKNOWN = -1;
    public static final int INFINITE_LOOPS = -1;
    private SoundContainer soundContainer = null;
    private SingletonSoundContainer singSoundContainer = null;
    private SoundSource source;
    private float initialGain;
    private int loopType;
    private boolean releaseEnabled;
    private boolean continuousEnabled;
    private boolean enabled = false;
    private boolean paused = false;
    private Bounds region;
    private float priority;
    private boolean disabled = false;
    private boolean wasRestarted = false;
    private boolean wasDeactivated = false;

    public void setSource(SoundSource source) {
        this.source = source;
    }

    public SoundSource getSource() {
        return this.source;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public final boolean isDisabled() {
        return this.disabled;
    }

    public void setEnabled(boolean enabled) {
        if (!this.enabled && enabled) {
            this.wasRestarted = true;
        }
        this.enabled = enabled;
        if (!enabled && this.source != null) {
            if (this.source.isPlaying()) {
                this.source.stop();
            }
            this.source.getSoundDriver().delete(this.source);
            this.source = null;
        }
        if (this.getSingletonSoundContainer() != null) {
            this.getSingletonSoundContainer().setEnabled(enabled);
        }
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public void setRestarted(boolean val) {
        this.wasRestarted = val;
    }

    public final boolean wasRestarted() {
        return this.wasRestarted;
    }

    public void setDeactivated(boolean val) {
        this.wasDeactivated = val;
    }

    public final boolean wasDeactivated() {
        return this.wasDeactivated;
    }

    public final SoundContainer getSoundContainer() {
        return this.soundContainer;
    }

    public final SingletonSoundContainer getSingletonSoundContainer() {
        return this.singSoundContainer;
    }

    public void setInitialGain(float initialGain) {
        this.initialGain = initialGain;
    }

    public final float getInitialGain() {
        return this.initialGain;
    }

    public void setPriority(float priority) {
        this.priority = priority;
    }

    public final float getPriority() {
        return this.priority;
    }

    public void setRegion(Bounds region) {
        this.region = region;
    }

    public final Bounds getRegion() {
        return this.region;
    }

    public void play() {
        this.setEnabled(false);
        if (this.source != null) {
            this.source.getSoundDriver().delete(this.source);
            this.source = null;
        }
        this.soundContainer = null;
        this.setEnabled(true);
    }

    public void setLoopType(int loopType) {
        this.loopType = loopType;
        if (loopType == -1) {
            this.setContinuousEnabled(true);
        }
    }

    public final int getLoopType() {
        return this.loopType;
    }

    public void setReleaseEnabled(boolean releaseEnable) {
        this.releaseEnabled = releaseEnable;
    }

    public final boolean isReleaseEnabled() {
        return this.releaseEnabled;
    }

    public void setContinuousEnabled(boolean continuousEnabled) {
        this.continuousEnabled = continuousEnabled;
    }

    public final boolean isContinuousEnabled() {
        return this.continuousEnabled;
    }

    public void setSchedulingBounds(Bounds bounds) {
    }

    public final Bounds getSchedulingBounds() {
        return null;
    }

    public void setSchedulingBoundingLeaf(BoundingLeaf boundingLeaf) {
    }

    public final BoundingLeaf getSchedulingBoundingLeaf() {
        return null;
    }

    public final long getDuration() {
        if (this.getSingletonSoundContainer() == null) {
            return 0L;
        }
        return this.getSingletonSoundContainer().getDuration();
    }

    public final boolean isReady() {
        return true;
    }

    public final boolean isReady(View view) {
        return false;
    }

    public final boolean isPlaying() {
        if (this.source == null) {
            return false;
        }
        return this.source.isPlaying();
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
        if (this.getSingletonSoundContainer() != null) {
            this.getSingletonSoundContainer().setPaused(this.enabled);
        }
    }

    public final boolean isPaused() {
        return this.paused;
    }

    protected boolean setLive(boolean live) {
        if (!super.setLive(live)) {
            return false;
        }
        if (live) {
            SoundProcessor.getInstance().addSound(this, this.getRoot());
        } else {
            this.setEnabled(false);
            if (this.source != null) {
                if (this.source.isPlaying()) {
                    this.source.stop();
                }
                this.source.getSoundDriver().delete(this.source);
                this.source = null;
            }
            SoundProcessor.getInstance().removeSound(this);
        }
        return true;
    }

    public final long getSoundPosition() {
        return 0L;
    }

    public void freeOpenGLResources(CanvasPeer canvasPeer) {
    }

    public boolean traverse(DetailedTraversalCallback callback) {
        return callback.traversalOperationCommon(this) && callback.traversalOperation(this) && callback.traversalOperationAfter(this) && callback.traversalOperationCommonAfter(this);
    }

    public Sound(SoundContainer soundContainer, float gain) {
        assert (soundContainer != null) : "SoundContainer must not be null.";
        this.soundContainer = soundContainer;
        if (soundContainer instanceof SingletonSoundContainer) {
            this.singSoundContainer = (SingletonSoundContainer)soundContainer;
        }
        this.initialGain = gain;
    }

    public Sound(SoundContainer soundContainer) {
        this(soundContainer, 0.0f);
    }
}

